/*
 * AXMIspObSettings.cpp
 */

#include "AXMIspObSettings.hpp"

AXMIspOBSamplingRange::AXMIspOBSamplingRange() :
	  hStart(0)
	, vStart(0)
	, hEnd(0)
	, vEnd(0)
{
	// TODO 自動生成されたコンストラクター・スタブ
}

AXMIspOBSamplingRange::~AXMIspOBSamplingRange() {
	// TODO Auto-generated destructor stub
}

void AXMIspOBSamplingRange::SetHorizon(SHORT start, SHORT end) {
	hStart = start;
	hEnd = end;
	if (hStart < 0) {
		hStart = 0;
	}
	if (hEnd < 0) {
		hEnd = 0;
	}
	if (end < start) {
		hStart = end;
		hEnd = start;
	}
}

void AXMIspOBSamplingRange::SetVertical(SHORT start, SHORT end) {
	vStart = start;
	vEnd = end;
	if (vStart < 0) {
		vStart = 0;
	}
	if (vEnd < 0) {
		vEnd = 0;
	}
	if (end < start) {
		vStart = end;
		vEnd = start;
	}
}

SHORT AXMIspOBSamplingRange::GetWidth() {
	return hEnd - hStart + 1;
}

SHORT AXMIspOBSamplingRange::GetHeight() {
	return vEnd - vStart + 1;
}

AXMIspObSettings::AXMIspObSettings() :
	  obMode(OBFeedback)
	, samplingRange(OBSamplingRange())
	, arrayPattern(OBArrayPattern_2_2)
{
	// TODO 自動生成されたコンストラクター・スタブ
	for (int i = 0; i < OB_ACCUM_CNT; i++) {
		obDarkLevelFloor[i] = 0;
	}
}

AXMIspObSettings::~AXMIspObSettings() {
	// TODO Auto-generated destructor stub
}
