/**
 * @file   AXMIspAwb.hpp
 * @brief  AXMIspAwbクラスヘッダ
 *
 * @n      AWB 初期化/生成/開始/停止 処理
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

#ifndef AXMISPAWB_HPP_
#define AXMISPAWB_HPP_

#include "../AXM/AXModelActor.hpp"
#include "../AXMCommon/AXMCommonSetParam.hpp"
#include "../AXMCommon/AXMCommonStruct.hpp"

//  AX.cppでコンパイルエラーにならないように以下のような記述とする
#include "../../AXM/AXMIspAwb/AXMIspAwbTypedefine.hpp"
#include "../../AXM/AXMIspAwb/AXMIspAwbCommon.hpp"
#include "../../AXM/AXMIspAwb/AXMIspAwbOPDConfig.hpp"
#include "../../AXM/AXMIspAwb/AXMIspAwbSettings.hpp"
#include "../../AXM/AXMIspAwb/AXMIspAwbAlgorithm.hpp"

/**
 * @class AXMAwb
 * @brief AWB実処理クラス
 */
class AXMIspAwb : public AXModelActor {
  AXFLog m_log;
  AXFObjectName& m_name;
#ifdef USE_AXFTEST_COMMAND
  int m_loopbackCount;
#endif /* USE_AXFTEST_COMMAND */

 public:
  AXMIspAwb(AXFObjectName& name);
  virtual ~AXMIspAwb();
  ax::actorFuncStatus onCreate();
  ax::actorFuncStatus onStart();
  ax::actorFuncStatus onStop();
#if 0
  ax::actorFuncStatus onPause();
  ax::actorFuncStatus onResume();
  ax::actorFuncStatus onRestart();
#endif

// StateMachineオブジェクト用ヘッダファイル挿入
#include "./AXMIspAwbState.hpp"


private:
  AXMIspAwbSettings                   AWBSettings;          //  AWB設定値群
  CAL_COLOR                           ImageData;            //  色別画像データ格納用
  CAL_DATA                            CalData;              //  AWB演算データ群
  AXMIspAwbAlgorithmJudgedLightSource *JudgeLightSource;     //  モード別光源データ群

  ST_SPEC                             *p_spec;              //  設定値参照用

};
#endif /* AXMISPAWB_HPP_ */
