/**
 * @file	AXMIspAwb2.hpp
 * @brief	AXMIspAwb演算クラス群ヘッダ
 *
 * @par		言語
 *			C++
 */

#ifndef AXMISPAWB2_HPP_
#define AXMISPAWB2_HPP_

//#define ENABLE_COLORDATA_ATWMODE                            //  AXMIspAwbExecColorDataATWModeクラス有効化
//#define ENABLE_COLORDATA_MANUMODE                           //  AXMIspAwbExecColorDataManuModeクラス有効化
//#define ENABLE_COLORDATA_ONEPUSH                            //  AXMIspAwbExecColorDataOnePushModeクラス有効化
//#define ENABLE_CALC_ATWMODE                                 //  AXMIspAwbExecCalcATWModeクラス有効化
#define ENABLE_CALC_MANUMODE                                //  AXMIspAwbExecCalcManuModeクラス有効化
//#define ENABLE_CALC_ONEPUSH                                 //  AXMIspAwbExecCalcOnePushModeクラス有効化

#ifdef ENABLE_COLORDATA_ATWMODE
/**
 * @class	AXMIspAwbExecColorDataATWMode
 * @brief	ATWモード用の色データ計算の一括処理を提供する
 */
class	AXMIspAwbExecColorDataATWMode
{

public:
	/**
	 * @brief 色データ計算処理(ATWモード前半演算処理)を実行する
	 *
	 * @param [in]	AWBSettings	AWB設定値群
	 * @param [in]	p_img	画像データ先頭アドレス
	 * @param [in,out]	CalData	演算データ群
	 * @param [in]	JudgeLightSource	モード別光源データ群
	 * @retval AWB_E_OK	正常終了
	 * @retval AWB_E_ER	異常終了
	 */
	AWB_ER	Exec(AXMIspAwbSettings AWBSettings, UCHAR *p_img, CAL_DATA& CalData, AXMIspAwbAlgorithmJudgedLightSource JudgeLightSource);

private:
	AXMIspAwbAlgorithmColorData						NormalData;					//	色データ計算処理クラス
	AXMIspAwbAlgorithmOPDMaskedColorData			OPDMaskData;				//	OPDマスク処理クラス
	AXMIspAwbAlgorithmLightSourceJudgedColorData	LightSourceData;			//	モード別光源データ群
	AXMIspAwbAlgorithmWeightedColorData				WeightData;					//	重み付け処理クラス

};
#endif  //  ENABLE_COLORDATA_ATWMODE


#ifdef ENABLE_COLORDATA_MANUMODE
/**
 * @class	AXMIspAwbExecColorDataManuMode
 * @brief	マニュアルモード用の色データ計算の一括処理を提供する
 */
class	AXMIspAwbExecColorDataManuMode
{

public:
	/**
	 * @brief 色データ計算処理(マニュアルモード前半演算処理)を実行する
	 *
	 * @param [in]	AWBSettings	AWB設定値群
	 * @param [in]	p_img	画像データ先頭アドレス
	 * @param [in]	ColorData	色画像データ
	 * @retval AWB_E_OK	正常終了
	 * @retval AWB_E_ER	異常終了
	 */
	AWB_ER	Exec(AXMIspAwbSettings AWBSettings, UCHAR *p_img, CAL_RG_BG& ColorData);

private:
	AXMIspAwbAlgorithmColorData	NormalData;										//	色データ計算処理クラス

};
#endif  //  ENABLE_COLORDATA_MANUMODE


#ifdef  ENABLE_COLORDATA_ONEPUSH
/**
 * @class	AXMIspAwbExecColorDataOnePushMode
 * @brief	ワンプシュモード用の色データ計算の一括処理を提供する
 */
class	AXMIspAwbExecColorDataOnePushMode
{

public:
	/**
	 * @brief 色データ計算処理(ワンプッシュモード前半計算処理)を実行する
	 *
	 * @param [in]	AWBSettings	AWB設定値群
	 * @param [in]	p_img	画像データ先頭アドレス
	 * @param [in,out]	CalData	演算データ群
	 * @param [in]	JudgeLightSource	モード別光源データ群
	 * @retval AWB_E_OK	正常終了
	 * @retval AWB_E_ER	異常終了
	 */
	AWB_ER	Exec(AXMIspAwbSettings AWBSettings, UCHAR *p_img, CAL_DATA& CalData, AXMIspAwbAlgorithmJudgedLightSource JudgeLightSource);

private:
	AXMIspAwbAlgorithmColorData						NormalData;					//	色データ計算処理クラス
	AXMIspAwbAlgorithmLightSourceJudgedColorData	LightSourceData;				//	モード別光源データ群

};
#endif  //  ENABLE_COLORDATA_ONEPUSH


#ifdef  ENABLE_CALC_ATWMODE
/**
 * @class	AXMIspAwbExecCalcATWMode
 * @brief	ATWモード用の演算の一括処理を提供する
 */
class	AXMIspAwbExecCalcATWMode
{

public:
	/**
	 * @brief 重心計算からゲイン/マトリックス出力まで処理(ATWモード後半演算処理)を実行する
	 *
	 * @param [in]	AWBSettings	AWB設定値群
	 * @param [in,out]	CalData	演算データ群
	 * @param [in]	JudgeLightSource	モード別光源データ群
	 * @retval AWB_E_OK	正常終了
	 * @retval AWB_E_ER	異常終了
	 */
	AWB_ER	Exec(AXMIspAwbSettings AWBSettings, CAL_DATA& CalData, AXMIspAwbAlgorithmJudgedLightSource JudgeLightSource);

private:
	AXMIspAwbAlgorithmBalanceCenterData		BalanceCenter;						//	重心計算処理クラス
	AXMIspAwbAlgorithmAWBTarget				AWBTarget;							//	調整/収束制御処理クラス
	AXMIspAwbAlgorithmCurrentControlValue	ControlValue;						//	ゲイン/マトリックス設定処理クラス

};
#endif  //  ENABLE_CALC_ATWMODE


//#define	CONFIG_MANU_BASE
#ifdef	CONFIG_MANU_BASE
/**
 * @class	AXMIspAwbExecCalcManuBase
 * @brief	マニュアルモード用の演算一括処理ベースクラス
 */
class	AXMIspAwbExecCalcManuBase
{

public:
	virtual INT	Exec();

private:
//	AXMIspAwbAlgorithmCurrentControlValue	ControlValue;

};
#endif


#ifdef ENABLE_CALC_MANUMODE
/**
 * @class  AXMIspAwbExecCalcManuMode
 * @brief  マニュアルモード用の演算の一括処理クラス
 *
 * @n      マニュアルモード用の演算の一括処理を提供する
 */
#ifdef CONFIG_MANU_BASE
class	AXMIspAwbExecCalcManuMode : public AXMIspAwbExecCalcManuBase
#else
class	AXMIspAwbExecCalcManuMode
#endif
{

public:
	/**
	 * @brief ゲイン/マトリックスの出力処理(マニュアルモード後半演算処理)を実行する
	 *
	 * @param [in]	AWBSettings	AWB設定値群
	 * @param [in]	CalData		演算データ群
	 * @retval AWB_E_OK	正常終了
	 * @retval AWB_E_ER	異常終了
	 */
	AWB_ER	Exec(AXMIspAwbSettings& AWBSettings, CAL_DATA& CalData);

private:
	/**
	 * @brief 色温度から黒体放射軌跡座標算出する
	 *
	 * @param [in]	AWBSettigs	AWB設定値群
	 * @param [in]	p1	光源デフォルト座標(開始座標)
	 * @param [in]	p2	光源デフォルト座標(終了座標)
	 * @param [in]	temp1	色温度(開始座標)
	 * @param [in]	temp2	色温度(終了座標)
	 * @return	座標算出結果(黒体放射軌跡上の座標)
	 */
	WBGain				getManuWBPoint(AXMIspAwbSettings& AWBSettigs, AWBLightDefault p1, AWBLightDefault p2, LONG temp1, LONG temp2);

	/**
	 * @brief 光源座標設定から光源デフォルト座標を選択する
	 *
	 * @param [in]	LigtSelect		照明番号
	 * @return	光源デフォルト座標番号
	 */
	AWBLightDefault	getLightSeletctToDefault(AWBLightSelect LigtSelect);

	AXMIspAwbAlgorithmAWBTarget             AWBTarget;      //  Matrix演算
	AXMIspAwbAlgorithmCurrentControlValue   ControlValue;   //	ゲイン/マトリックス設定処理

};
#endif  //  ENABLE_CALC_MANUMODE


#ifdef ENABLE_CALC_ONEPUSH
/**
 * @class	AXMIspAwbExecCalcOnePushMode
 * @brief	ワンプシュモード用の演算の一括処理を提供する
 */
#ifdef CONFIG_MANU_BASE
class	AXMIspAwbExecCalcOnePushMode : public AXMIspAwbExecCalcManuBase
#else
class	AXMIspAwbExecCalcOnePushMode
#endif
{

public:
	/**
	 * @brief 重心計算からゲイン/マトリックス出力までの処理(ワンプシュモード後半演算処理)を実行する
	 *
	 * @param [in]	AWBSettings	AWB設定値群
	 * @param [in,out]	CalData	演算データ群
	 * @param [in]	JudgeLightSource	モード別光源データ群
	 * @retval AWB_E_OK	正常終了
	 * @retval AWB_E_ER	異常終了
	 */
	AWB_ER	Exec(AXMIspAwbSettings AWBSettings, CAL_DATA& CalData, AXMIspAwbAlgorithmJudgedLightSource JudgeLightSource);

private:
	AXMIspAwbAlgorithmBalanceCenterData		BalanceCenter;	//	重心計算処理クラス
	AXMIspAwbAlgorithmAWBTarget				AWBTarget;		//	調整/収束制御処理クラス
	AXMIspAwbAlgorithmCurrentControlValue	ControlValue;	//	ゲイン/マトリックス設定処理クラス

};
#endif  //  ENABLE_CALC_ONEPUSH

#endif /* AXMISPAWB2_HPP_ */
