/**
 * @file	AXMIspAwbCommon.hpp
 * @brief	AXMIspAwb共通定数ヘッダ
 *
 * @par	言語
 *			C++
 */


#ifndef AXMISPAWBCOMMON_HPP_
#define AXMISPAWBCOMMON_HPP_


#include	"AXMIspAwbTypedefine.hpp"
#include	"AXMIspAwbOPDConfig.hpp"
//#include	"../AXMIspCommon/AXMIspCommonSetParam.hpp"


const UCHAR True = 1;                                       ///<  真
const UCHAR False = 0;                                      ///<  偽
const SHORT AWB_ColorDataException = -1;                    ///<  除外色データ


/**
 * @enum	Judge
 * @brief	判定結果
 */
typedef enum
{
  Judge_False = 0,                                          ///<  偽
  Judge_True,                                               ///<  真
} Judge;


/**
 * @enum	AWBColor
 * @brief	カラーインデックス定義
 */
//  Color Timing Arrangementの設定にて、C0CS_Lを0x0001_3008に設定しているので、
//  画像の出力は [ R, Gr, R, Gr, ・・・ ] または [ Gb, B, Gb, B, ・・・ ]の並びとなる
typedef enum
{
  AWBColor_IDX_R = 0,                                       ///<  カラーインデックス番号 : R
  AWBColor_IDX_Gr,                                          ///<  カラーインデックス番号 : Gr
  AWBColor_IDX_Gb,                                          ///<  カラーインデックス番号 : Gb
  AWBColor_IDX_B,                                           ///<  カラーインデックス番号 : B

  AWBColor_Max,                                             ///<  AWBColor_Max
} AWBColor;


/**
 * @enum	ATWSceaneMode
 * @brief	[AWB-2]ATWシーンモード選択定義
 */
typedef enum
{
  ATWSceaneMode_IndoorMode = 0,                             ///<  0.屋内モード
  ATWSceaneMode_IndoorCWFMode,                              ///<  1.屋内蛍光灯モード
  ATWSceaneMode_IndoorAMode,                                ///<  2.屋内暖色系モード
  ATWSceaneMode_OutdoorMode,                                ///<  3.屋外モード
  ATWSceaneMode_OutdoorAsphaltMode,                         ///<  4.屋外アスファルトモード
  ATWSceaneMode_LEDMode = 5,                                ///<  5.LED照明モード
  ATWSceaneMode_ColorRollingMode,                           ///<  6.カラーローリングモード

  ATWSceaneMode_Max,                                        ///<  ATWシーンモード選択数
} ATWSceaneMode;


/**
 * @enum	ATWMode
 * @brief	ATWモード定義
 */
typedef enum
{
  ATWMode_None = -1,                                        ///<  -1.ATWモード該当なし
  ATWMode_StandardMode = 0,                                 ///<   0.ATW標準モード
  ATWMode_SceaneIndoorMode,                                 ///<   1.ATWシーンモード : 屋内モード
  ATWMode_SceaneIndoorCWFMode,                              ///<   2.ATWシーンモード : 屋内蛍光灯モード
  ATWMode_SceaneIndoorAMode,                                ///<   3.ATWシーンモード : 屋内暖色系モード
  ATWMode_SceaneOutdoorMode,                                ///<   4.ATWシーンモード : 屋外モード
  ATWMode_SceaneLEDMode = 5,                                ///<   5.ATWシーンモード : LED照明モード
  ATWMode_SceaneColorRollingMode,                           ///<  6.ATWシーンモード : カラーローリングモード

  ATWMode_Max,                                              ///<  ATWモード数
} ATWMode;


/**
 * @enum	AWBLightSelect
 * @brief	照明選択定義
 */
typedef enum
{
  AWBLightSelect_A = 0,                                     ///<  0.白熱灯デフォルト座標
  AWBLightSelect_EBulbF,                                    ///<  1.電球色蛍光灯デフォルト座標
  AWBLightSelect_CWF,                                       ///<  2.白色蛍光灯デフォルト座標
  AWBLightSelect_DayWF,                                     ///<  3.昼白色蛍光灯デフォルト座標
  AWBLightSelect_DayF,                                      ///<  4.昼光色蛍光灯デフォルト座標
  AWBLightSelect_Day = 5,                                   ///<  5.昼光デフォルト座標
  AWBLightSelect_Cloudy,                                    ///<  6.雲天/日陰デフォルト座標
  AWBLightSelect_Merculy,                                   ///<  7.水銀灯デフォルト座標
  AWBLightSelect_NaLamp,                                    ///<  8.高圧ナトリウムランプデフォルト座標
  AWBLightSelect_EBulbLED,                                  ///<  9.電球色LEDデフォルト座標
  AWBLightSelect_WhiteLED = 10,                             ///<  10.白色LEDデフォルト座標
  AWBLightSelect_DayLED,                                    ///<  11.昼光色LEDデフォルト座標

  AWBLightSelect_Max,                                       ///<  OPD信頼性判定用光源デフォルト座標数
} AWBLightSelect;


//
//	[AWB-6]引込み範囲定義
//
const USHORT AWB_ColorTemp_1800K = 1800;                    ///<  色温度 1800K
const USHORT AWB_ColorTemp_3000K = 3000;                    ///<  色温度 3000K
const USHORT AWB_ColorTemp_3200K = 3200;                    ///<  色温度 3200K
const USHORT AWB_ColorTemp_7000K = 7000;                    ///<  色温度 7000K
const USHORT AWB_ColorTemp_10000K = 10000;                  ///<  色温度 10000K
const USHORT AWB_LTempLightRangeMin = AWB_ColorTemp_1800K;  ///<  低色温度側引込み範囲下限
const USHORT AWB_LTempLightRangeMax = AWB_ColorTemp_3000K;  ///<  低色温度側引込み範囲上限
const USHORT AWB_HTempLightRangeMin = AWB_ColorTemp_7000K;  ///<  高色温度側引込み範囲下限
const USHORT AWB_HTempLightRangeMax = AWB_ColorTemp_10000K; ///<  高色温度側引込み範囲下限

const INT AWB_LightRange_Value = 100;                       ///< 　Mg-G方向引き込み調整 基準値

/**
 * @enum AWB_LightSource_Pnt
 * @brief 光源枠座標位置
 */
typedef enum {
  AWB_LightSource_Pnt_0 = 0,                                ///<  枠座標 左上
  AWB_LightSource_Pnt_1,                                    ///<  枠座標 右上
  AWB_LightSource_Pnt_2,                                    ///<  枠座標 右下
  AWB_LightSource_Pnt_3,                                    ///<  枠座標 左上
} AWB_LightSource_Pnt;


/**
 * @enum	AWBLightSourceIdx
 * @brief	光源枠格納先定義
 */
typedef enum
{
  AWBLightSource_Idx_0 = 0,                                 ///< 光源枠データindex番号0
  AWBLightSource_Idx_1,                                     ///< 光源枠データindex番号1
  AWBLightSource_Idx_2,                                     ///< 光源枠データindex番号2
  AWBLightSource_Idx_3,                                     ///< 光源枠データindex番号3
  AWBLightSource_Idx_4,                                     ///< 光源枠データindex番号4
  AWBLightSource_Idx_5 = 5,                                 ///< 光源枠データindex番号5
  AWBLightSource_Idx_6,                                     ///< 光源枠データindex番号6
  AWBLightSource_Idx_7,                                     ///< 光源枠データindex番号7

  AWBLightSource_Idx_Max,                                   ///< 光源枠数:15

  AWB_WeightLightSourceMax = AWBLightSource_Idx_Max + 1,    ///< 重み付け処理用光源枠数
} AWBLightSourceIdx;


//
//	OPD信頼性判定関連定義
//

/**
 * @enum	AWBOPDTrustJudge
 * @brief	信頼性判定結果定義
 */
typedef enum
{
  AWBOPDTrustJudge_High = 0,                                ///<  0.高信頼性判定
  AWBOPDTrustJudge_Low_Hold,                                ///<  1.低信頼性/ホールド選択
  AWBOPDTrustJudge_Low_Default,                             ///<  2.低信頼性/デフォルト値選択

  AWBOPDTrustJudge_Max,                                     ///<  信頼性判定結果総数
} AWBOPDTrustJudge;


//
//	[AWB-10]安定性確認用定義
//
//const UCHAR  AWB_StableFlact = 0x01;                        ///< 変動中
//const UCHAR  AWB_StableTerm = 0x02;                         ///< 安定期間確認中
const UCHAR  AWB_StableComp = 0x04;                         ///< 安定性確認・差異評価完了
const USHORT AWB_StableTerm_Min = 4;                        ///< 安定性確認期間下限
const USHORT AWB_StableTerm_Max = 36;                       ///< 安定性確認期間上限

const UCHAR  AwbStatus_flact = 0;                           ///< 変動中
const UCHAR  AWBStatus_Convergence = 1;                     ///< 収束中
const UCHAR  AWBStauts_Stable = 2;                          ///< 安定中


/**
 * @enum	AWB_Adjust_Dir
 * @brief	引き込み範囲簡易調整時 マゼンタ方向/グリーン方向定義
 */
typedef enum {
  AWB_Adjust_Dir_Mg = 0,                                    ///<  Mg方向選択
  AWB_Adjust_Dir_G,                                         ///<  G方向選択
} AWB_Adjust_Dir;


/**
 * @enum AWB_SpectrumAdjust
 * @brief バラつき調整 調整種別定義
 */
typedef enum {
  AWB_SpectrumAdjust_LTemp = 0,                             ///<  低色温度側調整
  AWB_SpectrumAdjust_HTemp,                                 ///<  高色温度側調整
} AWB_SpectrumAdjust;


//
//	エラーコード定義
//
const AWB_ER  AWB_E_OK = 0;                                 ///< 正常終了
const AWB_ER  AWB_E_ER = -1;                                ///< 異常終了

const AWB_ER  AWB_E_IMAGE_ADDR         = (UINT)0x80000001l; ///< OPD信頼性判定エラー エラーコード定義
const AWB_ER  AWB_E_COLOR_DATA         = (UINT)0x80000002l; ///< OPD信頼性判定エラー エラーコード定義
const AWB_ER  AWB_E_BALANCE_CENTER     = (UINT)0x80000004l; ///< 重心計算エラー エラーコード定義
const AWB_ER  AWB_E_OPD_WEIGHT         = (UINT)0x80000008l; ///< OPD重み付けエラー エラーコー	ド定義
const AWB_ER  AWB_E_WEIGHT             = (UINT)0x80000010l; ///< 光源枠重み付けエラー エラーコード定義
const AWB_ER  AWB_E_OPD_TRUST          = (UINT)0x80000020l; ///< OPD信頼性判定エラー エラーコード定義
const AWB_ER  AWB_E_MGG_DIRECT         = (UINT)0x80000040l; ///< Mg-G方向調整エラー エラーコード定義
const AWB_ER  AWB_E_MGG_DIRECT_STD     = (UINT)0x80000080l; ///< Mg-G方向調整(標準モード)エラー エラーコード定義
const AWB_ER  AWB_E_MGG_DIRECT_INDOOR  = (UINT)0x80000100l; ///< Mg-G方向調整(シーンモード)エラー エラーコード定義
const AWB_ER  AWB_E_MGG_DIRECT_OUTDOOR = (UINT)0x80000200l; ///< Mg-G方向調整(アウトドアモード)エラー エラーコード定義
const AWB_ER  AWB_E_MGG_DIRECT_LED     = (UINT)0x80000400l; ///< Mg-G方向調整(アウトドアモード)エラー エラーコード定義
const AWB_ER  AWB_E_OFFSET             = (UINT)0x80000800l; ///< オフセット調整エラー エラーコード定義
const AWB_ER  AWB_E_MATRIX             = (UINT)0x80001000l; ///< マトリックス演算エラー エラーコード定義
const AWB_ER  AWB_E_CONVERGENCE        = (UINT)0x80002000l; ///< 収束制御演算エラー エラーコードコード定義
const AWB_ER  AWB_E_SPECTRUM_ADJ       = (UINT)0x80004000l; ///< センサー分光バラつき調整エラー エラーコード定義

#endif /* AXMISPAWBCOMMON_HPP_ */
