/*
 * AXMIspAwbState.cpp
 */

#include "../AXMCommon/AXMCommonConfig.hpp"
#include "../AXMCommon/AXMCommonParam.hpp"
#include "../AXMCommon/AXMCommonSetParam.hpp"
#include "../AXMCommon/AXMCommonStruct.hpp"

#include "AXMIspAwbTypedefine.hpp"
#include "AXMIspAwbCommon.hpp"								//	AXMCommonSetParam.hppとセットでincludeする必要がある
#include "AXMIspAwbOPDConfig.hpp"
#include "AXMIspAwbSettings.hpp"
#include "AXMIspAwbAlgorithm.hpp"
#ifdef AXM_ISP_CT_AWB
#include "../AXMIspCT/AXMIspCTAwb.hpp"
#endif

#include "AXMIspAwb.hpp"
#include "AXMIspAwb2.hpp"
#include "../AXMIsp/AXMIsp.hpp"
#include "../../project/refkit/AXMIspConfig.hpp"
#ifdef AXM_ISP_CT_AWB
#include "../AXMIspCT/AXMIspCTAwb.hpp"
#endif
#ifdef USE_AXFTEST_COMMAND
#include "../AXMIsp/AXMIsp.hpp"
//#include "../AXMIspAf/AXMIspAf.hpp"
#include "../AXMIspAe/AXMIspAe.hpp"
#include <stdio.h>
#include <string.h>
#include <sstream>
#include <string>
#endif /* USE_AXFTEST_COMMAND */

ST_AWB_ADJUST g_AwbAdjust   __attribute__ ((at (0x20059000)));		//今回セクション名では無く直接アドレス指定を行う ((section ("ispParam1")));
ST_AWB_STATUS g_AwbStatus   __attribute__ ((at (0x20059200)));		//今回セクション名では無く直接アドレス指定を行う ((section ("ispParam1")));

// 3rdリリースから、「モデルイベント」と「デバイスイベント」の
// 登録が可能となる。
//
// 状態テーブルは、状態ごとに定義し、イベントIDとメンバ関数の紐付けを行う。
// ※状態テーブルの最後は、必ず{0,NULL}で終了する必要がある。

// STATE_WATING状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
const AXMIspAwb::StateTable AXMIspAwb::state_wating[] = {
    { AXMIspAwb::EVENT_SPEC_ADDR,
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::funcSpecAddr }, //  設定値保存先アドレス通知
    //  モード切替
    { AXMIspAwb::EVENT_ATW_MODE,                            //  ATWモード切替
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0008 },
    { AXMIspAwb::EVENT_MANU_MODE,                           //  マニュアルモード切替
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0009 },
    { AXMIspAwb::EVENT_ONE_PUSH,                            //  ワンプッシュモード切替
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix000A },
    { AXMIspAwb::EVENT_ADJUST,                              //  調整モード(WB調整)切替
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix000B },
		// 該当処理なしのため不要
    //{ AXMIspAwb::EVENT_WAITING,                             //  モード変更なし
    //  (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix000C },
#ifdef USE_AXFTEST_COMMAND
    { AXMIspAwb::EVENT_AXCOMM_TEST,
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::funcAxcommTest },
    { AXMIspAwb::EVENT_PRIORITY_TEST,
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::funcPriorityTest },
    { AXMIspAwb::EVENT_LOOPBACK_TEST,
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::funcLoopbackTest },
#endif /*USE_AXFTEST_COMMAND*/
    {0,NULL}
};

// STATE_ATWMode状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
const AXMIspAwb::StateTable AXMIspAwb::state_atw_mode[] = {
    { AXMIspAwb::EVENT_COLOR_DATA,                          //  色データ計算処理
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0100 },
    { AXMIspAwb::EVENT_OPD_MASK,                            //  OPDマスク処理
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0101 },
    { AXMIspAwb::EVENT_LIGHT_SOURCE,                        //  光源枠判定処理
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0102 },
    { AXMIspAwb::EVENT_WEIGHT_DATA,                         //  重み付け処理
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0103 },
    { AXMIspAwb::EVENT_BALANCE_CENTER,                      //  重心計算処理
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0104 },
    { AXMIspAwb::EVENT_TARGET,                              //  調整/収束制御処理
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0105 },
    { AXMIspAwb::EVENT_CONTROL,                             //  ゲイン/マトリックス設定処理
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0106 },
    //  WDRモード追加によりフレーム数が足りなくなったので、matrix0104〜matrix0106をひとまとめにする
    //  問題なく動作していれば、matrix0104〜matrix0106までは削除可能
    { AXMIspAwb::EVENT_TARGET_CONTROL,                      //  重心計算/調整・収束制御/ゲイン・マトリックス設定処理
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0107 },
    //  モード切替
    { AXMIspAwb::EVENT_ATW_MODE,                            //  ATWモード切替(dummy)
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0108 },
    { AXMIspAwb::EVENT_MANU_MODE,                           //  マニュアルモード切替
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0109 },
    { AXMIspAwb::EVENT_ONE_PUSH,                            //  ワンプッシュモード切替
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix010A },
    { AXMIspAwb::EVENT_ADJUST,                              //  調整モード(WB調整)切替
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix010B },
		// 該当処理なしのため不要
    //{ AXMIspAwb::EVENT_WAITING,                             //  待機中:調整モード(WB調整以外)切替
    //  (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix010C },
#ifdef USE_AXFTEST_COMMAND
    { AXMIspAwb::EVENT_AXCOMM_TEST,
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::funcAxcommTest },
    { AXMIspAwb::EVENT_PRIORITY_TEST,
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::funcPriorityTest },
    { AXMIspAwb::EVENT_LOOPBACK_TEST,
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::funcLoopbackTest },
#endif /*USE_AXFTEST_COMMAND*/
    {0,NULL}
};

// STATE_ManuMode状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
const AXMIspAwb::StateTable AXMIspAwb::state_manu_mode[] = {
    { AXMIspAwb::EVENT_COLOR_DATA,                          //  色データ計算処理
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0200 },
    { AXMIspAwb::EVENT_CONTROL,                             //  ゲイン/マトリックス設定
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0201 },
    //  モード切替
    { AXMIspAwb::EVENT_ATW_MODE,                            //  ATWモード切替
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0208 },
    { AXMIspAwb::EVENT_MANU_MODE,                           //  マニュアルモード切替(dummy)
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0209 },
    { AXMIspAwb::EVENT_ONE_PUSH,                            //  ワンプッシュモード切替
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix020A },
    { AXMIspAwb::EVENT_ADJUST,                              //  調整モード(WB調整)切替
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix020B },
		// 該当処理なしのため不要
    //{ AXMIspAwb::EVENT_WAITING,                             //  待機中:調整モード(WB調整以外)切替
    //  (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix020C },
#ifdef USE_AXFTEST_COMMAND
    { AXMIspAwb::EVENT_AXCOMM_TEST,
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::funcAxcommTest },
    { AXMIspAwb::EVENT_PRIORITY_TEST,
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::funcPriorityTest },
    { AXMIspAwb::EVENT_LOOPBACK_TEST,
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::funcLoopbackTest },
#endif /*USE_AXFTEST_COMMAND*/
    {0,NULL}
};

// STATE_OnePush状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
const AXMIspAwb::StateTable AXMIspAwb::state_one_push[] = {
    { AXMIspAwb::EVENT_COLOR_DATA,                          //  色データ計算処理
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0300 },
    { AXMIspAwb::EVENT_LIGHT_SOURCE,                        //  光源枠判定処理
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0301 },
    { AXMIspAwb::EVENT_BALANCE_CENTER,                      //  重心計算処理
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0302 },
    { AXMIspAwb::EVENT_TARGET,                              //  調整/収束制御処理
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0303 },
    { AXMIspAwb::EVENT_CONTROL,                             //  ゲイン/マトリックス設定処理
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0304 },
    //  モード切替
    { AXMIspAwb::EVENT_ATW_MODE,                            //  ATWモード切替
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0308 },
    { AXMIspAwb::EVENT_MANU_MODE,                           //  マニュアルモード切替
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix0309 },
    { AXMIspAwb::EVENT_ONE_PUSH,                            //  ワンプッシュモード切替(dummy)
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix030A },
    { AXMIspAwb::EVENT_ADJUST,                              //  調整モード(WB調整)切替
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix030B },
		// 該当処理なしのため不要
    //{ AXMIspAwb::EVENT_WAITING,                             //  待機中:調整モード(WB調整以外)切替
    //  (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix030C },
#ifdef USE_AXFTEST_COMMAND
    { AXMIspAwb::EVENT_AXCOMM_TEST,
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::funcAxcommTest },
    { AXMIspAwb::EVENT_PRIORITY_TEST,
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::funcPriorityTest },
    { AXMIspAwb::EVENT_LOOPBACK_TEST,
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::funcLoopbackTest },
#endif /*USE_AXFTEST_COMMAND*/
    {0,NULL}
};

// STATE_ADJUST状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
const AXMIspAwb::StateTable AXMIspAwb::state_adjust[] = {
    { AXMIspAwb::EVENT_COLOR_DATA,                          //  色データ計算処理
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix1000 },
    //  モード切替
    { AXMIspAwb::EVENT_ATW_MODE,                            //  ATWモード切替
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix1008 },
    { AXMIspAwb::EVENT_MANU_MODE,                           //  マニュアルモード切替
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix1009 },
    { AXMIspAwb::EVENT_ONE_PUSH,                            //  ワンプッシュモード切替
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix100A },
    { AXMIspAwb::EVENT_ADJUST,                              //  調整モード切替(dummy)
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix100B },
		// 該当処理なしのため不要
    //{ AXMIspAwb::EVENT_WAITING,                             //  待機中:調整モード(WB調整以外)切替
    //  (AXMIspAwb::StateFuncPtr) &AXMIspAwb::matrix100C },
#ifdef USE_AXFTEST_COMMAND
    { AXMIspAwb::EVENT_AXCOMM_TEST,
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::funcAxcommTest },
    { AXMIspAwb::EVENT_PRIORITY_TEST,
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::funcPriorityTest },
    { AXMIspAwb::EVENT_LOOPBACK_TEST,
      (AXMIspAwb::StateFuncPtr) &AXMIspAwb::funcLoopbackTest },
#endif /*USE_AXFTEST_COMMAND*/
    {0,NULL}
};


ax::actorFuncStatus AXMIspAwb::funcSpecAddr(const void *pParam, int size) {
  if((0 < size) && (pParam != 0x00000000ul)) {
    ST_MSG *msg = (ST_MSG *)pParam;
    p_spec = (ST_SPEC *)msg->data;

#ifdef AXM_ISP_CT_AWB

    AXMIspCTAwb::SetSpecAwbSettings(p_spec);
    AXMIspCTAwb::SetCalData(&CalData);
    AXMIspCTAwb::SetLog(&m_log);
#endif
    //  パラメータチェック
    CheckParameter();

#ifndef ENABLE_OPD_SET
    //  [AWB-13]OPD関連設定値
    //  起動時に一度だけ取得する
    AWBSettings.OPDSet.setHDiv(p_spec->AWB.OPDSet.HDiv);
    AWBSettings.OPDSet.setVDiv(p_spec->AWB.OPDSet.VDiv);
#endif  //  ENABLE_OPD_SET

    state = STATE_ATWMode;
#ifndef PARASOFT_CPPTEST
    setNextState(state);
#endif  //  PARASOFT_CPPTEST
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0008(const void *pParam, int size) {
  //  ATWモード切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ATWMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0009(const void *pParam, int size) {
  //  マニュアルモード切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ManuMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix000A(const void *pParam, int size) {
  //  ワンプシュモード切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_OnePush;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix000B(const void *pParam, int size) {
  //  調整モード(WB調整)切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ADJUST;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix000C(const void *pParam, int size) {
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_WAITING;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0100(const void *pParam, int size) {
  //  パラメータチェック
  CheckParameter();

  if((0 < size) && (pParam != 0x00000000ul))
  {
    //  受信メッセージ取得
    ST_MSG  *msg = (ST_MSG *)pParam;
    UCHAR *p_img;
    p_img = (UCHAR *)msg->data;                             //  3A画像データ 先頭アドレス設定
    //  色データ計算処理実行
    AXMIspAwbAlgorithmColorData NormalData;
    NormalData.Exec(AWBSettings, p_img, ImageData, CalData.ColorData);

#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
    if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_END), 0, 0)) {
      //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_END");
    }
#endif  //  PARASOFT_CPPTEST

    state = STATE_ATWMode;
#ifndef PARASOFT_CPPTEST
    setNextState(state);
#endif  //  PARASOFT_CPPTEST
  }
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0101(const void *pParam, int size) {
  {
    //  OPDマスク処理実行
    AXMIspAwbAlgorithmOPDMaskedColorData  OPDMaskData;
    OPDMaskData.Exec(AWBSettings, CalData.ColorData);
  }

#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_END), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_END");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ATWMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0102(const void *pParam, int size) {
  {
    //  光源枠判定処理
    AXMIspAwbAlgorithmLightSourceJudgedColorData  LightSourceData;
    LightSourceData.Exec(AWBSettings, CalData, *JudgeLightSource);
  }

#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_END), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_END");
  }
#endif  //  CPPTEST_PARASOFT

  state = STATE_ATWMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0103(const void *pParam, int size) {
  if((size > 0) && (pParam != 0x00000000ul))
  {
#ifndef AXM_ISP_CT_AWB
    //  明るさ情報取得
    ST_MSG *p_msg = (ST_MSG *)pParam;
    ST_AWB_CALC *calc = (ST_AWB_CALC *)p_msg->data;
    CalData.BrightData = calc->Luminance;
#else
    // 明るさ情報が存在する場合は、採用する(testno = 5 FramePage = 5以降で設定。その他のtest noでは0設定)
    if (AXMIspCTAwb::GetBrightData() == -1) {
       ST_MSG *p_msg = (ST_MSG *)pParam;
       ST_AWB_CALC *calc = (ST_AWB_CALC *)p_msg->data;
    	CalData.BrightData = calc->Luminance;
    }
#endif
  }

  //  ATW停止閾値未満のときは演算を行わない
  if(AWBSettings.StopLowBright <= CalData.BrightData)
  {
    //  重み付け処理
    AXMIspAwbAlgorithmWeightedColorData WeightData;
    WeightData.Exec(AWBSettings, CalData, *JudgeLightSource);
  }

#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_END), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_END");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ATWMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0104(const void *pParam, int size) {
  //  ATW停止閾値未満のときは演算を行わない
  if(AWBSettings.StopLowBright <= CalData.BrightData)
  {
    //  重心計算処理
    AXMIspAwbAlgorithmBalanceCenterData BalanceCenter;
    BalanceCenter.Exec(AWBSettings, CalData, *JudgeLightSource);
  }

#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_END), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_END");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ATWMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0105(const void *pParam, int size) {
  //  ATW停止閾値未満のときは演算を行わない
  if(AWBSettings.StopLowBright <= CalData.BrightData)
  {
    //  調整/収束制御処理
    AXMIspAwbAlgorithmAWBTarget  AWBTarget;
    AWBTarget.ExecATWMode(AWBSettings, CalData, *JudgeLightSource);
		
#ifdef AXM_ISP_CT_AWB
    AXMIspCTAwb::CheckResult();
#endif
  }

#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_END), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_END");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ATWMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0106(const void *pParam, int size) {
  //  ATW停止閾値未満のときは演算を行わない
  if(AWBSettings.StopLowBright <= CalData.BrightData)
  {
    //  ゲイン/マトリックス設定処理
    AXMIspAwbAlgorithmCurrentControlValue ControlValue;
    ControlValue.Exec(CalData, AWBSettings);
  }

#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_END), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_END");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ATWMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0107(const void *pParam, int size) {
  //  ATW停止閾値未満のときは演算を行わない
  if(AWBSettings.StopLowBright <= CalData.BrightData)
  {
//  matrix0104
    //  重心計算処理
    AXMIspAwbAlgorithmBalanceCenterData BalanceCenter;
    BalanceCenter.Exec(AWBSettings, CalData, *JudgeLightSource);

//  matrix0105
    //  調整/収束制御処理
    AXMIspAwbAlgorithmAWBTarget  AWBTarget;
    AWBTarget.ExecATWMode(AWBSettings, CalData, *JudgeLightSource);
		
#ifdef AXM_ISP_CT_AWB
    AXMIspCTAwb::CheckResult();
#endif

//  matrix0106
    //  ゲイン/マトリックス設定処理
    AXMIspAwbAlgorithmCurrentControlValue ControlValue;
    ControlValue.Exec(CalData, AWBSettings);
  }

#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_END), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_END");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ATWMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0108(const void *pParam, int size) {
  //  モード切替完了通知
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0109(const void *pParam, int size) {
  //  マニュアルモード切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ManuMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix010A(const void *pParam, int size) {
  //  ワンプシュモード切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_OnePush;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix010B(const void *pParam, int size) {
  //  調整モード(WB調整)切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ADJUST;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix010C(const void *pParam, int size) {
  //  待機中:調整モード(WB調整)切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_WAITING;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0200(const void *pParam, int size) {
  //  パラメータチェック
  CheckParameter();

  if((0 < size) && (pParam != 0x00000000ul))
  {
    //  受信メッセージ取得
    ST_MSG  *msg = (ST_MSG *)pParam;
    UCHAR *p_img;
    p_img = (UCHAR *)msg->data;                             //  3A画像データ 先頭アドレス設定
    //  色データ計算処理実行
    AXMIspAwbAlgorithmColorData NormalData;
    NormalData.Exec(AWBSettings, p_img, ImageData, CalData.ColorData);
  }

#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_END), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_END");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ManuMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0201(const void *pParam, int size) {
  {
    //  ゲイン/マトリックス設定処理
    AXMIspAwbExecCalcManuMode CalcManuMode;
    CalcManuMode.Exec(AWBSettings, CalData);
  }

#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_END), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_END");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ManuMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0208(const void *pParam, int size) {
  //  ATWモード切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ATWMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0209(const void *pParam, int size) {
  //  モード切替完了通知
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix020A(const void *pParam, int size) {
  //  ワンプシュモード切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_OnePush;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix020B(const void *pParam, int size) {
  //  調整モード(WB調整)切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ADJUST;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix020C(const void *pParam, int size) {
  //  待機中:調整モード(WB調整以外)切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_WAITING;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0300(const void *pParam, int size) {
  //  パラメータチェック
	CheckParameter();

  if((0 < size) && (pParam != 0x00000000ul))
  {
    //  One Pushの演算は、実行レジスタが1の時のみ行う
    //  実行レジスタのクリアは、ゲイン/マトリックス設定(matirx0304)実行後にクリアする
    if(AWBSettings.OnePush.Start == 1)
    {
      //  受信メッセージ取得
      ST_MSG  *msg = (ST_MSG *)pParam;
      UCHAR *p_img;
      p_img = (UCHAR *)msg->data;                             //  3A画像データ 先頭アドレス設定
      //  収束制御用パラメータ初期化
      CalData.WBcnt = 0;
      //  色データ計算処理実行
      AXMIspAwbAlgorithmColorData NormalData;
      NormalData.Exec(AWBSettings, p_img, ImageData, CalData.ColorData);
      //  OPDエリア設定
      //    処理時間が足りない時は、新しくマトリックスを作成して対応すること
      for(USHORT i = 0; i < AWBSettings.OPDSet.VDiv; i++)     //  垂直方向
      {
        for(USHORT j = 0; j < AWBSettings.OPDSet.HDiv; j++)   //  水平方向
        {
          if((AWBSettings.OnePush.OPDArea[AWBOnePushPnt_Start].v <= i) &&
             (i <= AWBSettings.OnePush.OPDArea[AWBOnePushPnt_End].v) &&
             (AWBSettings.OnePush.OPDArea[AWBOnePushPnt_Start].h <= j) &&
             (j <= AWBSettings.OnePush.OPDArea[AWBOnePushPnt_End].h))
          {
            //  有効エリア
            CalData.ColorData.Enabled[i][j] = True;
          }
          else
          {
            //  無効エリア
            CalData.ColorData.Enabled[i][j] = False;
          }
        }
      }
    }
  }

#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_END), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_END");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_OnePush;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0301(const void *pParam, int size) {
  if(AWBSettings.OnePush.Start == 1)
  {
    //  光源枠判定処理 スタート
    AXMIspAwbAlgorithmLightSourceJudgedColorData  LightSourceData;
    LightSourceData.Exec(AWBSettings, CalData, *JudgeLightSource);
  }

#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_END), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_END");
  }
#endif  //  PARASOFT_CPPTEST
  state = STATE_OnePush;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0302(const void *pParam, int size) {
  if(AWBSettings.OnePush.Start == 1)
  {
    //  OPD積算処理
    AXMIspAwbAlgorithmWeightedColorData WeightData;
    WeightData.ProcOPDArea(AWBSettings, CalData, *JudgeLightSource);
    //  重心計算処理
    AXMIspAwbAlgorithmBalanceCenterData BalanceCenter;
    BalanceCenter.Exec(AWBSettings, CalData, *JudgeLightSource);
  }

#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_END), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_END");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_OnePush;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0303(const void *pParam, int size) {
  if((AWBSettings.OnePush.Start == 1) ||
     (CalData.WBcnt <= AWBSettings.OnePush.Speed))
  {
    //  調整/収束制御処理
    AXMIspAwbAlgorithmAWBTarget  AWBTarget;
    AWBTarget.ExecOnePushMode(AWBSettings, CalData, *JudgeLightSource);
  }

#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_END), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_END");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_OnePush;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0304(const void *pParam, int size) {
  if((AWBSettings.OnePush.Start == 1) ||
     (CalData.WBcnt <= AWBSettings.OnePush.Speed))
  {
    //  ゲイン/マトリックス設定処理
    AXMIspAwbAlgorithmCurrentControlValue ControlValue;
    ControlValue.Exec(CalData, AWBSettings);
		
    //  実行フラグクリア
    AWBSettings.OnePush.Start = 0;
  }

#ifndef PARASOFT_CPPTEST                //  PARASOFT_CPPTEST
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_END), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_END");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_OnePush;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0308(const void *pParam, int size) {
  //  ATWモード切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ATWMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix0309(const void *pParam, int size) {
  //  マニュアルモード切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外する
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ManuMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PASRASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix030A(const void *pParam, int size) {
  //  モード切替完了通知
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外する
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix030B(const void *pParam, int size) {
  //  調整モード(WB調整)切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ADJUST;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix030C(const void *pParam, int size) {
  //  待機中:調整モード(WB調整以外)切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_WAITING;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix1000(const void *pParam, int size) {
  if((0 < size) && (pParam != 0x00000000ul))
  {
    //  バラつき調整実行
    //    受信メッセージから低色温度側調整起動か高色温度側調整起動かを判断する
    AXMIspAwbAlgorithmColorData ColorData;
#ifndef ENABLE_AWB_ADJUST_AF_LENS_DATA
    AXMIspAwbAlgorithmBalanceCenterData BalanceCenter;
#endif
    AXMIspAwbAlgorithmSpectrumAdjust  SpectrumAdjust;

    //  受信メッセージ取得
    ST_MSG  *msg = (ST_MSG *)pParam;
#ifndef PARASOFT_CPPTEST
    //  C++TESTでは色データが重心となるようにデータを与えて調整後データを確認するので、
    //  色データ計算処理を行わないように条件コンパイル定義を追加する
    UCHAR *p_img;
    p_img = (UCHAR *)msg->data;                             //  3A画像データ 先頭アドレス設定
    //  色データ計算処理実行
    ColorData.Exec(AWBSettings, p_img, ImageData, CalData.ColorData);
#endif  //  PARASOFT_CPPTEST
#ifndef ENABLE_AWB_ADJUST_AF_LENS_DATA
    //  重心計算処理
    BalanceCenter.ExecAdjustMode(AWBSettings, CalData, *JudgeLightSource);
#endif  //  ENABLE_AWB_ADJUST_AF_LENS_DATA
    //  重心座標をデフォルト座標にコピー
    if((msg->cmd & Cmd_Adjust_AWB_Low) == Cmd_Adjust_AWB_Low) {
#ifdef  ENABLE_AWB_ADJUST_AF_LENS_DATA
      //  AF-Lens 2800Kポイントデータ設定
      CalData.CenterPnt.Data[0].bg = 102;
      CalData.CenterPnt.Data[0].rg = 131;
#endif  //  ENABLE_AWB_ADJUST_AF_LENS_DATA
      //  5800K座標基準で正規化する
      SpectrumAdjust.Init(AWB_SpectrumAdjust_LTemp, CalData.CenterPnt.Data[0], AWBSettings);
    }
    else if ((msg->cmd & Cmd_Adjust_AWB_High) == Cmd_Adjust_AWB_High) {
#ifdef  ENABLE_AWB_ADJUST_AF_LENS_DATA
      //  AF-Lens 5800Kポイントデータ設定
      CalData.CenterPnt.Data[0].bg = 160;
      CalData.CenterPnt.Data[0].rg =  89;
#endif  //  ENABLE_AWB_ADJUST_AF_LENS_DATA
      //  2800K座標基準で正規化する
      SpectrumAdjust.Init(AWB_SpectrumAdjust_HTemp, CalData.CenterPnt.Data[0], AWBSettings);
    }
    //  判定用光源枠データ更新
    refleshJudgedLightSourceData();
    //  更新データセット
    static ST_AWB_ADJUST AdjData;
    //  調整ポイントコピー
    AdjData.pntLowTemp.Bg = AWBSettings.SpectrumAdjust.LowTempPnt.bg;
    AdjData.pntLowTemp.Rg = AWBSettings.SpectrumAdjust.LowTempPnt.rg;
    AdjData.pntHighTemp.Bg = AWBSettings.SpectrumAdjust.HighTempPnt.bg;
    AdjData.pntHighTemp.Rg = AWBSettings.SpectrumAdjust.HighTempPnt.rg;
    //  ARMとの共有エリアにもコピー
    g_AwbAdjust.pntLowTemp.Bg = AWBSettings.SpectrumAdjust.LowTempPnt.bg;
    g_AwbAdjust.pntLowTemp.Rg = AWBSettings.SpectrumAdjust.LowTempPnt.rg;
    g_AwbAdjust.pntHighTemp.Bg = AWBSettings.SpectrumAdjust.HighTempPnt.bg;
    g_AwbAdjust.pntHighTemp.Rg = AWBSettings.SpectrumAdjust.HighTempPnt.rg;
    //  光源枠データコピー
    for(INT i = 0; i < AWBLightSource_Rolling_Max; i++) {
      for(INT j = 0; j < AWB_LightSourcePnt; j++) {
        AdjData.LightSource[i].Area[j].Bg = AWBSettings.LightSource.Area[i].CPnt[j].bg;
        AdjData.LightSource[i].Area[j].Rg = AWBSettings.LightSource.Area[i].CPnt[j].rg;
        //  ARMとの共有エリアにもコピー
        g_AwbAdjust.LightSource[i].Area[j].Bg = AWBSettings.LightSource.Area[i].CPnt[j].bg;
        g_AwbAdjust.LightSource[i].Area[j].Rg = AWBSettings.LightSource.Area[i].CPnt[j].rg;
      }
    }
    //  光源デフォルト座標コピー
    for(INT i = 0; i < AWBLightDefault_Max; i++) {
      AdjData.LightDefault[i].Bg = AWBSettings.LightDefault.CPnt[i].bg;
      AdjData.LightDefault[i].Rg = AWBSettings.LightDefault.CPnt[i].rg;
      //  ARMとの共有エリアにもコピー
      g_AwbAdjust.LightDefault[i].Bg = AWBSettings.LightDefault.CPnt[i].bg;
      g_AwbAdjust.LightDefault[i].Rg = AWBSettings.LightDefault.CPnt[i].rg;
    }
    //  更新データ送信
    static ST_MSG  sndMsg;
    sndMsg.sid = SID_AXMIspAwb;
    sndMsg.rid = RID_AXMIsp;
    sndMsg.data = (void *)&AdjData;
#ifndef PARASOFT_CPPTEST
    if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_ADJUST_END), &sndMsg, sizeof(ST_MSG))) {
      //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_ADJUST_END");
    }
#endif  //  PARASOFT_CPPTEST
  }

  state = STATE_ADJUST;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PASRASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix1008(const void *pParam, int size) {
  //  ATWモード切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ATWMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix1009(const void *pParam, int size) {
  //  マニュアルモード切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_ManuMode;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix100A(const void *pParam, int size) {
  //  OnePushモード切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_OnePush;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix100B(const void *pParam, int size) {
  //  モード切替完了通知
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::matrix100C(const void *pParam, int size) {
  //  待機中:調整モード(WB調整以外)切替
#ifndef PARASOFT_CPPTEST                //  CPPTESTでは除外
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AWB_MODE_CHANGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AWB_MODE_CHANGE");
  }
#endif  //  PARASOFT_CPPTEST

  state = STATE_WAITING;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}


//
// 設定値監視処理
//
AWB_ER	AXMIspAwb::CheckParameter()
{
  AWB_ER  ret = AWB_E_OK;
  AWB_ER  ret1;
  UCHAR   f_LightSourceRefresh = false;                     //  演算用光源枠 更新要求フラグ

  if(JudgeLightSource == NULL) {
    f_LightSourceRefresh = true;                            //  演算用光源枠 更新要求フラグ
  }

  //  [AWB-1]AWBモード選択 設定値取得
  if(AWBSettings.AWB_Mode != (AWBMode)p_spec->AWB.AWBMode) {
    ret1 = AWBSettings.setAWBMode((AWBMode)p_spec->AWB.AWBMode);
    if(ret1 == AWB_E_ER) {              // 変更できない時は、現在値を書き戻す
      p_spec->AWB.AWBMode = AWBSettings.AWB_Mode;
      ret = AWB_E_ER;
    }
    else {
    	f_LightSourceRefresh = true;                        //  演算用光源枠 更新要求フラグON
    }
  }
  //  [AWB-2]ATWシーンモード選択 設定値取得
  if(AWBSettings.ATW_SceaneMode != (ATWSceaneMode)p_spec->AWB.ATWSceaneMode) {
    ret1 = AWBSettings.setATWSceaneMode((ATWSceaneMode)p_spec->AWB.ATWSceaneMode);
    if(ret1 == AWB_E_ER) {              // 変更できない時は、現在値を書き戻す
      p_spec->AWB.ATWSceaneMode = AWBSettings.ATW_SceaneMode;
      ret = AWB_E_ER;
    }
    else {
    	f_LightSourceRefresh = true;                        //  演算用光源枠 更新要求フラグON
    }
  }
  //  [AWB-3]色温度指定(色温度指定マニュアルモード時) 設定値取得
  AWBSettings.setColorTemp(p_spec->AWB.ManuModeColorTemp);
  //  [AWB-4]照明指定(照明指定マニュアルモード時) 設定値取得
  ret1 = AWBSettings.setLightSelect((AWBLightSelect)p_spec->AWB.ManuModeLightSelect);
  if(ret1 == AWB_E_ER) {              // 変更できない時は、現在値を書き戻す
    p_spec->AWB.ManuModeLightSelect = AWBSettings.LightSelect;
    ret = AWB_E_ER;
  }
  //  [AWB-5]全引き込み実行(One Pushモード) 設定値取得
  ST_ONE_PUSH *AWBOnePush = (ST_ONE_PUSH*)&(p_spec->AWB.OnePush);
  if(AWBOnePush->Start != 0)
  {
    AWBSettings.OnePush.setStart(AWBOnePush->Start);
  }
  for(INT i = 0; i < OnePushPointMax; i++) {
    ImgPoint pnt;
    pnt.h = p_spec->AWB.OnePush.Area[i].h;
    pnt.v = p_spec->AWB.OnePush.Area[i].v;
    ret1 = AWBSettings.OnePush.setOPDArea((AWBOnePushPnt)i, pnt);
    if(ret1 == AWB_E_ER) {
      ret = AWB_E_ER;
      break;
    }
  }
  ret1 = AWBSettings.OnePush.setRange((AWBOnePushRange)AWBOnePush->Range);
  if(ret1 == AWB_E_ER) {                // 変更できない時は、現在値を書き戻す
    AWBOnePush->Range = AWBSettings.OnePush.Range;
    ret = AWB_E_ER;
  }
  AWBSettings.OnePush.setSpeed(AWBOnePush->Speed);
  //  引き込み範囲設定値更新フラグ確認
  if((p_spec->changeStatus[AXH_Index_SPEC_CHG_AWB] & SPEC_CHG_AWB_Range) == SPEC_CHG_AWB_Range) {
    //  [AWB-6]AWB光源枠引き込み範囲簡易調整
    ret1 = AWBSettings.LightRange.setHTempAdjust(p_spec->AWB.LightRange.HTempAdjust);
    if(ret1 == AWB_E_ER) {                // 変更できない時は、現在値を書き戻す
      p_spec->AWB.LightRange.HTempAdjust = AWBSettings.LightRange.HTempAdjust;
      ret = AWB_E_ER;
    }
    //  高色温度側の上限座標を更新
    AWBSettings.setHTempAdjustPnt();
    ret1 = AWBSettings.LightRange.setLTempAdjust(p_spec->AWB.LightRange.LTempAdjust);
    if(ret1 == AWB_E_ER) {                // 変更できない時は、現在値を書き戻す
      p_spec->AWB.LightRange.LTempAdjust = AWBSettings.LightRange.LTempAdjust;
      ret = AWB_E_ER;
    }
    //  低色温度側の上限座標を更新
    AWBSettings.setLTempAdjustPnt();
    AWBSettings.LightRange.setMgDirAdjust(p_spec->AWB.LightRange.MgDirAdjust);
    AWBSettings.LightRange.setGDirAdjust(p_spec->AWB.LightRange.GDirAdjust);
    //  光源枠座標を調整(Mg-G方向引き込み簡易調整)
    AWBSettings.setMgGDirAdjust();
    //  設定値更新フラグをクリア
    p_spec->changeStatus[AXH_Index_SPEC_CHG_AWB] &= ~SPEC_CHG_AWB_Range;
  }
  //  WBオフセット調整更新フラグ確認
  if((p_spec->changeStatus[AXH_Index_SPEC_CHG_AWB] & SPEC_CHG_AWB_WBOffset) == SPEC_CHG_AWB_WBOffset) {
    //  [AWB-7]WBオフセット調整(全ての設定値を更新)
    for(INT i = 0; i < AWBLightSource_Max; i++) {
      AWBSettings.Offset.setOffset((AWBLightSource)i, p_spec->AWB.Offset.Pnt[i].Bg, p_spec->AWB.Offset.Pnt[i].Rg);
    }
    //  設定値更新フラグクリア
    p_spec->changeStatus[AXH_Index_SPEC_CHG_AWB] &= ~SPEC_CHG_AWB_WBOffset;
  }
  //  カラーマトリックス設定値更新フラグ確認
  if((p_spec->changeStatus[AXH_Index_SPEC_CHG_AWB] & SPEC_CHG_AWB_Matrix) == SPEC_CHG_AWB_Matrix) {
    //  [AWB-8]カラーマトリックス調整(全ての設定値を更新)
    for(INT i = 0; i < AWBLightSource_Max; i++) {
      AWBSettings.AdjustMatrix.setAJCF11((AWBLightSource)i, p_spec->AWB.AdjustMatrix.Matrix[i].AJCF11);
      AWBSettings.AdjustMatrix.setAJCF12((AWBLightSource)i, p_spec->AWB.AdjustMatrix.Matrix[i].AJCF12);
      AWBSettings.AdjustMatrix.setAJCF21((AWBLightSource)i, p_spec->AWB.AdjustMatrix.Matrix[i].AJCF21);
      AWBSettings.AdjustMatrix.setAJCF22((AWBLightSource)i, p_spec->AWB.AdjustMatrix.Matrix[i].AJCF22);
    }
    //  [Img-5.2.2]カラーマトリックス設定
    AWBSettings.ColorMatrix.setMode(p_spec->AWB.ColorMatrix.Mode);
    for(INT i = 0; i < AWB_ColorMatrixMax; i++) {
      AWBSettings.ColorMatrix.setCC22(i, p_spec->AWB.ColorMatrix.Matrix[i].CC22);
      AWBSettings.ColorMatrix.setCC23(i, p_spec->AWB.ColorMatrix.Matrix[i].CC23);
      AWBSettings.ColorMatrix.setCC32(i, p_spec->AWB.ColorMatrix.Matrix[i].CC32);
      AWBSettings.ColorMatrix.setCC33(i, p_spec->AWB.ColorMatrix.Matrix[i].CC33);
    }
    AWBSettings.ColorMatrix.setCC11(p_spec->AWB.ColorMatrix.CC11);
    AWBSettings.ColorMatrix.setCOF1(p_spec->AWB.ColorMatrix.COF1);
    //  設定値更新フラグクリア
    p_spec->changeStatus[AXH_Index_SPEC_CHG_AWB] &= ~SPEC_CHG_AWB_Matrix;
  }
  //  [AWB-9]ゲイン指定(ゲイン指定マニュアルモード時)
  AWBSettings.WB.setBGain(p_spec->AWB.WBGain.bGain);
  AWBSettings.WB.setRGain(p_spec->AWB.WBGain.rGain);
  //  [AWB-10]AWB遷移特性設定(全ての設定値を更新)
  AWBSettings.Convergence.setSpeed(p_spec->AWB.Convergence.Speed);
  AWBSettings.Convergence.setLightTHData(p_spec->AWB.Convergence.LightTH);
  AWBSettings.Convergence.setStableTHData(p_spec->AWB.Convergence.StableTH);
  ret1 = AWBSettings.Convergence.setStableTerm(p_spec->AWB.Convergence.StableTerm);
  if(ret1 == AWB_E_ER) {                // 変更できない時は、現在値を書き戻す
    p_spec->AWB.Convergence.StableTerm = AWBSettings.Convergence.StableTerm;
    ret = AWB_E_ER;
  }
  //  光源枠重み付け設定更新フラグ確認
  if((p_spec->changeStatus[AXH_Index_SPEC_CHG_AWB] & SPEC_CHG_AWB_Weight) == SPEC_CHG_AWB_Weight) {
    //  [AWB-11]光源枠重み付け設定
    for(int i = 0; i < AWBLightSource_Max; i++) {
      ST_WEIGHT weight = p_spec->AWB.LightWeight.Weight[i];
      AWBSettings.LightSourceWeight.setWeightL((AWBLightSource)i, weight.WeightL);
      AWBSettings.LightSourceWeight.setWeightH((AWBLightSource)i, weight.WeightH);
      AWBSettings.LightSourceWeight.setLimitL((AWBLightSource)i, weight.LimitL);
      AWBSettings.LightSourceWeight.setLimitH((AWBLightSource)i, weight.LimitH);
    }
    //  設定値更新フラグクリア
    p_spec->changeStatus[AXH_Index_SPEC_CHG_AWB] &= ~SPEC_CHG_AWB_Weight;
  }
  //  [AWB-12]低輝度 ATW停止閾値
  AWBSettings.setStopLowBright(p_spec->AWB.stopLowBrightTH);
  //  OPD設定更新フラグ確認
  if((p_spec->changeStatus[AXH_Index_SPEC_CHG_AWB] & SPEC_CHG_AWB_OPD) == SPEC_CHG_AWB_OPD) {
#ifdef  ENABLE_OPD_SET
    //  [AWB-13]OPD関連設定値
    AWBSettings.OPDSet.setHDiv(p_spec->AWB.OPDSet.HDiv);
    AWBSettings.OPDSet.setVDiv(p_spec->AWB.OPDSet.VDiv);
    AWBSettings.OPDSet.setHLimit(p_spec->AWB.OPDSet.HLimit);
    AWBSettings.OPDSet.setLLimit(p_spec->AWB.OPDSet.LLimit);
#endif  //  ENABLE_OPD_SET
    //  [AWB-14]OPD枠重み付け
    AWBSettings.OPDWeight.setV1(p_spec->AWB.OPDWeight.V1);
    AWBSettings.OPDWeight.setH2(p_spec->AWB.OPDWeight.H2);
    AWBSettings.OPDWeight.setH3(p_spec->AWB.OPDWeight.H3);
    AWBSettings.OPDWeight.setV4(p_spec->AWB.OPDWeight.V4);
    for(int i = 0; i < AWB_OPDArea_Idx_Max; i++) {
      ret1 = AWBSettings.OPDWeight.setWeightMode((AWB_OPDArea)i, (AWBWeightMode)p_spec->AWB.OPDWeight.WeightMode[i]);
      if(ret1 == AWB_E_ER) {            // 変更できない時は、現在値を書き戻す
        p_spec->AWB.OPDWeight.WeightMode[i] = AWBSettings.OPDWeight.WeightMode[i];
        ret = AWB_E_ER;
      }
    }
    //  [AWB-15]OPD枠 AWBマスク領域設定
    for(int i = 0; i < AWB_OPDMaskSetMax; i++) {
      AWBSettings.OPDMask.setData(i, p_spec->AWB.OPDMask.Pnt[i].h, p_spec->AWB.OPDMask.Pnt[i].v);
    }
    //  設定値更新フラグクリア
    p_spec->changeStatus[AXH_Index_SPEC_CHG_AWB] &= ~SPEC_CHG_AWB_OPD;
  }
  //  [AWB-16]分光バラつき調整
  ST_COL_POINT pnt1 = p_spec->AWB.SpectrumAdjust.pntLowTemp;
  ST_COL_POINT pnt2 = p_spec->AWB.SpectrumAdjust.pntHighTemp;
  AWBSettings.SpectrumAdjust.setLowTempPoint(pnt1.Bg, pnt1.Rg);
  AWBSettings.SpectrumAdjust.setHighTempPoint(pnt2.Bg, pnt2.Rg);
  //  光源枠座標更新フラグ確認
  if((p_spec->changeStatus[AXH_Index_SPEC_CHG_AWB] & SPEC_CHG_AWB_Source) == SPEC_CHG_AWB_Source) {
    //  [AWB-17]光源枠座標(無条件で光源枠データを更新)
    for(int i = 0; i < AWBLightSource_Rolling_Max; i++) {
      for(int j = 0; j < AWB_LightSourcePnt; j++) {
        ST_COL_POINT pnt = p_spec->AWB.LightSource[i].Area[j];
        AWBSettings.LightSource.setData((AWBLightSource)i, j, pnt.Bg, pnt.Rg);
      }
    }
    //  光源枠座標を更新(Mg-G方向引き込み簡易調整)
    AWBSettings.setMgGDirAdjust();
    f_LightSourceRefresh = true;                            //  演算用光源枠 更新要求フラグON
    //  設定値更新フラグクリア
    p_spec->changeStatus[AXH_Index_SPEC_CHG_AWB] &= ~SPEC_CHG_AWB_Source;
  }
  //  光源デフォルト座標更新フラグ確認
  if((p_spec->changeStatus[AXH_Index_SPEC_CHG_AWB] & SPEC_CHG_AWB_Default) == SPEC_CHG_AWB_Default) {
    //  [AWB-18]光源デフォルト座標 設定値取得(全ての設定値を更新)
    for(int i = 0; i < AWBLightDefault_Max; i++) {
      AWBSettings.LightDefault.setData((AWBLightDefault)i, p_spec->AWB.LightDefault[i].Bg, p_spec->AWB.LightDefault[i].Rg);
    }
    //  デフォルト座標が行進されるため、低色温度側と高色温度側の上限座標を更新(引き込み範囲調整)
    AWBSettings.setLTempAdjustPnt();
    AWBSettings.setHTempAdjustPnt();
    //  基準座標が更新されるため、光源枠座標を更新(Mg-G方向引き込み簡易調整)
    AWBSettings.setMgGDirAdjust();
    f_LightSourceRefresh = true;                            //  演算用光源枠 更新要求フラグON
    //  設定値更新フラグクリア
    p_spec->changeStatus[AXH_Index_SPEC_CHG_AWB] &= ~SPEC_CHG_AWB_Default;
  }
  //  [AWB-19]OPD信頼性判定レベル 設定値取得(全ての設定値を更新)
  AWBSettings.OPDTrust.setTH(p_spec->AWB.OPDTrust.TH);
  ret1 = AWBSettings.OPDTrust.setSel((AWBLowTrust)p_spec->AWB.OPDTrust.Sel);
  if(ret1 == AWB_E_ER) {                // 変更できない時は、現在値を書き戻す
    p_spec->AWB.OPDTrust.Sel = AWBSettings.OPDTrust.Sel;
    ret = AWB_E_ER;
  }
  AWBSettings.OPDTrust.setZero((AWBLightSource)p_spec->AWB.OPDTrust.Zero);

  //  モード変更/光源枠データ更新があった場合には、光源枠データを更新する
  if(f_LightSourceRefresh == true) {
    refleshJudgedLightSourceData();
  }

  return ret;
}

//
//  判定用光源枠データ更新処理
//
void AXMIspAwb::refleshJudgedLightSourceData() {
  if(JudgeLightSource == NULL) {
    JudgeLightSource = new AXMIspAwbAlgorithmJudgedLightSource(AWBSettings);
  }
  else {
    JudgeLightSource->resetJudgedLightSourceData(AWBSettings);
  }
}

#ifdef USE_AXFTEST_COMMAND
ax::actorFuncStatus AXMIspAwb::funcAxcommTest(const void *pParam, int size) {
  //m_log.write(AXFLOG_SCENARIO, "@AWB funcAxcommTest()");
  //m_log.write(AXFLOG_SCENARIO, (char *) pParam);

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::funcPriorityTest(const void *pParam, int size) {
  //m_log.write(AXFLOG_SCENARIO, "AWB PriorityTest");
#ifndef PARASOFT_CPPTEST
  pthread_pri_dbgprint();
#endif  //  PARASOFT_CPPTEST

  //受信データからカウンタ値を取得
  int count = 0;
  if(pParam != NULL){
    count = *((int*)pParam);
  }

  //Ispへ結果送信
  int stat = send(nameIsp, AXMIsp::EVENT_PRISCHED_END, (void *)&count, sizeof(count));
  if (0 > stat) {
    //m_log.write(AXFLOG_ERR, "fail send Isp AWB Prisched End");
  }
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::funcMemTest(const void *pParam, int size) {
  int addr, bytes, i, *p, pat, v;
  unsigned char *mp;
  char msg[100];

  addr = 0x20000000 + 2 * 1024 * 1024;
  //addr = 0x20000000 + 2 * 1024 * 1024 + 511 * 1024;
  mp = (unsigned char *) addr;
  bytes = 3 * 1024 * 1024;
  //bytes = 3 * 1024 * 1024 - 511 * 1024;

  pat = 0;
  p = (int *) mp;
  for (i = 0; i < bytes / 4; i++)
    *p++ = pat++;

  pat = 0;
  p = (int *) mp;
  for (i = 0; i < bytes / 4; i++) {
    v = *p++;
    if (v != pat) {
      sprintf(msg, "!!! %08x %08x!=%08x", addr + i * 4, v, pat);
      //m_log.write(AXFLOG_INFO, msg);
    }
    pat++;
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::funcLoopbackTest(const void *pParam, int size) {
  //m_log.write(AXFLOG_SCENARIO, "@AWB funcLoopbackTest()");

  std::ostringstream loopCountStr;
  loopCountStr << m_loopbackCount;
  //m_log.write(
      AXFLOG_SCENARIO,
      "loopcount=" + loopCountStr.str() + " rcvdata=" + (char*)(pParam));
  m_loopbackCount++;

  AXFObjectName axtestName("axtest", "axStage");
  char buf[30];
  memcpy(buf, (char*)pParam, size);
  int i;
  for (i = 0; i < size; i += 2)
    buf[i] += 0x20;
  // EVENT_LOOPBACK_TEST
  if (0 > send(axtestName, AXFEVENT_MODEL(2), buf, size)) {
    //m_log.write(AXFLOG_ERR, "fail send loopback");
  }

  return ax::AXFACTOR_SUCCESS;
}
#endif /* USE_AXFTEST_COMMAND */

