/**
 * @file   AXMIspCorrect.hpp
 * @brief  AXMIspCorrectクラスヘッダ
 *
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

#ifndef AXMISPCORRECT_HPP_
#define AXMISPCORRECT_HPP_

#include "AXMCommon/AXMCommonTypedefine.hpp"

#include "../AXM/AXModelActor.hpp"
#include "AXHSpecParam.hpp"
#include "AXHSpecStruct.hpp"

const UINT  Shade_Grid_Ver_Pitch = 32;                      //  垂直方向グリッドピッチ
const UINT  Shade_Grid_Width = 32 + 1;                      //  水平方向グリッド数
const UINT  SFT_Shade_Grid_Width = 5;                       //  水平方向グリッド数 演算時シフト量
const UINT  SFT_Shade_Grid_Ver_Pitch = 5;                   //  垂直方向グリッドピッチ 演算時シフト量
const UINT  MASK_Shade_Grid_Ver_Pitch = 0x0000001Ful;       //  垂直方向余り確認用マスクパターン
const UINT  Shade_Pixcel_Data_Size = 2;                     //  1Pixcelあたり2バイト

const INT pntCnt_Max = 100;

/*
 * @class AXMIspCorrect
 * @brief シェーディング補正実行クラス
 *
 * @n     何もしない
 * @n
 */
class AXMIspCorrect : public AXModelActor {
  AXFLog m_log;
  AXFObjectName& m_name;
#ifdef USE_AXFTEST_COMMAND
  int m_loopbackCount;
#endif /* USE_AXFTEST_COMMAND */

 public:
  AXMIspCorrect(AXFObjectName& name);
  virtual ~AXMIspCorrect();
  ax::actorFuncStatus onCreate();
  ax::actorFuncStatus onStart();
  ax::actorFuncStatus onStop();
#if 0
  ax::actorFuncStatus onPause();
  ax::actorFuncStatus onResume();
  ax::actorFuncStatus onRestart();
#endif

// StateMachineオブジェクト用ヘッダファイル挿入
#include "./AXMIspCorrectState.hpp"

  int     state;                        //  次期ステータス格納用(setNextStateの引数)

private:
  ST_SPEC *p_spec;                      //  設定値参照用

  //  シェーディング補正演算用変数
  INT         cnt;
  UINT        Shade_Grid_Hor_Pitch;                         //  水平方向グリッドピッチ
  UINT        Shade_Grid_Height;                            //  垂直方向グリッド数

  struct {
    UINT  R;                                                //  補正用積算データ(R)
    UINT  G;                                                //  補正用積算データ(G)
    UINT  B;                                                //  補正用積算データ(B)
  } IntData[AXH_Shade_Grid_Height_Max][AXH_Shade_Grid_Width];     //  積算データ群

  struct st_defect_pixcel {
    struct st_defect_pixcel *p_next;                        //  次アドレスデータ参照先
    USHORT H;                                               //  水平座標
    USHORT V;                                               //  垂直座標
    USHORT Bright;                                          //  輝度
    BOOL   fl_Serial;                                       //  連欠陥判定フラグ
  };

  struct st_defect_pixcel *DefectPixcel;
};
#endif /* AXMISPCORRECT_HPP_ */
