#ifndef PARASOFT_CPPTEST

#ifdef  __cplusplus
extern "C"
{
#endif

#define ENABLE_OB_CALC

#include "DSPCommon.h"
#include "adrs_map.h"
#include "proc_def_imageif_eval.h"

#include "AXMIspAe/AXMISPtype.hpp"
#include "AXMImageSensor/imageSensorDrv.h"

#if 1
#include "../AXMCommon/AXMCommonParam.hpp"
#else
#if 0
extern UInt32 g_opd_mode_raw;
extern UInt32 g_opd_mode_yrgb;

extern UInt32 g_opd_h_div_awb;
extern UInt32 g_opd_v_div_awb;
extern UInt32 g_avever_w_size_h_awb;
extern UInt32 g_avever_w_size_v_awb;

extern UInt32 g_opd_h_div_ae;
extern UInt32 g_opd_v_div_ae;
extern UInt32 g_avever_w_size_h_ae;
extern UInt32 g_avever_w_size_v_ae;

extern UInt32 g_avesize;
#else
UInt32 g_opd_mode_raw;
UInt32 g_opd_mode_yrgb;

UInt32 g_opd_h_div_awb;
UInt32 g_opd_v_div_awb;
UInt32 g_avever_w_size_h_awb;
UInt32 g_avever_w_size_v_awb;

UInt32 g_opd_h_div_ae;
UInt32 g_opd_v_div_ae;
UInt32 g_avever_w_size_h_ae;
UInt32 g_avever_w_size_v_ae;

UInt32 g_avesize;
#endif
#endif

UInt32 ob_vstart = 4;
UInt32 spu_vstart = 20;
UInt32 pix_hstart = 16;

void init_imageif_sony_imx136_dsp(UInt32 ivl_width, UInt32 ivl_height,
                                  UInt32 pix_width, UInt32 pix_height)
{
	SetReg32 (ISI_DSP_IC_MASK,	0x00000003);
    set_imageif_sony_imx136();
    //SetReg32(ISI_IC_MASK, 0x00000001);
    init_imageif_base(ivl_width, ivl_height, pix_width, pix_height);
}

void init_imageif_base(UInt32 ivl_width, UInt32 ivl_height, UInt32 pix_width, UInt32 pix_height)
{    
    SetReg32(ISI_IVL, ((ivl_height-1)<<16) | (ivl_width-1));
////#ifndef ENABLE_OB_CALC
////    SetReg32(ISI_CAP_SIZE, (pix_height<<16) | pix_width);
//    SetReg32(ISI_CAP_SIZE, ((pix_height+23)<<16) | pix_width);
    SetReg32(ISI_CAP_SIZE, ((pix_height+spu_vstart)<<16) | pix_width);
////#else   //  ENABLE_OB_CALC
////    SetReg32(ISI_CAP_SIZE, (ivl_height<<16) | pix_width);
////#endif  //  ENABLE_OB_CALC
    
    SetReg32(ISI_STGINT0TM, 0x00000000);
//    SetReg32(ISI_STGINT0TM, 0x04400000);		// B27-16	ISI_STGINT0V	RW(d)	12'hfff	ISI割り込みVタイミング0 1088
    SetReg32(ISI_STGINT1TM, ((ivl_height>>1)<<16) | 0);
    SetReg32(ISI_STGUP1TM, 0x00000000);
    SetReg32(ISI_STGDN1TM, 0x000b0000);
    
    SetReg32(r_ISI_DMAR_SRST,       0x00000000);  // DMAR_SRST
    SetReg32(r_ISI_DMAR_INT_MASK,   0x00000001);  // INT_MASK
    SetReg32(r_ISI_DMAR_INT_INV,    0x00000001);  // INT_INV
    SetReg32(r_ISI_DMAR_UF_MODE,    0x00000000);  // UF_MODE
    SetReg32(r_ISI_DMAR_EN,         0x00000001);  // DMA_EN
    SetReg32(r_ISI_DMAR_SRST,       0x00000001);  // DMAR_SRST
    SetReg32(r_ISI_DMAR_SRST,       0x00000000);  // DMAR_SRST release
    
    SetReg32(r_ISI_DMAW_SRST,       0x00000000);  // DMAW_SRST
    SetReg32(r_ISI_DMAW_INT_MASK,   0x00000000);  // INT_MASK
    SetReg32(r_ISI_DMAW_INT_INV,    0x00000001);  // INT_INV
    SetReg32(r_ISI_DMAW_UF_MODE,    0x00000000);  // UF_MODE
    SetReg32(r_ISI_DMAW_EN,         0x00000001);  // DMA_EN
    SetReg32(r_ISI_DMAW_SRST,       0x00000001);  // DMAW_SRST
    SetReg32(r_ISI_DMAW_SRST,       0x00000000);  // DMAW_SRST release
    
    
    SetReg32(r_ISI_DMAREG_SRST,    0x00000000);  // DMA_SRST release
    SetReg32(r_ISI_DMAREG_EN,      0x00000300);  // DMA_EN
    
    // SPU reg set
    //SetReg32(RegSPU_INTCNT_MASK, 0x00002000);
    SetReg32(RegHCAPT, (pix_width << 16));
////#ifndef ENABLE_OB_CALC
//    SetReg32(RegVCAPT1,(pix_height << 16));
    SetReg32(RegVCAPT1,((pix_height + spu_vstart) << 16) | (spu_vstart));
////#else   //  ENABLE_OB_CALC
////    SetReg32(RegVCAPT1,((pix_height + 23) << 16) | 23);
////#endif  //  ENABLE_OB_CALC
    SetReg32(RegVCAPT2, 0x00000000);
    SetReg32(RegSPU_C, 0x00040400);	// b18:DMAW0 out sel, b19:direct out sel
    SetReg32(RegSPU_C2, 0x10100000);
    SetReg32(RegSPU_C3, 0x00000000);
    SetReg32(RegC0CS_L, 0x00013008);
    SetReg32(RegC0CS_H, 0x00000000);
    SetReg32(RegDL0, 0x00000000);
    SetReg32(RegDL1, 0x00000000);
    SetReg32(RegDL2, 0x00000000);
    SetReg32(RegDL3, 0x00000000);
    SetReg32(RegDL4, 0x00000000);
    SetReg32(RegDL5, 0x00000000);
    SetReg32(RegDL6, 0x00000000);
    SetReg32(RegDL7, 0x00000000);
    SetReg32(RegDL0, 0x00007F10);       /* 0x0000_0321 -> 0x0000_7F10 */
    SetReg32(RegDL1, 0x00007F11);       /* 0x0000_0654 -> 0x0000_7F11 */
    SetReg32(RegDL2, 0x00007F11);       /* 0x0000_0987 -> 0x0000_7F11 */
    SetReg32(RegDL3, 0x00007F10);       /* 0x0000_0cba -> 0x0000_7F10 */
    SetReg32(RegDL4, 0x00000000);       /* 0x0000_0ddd -> 0x0000_0000 */
    SetReg32(RegDL5, 0x00000000);       /* 0x0000_0ddd -> 0x0000_0000 */
    SetReg32(RegDL6, 0x00000000);       /* 0x0000_0ddd -> 0x0000_0000 */
    SetReg32(RegDL7, 0x00000000);       /* 0x0000_0ddd -> 0x0000_0000 */
#if 1
    SetReg32(RegWB0, 0x00000100);
#else
    SetReg32(RegWB0, 0x0000018e);
#endif
    SetReg32(RegWB1, 0x00000100);
#if 1
    SetReg32(RegWB2, 0x00000100);
#else
    SetReg32(RegWB2, 0x00000198);
#endif
    SetReg32(RegWB3, 0x00000100);
    SetReg32(RegWB4, 0x00000100);
    SetReg32(RegWB5, 0x00000100);
    SetReg32(RegWB6, 0x00000100);
    SetReg32(RegWB7, 0x00000100);
    SetReg32(RegCOLOR_TMG, 0x00000009);
    SetReg32(RegAVE_C, 0x00010000);
    SetReg32(RegWB0_TH, 0xffff0000);
    SetReg32(RegWB1_TH, 0xffff0000);
    SetReg32(RegWB2_TH, 0xffff0000);
    SetReg32(RegWB3_TH, 0xffff0000);
    SetReg32(RegWB4_TH, 0xffff0000);
    SetReg32(RegWB5_TH, 0xffff0000);
    SetReg32(RegWB6_TH, 0xffff0000);
    SetReg32(RegWB7_TH, 0xffff0000);
//  AF検波値出力確認用設定
    SetReg32(RegAFH_C, 0x00000012);                         /* 0x00000000 -> 0x00000012 */
    SetReg32(RegAFHW_H0, (( 719 << 16) |  240));            /* 0x00200000 ->            */
    SetReg32(RegAFHW_H1, ((1199 << 16) |  720));            /* 0x00000000 ->            */
    SetReg32(RegAFHW_H2, ((1679 << 16) | 1200));            /* 0x00000000 ->            */
    SetReg32(RegAFHW_H3, (( 719 << 16) |  240));            /* 0x00000000 ->            */
    SetReg32(RegAFHW_H4, ((1199 << 16) |  720));            /* 0x00000000 ->            */
    SetReg32(RegAFHW_H5, ((1679 << 16) | 1200));            /* 0x00000000 ->            */
    SetReg32(RegAFHW_H6, (( 719 << 16) |  240));            /* 0x00000000 ->            */
    SetReg32(RegAFHW_H7, ((1199 << 16) |  720));            /* 0x00000000 ->            */
    SetReg32(RegAFHW_H8, ((1679 << 16) | 1200));            /* 0x00000000 ->            */
    SetReg32(RegAFHW_V0, (( 404 << 16) |  135));            /* 0x00000000 ->            */
    SetReg32(RegAFHW_V1, (( 404 << 16) |  135));            /* 0x00000000 ->            */
    SetReg32(RegAFHW_V2, (( 404 << 16) |  135));            /* 0x00000000 ->            */
    SetReg32(RegAFHW_V3, (( 674 << 16) |  405));            /* 0x00000000 ->            */
    SetReg32(RegAFHW_V4, (( 674 << 16) |  405));            /* 0x00000000 ->            */
    SetReg32(RegAFHW_V5, (( 674 << 16) |  405));            /* 0x00000000 ->            */
    SetReg32(RegAFHW_V6, (( 944 << 16) |  675));            /* 0x00000000 ->            */
    SetReg32(RegAFHW_V7, (( 944 << 16) |  675));            /* 0x00000000 ->            */
    SetReg32(RegAFHW_V8, (( 944 << 16) |  675));            /* 0x00000000 ->            */
//
    SetReg32(RegAFH_DTH0, 0x00000000);
    SetReg32(RegAFH_DTH1, 0x00000000);
    SetReg32(RegAFH_DTH2, 0x00000000);
    SetReg32(RegAFH_DTH3, 0x00000000);
    SetReg32(RegAFH_DTH4, 0x00000000);
    SetReg32(RegAFH_DTH5, 0x00000000);
    SetReg32(RegAFH_DTH6, 0x00000000);
    SetReg32(RegAFH_DTH7, 0x00000000);
    SetReg32(RegAFH_DTH8, 0x00000000);
    SetReg32(RegAFH_DTL0, 0x00000000);
    SetReg32(RegAFH_DTL1, 0x00000000);
    SetReg32(RegAFH_DTL2, 0x00000000);
    SetReg32(RegAFH_DTL3, 0x00000000);
    SetReg32(RegAFH_DTL4, 0x00000000);
    SetReg32(RegAFH_DTL5, 0x00000000);
    SetReg32(RegAFH_DTL6, 0x00000000);
    SetReg32(RegAFH_DTL7, 0x00000000);
    SetReg32(RegAFH_DTL8, 0x00000000);
    SetReg32(RegAFH_PDH0, 0x00000000);
    SetReg32(RegAFH_PDH1, 0x00000000);
    SetReg32(RegAFH_PDH2, 0x00000000);
    SetReg32(RegAFH_PDH3, 0x00000000);
    SetReg32(RegAFH_PDH4, 0x00000000);
    SetReg32(RegAFH_PDH5, 0x00000000);
    SetReg32(RegAFH_PDH6, 0x00000000);
    SetReg32(RegAFH_PDH7, 0x00000000);
    SetReg32(RegAFH_PDH8, 0x00000000);
    SetReg32(RegAFH_PDL0, 0x00000000);
    SetReg32(RegAFH_PDL1, 0x00000000);
    SetReg32(RegAFH_PDL2, 0x00000000);
    SetReg32(RegAFH_PDL3, 0x00000000);
    SetReg32(RegAFH_PDL4, 0x00000000);
    SetReg32(RegAFH_PDL5, 0x00000000);
    SetReg32(RegAFH_PDL6, 0x00000000);
    SetReg32(RegAFH_PDL7, 0x00000000);
    SetReg32(RegAFH_PDL8, 0x00000000);
    SetReg32(RegBRTTH, 0x00000000);
    SetReg32(RegHCAPT2, 0x00000000);
//    SetReg32(RegOBEAH, 0x00000000);
//    SetReg32(RegOBEAV, 0x00000000);
////    SetReg32(RegOBEAH, 0x877F0000);
//    SetReg32(RegOBEAH, 0x800B0000);
    SetReg32(RegOBEAH, 0x8790000);
////    SetReg32(RegOBEAV, 0x000B0004);
//    SetReg32(RegOBEAV, 0x00030000);
    SetReg32(RegOBEAV, 0x00090000);
    SetReg32(RegOBCRR0, 0x00000000);
    SetReg32(RegOBCRR1, 0x00000000);
    SetReg32(RegOBCRR2, 0x00000000);
    SetReg32(RegOBCRR3, 0x00000000);
    SetReg32(RegSMODE, 0x00000000);
    SetReg32(RegSMODE2, 0x00000000);
    SetReg32(RegSHCAPT, 0x00000000);
    SetReg32(RegSVCAPT, 0x00000000);
    SetReg32(RegLNZ_C, 0x00000000);
    SetReg32(RegLZT0_00, 0x00000000);
    SetReg32(RegLZT0_01, 0x00000000);
    SetReg32(RegLZT0_02, 0x00000000);
    SetReg32(RegLZT0_03, 0x00000000);
    SetReg32(RegLZT0_04, 0x00000000);
    SetReg32(RegLZT0_05, 0x00000000);
    SetReg32(RegLZT0_06, 0x00000000);
    SetReg32(RegLZT0_07, 0x00000000);
    SetReg32(RegLZT0_08, 0x00000000);
    SetReg32(RegLZT0_09, 0x00000000);
    SetReg32(RegLZT0_10, 0x00000000);
    SetReg32(RegLZT0_11, 0x00000000);
    SetReg32(RegLZT0_12, 0x00000000);
    SetReg32(RegLZT0_13, 0x00000000);
    SetReg32(RegLZT0_14, 0x00000000);
    SetReg32(RegLZT0_15, 0x00000000);
    SetReg32(RegLZT0_16, 0x00000000);
    SetReg32(RegLZT0_17, 0x00000000);
    SetReg32(RegLZT0_18, 0x00000000);
    SetReg32(RegLZT0_19, 0x00000000);
    SetReg32(RegLZT0_20, 0x00000000);
    SetReg32(RegLZT0_21, 0x00000000);
    SetReg32(RegLZT0_22, 0x00000000);
    SetReg32(RegLZT0_23, 0x00000000);
    SetReg32(RegLZT0_24, 0x00000000);
    SetReg32(RegLZT0_25, 0x00000000);
    SetReg32(RegLZT0_26, 0x00000000);
    SetReg32(RegLZT0_27, 0x00000000);
    SetReg32(RegLZT0_28, 0x00000000);
    SetReg32(RegLZT0_29, 0x00000000);
    SetReg32(RegLZT0_30, 0x00000000);
    SetReg32(RegLZT0_31, 0x00000000);
    SetReg32(RegLZT0_32, 0x00000000);
    SetReg32(RegLZT1_00, 0x00000000);
    SetReg32(RegLZT1_01, 0x00000000);
    SetReg32(RegLZT1_02, 0x00000000);
    SetReg32(RegLZT1_03, 0x00000000);
    SetReg32(RegLZT1_04, 0x00000000);
    SetReg32(RegLZT1_05, 0x00000000);
    SetReg32(RegLZT1_06, 0x00000000);
    SetReg32(RegLZT1_07, 0x00000000);
    SetReg32(RegLZT1_08, 0x00000000);
    SetReg32(RegLZT1_09, 0x00000000);
    SetReg32(RegLZT1_10, 0x00000000);
    SetReg32(RegLZT1_11, 0x00000000);
    SetReg32(RegLZT1_12, 0x00000000);
    SetReg32(RegLZT1_13, 0x00000000);
    SetReg32(RegLZT1_14, 0x00000000);
    SetReg32(RegLZT1_15, 0x00000000);
    SetReg32(RegLZT1_16, 0x00000000);
    SetReg32(RegLZT1_17, 0x00000000);
    SetReg32(RegLZT1_18, 0x00000000);
    SetReg32(RegLZT1_19, 0x00000000);
    SetReg32(RegLZT1_20, 0x00000000);
    SetReg32(RegLZT1_21, 0x00000000);
    SetReg32(RegLZT1_22, 0x00000000);
    SetReg32(RegLZT1_23, 0x00000000);
    SetReg32(RegLZT1_24, 0x00000000);
    SetReg32(RegLZT1_25, 0x00000000);
    SetReg32(RegLZT1_26, 0x00000000);
    SetReg32(RegLZT1_27, 0x00000000);
    SetReg32(RegLZT1_28, 0x00000000);
    SetReg32(RegLZT1_29, 0x00000000);
    SetReg32(RegLZT1_30, 0x00000000);
    SetReg32(RegLZT1_31, 0x00000000);
    SetReg32(RegLZT1_32, 0x00000000);
    SetReg32(RegLZT2_00, 0x00000000);
    SetReg32(RegLZT2_01, 0x00000000);
    SetReg32(RegLZT2_02, 0x00000000);
    SetReg32(RegLZT2_03, 0x00000000);
    SetReg32(RegLZT2_04, 0x00000000);
    SetReg32(RegLZT2_05, 0x00000000);
    SetReg32(RegLZT2_06, 0x00000000);
    SetReg32(RegLZT2_07, 0x00000000);
    SetReg32(RegLZT2_08, 0x00000000);
    SetReg32(RegLZT2_09, 0x00000000);
    SetReg32(RegLZT2_10, 0x00000000);
    SetReg32(RegLZT2_11, 0x00000000);
    SetReg32(RegLZT2_12, 0x00000000);
    SetReg32(RegLZT2_13, 0x00000000);
    SetReg32(RegLZT2_14, 0x00000000);
    SetReg32(RegLZT2_15, 0x00000000);
    SetReg32(RegLZT2_16, 0x00000000);
    SetReg32(RegLZT2_17, 0x00000000);
    SetReg32(RegLZT2_18, 0x00000000);
    SetReg32(RegLZT2_19, 0x00000000);
    SetReg32(RegLZT2_20, 0x00000000);
    SetReg32(RegLZT2_21, 0x00000000);
    SetReg32(RegLZT2_22, 0x00000000);
    SetReg32(RegLZT2_23, 0x00000000);
    SetReg32(RegLZT2_24, 0x00000000);
    SetReg32(RegLZT2_25, 0x00000000);
    SetReg32(RegLZT2_26, 0x00000000);
    SetReg32(RegLZT2_27, 0x00000000);
    SetReg32(RegLZT2_28, 0x00000000);
    SetReg32(RegLZT2_29, 0x00000000);
    SetReg32(RegLZT2_30, 0x00000000);
    SetReg32(RegLZT2_31, 0x00000000);
    SetReg32(RegLZT2_32, 0x00000000);
    SetReg32(RegLZT3_00, 0x00000000);
    SetReg32(RegLZT3_01, 0x00000000);
    SetReg32(RegLZT3_02, 0x00000000);
    SetReg32(RegLZT3_03, 0x00000000);
    SetReg32(RegLZT3_04, 0x00000000);
    SetReg32(RegLZT3_05, 0x00000000);
    SetReg32(RegLZT3_06, 0x00000000);
    SetReg32(RegLZT3_07, 0x00000000);
    SetReg32(RegLZT3_08, 0x00000000);
    SetReg32(RegLZT3_09, 0x00000000);
    SetReg32(RegLZT3_10, 0x00000000);
    SetReg32(RegLZT3_11, 0x00000000);
    SetReg32(RegLZT3_12, 0x00000000);
    SetReg32(RegLZT3_13, 0x00000000);
    SetReg32(RegLZT3_14, 0x00000000);
    SetReg32(RegLZT3_15, 0x00000000);
    SetReg32(RegLZT3_16, 0x00000000);
    SetReg32(RegLZT3_17, 0x00000000);
    SetReg32(RegLZT3_18, 0x00000000);
    SetReg32(RegLZT3_19, 0x00000000);
    SetReg32(RegLZT3_20, 0x00000000);
    SetReg32(RegLZT3_21, 0x00000000);
    SetReg32(RegLZT3_22, 0x00000000);
    SetReg32(RegLZT3_23, 0x00000000);
    SetReg32(RegLZT3_24, 0x00000000);
    SetReg32(RegLZT3_25, 0x00000000);
    SetReg32(RegLZT3_26, 0x00000000);
    SetReg32(RegLZT3_27, 0x00000000);
    SetReg32(RegLZT3_28, 0x00000000);
    SetReg32(RegLZT3_29, 0x00000000);
    SetReg32(RegLZT3_30, 0x00000000);
    SetReg32(RegLZT3_31, 0x00000000);
    SetReg32(RegLZT3_32, 0x00000000);
    SetReg32(RegLZT4_00, 0x00000000);
    SetReg32(RegLZT4_01, 0x00000000);
    SetReg32(RegLZT4_02, 0x00000000);
    SetReg32(RegLZT4_03, 0x00000000);
    SetReg32(RegLZT4_04, 0x00000000);
    SetReg32(RegLZT4_05, 0x00000000);
    SetReg32(RegLZT4_06, 0x00000000);
    SetReg32(RegLZT4_07, 0x00000000);
    SetReg32(RegLZT4_08, 0x00000000);
    SetReg32(RegLZT4_09, 0x00000000);
    SetReg32(RegLZT4_10, 0x00000000);
    SetReg32(RegLZT4_11, 0x00000000);
    SetReg32(RegLZT4_12, 0x00000000);
    SetReg32(RegLZT4_13, 0x00000000);
    SetReg32(RegLZT4_14, 0x00000000);
    SetReg32(RegLZT4_15, 0x00000000);
    SetReg32(RegLZT4_16, 0x00000000);
    SetReg32(RegLZT4_17, 0x00000000);
    SetReg32(RegLZT4_18, 0x00000000);
    SetReg32(RegLZT4_19, 0x00000000);
    SetReg32(RegLZT4_20, 0x00000000);
    SetReg32(RegLZT4_21, 0x00000000);
    SetReg32(RegLZT4_22, 0x00000000);
    SetReg32(RegLZT4_23, 0x00000000);
    SetReg32(RegLZT4_24, 0x00000000);
    SetReg32(RegLZT4_25, 0x00000000);
    SetReg32(RegLZT4_26, 0x00000000);
    SetReg32(RegLZT4_27, 0x00000000);
    SetReg32(RegLZT4_28, 0x00000000);
    SetReg32(RegLZT4_29, 0x00000000);
    SetReg32(RegLZT4_30, 0x00000000);
    SetReg32(RegLZT4_31, 0x00000000);
    SetReg32(RegLZT4_32, 0x00000000);
    SetReg32(RegLZT0_LMT, 0x00003fff);
    SetReg32(RegLZT1_LMT, 0x00003fff);
    SetReg32(RegLZT2_LMT, 0x00003fff);
    SetReg32(RegLZT3_LMT, 0x00003fff);
    SetReg32(RegLZT4_LMT, 0x00003fff);
    SetReg32(RegLNZ_FX, 0x00000000);
    SetReg32(RegDLC_C, 0x00000001);     /* 0x0000_0000 -> 0x0000_0001 */
    SetReg32(RegDLC0_R0A, 0x00000000);
    SetReg32(RegDLC0_R0B, 0x00000000);
    SetReg32(RegDLC0_R1A, 0x00000000);
    SetReg32(RegDLC0_R1B, 0x00000000);
    SetReg32(RegDLC0_R2A, 0x00000000);
    SetReg32(RegDLC0_R2B, 0x00000000);
    SetReg32(RegDLC0_COF, 0x00000000);
    SetReg32(RegCOLM_C, 0x00000000);
    SetReg32(RegCOLM_C2, 0x00000000);
    SetReg32(RegCOLRAM_RAD, 0x00000000);
    SetReg32(RegCOLRAM0, 0x00000000);
    SetReg32(RegCOLRAM1, 0x00000000);
    SetReg32(RegCOLRAM2, 0x00000000);
    SetReg32(RegCOLRAM3, 0x00000000);
    SetReg32(RegCXA00, 0x00000000);
    SetReg32(RegCXA01, 0x00000000);
    SetReg32(RegCXA10, 0x00000000);
    SetReg32(RegCXA11, 0x00000000);
    SetReg32(RegCXB00, 0x00000000);
    SetReg32(RegCXB01, 0x00000000);
    SetReg32(RegCXB10, 0x00000000);
    SetReg32(RegCXB11, 0x00000000);
    SetReg32(RegWBC_C, 0x00000001);
    SetReg32(RegSTG_C, 0x00000000);
    SetReg32(RegSTG_IVL, 0x00a000c0);
    SetReg32(RegSTG_CTV, 0x009f0000);
    SetReg32(RegSTG_STP, 0x00a000c0);
    SetReg32(RegSTG_DLD, 0x00000000);
    SetReg32(RegSG1T0, 0x00000000);
    SetReg32(RegSG1T1, 0x00000000);
    SetReg32(RegSG1T2, 0x00000000);
    SetReg32(RegSG1T3, 0x00000000);
    SetReg32(RegSG2T0, 0x00000000);
    SetReg32(RegSG2T1, 0x00000000);
    SetReg32(RegSG2T2, 0x00000000);
    SetReg32(RegSG2T3, 0x00000000);
    SetReg32(RegSG3T0, 0x00000000);
    SetReg32(RegSG3T1, 0x00000000);
    SetReg32(RegSG3T2, 0x00000000);
    SetReg32(RegSG3T3, 0x00000000);
    SetReg32(RegSG4T0, 0x00000000);
    SetReg32(RegSG4T1, 0x00000000);
    SetReg32(RegSG4T2, 0x00000000);
    SetReg32(RegSG4T3, 0x00000000);
    SetReg32(RegEFT_L, 0x009800a0);
    SetReg32(RegSTG_RSLD,0x00000006);
    SetReg32(RegSTG_C,0x00030601);

    // spu 3A ACC
//    SetReg32(RegAVE_C,           ((g_avesize << 16) | 0x00000013));
    SetReg32(RegAVE_C,           ((g_avesize << 16) | 0x80000013ul));
    SetReg32(RegAVEVER_MODE_SEL, g_opd_mode_raw);
    SetReg32(RegAVEVER_W_NUM,    ((g_opd_v_div_awb << 8) | g_opd_h_div_awb));
    SetReg32(RegAVEVER_W_SIZE,   ((g_avever_w_size_v_awb << 16) | g_avever_w_size_h_awb));
    SetReg32(RegAVEVER_MODE2_PARAM0, 0x0096004c);
    SetReg32(RegAVEVER_MODE2_PARAM1, 0x0a00001e);
    
    // mix reg set
    SetReg32(RegMIX_MODE,      0x01100010);
//    SetReg32(RegMIX_EXP_RATIO, 0x0c000400);
    SetReg32(RegMIX_EXP_RATIO, 0x00400C00);                 //  0x0c000400 -> 0x00400C00
    SetReg32(RegMIX_THR_SHORT, 0x00800f00);
//    SetReg32(RegMIX_ERR_THR,   0x02000040);
    SetReg32(RegMIX_ERR_THR,   0x02000010);
    SetReg32(RegMIX_DMAR_OFS,  DRAM_OFST_IMG_SPU_0);	// mix_dmar_ofs_r (*)
    SetReg32(RegMIX_DMAR_LEN,  (pix_height*pix_width)); // mix_dmar_fmt_r,mix_dmar_len_r
    // mix_int
    SetReg32(RegMIX_INT_MASK, 0x00000003);              // MASK
    SetReg32(RegMIX_INT_INV, 0x00000000);               // INV
    SetReg32(RegMIX_INT_LVLEDGE, 0x00000000);          // LVLEDGE
    
    // spu_brg reg
//    SetReg32(RegSPU_DMAR1_OFS, DRAM_OFST_IMG_DEF);     	// spu_dmar1_ofs_r (*)
    SetReg32(RegSPU_DMAW0_OFS, DRAM_OFST_IMG_SPU_0);   	// spu_dmaw0_ofs_r (*)
//    SetReg32(RegSPU_DMAW1_OFS, DRAM_OFST_IMG_3A_AWE_0);	// spu_dmaw1_ofs_r (*)
    SetReg32(RegSPU_DMAW1_OFS, SPAD_OFST_IMG_AWE_0);	// spu_dmaw1_ofs_r (*)
    SetReg32(RegSPU_DMAR1_LEN, 0x00002000);             // spu_dmar1_len_r
//    SetReg32(RegSPU_DMAW0_LEN, (pix_height*pix_width));
    SetReg32(RegSPU_DMAW1_LEN, (g_opd_v_div_awb*g_opd_h_div_awb*6)); // spu_dmaw1_len_r
    
    SetReg32(RegSPU_ACT, 0x80000006);                   // act
    SetReg32(RegMIX_ACT, 0x80000000);                   // act, double buffer
    SetReg32(r_ISI_DMAREG_SRST,	0x00000000);            // DMA_SRST release
    SetReg32(r_ISI_DMAREG_EN,	0x00000300);            // DMA_EN
    
    SetReg32(ISI_ACT,   0x00000013);
}

void set_imageif_sony_imx136(void)
{
    SetReg32(CIO_HS_EN, 0x00030033);     //
    SetReg32(CIO_C, 0x00010013);         // RSTN,PWDN =1 , SBSEL=1 (MSB) , IFIMODE=0b00;
    SetReg32(CIO_TE_EN, 0x70fff);        // Curius TE_EN all 1
    
    SetReg32(ISI_C, 0x8000e404);         // SONY

    SetReg32(CH1P0_SOF_12W, 0x00000fff);
    SetReg32(CH1P0_SOF_34W, 0x08000000); // fff_000_000_800
    SetReg32(CH1P0_SOL_12W, 0x00000fff);
    SetReg32(CH1P0_SOL_34W, 0x0ab00000); // fff_000_000_ab0
    
    SetReg32(CH1P0_EOL_12W, 0x00000fff);
    SetReg32(CH1P0_EOL_34W, 0x0b600000); // fff_000_000_b60
    SetReg32(CH1P0_EOF_12W, 0x00000fff);
    SetReg32(CH1P0_EOF_34W, 0x09d00000); // fff_000_000_9d0
    
    SetReg32(CH1P1_SOF_12W, 0x00000fff);
    SetReg32(CH1P1_SOF_34W, 0x08000000); // fff_000_000_801
    SetReg32(CH1P1_SOL_12W, 0x00000fff);
    SetReg32(CH1P1_SOL_34W, 0x0ab00000); // fff_000_000_ab1
    
    SetReg32(CH1P1_EOL_12W, 0x00000fff);
    SetReg32(CH1P1_EOL_34W, 0x0b600000); // fff_000_000_b61
    SetReg32(CH1P1_EOF_12W, 0x00000fff);
    SetReg32(CH1P1_EOF_34W, 0x09d00000); // fff_000_000_9d1
    
    SetReg32(CH2P0_SOF_12W, 0x00000fff);
    SetReg32(CH2P0_SOF_34W, 0x08000000); // fff_000_000_802
    SetReg32(CH2P0_SOL_12W, 0x00000fff);
    SetReg32(CH2P0_SOL_34W, 0x0ab00000); // fff_000_000_ab2
    
    SetReg32(CH2P0_EOL_12W, 0x00000fff);
    SetReg32(CH2P0_EOL_34W, 0x0b600000); // fff_000_000_b62
    SetReg32(CH2P0_EOF_12W, 0x00000fff);
    SetReg32(CH2P0_EOF_34W, 0x09d00000); // fff_000_000_9d2
    
    SetReg32(CH2P1_SOF_12W, 0x00000fff);
    SetReg32(CH2P1_SOF_34W, 0x08000000); // fff_000_000_803
    SetReg32(CH2P1_SOL_12W, 0x00000fff);
    SetReg32(CH2P1_SOL_34W, 0x0ab00000); // fff_000_000_ab3
    
    SetReg32(CH2P1_EOL_12W, 0x00000fff);
    SetReg32(CH2P1_EOL_34W, 0x0b600000); // fff_000_000_b63
    SetReg32(CH2P1_EOF_12W, 0x00000fff);
    SetReg32(CH2P1_EOF_34W, 0x09d00000); // fff_000_000_9d3

#ifndef ENABLE_OB_CALC
//    SetReg32(ISI_CAP_STAT, (24 <<16) | 16);
    SetReg32(ISI_CAP_STAT, (ob_vstart <<16) | pix_hstart);
#else   //  ENABLE_OB_CALC
    SetReg32(ISI_CAP_STAT, (2 <<16) | 16);
#endif  //  ENABLE_OB_CALC
}

//  imageif_enc_pic_startは使用禁止
#if 0
void imageif_enc_pic_start(UInt8 PicNum , bool wdrMode)
{
//    SetReg32(RegSPU_ACT, 0x80000002);   // double buffer

#if 0
    if ((PicNum&0x3) == 0x0) {
        SetReg32(RegAVEVER_MODE_SEL, g_opd_mode_raw);
        SetReg32(RegAVEVER_W_NUM,    (g_opd_v_div_awb << 8) | g_opd_h_div_awb );
        SetReg32(RegAVEVER_W_SIZE,   (g_avever_w_size_v_awb << 16) | g_avever_w_size_h_awb );
        SetReg32(RegSPU_DMAW1_LEN, (g_opd_v_div_awb*g_opd_h_div_awb*6)); // spu_dmaw1_len_r
//        SetReg32(RegSPU_DMAW1_OFS, DRAM_OFST_IMG_3A_AWE_0); // spu_dmaw1_ofs_r (*)
        SetReg32(RegSPU_DMAW1_OFS, SPAD_OFST_IMG_AWE_0); // spu_dmaw1_ofs_r (*)
    }
    else if ((PicNum&0x3) == 0x1) {
        SetReg32(RegAVEVER_MODE_SEL, g_opd_mode_raw);
        SetReg32(RegAVEVER_W_NUM,    (g_opd_v_div_awb << 8) | g_opd_h_div_awb );
        SetReg32(RegAVEVER_W_SIZE,   (g_avever_w_size_v_awb << 16) | g_avever_w_size_h_awb );
        SetReg32(RegSPU_DMAW1_LEN, (g_opd_v_div_awb*g_opd_h_div_awb*6)); // spu_dmaw1_len_r
//        SetReg32(RegSPU_DMAW1_OFS, DRAM_OFST_IMG_3A_AWE_1); // spu_dmaw1_ofs_r (*)
        SetReg32(RegSPU_DMAW1_OFS, SPAD_OFST_IMG_AWE_1); // spu_dmaw1_ofs_r (*)
    }
    else if (PicNum&0x1) {
        SetReg32(RegAVEVER_MODE_SEL, g_opd_mode_yrgb);
        SetReg32(RegAVEVER_W_NUM,    (g_opd_v_div_ae << 8) | g_opd_h_div_ae );
        SetReg32(RegAVEVER_W_SIZE,   (g_avever_w_size_v_ae << 16) | g_avever_w_size_h_ae );
        SetReg32(RegSPU_DMAW1_LEN, (g_opd_v_div_ae*g_opd_h_div_ae)); // spu_dmaw1_len_r
//        SetReg32(RegSPU_DMAW1_OFS, DRAM_OFST_IMG_3A_AE0_0); // spu_dmaw1_ofs_r (*)
        SetReg32(RegSPU_DMAW1_OFS, SPAD_OFST_IMG_AE0_0); // spu_dmaw1_ofs_r (*)
    }
    else {
        SetReg32(RegAVEVER_MODE_SEL, g_opd_mode_yrgb);
        SetReg32(RegAVEVER_W_NUM,    (g_opd_v_div_ae << 8) | g_opd_h_div_ae );
        SetReg32(RegAVEVER_W_SIZE,   (g_avever_w_size_v_ae << 16) | g_avever_w_size_h_ae );
        SetReg32(RegSPU_DMAW1_LEN, (g_opd_v_div_ae*g_opd_h_div_ae)); // spu_dmaw1_len_r
//        SetReg32(RegSPU_DMAW1_OFS, DRAM_OFST_IMG_3A_AE0_1); // spu_dmaw1_ofs_r (*)
        SetReg32(RegSPU_DMAW1_OFS, SPAD_OFST_IMG_AE0_1); // spu_dmaw1_ofs_r (*)
    }
#endif
	if (PicNum&0x1) {
        SetReg32(RegSPU_C, 0x00080400);                      // b18:DMAW0 out sel, b19:direct out sel
        if (PicNum&0x2) {
            SetReg32(RegSPU_DMAW0_OFS, DRAM_OFST_IMG_MIX_1); // spu_dmaw0_ofs_r (*)
        }
        else {
            SetReg32(RegSPU_DMAW0_OFS, DRAM_OFST_IMG_MIX_0); // spu_dmaw0_ofs_r (*)
        }
        
        if(wdrMode) {
			SetReg32(RegMIX_ACT, 0x80000003);	// K.Kawachi 0x80000001 => 0x80000003
        } else {
			SetReg32(RegMIX_ACT, 0x80000001);	// K.Kawachi 0x80000001 => 0x80000003
        }
//		SetReg32(RegMIX_ACT, 0x80000001);	// K.Kawachi 0x80000001 => 0x80000003
    										//          B31:Double buffer
    										//          B1:Direct入力画像設定 1: 長時間露光画像
    										//          B0:MIX動作の制御 1:ON
		setRegLog2(GetReg32(RegSPU_C) | 0x20000000 , GetReg32(RegMIX_ACT) | 0x2000);
    }
    else {
        SetReg32(RegSPU_C, 0x00040400);                      // b18:DMAW0 out sel, b19:direct out sel  

        SetReg32(RegSPU_DMAW0_OFS, DRAM_OFST_IMG_SPU_0);     // spu_dmaw0_ofs_r (*)
        
        SetReg32(RegMIX_ACT, 0x80000002);	// K.Kawachi 0x80000000 => 0x80000002
//        SetReg32(RegMIX_ACT, 0x80000000);	// K.Kawachi 0x80000000 => 0x80000002
    										//          B31:Double buffer
    										//          B1:Direct入力画像設定 1: 長時間露光画像
    										//          B0:MIX動作の制御 0:OFF
		setRegLog2(GetReg32(RegSPU_C) | 0x10000000 , GetReg32(RegMIX_ACT) | 0x1000);
    }
		setRegLog3(0 , 0);

}
#endif
#ifdef  __cplusplus
}
#endif

#endif  //  PARASOFT_CPPTEST
