//---------------------------------------------------------------------------
// Across
//---------------------------------------------------------------------------

#define       REG_ISP_DMAW_BASE             (REG_ISP_DMAC_BASE + 0x00000000)
#define       REG_ISP_DMAR_BASE             (REG_ISP_DMAC_BASE + 0x00001000)

#define       REG_ISP_RPU_BASE              (REG_ISP_CORE_BASE + 0x00000000)
#define       REG_ISP_SCL_BASE              (REG_ISP_CORE_BASE + 0x00008000)
#define       REG_ISP_DMAREG_BASE           (REG_ISP_CORE_BASE + 0x0000a000)
#define       REG_ISP_WDR_BASE              (REG_ISP_CORE_BASE + 0x0000c000)
#define       REG_ISP_3DNR_BASE             (REG_ISP_CORE_BASE + 0x0000e000)


// ISP DMAW register


// ISP DMAR register


// ISP RPU register
#define       REG_ISP_RPU_DUMMY             (REG_ISP_RPU_BASE + 0x00000000)


// ISP SCL register
#define       REG_ISP_SCL_CTL               (REG_ISP_SCL_BASE + 0x00000000)
#define       REG_ISP_SCL_INT_MASK          (REG_ISP_SCL_BASE + 0x00000004)
#define       REG_ISP_SCL_INT_INV           (REG_ISP_SCL_BASE + 0x00000008)
#define       REG_ISP_SCL_INT_LEVEL         (REG_ISP_SCL_BASE + 0x0000000c)
#define       REG_ISP_SCL_INT_STATUS        (REG_ISP_SCL_BASE + 0x00000010)
#define       REG_ISP_SCL_INT_UNMASK        (REG_ISP_SCL_BASE + 0x00000014)
#define       REG_ISP_SCL_INT_RAW           (REG_ISP_SCL_BASE + 0x00000018)
#define       REG_ISP_SCL_DIO_CNT_STATUS    (REG_ISP_SCL_BASE + 0x0000001c)
#define       REG_ISP_SCL_DIO_SATD8X8       (REG_ISP_SCL_BASE + 0x00000020)
// dont use                                   (REG_ISP_SCL_BASE + 0x00000024)
// ~                                          (REG_ISP_SCL_BASE + 0x0000003c)
#define       REG_ISP_SCL_SRC0              (REG_ISP_SCL_BASE + 0x00000040)
#define       REG_ISP_SCL_DST0              (REG_ISP_SCL_BASE + 0x00000044)
#define       REG_ISP_SCL_DMA0              (REG_ISP_SCL_BASE + 0x00000048)
#define       REG_ISP_SCL_NEG_FLIP0         (REG_ISP_SCL_BASE + 0x0000004c)
#define       REG_ISP_SCL_CLIP0             (REG_ISP_SCL_BASE + 0x00000050)
// dont use                                   (REG_ISP_SCL_BASE + 0x00000054)
// ~                                          (REG_ISP_SCL_BASE + 0x0000005c)
#define       REG_ISP_SCL_SRC1              (REG_ISP_SCL_BASE + 0x00000060)
#define       REG_ISP_SCL_DST1              (REG_ISP_SCL_BASE + 0x00000064)
#define       REG_ISP_SCL_DMA1              (REG_ISP_SCL_BASE + 0x00000068)
#define       REG_ISP_SCL_NEG_FLIP1         (REG_ISP_SCL_BASE + 0x0000006c)
#define       REG_ISP_SCL_CLIP1             (REG_ISP_SCL_BASE + 0x00000070)
// dont use                                   (REG_ISP_SCL_BASE + 0x00000074)
// ~                                          (REG_ISP_SCL_BASE + 0x0000007c)
#define       REG_ISP_SCL_SRC2              (REG_ISP_SCL_BASE + 0x00000080)
#define       REG_ISP_SCL_DST2              (REG_ISP_SCL_BASE + 0x00000084)
#define       REG_ISP_SCL_DMA2              (REG_ISP_SCL_BASE + 0x00000088)
#define       REG_ISP_SCL_NEG_FLIP2         (REG_ISP_SCL_BASE + 0x0000008c)
#define       REG_ISP_SCL_CLIP2             (REG_ISP_SCL_BASE + 0x00000090)
// dont use                                   (REG_ISP_SCL_BASE + 0x00000094)
// ~                                          (REG_ISP_SCL_BASE + 0x0000009c)
#define       REG_ISP_SCL_SRC3              (REG_ISP_SCL_BASE + 0x000000a0)
// dont use(REG_ISP_SCL_DST3)                 (REG_ISP_SCL_BASE + 0x000000a4)
#define       REG_ISP_SCL_DMA3              (REG_ISP_SCL_BASE + 0x000000a8)
#define       REG_ISP_SCL_NEG_FLIP3         (REG_ISP_SCL_BASE + 0x000000ac)
#define       REG_ISP_SCL_CLIP3             (REG_ISP_SCL_BASE + 0x000000b0)
// dont use                                   (REG_ISP_SCL_BASE + 0x000000b4)
// ~                                          (REG_ISP_SCL_BASE + 0x000000bc)
#define       REG_ISP_SCL_SRC4              (REG_ISP_SCL_BASE + 0x000000c0)
// dont use(REG_ISP_SCL_DST4)                 (REG_ISP_SCL_BASE + 0x000000c4)
#define       REG_ISP_SCL_DMA4              (REG_ISP_SCL_BASE + 0x000000c8)
#define       REG_ISP_SCL_NEG_FLIP4         (REG_ISP_SCL_BASE + 0x000000cc)
#define       REG_ISP_SCL_CLIP4             (REG_ISP_SCL_BASE + 0x000000d0)
// dont use                                   (REG_ISP_SCL_BASE + 0x000000d4)
// ~                                          (REG_ISP_SCL_BASE + 0x000000dc)
#define       REG_ISP_SCL_SRC5              (REG_ISP_SCL_BASE + 0x000000e0)
#define       REG_ISP_SCL_DST5              (REG_ISP_SCL_BASE + 0x000000e4)
#define       REG_ISP_SCL_IMGRAM            (REG_ISP_SCL_BASE + 0x000000e8)
// dont use(REG_ISP_SCL_NEG_FLIP5)            (REG_ISP_SCL_BASE + 0x000000ec)
// dont use(REG_ISP_SCL_CLIP5)                (REG_ISP_SCL_BASE + 0x000000f0)
#define       REG_ISP_SCL_IMG_ID            (REG_ISP_SCL_BASE + 0x000000f4)


// ISP SCL register bit
#define       SCL_CTL_SRST                  (1)
#define       SCL_CTL_START                 (1<<8)
#define       SCL_CTL_CH0                   (1<<16)
#define       SCL_CTL_CH1                   (1<<17)
#define       SCL_CTL_CH2                   (1<<18)
#define       SCL_CTL_CH3                   (1<<19)
#define       SCL_CTL_CH4                   (1<<20)
#define       SCL_CTL_CH5                   (1<<21)
#define       SCL_DMA0_ADDR_MON             (1<<24)
#define       SCL_DMA1_ADDR_MON             (1<<25)
#define       SCL_DMA2_ADDR_MON             (1<<26)
#define       SCL_DMA3_ADDR_MON             (1<<27)
#define       SCL_DMA4_ADDR_MON             (1<<28)
#define       SCL_IMGRAM_ADDR_MON           (1<<29)
#define       SCL_CTL_DIO_CNT_CLR           (1<<30)
#define       SCL_CTL_SATD8X8_CLR           (1<<31)

#define       SCL_INT_SCALE0_DONE           (1)
#define       SCL_INT_SCALE1_DONE           (1<<1)
#define       SCL_INT_SCALE2_DONE           (1<<2)
#define       SCL_INT_SCALE3_DONE           (1<<3)
#define       SCL_INT_SCALE4_DONE           (1<<4)
#define       SCL_INT_SCALE5_DONE           (1<<5)
#define       SCL_INT_DMA0_SCALE_DONE       (1<<6)
#define       SCL_INT_DMA1_SCALE_DONE       (1<<7)
#define       SCL_INT_DMA2_SCALE_DONE       (1<<8)
#define       SCL_INT_DMA3_SCALE_DONE       (1<<9)
#define       SCL_INT_DMA4_SCALE_DONE       (1<<10)
#define       SCL_INT_DMA5_SCALE_DONE       (1<<11)
#define       SCL_INT_DIRECT_OVFL           (1<<12)
#define       SCL_INT_DP_ALL_DONE           (1<<13)
#define       SCL_INT_DMA_ALL_DONE          (1<<14)

#define       SCL_NEG                       (1)
#define       SCL_H_FLIP                    (1<<8)
#define       SCL_V_FLIP                    (1<<12)

  
// ISP DMA register
#define r_ISP_DMAREG_SRST                 (REG_ISP_DMAREG_BASE + 0x000)
#define r_ISP_DMAREG_EN                   (REG_ISP_DMAREG_BASE + 0x004)

// ISP WDR register
//#define IR_LEN                     (REG_ISP_WDR_BASE + 0x00)
//#define IR_DITHER                  (REG_ISP_WDR_BASE + 0x04)
//#define IR_SLOPE                   (REG_ISP_WDR_BASE + 0x08)
//#define IR_LEVEL                   (REG_ISP_WDR_BASE + 0x0c)
//#define IR_CONTROL                 (REG_ISP_WDR_BASE + 0x10)
//#define IR_STRENGTH                (REG_ISP_WDR_BASE + 0x14)
//#define IR_LUT_FI_ADR              (REG_ISP_WDR_BASE + 0x18)
//#define IR_LUT_FI_DATA             (REG_ISP_WDR_BASE + 0x1c)
//#define IR_FWD_PERCEPT_LUT_ADR     (REG_ISP_WDR_BASE + 0x20)
//#define IR_FWD_PERCEPT_LUT_DATA    (REG_ISP_WDR_BASE + 0x24)
//#define IR_FWD_PERCEPT_LUT_EN      (REG_ISP_WDR_BASE + 0x28)
//#define IR_REV_PERCEPT_LUT_ADR     (REG_ISP_WDR_BASE + 0x2c)
//#define IR_REV_PERCEPT_LUT_DATA    (REG_ISP_WDR_BASE + 0x30)
//#define IR_REV_PERCEPT_LUT_EN      (REG_ISP_WDR_BASE + 0x34)
//#define IR_RGGB_START              (REG_ISP_WDR_BASE + 0x38)
//#define IR_WBGAIN0                 (REG_ISP_WDR_BASE + 0x3c)
//#define IR_WBGAIN1                 (REG_ISP_WDR_BASE + 0x40)
//#define IR_IFCONTROL               (REG_ISP_WDR_BASE + 0x44)

// ISP WDR regsiter(RPU 3A)
#define RegRPU_AVE_C               (REG_ISP_WDR_BASE + 0x80);
#define RegRPU_WB0_TH              (REG_ISP_WDR_BASE + 0x84);
#define RegRPU_WB1_TH              (REG_ISP_WDR_BASE + 0x88);
#define RegRPU_WB2_TH              (REG_ISP_WDR_BASE + 0x8C);
#define RegRPU_WB3_TH              (REG_ISP_WDR_BASE + 0x90);
#define RegRPU_AVEVER_MODE_SEL     (REG_ISP_WDR_BASE + 0x94);
#define RegRPU_AVEVER_W_NUM        (REG_ISP_WDR_BASE + 0x98);
#define RegRPU_AVEVER_W_SIZE       (REG_ISP_WDR_BASE + 0x9C);
#define RegRPU_AVEVER_MODE2_PARAM0 (REG_ISP_WDR_BASE + 0xA0);
#define RegRPU_AVEVER_MODE2_PARAM1 (REG_ISP_WDR_BASE + 0xA4);

// ISP 3DNR register
//#define NR_HLEN         (REG_ISP_3DNR_BASE + 0x00)
//#define NR_VLEN         (REG_ISP_3DNR_BASE + 0x04)
//#define NR_BLANK        (REG_ISP_3DNR_BASE + 0x08)
//#define NR_EN           (REG_ISP_3DNR_BASE + 0x0c)
//#define NR_MAIN_YTH0    (REG_ISP_3DNR_BASE + 0x10)
//#define NR_MAIN_YTH1    (REG_ISP_3DNR_BASE + 0x14)
//#define NR_MAIN_YTH2    (REG_ISP_3DNR_BASE + 0x18)
//#define NR_MAIN_YTH3    (REG_ISP_3DNR_BASE + 0x1c)
//#define NR_MAIN_CTH0    (REG_ISP_3DNR_BASE + 0x20)
//#define NR_MAIN_CTH1    (REG_ISP_3DNR_BASE + 0x24)
//#define NR_MAIN_CTH2    (REG_ISP_3DNR_BASE + 0x28)
//#define NR_MAIN_CTH3    (REG_ISP_3DNR_BASE + 0x2c)
//#define NR_MAIN_YIN0    (REG_ISP_3DNR_BASE + 0x30)
//#define NR_MAIN_YIN1    (REG_ISP_3DNR_BASE + 0x34)
//#define NR_MAIN_YIN2    (REG_ISP_3DNR_BASE + 0x38)
//#define NR_MAIN_YIN3    (REG_ISP_3DNR_BASE + 0x3c)
//#define NR_MAIN_CIN0    (REG_ISP_3DNR_BASE + 0x40)
//#define NR_MAIN_CIN1    (REG_ISP_3DNR_BASE + 0x44)
//#define NR_MAIN_CIN2    (REG_ISP_3DNR_BASE + 0x48)
//#define NR_MAIN_CIN3    (REG_ISP_3DNR_BASE + 0x4c)
//#define NR_SUB_YTH      (REG_ISP_3DNR_BASE + 0x50)
//#define NR_SUB_CTH      (REG_ISP_3DNR_BASE + 0x54)
//#define NR_SUB_YIN      (REG_ISP_3DNR_BASE + 0x58)
//#define NR_SUB_CIN      (REG_ISP_3DNR_BASE + 0x5c)
//#define NR_MAIN_YLV0    (REG_ISP_3DNR_BASE + 0x60)
//#define NR_MAIN_YLV1    (REG_ISP_3DNR_BASE + 0x64)
//#define NR_MAIN_YLV2    (REG_ISP_3DNR_BASE + 0x68)
//#define NR_MAIN_YLV3    (REG_ISP_3DNR_BASE + 0x6c)
//#define NR_MAIN_CLV0    (REG_ISP_3DNR_BASE + 0x70)
//#define NR_MAIN_CLV1    (REG_ISP_3DNR_BASE + 0x74)
//#define NR_MAIN_CLV2    (REG_ISP_3DNR_BASE + 0x78)
//#define NR_MAIN_CLV3    (REG_ISP_3DNR_BASE + 0x7c)
//#define NR_SUB_YLV      (REG_ISP_3DNR_BASE + 0x80)
//#define NR_SUB_CLV      (REG_ISP_3DNR_BASE + 0x84)
#define RPU_DMA_ACT 	  (REG_ISP_3DNR_BASE + 0x88)
#define RPU_DMAR0_OFS   (REG_ISP_3DNR_BASE + 0x8c)
#define RPU_DMAR0_FMT   (REG_ISP_3DNR_BASE + 0x90)
#define RPU_DMAR1_OFS   (REG_ISP_3DNR_BASE + 0x94)
#define RPU_DMAR1_FMT   (REG_ISP_3DNR_BASE + 0x98)
#define	RPU_DMAW1_OFS	(REG_ISP_3DNR_BASE + 0x9c)
#define	RPU_DMAW1_LEN	(REG_ISP_3DNR_BASE + 0xa0)
#define NR_DMAR_OFS     (REG_ISP_3DNR_BASE + 0xa4)
#define NR_ISP_MODE     (REG_ISP_3DNR_BASE + 0xa8)
#define NR_PTZ1_X       (REG_ISP_3DNR_BASE + 0xac)
#define NR_PTZ1_Y       (REG_ISP_3DNR_BASE + 0xb0)
#define NR_PTZ2_X       (REG_ISP_3DNR_BASE + 0xb4)
#define NR_PTZ2_Y       (REG_ISP_3DNR_BASE + 0xb8)
#define NR_PTZ3_X       (REG_ISP_3DNR_BASE + 0xbc)
#define NR_PTZ3_Y       (REG_ISP_3DNR_BASE + 0xc0)
#define NR_PTZ4_X       (REG_ISP_3DNR_BASE + 0xc4)
#define NR_PTZ4_Y       (REG_ISP_3DNR_BASE + 0xc8)
#define NR_PTZ5_X       (REG_ISP_3DNR_BASE + 0xcc)
#define NR_PTZ5_Y       (REG_ISP_3DNR_BASE + 0xd0)


//---- rpu_reg -------------------------------------------------------------
#define r_ISP_RPU_C0    (REG_ISP_RPU_BASE + 0x000) // 'd000
#define r_ISP_RPU_IDM   (REG_ISP_RPU_BASE + 0x004) // 'd001
#define r_ISP_RPU_ID0   (REG_ISP_RPU_BASE + 0x008) // 'd002
#define r_ISP_RPU_ID1   (REG_ISP_RPU_BASE + 0x00C) // 'd003
#define r_ISP_RPU_ID2   (REG_ISP_RPU_BASE + 0x010) // 'd004
#define r_ISP_RPU_ID3   (REG_ISP_RPU_BASE + 0x014) // 'd005
#define r_ISP_RPU_ID4   (REG_ISP_RPU_BASE + 0x018) // 'd006
#define r_ISP_RPU_ODM   (REG_ISP_RPU_BASE + 0x01C) // 'd007
#define r_ISP_RPU_OD0   (REG_ISP_RPU_BASE + 0x020) // 'd008
#define r_ISP_RPU_OD1   (REG_ISP_RPU_BASE + 0x024) // 'd009
#define r_ISP_RPU_OD2   (REG_ISP_RPU_BASE + 0x028) // 'd010
#define r_ISP_RPU_OD3   (REG_ISP_RPU_BASE + 0x02C) // 'd011
// -> dsc4hasm.vh
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////


/*       ////---        RPU             ---////       */


#define RPU_C0          (REG_ISP_RPU_BASE + 0x000)
#define RPU_IDM         (REG_ISP_RPU_BASE + 0x004)
#define RPU_ID0         (REG_ISP_RPU_BASE + 0x008)
#define RPU_ID1         (REG_ISP_RPU_BASE + 0x00C)
#define RPU_ID2         (REG_ISP_RPU_BASE + 0x010)
#define RPU_ID3         (REG_ISP_RPU_BASE + 0x014)
#define RPU_ID4         (REG_ISP_RPU_BASE + 0x018)
#define RPU_ODM         (REG_ISP_RPU_BASE + 0x01C)
#define RPU_OD0         (REG_ISP_RPU_BASE + 0x020)
#define RPU_OD1         (REG_ISP_RPU_BASE + 0x024)
#define RPU_OD2         (REG_ISP_RPU_BASE + 0x028)
#define RPU_OD3         (REG_ISP_RPU_BASE + 0x02C)
#define DMAO0_HW        (REG_ISP_RPU_BASE + 0x030)
#define DMAO0_VW        (REG_ISP_RPU_BASE + 0x034)
#define DMAO1_HW        (REG_ISP_RPU_BASE + 0x038)
#define DMAO1_VW        (REG_ISP_RPU_BASE + 0x03C)
#define DMAO2_HW        (REG_ISP_RPU_BASE + 0x040)
#define DMAO2_VW        (REG_ISP_RPU_BASE + 0x044)
#define DMAO3_HW        (REG_ISP_RPU_BASE + 0x048)
#define DMAO3_VW        (REG_ISP_RPU_BASE + 0x04C)
#define RPU_LN          (REG_ISP_RPU_BASE + 0x050)
#define RPU_IC          (REG_ISP_RPU_BASE + 0x054)
#define SPP_C           (REG_ISP_RPU_BASE + 0x058)
#define SPPOB0          (REG_ISP_RPU_BASE + 0x05C)
#define SPPOB1          (REG_ISP_RPU_BASE + 0x060)
#define SPPOB2          (REG_ISP_RPU_BASE + 0x064)
#define SPPOB3          (REG_ISP_RPU_BASE + 0x068)
#define SPPWB0          (REG_ISP_RPU_BASE + 0x06C)
#define SPPWB1          (REG_ISP_RPU_BASE + 0x070)
#define SPPWB2          (REG_ISP_RPU_BASE + 0x074)
#define SPPWB3          (REG_ISP_RPU_BASE + 0x078)
#define LCC01A          (REG_ISP_RPU_BASE + 0x07C)
#define LCC23A          (REG_ISP_RPU_BASE + 0x080)
#define LCC01B          (REG_ISP_RPU_BASE + 0x084)
#define LCC23B          (REG_ISP_RPU_BASE + 0x088)
#define SPPVAL          (REG_ISP_RPU_BASE + 0x08C)
#define SPP_C2          (REG_ISP_RPU_BASE + 0x090)
#define SPP_VAL2        (REG_ISP_RPU_BASE + 0x094)
#define SPP_VAL3        (REG_ISP_RPU_BASE + 0x098)
#define SPP_VAL4        (REG_ISP_RPU_BASE + 0x09C)
#define SPP_VAL5        (REG_ISP_RPU_BASE + 0x0A0)
#define SPP_VAL6        (REG_ISP_RPU_BASE + 0x0A4)
#define SPP_SHT0        (REG_ISP_RPU_BASE + 0x0A8)
#define SPP_SHT1        (REG_ISP_RPU_BASE + 0x0AC)
#define SPP_SHT2        (REG_ISP_RPU_BASE + 0x0B0)
#define IAG_C           (REG_ISP_RPU_BASE + 0x0B4)
#define IAG_C2          (REG_ISP_RPU_BASE + 0x0B8)
#define ITP_CHONY       (REG_ISP_RPU_BASE + 0x0BC)
#define ITP_V0          (REG_ISP_RPU_BASE + 0x0C0)
#define ITP_V1          (REG_ISP_RPU_BASE + 0x0C4)
#define ITP_V2          (REG_ISP_RPU_BASE + 0x0C8)
#define ITP_V3          (REG_ISP_RPU_BASE + 0x0CC)
#define ITP_V4          (REG_ISP_RPU_BASE + 0x0D0)
#define ITP_V5          (REG_ISP_RPU_BASE + 0x0D4)
#define ITP_V6          (REG_ISP_RPU_BASE + 0x0D8)
#define ITP_V7          (REG_ISP_RPU_BASE + 0x0DC)
#define ITP_V8          (REG_ISP_RPU_BASE + 0x0E0)
#define ITP_LAP0        (REG_ISP_RPU_BASE + 0x0E4)
#define ITP_LAP1        (REG_ISP_RPU_BASE + 0x0E8)
#define ITP_LAP2        (REG_ISP_RPU_BASE + 0x0EC)
#define ITP_LAP3        (REG_ISP_RPU_BASE + 0x0F0)
#define ITP_LAP4        (REG_ISP_RPU_BASE + 0x0F4)
#define AFV_C           (REG_ISP_RPU_BASE + 0x0F8)
#define AFVW_H          (REG_ISP_RPU_BASE + 0x0FC)
#define AFVW_V          (REG_ISP_RPU_BASE + 0x100)
#define AFV_DT          (REG_ISP_RPU_BASE + 0x104)
#define AFV_PD          (REG_ISP_RPU_BASE + 0x108)
#define LMCF00          (REG_ISP_RPU_BASE + 0x10C)
#define LMCF01          (REG_ISP_RPU_BASE + 0x110)
#define LMCF02          (REG_ISP_RPU_BASE + 0x114)
#define LMCF03          (REG_ISP_RPU_BASE + 0x118)
#define LMCF10          (REG_ISP_RPU_BASE + 0x11C)
#define LMCF11          (REG_ISP_RPU_BASE + 0x120)
#define LMCF12          (REG_ISP_RPU_BASE + 0x124)
#define LMCF13          (REG_ISP_RPU_BASE + 0x128)
#define LMCF20          (REG_ISP_RPU_BASE + 0x12C)
#define LMCF21          (REG_ISP_RPU_BASE + 0x130)
#define LMCF22          (REG_ISP_RPU_BASE + 0x134)
#define LMCF23          (REG_ISP_RPU_BASE + 0x138)
#define LMCF30          (REG_ISP_RPU_BASE + 0x13C)
#define LMCF31          (REG_ISP_RPU_BASE + 0x140)
#define LMCF32          (REG_ISP_RPU_BASE + 0x144)
#define LMCF33          (REG_ISP_RPU_BASE + 0x148)
#define LMOF0           (REG_ISP_RPU_BASE + 0x14C)
#define LMOF1           (REG_ISP_RPU_BASE + 0x150)
#define LMOF2           (REG_ISP_RPU_BASE + 0x154)
#define LMOF3           (REG_ISP_RPU_BASE + 0x158)
#define LMBC            (REG_ISP_RPU_BASE + 0x15C)
//#define RG_GMOF0_00     (REG_ISP_RPU_BASE + 0x160)
//#define RG_GMOF0_01     (REG_ISP_RPU_BASE + 0x164)
//#define RG_GMOF0_02     (REG_ISP_RPU_BASE + 0x168)
//#define RG_GMOF0_03     (REG_ISP_RPU_BASE + 0x16C)
//#define RG_GMOF0_04     (REG_ISP_RPU_BASE + 0x170)
//#define RG_GMOF0_05     (REG_ISP_RPU_BASE + 0x174)
//#define RG_GMOF0_06     (REG_ISP_RPU_BASE + 0x178)
//#define RG_GMOF0_07     (REG_ISP_RPU_BASE + 0x17C)
//#define RG_GMOF0_08     (REG_ISP_RPU_BASE + 0x180)
//#define RG_GMOF0_09     (REG_ISP_RPU_BASE + 0x184)
//#define RG_GMOF0_10     (REG_ISP_RPU_BASE + 0x188)
//#define RG_GMOF0_11     (REG_ISP_RPU_BASE + 0x18C)
//#define RG_GMOF0_12     (REG_ISP_RPU_BASE + 0x190)
//#define RG_GMOF0_13     (REG_ISP_RPU_BASE + 0x194)
//#define RG_GMOF0_14     (REG_ISP_RPU_BASE + 0x198)
//#define RG_GMOF0_15     (REG_ISP_RPU_BASE + 0x19C)
//#define RG_GMOF0_16     (REG_ISP_RPU_BASE + 0x1A0)
//#define RG_GMOF0_17     (REG_ISP_RPU_BASE + 0x1A4)
//#define RG_GMOF0_18     (REG_ISP_RPU_BASE + 0x1A8)
//#define RG_GMOF0_19     (REG_ISP_RPU_BASE + 0x1AC)
//#define RG_GMOF0_20     (REG_ISP_RPU_BASE + 0x1B0)
//#define RG_GMOF0_21     (REG_ISP_RPU_BASE + 0x1B4)
//#define RG_GMOF0_22     (REG_ISP_RPU_BASE + 0x1B8)
//#define RG_GMOF0_23     (REG_ISP_RPU_BASE + 0x1BC)
//#define RG_GMOF0_24     (REG_ISP_RPU_BASE + 0x1C0)
//#define RG_GMOF0_25     (REG_ISP_RPU_BASE + 0x1C4)
//#define RG_GMOF0_26     (REG_ISP_RPU_BASE + 0x1C8)
//#define RG_GMOF0_27     (REG_ISP_RPU_BASE + 0x1CC)
//#define RG_GMOF0_28     (REG_ISP_RPU_BASE + 0x1D0)
//#define RG_GMOF0_29     (REG_ISP_RPU_BASE + 0x1D4)
//#define RG_GMOF0_30     (REG_ISP_RPU_BASE + 0x1D8)
//#define RG_GMOF0_31     (REG_ISP_RPU_BASE + 0x1DC)
//#define RG_GMOF0_32     (REG_ISP_RPU_BASE + 0x1E0)
//#define RG_GMOF0_33     (REG_ISP_RPU_BASE + 0x1E4)
//#define RG_GMOF0_34     (REG_ISP_RPU_BASE + 0x1E8)
//#define RG_GMOF0_35     (REG_ISP_RPU_BASE + 0x1EC)
//#define RG_GMOF0_36     (REG_ISP_RPU_BASE + 0x1F0)
//#define RG_GMOF0_37     (REG_ISP_RPU_BASE + 0x1F4)
//#define RG_GMOF0_38     (REG_ISP_RPU_BASE + 0x1F8)
//#define RG_GMOF0_39     (REG_ISP_RPU_BASE + 0x1FC)
//#define RG_GMOF0_40     (REG_ISP_RPU_BASE + 0x200)
//#define RG_GMOF0_41     (REG_ISP_RPU_BASE + 0x204)
//#define RG_GMOF0_42     (REG_ISP_RPU_BASE + 0x208)
//#define RG_GMOF0_43     (REG_ISP_RPU_BASE + 0x20C)
//#define RG_GMOF0_44     (REG_ISP_RPU_BASE + 0x210)
//#define RG_GMOF0_45     (REG_ISP_RPU_BASE + 0x214)
//#define RG_GMOF0_46     (REG_ISP_RPU_BASE + 0x218)
//#define RG_GMOF0_47     (REG_ISP_RPU_BASE + 0x21C)
//#define RG_GMOF0_48     (REG_ISP_RPU_BASE + 0x220)
//#define RG_GMOF0_49     (REG_ISP_RPU_BASE + 0x224)
//#define RG_GMOF0_50     (REG_ISP_RPU_BASE + 0x228)
//#define RG_GMOF0_51     (REG_ISP_RPU_BASE + 0x22C)
//#define RG_GMOF0_52     (REG_ISP_RPU_BASE + 0x230)
//#define RG_GMOF0_53     (REG_ISP_RPU_BASE + 0x234)
//#define RG_GMOF0_54     (REG_ISP_RPU_BASE + 0x238)
//#define RG_GMOF0_55     (REG_ISP_RPU_BASE + 0x23C)
//#define RG_GMOF0_56     (REG_ISP_RPU_BASE + 0x240)
//#define RG_GMOF0_57     (REG_ISP_RPU_BASE + 0x244)
//#define RG_GMOF0_58     (REG_ISP_RPU_BASE + 0x248)
//#define RG_GMOF0_59     (REG_ISP_RPU_BASE + 0x24C)
//#define RG_GMOF0_60     (REG_ISP_RPU_BASE + 0x250)
//#define RG_GMOF0_61     (REG_ISP_RPU_BASE + 0x254)
//#define RG_GMOF0_62     (REG_ISP_RPU_BASE + 0x258)
//#define RG_GMOF0_63     (REG_ISP_RPU_BASE + 0x25C)
//#define RG_GMOF0_64     (REG_ISP_RPU_BASE + 0x260)
//#define RG_GMOF1_00     (REG_ISP_RPU_BASE + 0x264)
//#define RG_GMOF1_01     (REG_ISP_RPU_BASE + 0x268)
//#define RG_GMOF1_02     (REG_ISP_RPU_BASE + 0x26C)
//#define RG_GMOF1_03     (REG_ISP_RPU_BASE + 0x270)
//#define RG_GMOF1_04     (REG_ISP_RPU_BASE + 0x274)
//#define RG_GMOF1_05     (REG_ISP_RPU_BASE + 0x278)
//#define RG_GMOF1_06     (REG_ISP_RPU_BASE + 0x27C)
//#define RG_GMOF1_07     (REG_ISP_RPU_BASE + 0x280)
//#define RG_GMOF1_08     (REG_ISP_RPU_BASE + 0x284)
//#define RG_GMOF1_09     (REG_ISP_RPU_BASE + 0x288)
//#define RG_GMOF1_10     (REG_ISP_RPU_BASE + 0x28C)
//#define RG_GMOF1_11     (REG_ISP_RPU_BASE + 0x290)
//#define RG_GMOF1_12     (REG_ISP_RPU_BASE + 0x294)
//#define RG_GMOF1_13     (REG_ISP_RPU_BASE + 0x298)
//#define RG_GMOF1_14     (REG_ISP_RPU_BASE + 0x29C)
//#define RG_GMOF1_15     (REG_ISP_RPU_BASE + 0x2A0)
//#define RG_GMOF1_16     (REG_ISP_RPU_BASE + 0x2A4)
//#define RG_GMOF1_17     (REG_ISP_RPU_BASE + 0x2A8)
//#define RG_GMOF1_18     (REG_ISP_RPU_BASE + 0x2AC)
//#define RG_GMOF1_19     (REG_ISP_RPU_BASE + 0x2B0)
//#define RG_GMOF1_20     (REG_ISP_RPU_BASE + 0x2B4)
//#define RG_GMOF1_21     (REG_ISP_RPU_BASE + 0x2B8)
//#define RG_GMOF1_22     (REG_ISP_RPU_BASE + 0x2BC)
//#define RG_GMOF1_23     (REG_ISP_RPU_BASE + 0x2C0)
//#define RG_GMOF1_24     (REG_ISP_RPU_BASE + 0x2C4)
//#define RG_GMOF1_25     (REG_ISP_RPU_BASE + 0x2C8)
//#define RG_GMOF1_26     (REG_ISP_RPU_BASE + 0x2CC)
//#define RG_GMOF1_27     (REG_ISP_RPU_BASE + 0x2D0)
//#define RG_GMOF1_28     (REG_ISP_RPU_BASE + 0x2D4)
//#define RG_GMOF1_29     (REG_ISP_RPU_BASE + 0x2D8)
//#define RG_GMOF1_30     (REG_ISP_RPU_BASE + 0x2DC)
//#define RG_GMOF1_31     (REG_ISP_RPU_BASE + 0x2E0)
//#define RG_GMOF1_32     (REG_ISP_RPU_BASE + 0x2E4)
//#define RG_GMOF1_33     (REG_ISP_RPU_BASE + 0x2E8)
//#define RG_GMOF1_34     (REG_ISP_RPU_BASE + 0x2EC)
//#define RG_GMOF1_35     (REG_ISP_RPU_BASE + 0x2F0)
//#define RG_GMOF1_36     (REG_ISP_RPU_BASE + 0x2F4)
//#define RG_GMOF1_37     (REG_ISP_RPU_BASE + 0x2F8)
//#define RG_GMOF1_38     (REG_ISP_RPU_BASE + 0x2FC)
//#define RG_GMOF1_39     (REG_ISP_RPU_BASE + 0x300)
//#define RG_GMOF1_40     (REG_ISP_RPU_BASE + 0x304)
//#define RG_GMOF1_41     (REG_ISP_RPU_BASE + 0x308)
//#define RG_GMOF1_42     (REG_ISP_RPU_BASE + 0x30C)
//#define RG_GMOF1_43     (REG_ISP_RPU_BASE + 0x310)
//#define RG_GMOF1_44     (REG_ISP_RPU_BASE + 0x314)
//#define RG_GMOF1_45     (REG_ISP_RPU_BASE + 0x318)
//#define RG_GMOF1_46     (REG_ISP_RPU_BASE + 0x31C)
//#define RG_GMOF1_47     (REG_ISP_RPU_BASE + 0x320)
//#define RG_GMOF1_48     (REG_ISP_RPU_BASE + 0x324)
//#define RG_GMOF1_49     (REG_ISP_RPU_BASE + 0x328)
//#define RG_GMOF1_50     (REG_ISP_RPU_BASE + 0x32C)
//#define RG_GMOF1_51     (REG_ISP_RPU_BASE + 0x330)
//#define RG_GMOF1_52     (REG_ISP_RPU_BASE + 0x334)
//#define RG_GMOF1_53     (REG_ISP_RPU_BASE + 0x338)
//#define RG_GMOF1_54     (REG_ISP_RPU_BASE + 0x33C)
//#define RG_GMOF1_55     (REG_ISP_RPU_BASE + 0x340)
//#define RG_GMOF1_56     (REG_ISP_RPU_BASE + 0x344)
//#define RG_GMOF1_57     (REG_ISP_RPU_BASE + 0x348)
//#define RG_GMOF1_58     (REG_ISP_RPU_BASE + 0x34C)
//#define RG_GMOF1_59     (REG_ISP_RPU_BASE + 0x350)
//#define RG_GMOF1_60     (REG_ISP_RPU_BASE + 0x354)
//#define RG_GMOF1_61     (REG_ISP_RPU_BASE + 0x358)
//#define RG_GMOF1_62     (REG_ISP_RPU_BASE + 0x35C)
//#define RG_GMOF1_63     (REG_ISP_RPU_BASE + 0x360)
//#define RG_GMOF1_64     (REG_ISP_RPU_BASE + 0x364)
//#define RG_GMOF2_00     (REG_ISP_RPU_BASE + 0x368)
//#define RG_GMOF2_01     (REG_ISP_RPU_BASE + 0x36C)
//#define RG_GMOF2_02     (REG_ISP_RPU_BASE + 0x370)
//#define RG_GMOF2_03     (REG_ISP_RPU_BASE + 0x374)
//#define RG_GMOF2_04     (REG_ISP_RPU_BASE + 0x378)
//#define RG_GMOF2_05     (REG_ISP_RPU_BASE + 0x37C)
//#define RG_GMOF2_06     (REG_ISP_RPU_BASE + 0x380)
//#define RG_GMOF2_07     (REG_ISP_RPU_BASE + 0x384)
//#define RG_GMOF2_08     (REG_ISP_RPU_BASE + 0x388)
//#define RG_GMOF2_09     (REG_ISP_RPU_BASE + 0x38C)
//#define RG_GMOF2_10     (REG_ISP_RPU_BASE + 0x390)
//#define RG_GMOF2_11     (REG_ISP_RPU_BASE + 0x394)
//#define RG_GMOF2_12     (REG_ISP_RPU_BASE + 0x398)
//#define RG_GMOF2_13     (REG_ISP_RPU_BASE + 0x39C)
//#define RG_GMOF2_14     (REG_ISP_RPU_BASE + 0x3A0)
//#define RG_GMOF2_15     (REG_ISP_RPU_BASE + 0x3A4)
//#define RG_GMOF2_16     (REG_ISP_RPU_BASE + 0x3A8)
//#define RG_GMOF2_17     (REG_ISP_RPU_BASE + 0x3AC)
//#define RG_GMOF2_18     (REG_ISP_RPU_BASE + 0x3B0)
//#define RG_GMOF2_19     (REG_ISP_RPU_BASE + 0x3B4)
//#define RG_GMOF2_20     (REG_ISP_RPU_BASE + 0x3B8)
//#define RG_GMOF2_21     (REG_ISP_RPU_BASE + 0x3BC)
//#define RG_GMOF2_22     (REG_ISP_RPU_BASE + 0x3C0)
//#define RG_GMOF2_23     (REG_ISP_RPU_BASE + 0x3C4)
//#define RG_GMOF2_24     (REG_ISP_RPU_BASE + 0x3C8)
//#define RG_GMOF2_25     (REG_ISP_RPU_BASE + 0x3CC)
//#define RG_GMOF2_26     (REG_ISP_RPU_BASE + 0x3D0)
//#define RG_GMOF2_27     (REG_ISP_RPU_BASE + 0x3D4)
//#define RG_GMOF2_28     (REG_ISP_RPU_BASE + 0x3D8)
//#define RG_GMOF2_29     (REG_ISP_RPU_BASE + 0x3DC)
//#define RG_GMOF2_30     (REG_ISP_RPU_BASE + 0x3E0)
//#define RG_GMOF2_31     (REG_ISP_RPU_BASE + 0x3E4)
//#define RG_GMOF2_32     (REG_ISP_RPU_BASE + 0x3E8)
//#define RG_GMOF2_33     (REG_ISP_RPU_BASE + 0x3EC)
//#define RG_GMOF2_34     (REG_ISP_RPU_BASE + 0x3F0)
//#define RG_GMOF2_35     (REG_ISP_RPU_BASE + 0x3F4)
//#define RG_GMOF2_36     (REG_ISP_RPU_BASE + 0x3F8)
//#define RG_GMOF2_37     (REG_ISP_RPU_BASE + 0x3FC)
//#define RG_GMOF2_38     (REG_ISP_RPU_BASE + 0x400)
//#define RG_GMOF2_39     (REG_ISP_RPU_BASE + 0x404)
//#define RG_GMOF2_40     (REG_ISP_RPU_BASE + 0x408)
//#define RG_GMOF2_41     (REG_ISP_RPU_BASE + 0x40C)
//#define RG_GMOF2_42     (REG_ISP_RPU_BASE + 0x410)
//#define RG_GMOF2_43     (REG_ISP_RPU_BASE + 0x414)
//#define RG_GMOF2_44     (REG_ISP_RPU_BASE + 0x418)
//#define RG_GMOF2_45     (REG_ISP_RPU_BASE + 0x41C)
//#define RG_GMOF2_46     (REG_ISP_RPU_BASE + 0x420)
//#define RG_GMOF2_47     (REG_ISP_RPU_BASE + 0x424)
//#define RG_GMOF2_48     (REG_ISP_RPU_BASE + 0x428)
//#define RG_GMOF2_49     (REG_ISP_RPU_BASE + 0x42C)
//#define RG_GMOF2_50     (REG_ISP_RPU_BASE + 0x430)
//#define RG_GMOF2_51     (REG_ISP_RPU_BASE + 0x434)
//#define RG_GMOF2_52     (REG_ISP_RPU_BASE + 0x438)
//#define RG_GMOF2_53     (REG_ISP_RPU_BASE + 0x43C)
//#define RG_GMOF2_54     (REG_ISP_RPU_BASE + 0x440)
//#define RG_GMOF2_55     (REG_ISP_RPU_BASE + 0x444)
//#define RG_GMOF2_56     (REG_ISP_RPU_BASE + 0x448)
//#define RG_GMOF2_57     (REG_ISP_RPU_BASE + 0x44C)
//#define RG_GMOF2_58     (REG_ISP_RPU_BASE + 0x450)
//#define RG_GMOF2_59     (REG_ISP_RPU_BASE + 0x454)
//#define RG_GMOF2_60     (REG_ISP_RPU_BASE + 0x458)
//#define RG_GMOF2_61     (REG_ISP_RPU_BASE + 0x45C)
//#define RG_GMOF2_62     (REG_ISP_RPU_BASE + 0x460)
//#define RG_GMOF2_63     (REG_ISP_RPU_BASE + 0x464)
//#define RG_GMOF2_64     (REG_ISP_RPU_BASE + 0x468)
//#define RG_GMOF3_00     (REG_ISP_RPU_BASE + 0x46C)
//#define RG_GMOF3_01     (REG_ISP_RPU_BASE + 0x470)
//#define RG_GMOF3_02     (REG_ISP_RPU_BASE + 0x474)
//#define RG_GMOF3_03     (REG_ISP_RPU_BASE + 0x478)
//#define RG_GMOF3_04     (REG_ISP_RPU_BASE + 0x47C)
//#define RG_GMOF3_05     (REG_ISP_RPU_BASE + 0x480)
//#define RG_GMOF3_06     (REG_ISP_RPU_BASE + 0x484)
//#define RG_GMOF3_07     (REG_ISP_RPU_BASE + 0x488)
//#define RG_GMOF3_08     (REG_ISP_RPU_BASE + 0x48C)
//#define RG_GMOF3_09     (REG_ISP_RPU_BASE + 0x490)
//#define RG_GMOF3_10     (REG_ISP_RPU_BASE + 0x494)
//#define RG_GMOF3_11     (REG_ISP_RPU_BASE + 0x498)
//#define RG_GMOF3_12     (REG_ISP_RPU_BASE + 0x49C)
//#define RG_GMOF3_13     (REG_ISP_RPU_BASE + 0x4A0)
//#define RG_GMOF3_14     (REG_ISP_RPU_BASE + 0x4A4)
//#define RG_GMOF3_15     (REG_ISP_RPU_BASE + 0x4A8)
//#define RG_GMOF3_16     (REG_ISP_RPU_BASE + 0x4AC)
//#define RG_GMOF3_17     (REG_ISP_RPU_BASE + 0x4B0)
//#define RG_GMOF3_18     (REG_ISP_RPU_BASE + 0x4B4)
//#define RG_GMOF3_19     (REG_ISP_RPU_BASE + 0x4B8)
//#define RG_GMOF3_20     (REG_ISP_RPU_BASE + 0x4BC)
//#define RG_GMOF3_21     (REG_ISP_RPU_BASE + 0x4C0)
//#define RG_GMOF3_22     (REG_ISP_RPU_BASE + 0x4C4)
//#define RG_GMOF3_23     (REG_ISP_RPU_BASE + 0x4C8)
//#define RG_GMOF3_24     (REG_ISP_RPU_BASE + 0x4CC)
//#define RG_GMOF3_25     (REG_ISP_RPU_BASE + 0x4D0)
//#define RG_GMOF3_26     (REG_ISP_RPU_BASE + 0x4D4)
//#define RG_GMOF3_27     (REG_ISP_RPU_BASE + 0x4D8)
//#define RG_GMOF3_28     (REG_ISP_RPU_BASE + 0x4DC)
//#define RG_GMOF3_29     (REG_ISP_RPU_BASE + 0x4E0)
//#define RG_GMOF3_30     (REG_ISP_RPU_BASE + 0x4E4)
//#define RG_GMOF3_31     (REG_ISP_RPU_BASE + 0x4E8)
//#define RG_GMOF3_32     (REG_ISP_RPU_BASE + 0x4EC)
//#define RG_GMOF3_33     (REG_ISP_RPU_BASE + 0x4F0)
//#define RG_GMOF3_34     (REG_ISP_RPU_BASE + 0x4F4)
//#define RG_GMOF3_35     (REG_ISP_RPU_BASE + 0x4F8)
//#define RG_GMOF3_36     (REG_ISP_RPU_BASE + 0x4FC)
//#define RG_GMOF3_37     (REG_ISP_RPU_BASE + 0x500)
//#define RG_GMOF3_38     (REG_ISP_RPU_BASE + 0x504)
//#define RG_GMOF3_39     (REG_ISP_RPU_BASE + 0x508)
//#define RG_GMOF3_40     (REG_ISP_RPU_BASE + 0x50C)
//#define RG_GMOF3_41     (REG_ISP_RPU_BASE + 0x510)
//#define RG_GMOF3_42     (REG_ISP_RPU_BASE + 0x514)
//#define RG_GMOF3_43     (REG_ISP_RPU_BASE + 0x518)
//#define RG_GMOF3_44     (REG_ISP_RPU_BASE + 0x51C)
//#define RG_GMOF3_45     (REG_ISP_RPU_BASE + 0x520)
//#define RG_GMOF3_46     (REG_ISP_RPU_BASE + 0x524)
//#define RG_GMOF3_47     (REG_ISP_RPU_BASE + 0x528)
//#define RG_GMOF3_48     (REG_ISP_RPU_BASE + 0x52C)
//#define RG_GMOF3_49     (REG_ISP_RPU_BASE + 0x530)
//#define RG_GMOF3_50     (REG_ISP_RPU_BASE + 0x534)
//#define RG_GMOF3_51     (REG_ISP_RPU_BASE + 0x538)
//#define RG_GMOF3_52     (REG_ISP_RPU_BASE + 0x53C)
//#define RG_GMOF3_53     (REG_ISP_RPU_BASE + 0x540)
//#define RG_GMOF3_54     (REG_ISP_RPU_BASE + 0x544)
//#define RG_GMOF3_55     (REG_ISP_RPU_BASE + 0x548)
//#define RG_GMOF3_56     (REG_ISP_RPU_BASE + 0x54C)
//#define RG_GMOF3_57     (REG_ISP_RPU_BASE + 0x550)
//#define RG_GMOF3_58     (REG_ISP_RPU_BASE + 0x554)
//#define RG_GMOF3_59     (REG_ISP_RPU_BASE + 0x558)
//#define RG_GMOF3_60     (REG_ISP_RPU_BASE + 0x55C)
//#define RG_GMOF3_61     (REG_ISP_RPU_BASE + 0x560)
//#define RG_GMOF3_62     (REG_ISP_RPU_BASE + 0x564)
//#define RG_GMOF3_63     (REG_ISP_RPU_BASE + 0x568)
//#define RG_GMOF3_64     (REG_ISP_RPU_BASE + 0x56C)
#define RG_GMLMTPOS0    (REG_ISP_RPU_BASE + 0x570)
#define RG_GMLMTPOS1    (REG_ISP_RPU_BASE + 0x574)
#define RG_GMLMTPOS2    (REG_ISP_RPU_BASE + 0x578)
#define RG_GMLMTPOS3    (REG_ISP_RPU_BASE + 0x57C)
#define RG_GMLC         (REG_ISP_RPU_BASE + 0x580)
#define RG_GML064       (REG_ISP_RPU_BASE + 0x584)
#define RG_GML128       (REG_ISP_RPU_BASE + 0x588)
#define RG_GMLOFS0      (REG_ISP_RPU_BASE + 0x58C)
#define RG_GMLOFS1      (REG_ISP_RPU_BASE + 0x590)
#define RG_GMLOFS2      (REG_ISP_RPU_BASE + 0x594)
#define RG_GMLOFS3      (REG_ISP_RPU_BASE + 0x598)
#define RG_GMLGAIN01    (REG_ISP_RPU_BASE + 0x59C)
#define RG_GMLGAIN23    (REG_ISP_RPU_BASE + 0x5A0)
#define RG_GMLGSHT      (REG_ISP_RPU_BASE + 0x5A4)
#define RG_GMLTHRESA0   (REG_ISP_RPU_BASE + 0x5A8)
#define RG_GMLTHRESA1   (REG_ISP_RPU_BASE + 0x5AC)
#define RG_GMLTHRESA2   (REG_ISP_RPU_BASE + 0x5B0)
#define RG_GMLTHRESA3   (REG_ISP_RPU_BASE + 0x5B4)
#define RG_GMLTHRESB0   (REG_ISP_RPU_BASE + 0x5B8)
#define RG_GMLTHRESB1   (REG_ISP_RPU_BASE + 0x5BC)
#define RG_GMLTHRESB2   (REG_ISP_RPU_BASE + 0x5C0)
#define RG_GMLTHRESB3   (REG_ISP_RPU_BASE + 0x5C4)
#define RG_GMLTHRESC0   (REG_ISP_RPU_BASE + 0x5C8)
#define RG_GMLTHRESC1   (REG_ISP_RPU_BASE + 0x5CC)
#define RG_GMLTHRESC2   (REG_ISP_RPU_BASE + 0x5D0)
#define RG_GMLTHRESC3   (REG_ISP_RPU_BASE + 0x5D4)
#define RG_GMLTHRESD0   (REG_ISP_RPU_BASE + 0x5D8)
#define RG_GMLTHRESD1   (REG_ISP_RPU_BASE + 0x5DC)
#define RG_GMLTHRESD2   (REG_ISP_RPU_BASE + 0x5E0)
#define RG_GMLTHRESD3   (REG_ISP_RPU_BASE + 0x5E4)
#define RG_MMFC         (REG_ISP_RPU_BASE + 0x5E8)
#define RG_MMFVAL0      (REG_ISP_RPU_BASE + 0x5EC)
#define RG_MMFVAL1      (REG_ISP_RPU_BASE + 0x5F0)
#define RG_MMFVAL2      (REG_ISP_RPU_BASE + 0x5F4)
#define RG_MMFVAL3      (REG_ISP_RPU_BASE + 0x5F8)
#define RG_MMFVAL4      (REG_ISP_RPU_BASE + 0x5FC)
#define RG_MMFVAL5      (REG_ISP_RPU_BASE + 0x600)
#define RG_MMFVAL6      (REG_ISP_RPU_BASE + 0x604)
#define RG_MMFVAL7      (REG_ISP_RPU_BASE + 0x608)
#define CSCF00          (REG_ISP_RPU_BASE + 0x60C)
#define CSCF01          (REG_ISP_RPU_BASE + 0x610)
#define CSCF02          (REG_ISP_RPU_BASE + 0x614)
#define CSCF03          (REG_ISP_RPU_BASE + 0x618)
#define CSCF10          (REG_ISP_RPU_BASE + 0x61C)
#define CSCF11          (REG_ISP_RPU_BASE + 0x620)
#define CSCF12          (REG_ISP_RPU_BASE + 0x624)
#define CSCF13          (REG_ISP_RPU_BASE + 0x628)
#define CSCF20          (REG_ISP_RPU_BASE + 0x62C)
#define CSCF21          (REG_ISP_RPU_BASE + 0x630)
#define CSCF22          (REG_ISP_RPU_BASE + 0x634)
#define CSCF23          (REG_ISP_RPU_BASE + 0x638)
#define CSCF30          (REG_ISP_RPU_BASE + 0x63C)
#define CSCF31          (REG_ISP_RPU_BASE + 0x640)
#define CSCF32          (REG_ISP_RPU_BASE + 0x644)
#define CSCF33          (REG_ISP_RPU_BASE + 0x648)
#define CSOS0           (REG_ISP_RPU_BASE + 0x64C)
#define CSOS1           (REG_ISP_RPU_BASE + 0x650)
#define CSOS2           (REG_ISP_RPU_BASE + 0x654)
#define CSOS3           (REG_ISP_RPU_BASE + 0x658)
#define CSBC            (REG_ISP_RPU_BASE + 0x65C)
#define SAC_C           (REG_ISP_RPU_BASE + 0x660)
#define SAC_C00         (REG_ISP_RPU_BASE + 0x664)
#define SAC_C01         (REG_ISP_RPU_BASE + 0x668)
#define SAC_C10         (REG_ISP_RPU_BASE + 0x66C)
#define SAC_C20         (REG_ISP_RPU_BASE + 0x670)
#define SAC_C30         (REG_ISP_RPU_BASE + 0x674)
#define SAC_C40         (REG_ISP_RPU_BASE + 0x678)
#define SAC_C50         (REG_ISP_RPU_BASE + 0x67C)
#define C0CR00          (REG_ISP_RPU_BASE + 0x680)
#define C0CR01          (REG_ISP_RPU_BASE + 0x684)
#define C0CR02          (REG_ISP_RPU_BASE + 0x688)
#define C0CR03          (REG_ISP_RPU_BASE + 0x68C)
#define C0CR04          (REG_ISP_RPU_BASE + 0x690)
#define C0CR10          (REG_ISP_RPU_BASE + 0x694)
#define C0CR11          (REG_ISP_RPU_BASE + 0x698)
#define C0CR12          (REG_ISP_RPU_BASE + 0x69C)
#define C0CR13          (REG_ISP_RPU_BASE + 0x6A0)
#define C0CR14          (REG_ISP_RPU_BASE + 0x6A4)
#define C0CR20          (REG_ISP_RPU_BASE + 0x6A8)
#define C0CR21          (REG_ISP_RPU_BASE + 0x6AC)
#define C0CR22          (REG_ISP_RPU_BASE + 0x6B0)
#define C0CR23          (REG_ISP_RPU_BASE + 0x6B4)
#define C0CR24          (REG_ISP_RPU_BASE + 0x6B8)
#define C0CR30          (REG_ISP_RPU_BASE + 0x6BC)
#define C0CR31          (REG_ISP_RPU_BASE + 0x6C0)
#define C0CR32          (REG_ISP_RPU_BASE + 0x6C4)
#define C0CR33          (REG_ISP_RPU_BASE + 0x6C8)
#define C0CR34          (REG_ISP_RPU_BASE + 0x6CC)
#define C0CR40          (REG_ISP_RPU_BASE + 0x6D0)
#define C0CR41          (REG_ISP_RPU_BASE + 0x6D4)
#define C0CR42          (REG_ISP_RPU_BASE + 0x6D8)
#define C0CR43          (REG_ISP_RPU_BASE + 0x6DC)
#define C0CR44          (REG_ISP_RPU_BASE + 0x6E0)
#define C0KCTL0         (REG_ISP_RPU_BASE + 0x6E4)
#define C0KTH0          (REG_ISP_RPU_BASE + 0x6E8)
#define C0KCR0          (REG_ISP_RPU_BASE + 0x6EC)
#define C0KCR1          (REG_ISP_RPU_BASE + 0x6F0)
#define C0KCR2          (REG_ISP_RPU_BASE + 0x6F4)
#define C0KCR3          (REG_ISP_RPU_BASE + 0x6F8)
#define C0COR           (REG_ISP_RPU_BASE + 0x6FC)
#define SBLCOR          (REG_ISP_RPU_BASE + 0x700)
#define C1COR           (REG_ISP_RPU_BASE + 0x704)
#define C2COR           (REG_ISP_RPU_BASE + 0x708)
#define HPYOFS_L0_0     (REG_ISP_RPU_BASE + 0x70C)
#define HPYOFS_L0_1     (REG_ISP_RPU_BASE + 0x710)
#define HPYOFS_L0_2     (REG_ISP_RPU_BASE + 0x714)
#define HPYOFS_L3A_0    (REG_ISP_RPU_BASE + 0x718)
#define HPYOFS_L3A_1    (REG_ISP_RPU_BASE + 0x71C)
#define HPYOFS_L3A_2    (REG_ISP_RPU_BASE + 0x720)
#define HPYOFS_L4_0     (REG_ISP_RPU_BASE + 0x724)
#define HPYOFS_L4_1     (REG_ISP_RPU_BASE + 0x728)
#define HPYOFS_L4_2     (REG_ISP_RPU_BASE + 0x72C)
#define HPYOFS_L5_0     (REG_ISP_RPU_BASE + 0x730)
#define HPYOFS_L5_1     (REG_ISP_RPU_BASE + 0x734)
#define HPYOFS_L5_2     (REG_ISP_RPU_BASE + 0x738)
#define SAC_VAL00       (REG_ISP_RPU_BASE + 0x73C)
#define SAC_VAL01       (REG_ISP_RPU_BASE + 0x740)
#define SAC_VAL02       (REG_ISP_RPU_BASE + 0x744)
#define SAC_VAL03       (REG_ISP_RPU_BASE + 0x748)
#define SAC_VAL04       (REG_ISP_RPU_BASE + 0x74C)
#define SAC_VAL10       (REG_ISP_RPU_BASE + 0x750)
#define SAC_VAL11       (REG_ISP_RPU_BASE + 0x754)
#define SAC_VAL20       (REG_ISP_RPU_BASE + 0x758)
#define SAC_VAL21       (REG_ISP_RPU_BASE + 0x75C)
#define SAC_VAL30       (REG_ISP_RPU_BASE + 0x760)
#define SAC_VAL40       (REG_ISP_RPU_BASE + 0x764)
#define SAC_VAL50       (REG_ISP_RPU_BASE + 0x768)
#define SBL33_VAL0      (REG_ISP_RPU_BASE + 0x76C)
#define SBL33_VAL1      (REG_ISP_RPU_BASE + 0x770)
#define SBL33_VAL2      (REG_ISP_RPU_BASE + 0x774)
#define SBL33_VAL3      (REG_ISP_RPU_BASE + 0x778)
#define SBL33_VAL4      (REG_ISP_RPU_BASE + 0x77C)
#define SBL55_VAL0      (REG_ISP_RPU_BASE + 0x780)
#define SBL55_VAL1      (REG_ISP_RPU_BASE + 0x784)
#define SBL55_VAL2      (REG_ISP_RPU_BASE + 0x788)
#define SBL55_VAL3      (REG_ISP_RPU_BASE + 0x78C)
#define SBL55_VAL4      (REG_ISP_RPU_BASE + 0x790)
#define LUT_ACS         (REG_ISP_RPU_BASE + 0x794)
#define RSZ_C0          (REG_ISP_RPU_BASE + 0x798)
#define RSZ_RAT0        (REG_ISP_RPU_BASE + 0x79C)
#define RSZ_RAT1        (REG_ISP_RPU_BASE + 0x7A0)
//#define RG_RZ_CSCF00    (REG_ISP_RPU_BASE + 0x7A4)
//#define RG_RZ_CSCF01    (REG_ISP_RPU_BASE + 0x7A8)
//#define RG_RZ_CSCF02    (REG_ISP_RPU_BASE + 0x7AC)
//#define RG_RZ_CSCF03    (REG_ISP_RPU_BASE + 0x7B0)
//#define RG_RZ_CSCF10    (REG_ISP_RPU_BASE + 0x7B4)
//#define RG_RZ_CSCF11    (REG_ISP_RPU_BASE + 0x7B8)
//#define RG_RZ_CSCF12    (REG_ISP_RPU_BASE + 0x7BC)
//#define RG_RZ_CSCF13    (REG_ISP_RPU_BASE + 0x7C0)
//#define RG_RZ_CSCF20    (REG_ISP_RPU_BASE + 0x7C4)
//#define RG_RZ_CSCF21    (REG_ISP_RPU_BASE + 0x7C8)
//#define RG_RZ_CSCF22    (REG_ISP_RPU_BASE + 0x7CC)
//#define RG_RZ_CSCF23    (REG_ISP_RPU_BASE + 0x7D0)
//#define RG_RZ_CSCF30    (REG_ISP_RPU_BASE + 0x7D4)
//#define RG_RZ_CSCF31    (REG_ISP_RPU_BASE + 0x7D8)
//#define RG_RZ_CSCF32    (REG_ISP_RPU_BASE + 0x7DC)
//#define RG_RZ_CSCF33    (REG_ISP_RPU_BASE + 0x7E0)
//#define RG_RZ_CSOS0     (REG_ISP_RPU_BASE + 0x7E4)
//#define RG_RZ_CSOS1     (REG_ISP_RPU_BASE + 0x7E8)
//#define RG_RZ_CSOS2     (REG_ISP_RPU_BASE + 0x7EC)
//#define RG_RZ_CSOS3     (REG_ISP_RPU_BASE + 0x7F0)
//#define RG_RZ_CSBC              (REG_ISP_RPU_BASE + 0x7F4)
//#define RG_RZ_GMOF0_00          (REG_ISP_RPU_BASE + 0x7F8)
//#define RG_RZ_GMOF0_01          (REG_ISP_RPU_BASE + 0x7FC)
//#define RG_RZ_GMOF0_02          (REG_ISP_RPU_BASE + 0x800)
//#define RG_RZ_GMOF0_03          (REG_ISP_RPU_BASE + 0x804)
//#define RG_RZ_GMOF0_04          (REG_ISP_RPU_BASE + 0x808)
//#define RG_RZ_GMOF0_05          (REG_ISP_RPU_BASE + 0x80C)
//#define RG_RZ_GMOF0_06          (REG_ISP_RPU_BASE + 0x810)
//#define RG_RZ_GMOF0_07          (REG_ISP_RPU_BASE + 0x814)
//#define RG_RZ_GMOF0_08          (REG_ISP_RPU_BASE + 0x818)
//#define RG_RZ_GMOF0_09          (REG_ISP_RPU_BASE + 0x81C)
//#define RG_RZ_GMOF0_10          (REG_ISP_RPU_BASE + 0x820)
//#define RG_RZ_GMOF0_11          (REG_ISP_RPU_BASE + 0x824)
//#define RG_RZ_GMOF0_12          (REG_ISP_RPU_BASE + 0x828)
//#define RG_RZ_GMOF0_13          (REG_ISP_RPU_BASE + 0x82C)
//#define RG_RZ_GMOF0_14          (REG_ISP_RPU_BASE + 0x830)
//#define RG_RZ_GMOF0_15          (REG_ISP_RPU_BASE + 0x834)
//#define RG_RZ_GMOF0_16          (REG_ISP_RPU_BASE + 0x838)
//#define RG_RZ_GMOF1_00          (REG_ISP_RPU_BASE + 0x83C)
//#define RG_RZ_GMOF1_01          (REG_ISP_RPU_BASE + 0x840)
//#define RG_RZ_GMOF1_02          (REG_ISP_RPU_BASE + 0x844)
//#define RG_RZ_GMOF1_03          (REG_ISP_RPU_BASE + 0x848)
//#define RG_RZ_GMOF1_04          (REG_ISP_RPU_BASE + 0x84C)
//#define RG_RZ_GMOF1_05          (REG_ISP_RPU_BASE + 0x850)
//#define RG_RZ_GMOF1_06          (REG_ISP_RPU_BASE + 0x854)
//#define RG_RZ_GMOF1_07          (REG_ISP_RPU_BASE + 0x858)
//#define RG_RZ_GMOF1_08          (REG_ISP_RPU_BASE + 0x85C)
//#define RG_RZ_GMOF1_09          (REG_ISP_RPU_BASE + 0x860)
//#define RG_RZ_GMOF1_10          (REG_ISP_RPU_BASE + 0x864)
//#define RG_RZ_GMOF1_11          (REG_ISP_RPU_BASE + 0x868)
//#define RG_RZ_GMOF1_12          (REG_ISP_RPU_BASE + 0x86C)
//#define RG_RZ_GMOF1_13          (REG_ISP_RPU_BASE + 0x870)
//#define RG_RZ_GMOF1_14          (REG_ISP_RPU_BASE + 0x874)
//#define RG_RZ_GMOF1_15          (REG_ISP_RPU_BASE + 0x878)
//#define RG_RZ_GMOF1_16          (REG_ISP_RPU_BASE + 0x87C)
//#define RG_RZ_GMOF2_00          (REG_ISP_RPU_BASE + 0x880)
//#define RG_RZ_GMOF2_01          (REG_ISP_RPU_BASE + 0x884)
//#define RG_RZ_GMOF2_02          (REG_ISP_RPU_BASE + 0x888)
//#define RG_RZ_GMOF2_03          (REG_ISP_RPU_BASE + 0x88C)
//#define RG_RZ_GMOF2_04          (REG_ISP_RPU_BASE + 0x890)
//#define RG_RZ_GMOF2_05          (REG_ISP_RPU_BASE + 0x894)
//#define RG_RZ_GMOF2_06          (REG_ISP_RPU_BASE + 0x898)
//#define RG_RZ_GMOF2_07          (REG_ISP_RPU_BASE + 0x89C)
//#define RG_RZ_GMOF2_08          (REG_ISP_RPU_BASE + 0x8A0)
//#define RG_RZ_GMOF2_09          (REG_ISP_RPU_BASE + 0x8A4)
//#define RG_RZ_GMOF2_10          (REG_ISP_RPU_BASE + 0x8A8)
//#define RG_RZ_GMOF2_11          (REG_ISP_RPU_BASE + 0x8AC)
//#define RG_RZ_GMOF2_12          (REG_ISP_RPU_BASE + 0x8B0)
//#define RG_RZ_GMOF2_13          (REG_ISP_RPU_BASE + 0x8B4)
//#define RG_RZ_GMOF2_14          (REG_ISP_RPU_BASE + 0x8B8)
//#define RG_RZ_GMOF2_15          (REG_ISP_RPU_BASE + 0x8BC)
//#define RG_RZ_GMOF2_16          (REG_ISP_RPU_BASE + 0x8C0)
//#define RG_RZ_GMOF3_00          (REG_ISP_RPU_BASE + 0x8C4)
//#define RG_RZ_GMOF3_01          (REG_ISP_RPU_BASE + 0x8C8)
//#define RG_RZ_GMOF3_02          (REG_ISP_RPU_BASE + 0x8CC)
//#define RG_RZ_GMOF3_03          (REG_ISP_RPU_BASE + 0x8D0)
//#define RG_RZ_GMOF3_04          (REG_ISP_RPU_BASE + 0x8D4)
//#define RG_RZ_GMOF3_05          (REG_ISP_RPU_BASE + 0x8D8)
//#define RG_RZ_GMOF3_06          (REG_ISP_RPU_BASE + 0x8DC)
//#define RG_RZ_GMOF3_07          (REG_ISP_RPU_BASE + 0x8E0)
//#define RG_RZ_GMOF3_08          (REG_ISP_RPU_BASE + 0x8E4)
//#define RG_RZ_GMOF3_09          (REG_ISP_RPU_BASE + 0x8E8)
//#define RG_RZ_GMOF3_10          (REG_ISP_RPU_BASE + 0x8EC)
//#define RG_RZ_GMOF3_11          (REG_ISP_RPU_BASE + 0x8F0)
//#define RG_RZ_GMOF3_12          (REG_ISP_RPU_BASE + 0x8F4)
//#define RG_RZ_GMOF3_13          (REG_ISP_RPU_BASE + 0x8F8)
//#define RG_RZ_GMOF3_14          (REG_ISP_RPU_BASE + 0x8FC)
//#define RG_RZ_GMOF3_15          (REG_ISP_RPU_BASE + 0x900)
//#define RG_RZ_GMOF3_16          (REG_ISP_RPU_BASE + 0x904)
#define RG_RZ_VRMD              (REG_ISP_RPU_BASE + 0x908)

// ## DSC4S 060215 nobu
#define SPPLMTWB0       (REG_ISP_RPU_BASE + 0xa00)
#define SPPLMTWB1       (REG_ISP_RPU_BASE + 0xa04)
#define SPPLMTWB2       (REG_ISP_RPU_BASE + 0xa08)
#define SPPLMTWB3       (REG_ISP_RPU_BASE + 0xa0c)

// ## DSC4S 060524 nobu
#define RSZ_NRSOL0      (REG_ISP_RPU_BASE + 0xA10)
#define RSZ_NRSOL1      (REG_ISP_RPU_BASE + 0xA14)
#define RSZ_DEF0        (REG_ISP_RPU_BASE + 0xA18)
#define RSZ_DEF1        (REG_ISP_RPU_BASE + 0xA1C)
#define RSZ_NRAT0       (REG_ISP_RPU_BASE + 0xA20)
#define RSZ_NRAT1       (REG_ISP_RPU_BASE + 0xA24)
#define RSZ_NewRatio0   (REG_ISP_RPU_BASE + 0xA20)
#define RSZ_NewRatio1   (REG_ISP_RPU_BASE + 0xA24)
#define RSZ_NRZO0       (REG_ISP_RPU_BASE + 0xA28)
#define RSZ_NRZO1       (REG_ISP_RPU_BASE + 0xA2C)

// @@071015 nobu add for DSC-4H
#define SAC_C02         (REG_ISP_RPU_BASE + 0xA30)
#define SAC_VAL05       (REG_ISP_RPU_BASE + 0xA34)
#define C4CNTFHV0       (REG_ISP_RPU_BASE + 0xA38)
#define C4CNTFHV1       (REG_ISP_RPU_BASE + 0xA3C)
#define C4CNTFHV2       (REG_ISP_RPU_BASE + 0xA40)
#define C4CNTFHV3       (REG_ISP_RPU_BASE + 0xA44)
#define C4CNTFHV4       (REG_ISP_RPU_BASE + 0xA48)
#define C4CNTFDD0       (REG_ISP_RPU_BASE + 0xA4C)
#define C4CNTFDD1       (REG_ISP_RPU_BASE + 0xA50)
#define C4CNTFDD2       (REG_ISP_RPU_BASE + 0xA54)
#define C4CNTFDD3       (REG_ISP_RPU_BASE + 0xA58)
#define C4CNTFDD4       (REG_ISP_RPU_BASE + 0xA5C)
#define C4CNTFMM0       (REG_ISP_RPU_BASE + 0xA60)
#define C4CNTFMM1       (REG_ISP_RPU_BASE + 0xA64)
#define C4CNTFMM2       (REG_ISP_RPU_BASE + 0xA68)
#define C4CNTFMM3       (REG_ISP_RPU_BASE + 0xA6C)
#define C4CNTFMM4       (REG_ISP_RPU_BASE + 0xA70)

// pix2
#define ITP_V9          (REG_ISP_RPU_BASE + 0xA74)
#define ITP_V10         (REG_ISP_RPU_BASE + 0xA78)
#define C0CRA00         (REG_ISP_RPU_BASE + 0xA7C)
#define C0CRA01         (REG_ISP_RPU_BASE + 0xA80)
#define C0CRA02         (REG_ISP_RPU_BASE + 0xA84)
#define C0CRA03         (REG_ISP_RPU_BASE + 0xA88)
#define C0CRA04         (REG_ISP_RPU_BASE + 0xA8C)
#define C0CRA10         (REG_ISP_RPU_BASE + 0xA90)
#define C0CRA11         (REG_ISP_RPU_BASE + 0xA94)
#define C0CRA12         (REG_ISP_RPU_BASE + 0xA98)
#define C0CRA13         (REG_ISP_RPU_BASE + 0xA9C)
#define C0CRA14         (REG_ISP_RPU_BASE + 0xAA0)
#define C0CRA20         (REG_ISP_RPU_BASE + 0xAA4)
#define C0CRA21         (REG_ISP_RPU_BASE + 0xAA8)
#define C0CRA22         (REG_ISP_RPU_BASE + 0xAAC)
#define C0CRA23         (REG_ISP_RPU_BASE + 0xAB0)
#define C0CRA24         (REG_ISP_RPU_BASE + 0xAB4)
#define C0CRA30         (REG_ISP_RPU_BASE + 0xAB8)
#define C0CRA31         (REG_ISP_RPU_BASE + 0xABC)
#define C0CRA32         (REG_ISP_RPU_BASE + 0xAC0)
#define C0CRA33         (REG_ISP_RPU_BASE + 0xAC4)
#define C0CRA34         (REG_ISP_RPU_BASE + 0xAC8)
#define C0CRA40         (REG_ISP_RPU_BASE + 0xACC)
#define C0CRA41         (REG_ISP_RPU_BASE + 0xAD0)
#define C0CRA42         (REG_ISP_RPU_BASE + 0xAD4)
#define C0CRA43         (REG_ISP_RPU_BASE + 0xAD8)
#define C0CRA44         (REG_ISP_RPU_BASE + 0xADC)
#define C0KFHHV0        (REG_ISP_RPU_BASE + 0xAE0)
#define C0KFHHV1        (REG_ISP_RPU_BASE + 0xAE4)
#define C0KFHHV2        (REG_ISP_RPU_BASE + 0xAE8)
#define C0KFHHV3        (REG_ISP_RPU_BASE + 0xAEC)
#define C0KFHHV4        (REG_ISP_RPU_BASE + 0xAF0)
#define C0KFHHV5        (REG_ISP_RPU_BASE + 0xAF4)
#define C0KFHHV6        (REG_ISP_RPU_BASE + 0xAF8)
#define C0KFHHV7        (REG_ISP_RPU_BASE + 0xAFC)
#define C0KFHHV8        (REG_ISP_RPU_BASE + 0xB00)
#define C0KFHDD0        (REG_ISP_RPU_BASE + 0xB04)
#define C0KFHDD1        (REG_ISP_RPU_BASE + 0xB08)
#define C0KFHDD2        (REG_ISP_RPU_BASE + 0xB0C)
#define C0KFHDD3        (REG_ISP_RPU_BASE + 0xB10)
#define C0KFHDD4        (REG_ISP_RPU_BASE + 0xB14)
#define C0KFHDD5        (REG_ISP_RPU_BASE + 0xB18)
#define C0KFHDD6        (REG_ISP_RPU_BASE + 0xB1C)
#define C0KFHDD7        (REG_ISP_RPU_BASE + 0xB20)
#define C0KFHDD8        (REG_ISP_RPU_BASE + 0xB24)
#define ITP_V11         (REG_ISP_RPU_BASE + 0xB28)
#define ITP_RNR0        (REG_ISP_RPU_BASE + 0xB2C)
#define ITP_RNR1        (REG_ISP_RPU_BASE + 0xB30)
#define ITP_RNR2        (REG_ISP_RPU_BASE + 0xB34)
#define ITP_RNR3        (REG_ISP_RPU_BASE + 0xB38)
#define ITP_RNR4        (REG_ISP_RPU_BASE + 0xB3C)
#define ITP_RNR5        (REG_ISP_RPU_BASE + 0xB40)
//#define RG_RZ_CSCFB00   (REG_ISP_RPU_BASE + 0xB44)
//#define RG_RZ_CSCFB01   (REG_ISP_RPU_BASE + 0xB48)
//#define RG_RZ_CSCFB02   (REG_ISP_RPU_BASE + 0xB4C)
//#define RG_RZ_CSCFB03   (REG_ISP_RPU_BASE + 0xB50)
//#define RG_RZ_CSCFB10   (REG_ISP_RPU_BASE + 0xB54)
//#define RG_RZ_CSCFB11   (REG_ISP_RPU_BASE + 0xB58)
//#define RG_RZ_CSCFB12   (REG_ISP_RPU_BASE + 0xB5C)
//#define RG_RZ_CSCFB13   (REG_ISP_RPU_BASE + 0xB60)
//#define RG_RZ_CSCFB20   (REG_ISP_RPU_BASE + 0xB64)
//#define RG_RZ_CSCFB21   (REG_ISP_RPU_BASE + 0xB68)
//#define RG_RZ_CSCFB22   (REG_ISP_RPU_BASE + 0xB6C)
//#define RG_RZ_CSCFB23   (REG_ISP_RPU_BASE + 0xB70)
//#define RG_RZ_CSCFB30   (REG_ISP_RPU_BASE + 0xB74)
//#define RG_RZ_CSCFB31   (REG_ISP_RPU_BASE + 0xB78)
//#define RG_RZ_CSCFB32   (REG_ISP_RPU_BASE + 0xB7C)
//#define RG_RZ_CSCFB33   (REG_ISP_RPU_BASE + 0xB80)
//#define RG_RZ_CSCFC00   (REG_ISP_RPU_BASE + 0xB84)
//#define RG_RZ_CSCFC01   (REG_ISP_RPU_BASE + 0xB88)
//#define RG_RZ_CSCFC02   (REG_ISP_RPU_BASE + 0xB8C)
//#define RG_RZ_CSCFC03   (REG_ISP_RPU_BASE + 0xB90)
//#define RG_RZ_CSCFC10   (REG_ISP_RPU_BASE + 0xB94)
//#define RG_RZ_CSCFC11   (REG_ISP_RPU_BASE + 0xB98)
//#define RG_RZ_CSCFC12   (REG_ISP_RPU_BASE + 0xB9C)
//#define RG_RZ_CSCFC13   (REG_ISP_RPU_BASE + 0xBA0)
//#define RG_RZ_CSCFC20   (REG_ISP_RPU_BASE + 0xBA4)
//#define RG_RZ_CSCFC21   (REG_ISP_RPU_BASE + 0xBA8)
//#define RG_RZ_CSCFC22   (REG_ISP_RPU_BASE + 0xBAC)
//#define RG_RZ_CSCFC23   (REG_ISP_RPU_BASE + 0xBB0)
//#define RG_RZ_CSCFC30   (REG_ISP_RPU_BASE + 0xBB4)
//#define RG_RZ_CSCFC31   (REG_ISP_RPU_BASE + 0xBB8)
//#define RG_RZ_CSCFC32   (REG_ISP_RPU_BASE + 0xBBC)
//#define RG_RZ_CSCFC33   (REG_ISP_RPU_BASE + 0xBC0)
//#define RG_RZ_CSCFD00   (REG_ISP_RPU_BASE + 0xBC4)
//#define RG_RZ_CSCFD01   (REG_ISP_RPU_BASE + 0xBC8)
//#define RG_RZ_CSCFD02   (REG_ISP_RPU_BASE + 0xBCC)
//#define RG_RZ_CSCFD03   (REG_ISP_RPU_BASE + 0xBD0)
//#define RG_RZ_CSCFD10   (REG_ISP_RPU_BASE + 0xBD4)
//#define RG_RZ_CSCFD11   (REG_ISP_RPU_BASE + 0xBD8)
//#define RG_RZ_CSCFD12   (REG_ISP_RPU_BASE + 0xBDC)
//#define RG_RZ_CSCFD13   (REG_ISP_RPU_BASE + 0xBE0)
//#define RG_RZ_CSCFD20   (REG_ISP_RPU_BASE + 0xBE4)
//#define RG_RZ_CSCFD21   (REG_ISP_RPU_BASE + 0xBE8)
//#define RG_RZ_CSCFD22   (REG_ISP_RPU_BASE + 0xBEC)
//#define RG_RZ_CSCFD23   (REG_ISP_RPU_BASE + 0xBF0)
//#define RG_RZ_CSCFD30   (REG_ISP_RPU_BASE + 0xBF4)
//#define RG_RZ_CSCFD31   (REG_ISP_RPU_BASE + 0xBF8)
//#define RG_RZ_CSCFD32   (REG_ISP_RPU_BASE + 0xBFC)
//#define RG_RZ_CSCFD33   (REG_ISP_RPU_BASE + 0xC00)
#define RPU_INTCNT_MASK (REG_ISP_RPU_BASE + 0xC20)
#define RPU_INTCNT_STAT (REG_ISP_RPU_BASE + 0xC2C)
#define RNR_AREAOPT     (REG_ISP_RPU_BASE + 0xc40)
#define RNR_REPN        (REG_ISP_RPU_BASE + 0xc44)
#define RNR_MAXLIM0     (REG_ISP_RPU_BASE + 0xc48)
#define RNR_MAXLIM1     (REG_ISP_RPU_BASE + 0xc4c)
#define RNR_MAXLIM2     (REG_ISP_RPU_BASE + 0xc50)
#define RNR_MAXLIM3     (REG_ISP_RPU_BASE + 0xc54)
#define RNR_MINLIM0     (REG_ISP_RPU_BASE + 0xc58)
#define RNR_MINLIM1     (REG_ISP_RPU_BASE + 0xc5c)
#define RNR_MINLIM2     (REG_ISP_RPU_BASE + 0xc60)
#define RNR_MINLIM3     (REG_ISP_RPU_BASE + 0xc64)
#define RNR_MAXTH0      (REG_ISP_RPU_BASE + 0xc68)
#define RNR_MAXTH1      (REG_ISP_RPU_BASE + 0xc6c)
#define RNR_MAXTH2      (REG_ISP_RPU_BASE + 0xc70)
#define RNR_MAXTH3      (REG_ISP_RPU_BASE + 0xc74)
#define RNR_MINTH0      (REG_ISP_RPU_BASE + 0xc78)
#define RNR_MINTH1      (REG_ISP_RPU_BASE + 0xc7c)
#define RNR_MINTH2      (REG_ISP_RPU_BASE + 0xc80)
#define RNR_MINTH3      (REG_ISP_RPU_BASE + 0xc84)
#define RNR_REPNS       (REG_ISP_RPU_BASE + 0xc88)
#define RNR_DIFFTH0     (REG_ISP_RPU_BASE + 0xc8c)
#define RNR_DIFFTH1     (REG_ISP_RPU_BASE + 0xc90)
#define RNR_DIFFTH2     (REG_ISP_RPU_BASE + 0xc94)
#define RPU_OD0CSL      (REG_ISP_RPU_BASE + 0xc98)
#define RPU_OD1CSL      (REG_ISP_RPU_BASE + 0xc9c)
#define RPU_OD2CSL      (REG_ISP_RPU_BASE + 0xca0)
// <- dsc4hasm.vh


//---- dmaw_reg ------------------------------------------------------------
#define r_ISP_DMAW_SRST                  (REG_ISP_DMAW_BASE + 0x000)       // 'd000
#define r_ISP_DMAW_EN                    (REG_ISP_DMAW_BASE + 0x004)       // 'd001
#define r_ISP_DMAW_reserve_0x008         (REG_ISP_DMAW_BASE + 0x008)       // 'd002
#define r_ISP_DMAW_reserve_0x00c         (REG_ISP_DMAW_BASE + 0x00c)       // 'd003
#define r_ISP_DMAW_reserve_0x010         (REG_ISP_DMAW_BASE + 0x010)       // 'd004
#define r_ISP_DMAW_reserve_0x014         (REG_ISP_DMAW_BASE + 0x014)       // 'd005
#define r_ISP_DMAW_reserve_0x018         (REG_ISP_DMAW_BASE + 0x018)       // 'd006
#define r_ISP_DMAW_reserve_0x01c         (REG_ISP_DMAW_BASE + 0x01c)       // 'd007
#define r_ISP_DMAW_INT_MASK              (REG_ISP_DMAW_BASE + 0x020)       // 'd008
#define r_ISP_DMAW_INT_INV               (REG_ISP_DMAW_BASE + 0x024)       // 'd009
#define r_ISP_DMAW_INT_LVLEDGE           (REG_ISP_DMAW_BASE + 0x028)       // 'd010
#define r_ISP_DMAW_INT_STATUS            (REG_ISP_DMAW_BASE + 0x02c)       // 'd011
#define r_ISP_DMAW_INT_UNMASKED_STATUS   (REG_ISP_DMAW_BASE + 0x030)       // 'd012
#define r_ISP_DMAW_INT_RAW_STATUS        (REG_ISP_DMAW_BASE + 0x034)       // 'd013
#define r_ISP_DMAW_reserve_0x038         (REG_ISP_DMAW_BASE + 0x038)       // 'd014
#define r_ISP_DMAW_reserve_0x03c         (REG_ISP_DMAW_BASE + 0x03c)       // 'd015
#define r_ISP_DMAW_reserve_0x040         (REG_ISP_DMAW_BASE + 0x040)       // 'd016
#define r_ISP_DMAW_reserve_0x044         (REG_ISP_DMAW_BASE + 0x044)       // 'd017
#define r_ISP_DMAW_reserve_0x048         (REG_ISP_DMAW_BASE + 0x048)       // 'd018
#define r_ISP_DMAW_reserve_0x04c         (REG_ISP_DMAW_BASE + 0x04c)       // 'd019
#define r_ISP_DMAW_reserve_0x050         (REG_ISP_DMAW_BASE + 0x050)       // 'd020
#define r_ISP_DMAW_reserve_0x054         (REG_ISP_DMAW_BASE + 0x054)       // 'd021
#define r_ISP_DMAW_reserve_0x058         (REG_ISP_DMAW_BASE + 0x058)       // 'd022
#define r_ISP_DMAW_reserve_0x05c         (REG_ISP_DMAW_BASE + 0x05c)       // 'd023
#define r_ISP_DMAW_reserve_0x060         (REG_ISP_DMAW_BASE + 0x060)       // 'd024
#define r_ISP_DMAW_reserve_0x064         (REG_ISP_DMAW_BASE + 0x064)       // 'd025
#define r_ISP_DMAW_reserve_0x068         (REG_ISP_DMAW_BASE + 0x068)       // 'd026
#define r_ISP_DMAW_reserve_0x06c         (REG_ISP_DMAW_BASE + 0x06c)       // 'd027
#define r_ISP_DMAW_reserve_0x070         (REG_ISP_DMAW_BASE + 0x070)       // 'd028
#define r_ISP_DMAW_reserve_0x074         (REG_ISP_DMAW_BASE + 0x074)       // 'd029
#define r_ISP_DMAW_reserve_0x078         (REG_ISP_DMAW_BASE + 0x078)       // 'd030
#define r_ISP_DMAW_reserve_0x07c         (REG_ISP_DMAW_BASE + 0x07c)       // 'd031
#define r_ISP_DMAW_reserve_0x080         (REG_ISP_DMAW_BASE + 0x080)       // 'd032
#define r_ISP_DMAW_reserve_0x084         (REG_ISP_DMAW_BASE + 0x084)       // 'd033
#define r_ISP_DMAW_reserve_0x088         (REG_ISP_DMAW_BASE + 0x088)       // 'd034
#define r_ISP_DMAW_reserve_0x08c         (REG_ISP_DMAW_BASE + 0x08c)       // 'd035
#define r_ISP_DMAW_reserve_0x090         (REG_ISP_DMAW_BASE + 0x090)       // 'd036
#define r_ISP_DMAW_reserve_0x094         (REG_ISP_DMAW_BASE + 0x094)       // 'd037
#define r_ISP_DMAW_reserve_0x098         (REG_ISP_DMAW_BASE + 0x098)       // 'd038
#define r_ISP_DMAW_reserve_0x09c         (REG_ISP_DMAW_BASE + 0x09c)       // 'd039
#define r_ISP_DMAW_reserve_0x0a0         (REG_ISP_DMAW_BASE + 0x0a0)       // 'd040
#define r_ISP_DMAW_reserve_0x0a4         (REG_ISP_DMAW_BASE + 0x0a4)       // 'd041
#define r_ISP_DMAW_reserve_0x0a8         (REG_ISP_DMAW_BASE + 0x0a8)       // 'd042
#define r_ISP_DMAW_reserve_0x0ac         (REG_ISP_DMAW_BASE + 0x0ac)       // 'd043
#define r_ISP_DMAW_reserve_0x0b0         (REG_ISP_DMAW_BASE + 0x0b0)       // 'd044
#define r_ISP_DMAW_reserve_0x0b4         (REG_ISP_DMAW_BASE + 0x0b4)       // 'd045
#define r_ISP_DMAW_reserve_0x0b8         (REG_ISP_DMAW_BASE + 0x0b8)       // 'd046
#define r_ISP_DMAW_reserve_0x0bc         (REG_ISP_DMAW_BASE + 0x0bc)       // 'd047
#define r_ISP_DMAW_reserve_0x0c0         (REG_ISP_DMAW_BASE + 0x0c0)       // 'd048
#define r_ISP_DMAW_reserve_0x0c4         (REG_ISP_DMAW_BASE + 0x0c4)       // 'd049
#define r_ISP_DMAW_reserve_0x0c8         (REG_ISP_DMAW_BASE + 0x0c8)       // 'd050
#define r_ISP_DMAW_reserve_0x0cc         (REG_ISP_DMAW_BASE + 0x0cc)       // 'd051
#define r_ISP_DMAW_reserve_0x0d0         (REG_ISP_DMAW_BASE + 0x0d0)       // 'd052
#define r_ISP_DMAW_reserve_0x0d4         (REG_ISP_DMAW_BASE + 0x0d4)       // 'd053
#define r_ISP_DMAW_reserve_0x0d8         (REG_ISP_DMAW_BASE + 0x0d8)       // 'd054
#define r_ISP_DMAW_reserve_0x0dc         (REG_ISP_DMAW_BASE + 0x0dc)       // 'd055
#define r_ISP_DMAW_reserve_0x0e0         (REG_ISP_DMAW_BASE + 0x0e0)       // 'd056
#define r_ISP_DMAW_reserve_0x0e4         (REG_ISP_DMAW_BASE + 0x0e4)       // 'd057
#define r_ISP_DMAW_reserve_0x0e8         (REG_ISP_DMAW_BASE + 0x0e8)       // 'd058
#define r_ISP_DMAW_reserve_0x0ec         (REG_ISP_DMAW_BASE + 0x0ec)       // 'd059
#define r_ISP_DMAW_reserve_0x0f0         (REG_ISP_DMAW_BASE + 0x0f0)       // 'd060
#define r_ISP_DMAW_reserve_0x0f4         (REG_ISP_DMAW_BASE + 0x0f4)       // 'd061
#define r_ISP_DMAW_reserve_0x0f8         (REG_ISP_DMAW_BASE + 0x0f8)       // 'd062
#define r_ISP_DMAW_reserve_0x0fc         (REG_ISP_DMAW_BASE + 0x0fc)       // 'd063
#define r_ISP_DMAW_UF_MODE               (REG_ISP_DMAW_BASE + 0x100)       // 'd064
#define r_ISP_DMAW_reserve_0x104         (REG_ISP_DMAW_BASE + 0x104)       // 'd065
#define r_ISP_DMAW_reserve_0x108         (REG_ISP_DMAW_BASE + 0x108)       // 'd066
#define r_ISP_DMAW_reserve_0x10c         (REG_ISP_DMAW_BASE + 0x10c)       // 'd067
#define r_ISP_DMAW_reserve_0x110         (REG_ISP_DMAW_BASE + 0x110)       // 'd068
#define r_ISP_DMAW_reserve_0x114         (REG_ISP_DMAW_BASE + 0x114)       // 'd069
#define r_ISP_DMAW_reserve_0x118         (REG_ISP_DMAW_BASE + 0x118)       // 'd070
#define r_ISP_DMAW_reserve_0x11c         (REG_ISP_DMAW_BASE + 0x11c)       // 'd071

//---- dmar_reg ------------------------------------------------------------
#define r_ISP_DMAR_SRST                  (REG_ISP_DMAR_BASE + 0x000)       // 'd000
#define r_ISP_DMAR_EN                    (REG_ISP_DMAR_BASE + 0x004)       // 'd001
#define r_ISP_DMAR_reserve_0x008         (REG_ISP_DMAR_BASE + 0x008)       // 'd002
#define r_ISP_DMAR_reserve_0x00c         (REG_ISP_DMAR_BASE + 0x00c)       // 'd003
#define r_ISP_DMAR_reserve_0x010         (REG_ISP_DMAR_BASE + 0x010)       // 'd004
#define r_ISP_DMAR_reserve_0x014         (REG_ISP_DMAR_BASE + 0x014)       // 'd005
#define r_ISP_DMAR_reserve_0x018         (REG_ISP_DMAR_BASE + 0x018)       // 'd006
#define r_ISP_DMAR_reserve_0x01c         (REG_ISP_DMAR_BASE + 0x01c)       // 'd007
#define r_ISP_DMAR_INT_MASK              (REG_ISP_DMAR_BASE + 0x020)       // 'd008
#define r_ISP_DMAR_INT_INV               (REG_ISP_DMAR_BASE + 0x024)       // 'd009
#define r_ISP_DMAR_INT_LVLEDGE           (REG_ISP_DMAR_BASE + 0x028)       // 'd010
#define r_ISP_DMAR_INT_STATUS            (REG_ISP_DMAR_BASE + 0x02c)       // 'd011
#define r_ISP_DMAR_INT_UNMASKED_STATUS   (REG_ISP_DMAR_BASE + 0x030)       // 'd012
#define r_ISP_DMAR_INT_RAW_STATUS        (REG_ISP_DMAR_BASE + 0x034)       // 'd013
#define r_ISP_DMAR_reserve_0x038         (REG_ISP_DMAR_BASE + 0x038)       // 'd014
#define r_ISP_DMAR_reserve_0x03c         (REG_ISP_DMAR_BASE + 0x03c)       // 'd015
#define r_ISP_DMAR_reserve_0x040         (REG_ISP_DMAR_BASE + 0x040)       // 'd016
#define r_ISP_DMAR_reserve_0x044         (REG_ISP_DMAR_BASE + 0x044)       // 'd017
#define r_ISP_DMAR_reserve_0x048         (REG_ISP_DMAR_BASE + 0x048)       // 'd018
#define r_ISP_DMAR_reserve_0x04c         (REG_ISP_DMAR_BASE + 0x04c)       // 'd019
#define r_ISP_DMAR_reserve_0x050         (REG_ISP_DMAR_BASE + 0x050)       // 'd020
#define r_ISP_DMAR_reserve_0x054         (REG_ISP_DMAR_BASE + 0x054)       // 'd021
#define r_ISP_DMAR_reserve_0x058         (REG_ISP_DMAR_BASE + 0x058)       // 'd022
#define r_ISP_DMAR_reserve_0x05c         (REG_ISP_DMAR_BASE + 0x05c)       // 'd023
#define r_ISP_DMAR_reserve_0x060         (REG_ISP_DMAR_BASE + 0x060)       // 'd024
#define r_ISP_DMAR_reserve_0x064         (REG_ISP_DMAR_BASE + 0x064)       // 'd025
#define r_ISP_DMAR_reserve_0x068         (REG_ISP_DMAR_BASE + 0x068)       // 'd026
#define r_ISP_DMAR_reserve_0x06c         (REG_ISP_DMAR_BASE + 0x06c)       // 'd027
#define r_ISP_DMAR_reserve_0x070         (REG_ISP_DMAR_BASE + 0x070)       // 'd028
#define r_ISP_DMAR_reserve_0x074         (REG_ISP_DMAR_BASE + 0x074)       // 'd029
#define r_ISP_DMAR_reserve_0x078         (REG_ISP_DMAR_BASE + 0x078)       // 'd030
#define r_ISP_DMAR_reserve_0x07c         (REG_ISP_DMAR_BASE + 0x07c)       // 'd031
#define r_ISP_DMAR_reserve_0x080         (REG_ISP_DMAR_BASE + 0x080)       // 'd032
#define r_ISP_DMAR_reserve_0x084         (REG_ISP_DMAR_BASE + 0x084)       // 'd033
#define r_ISP_DMAR_reserve_0x088         (REG_ISP_DMAR_BASE + 0x088)       // 'd034
#define r_ISP_DMAR_reserve_0x08c         (REG_ISP_DMAR_BASE + 0x08c)       // 'd035
#define r_ISP_DMAR_reserve_0x090         (REG_ISP_DMAR_BASE + 0x090)       // 'd036
#define r_ISP_DMAR_reserve_0x094         (REG_ISP_DMAR_BASE + 0x094)       // 'd037
#define r_ISP_DMAR_reserve_0x098         (REG_ISP_DMAR_BASE + 0x098)       // 'd038
#define r_ISP_DMAR_reserve_0x09c         (REG_ISP_DMAR_BASE + 0x09c)       // 'd039
#define r_ISP_DMAR_reserve_0x0a0         (REG_ISP_DMAR_BASE + 0x0a0)       // 'd040
#define r_ISP_DMAR_reserve_0x0a4         (REG_ISP_DMAR_BASE + 0x0a4)       // 'd041
#define r_ISP_DMAR_reserve_0x0a8         (REG_ISP_DMAR_BASE + 0x0a8)       // 'd042
#define r_ISP_DMAR_reserve_0x0ac         (REG_ISP_DMAR_BASE + 0x0ac)       // 'd043
#define r_ISP_DMAR_reserve_0x0b0         (REG_ISP_DMAR_BASE + 0x0b0)       // 'd044
#define r_ISP_DMAR_reserve_0x0b4         (REG_ISP_DMAR_BASE + 0x0b4)       // 'd045
#define r_ISP_DMAR_reserve_0x0b8         (REG_ISP_DMAR_BASE + 0x0b8)       // 'd046
#define r_ISP_DMAR_reserve_0x0bc         (REG_ISP_DMAR_BASE + 0x0bc)       // 'd047
#define r_ISP_DMAR_reserve_0x0c0         (REG_ISP_DMAR_BASE + 0x0c0)       // 'd048
#define r_ISP_DMAR_reserve_0x0c4         (REG_ISP_DMAR_BASE + 0x0c4)       // 'd049
#define r_ISP_DMAR_reserve_0x0c8         (REG_ISP_DMAR_BASE + 0x0c8)       // 'd050
#define r_ISP_DMAR_reserve_0x0cc         (REG_ISP_DMAR_BASE + 0x0cc)       // 'd051
#define r_ISP_DMAR_reserve_0x0d0         (REG_ISP_DMAR_BASE + 0x0d0)       // 'd052
#define r_ISP_DMAR_reserve_0x0d4         (REG_ISP_DMAR_BASE + 0x0d4)       // 'd053
#define r_ISP_DMAR_reserve_0x0d8         (REG_ISP_DMAR_BASE + 0x0d8)       // 'd054
#define r_ISP_DMAR_reserve_0x0dc         (REG_ISP_DMAR_BASE + 0x0dc)       // 'd055
#define r_ISP_DMAR_reserve_0x0e0         (REG_ISP_DMAR_BASE + 0x0e0)       // 'd056
#define r_ISP_DMAR_reserve_0x0e4         (REG_ISP_DMAR_BASE + 0x0e4)       // 'd057
#define r_ISP_DMAR_reserve_0x0e8         (REG_ISP_DMAR_BASE + 0x0e8)       // 'd058
#define r_ISP_DMAR_reserve_0x0ec         (REG_ISP_DMAR_BASE + 0x0ec)       // 'd059
#define r_ISP_DMAR_reserve_0x0f0         (REG_ISP_DMAR_BASE + 0x0f0)       // 'd060
#define r_ISP_DMAR_reserve_0x0f4         (REG_ISP_DMAR_BASE + 0x0f4)       // 'd061
#define r_ISP_DMAR_reserve_0x0f8         (REG_ISP_DMAR_BASE + 0x0f8)       // 'd062
#define r_ISP_DMAR_reserve_0x0fc         (REG_ISP_DMAR_BASE + 0x0fc)       // 'd063
#define r_ISP_DMAR_UF_MODE               (REG_ISP_DMAR_BASE + 0x100)       // 'd064
#define r_ISP_DMAR_reserve_0x104         (REG_ISP_DMAR_BASE + 0x104)       // 'd065
#define r_ISP_DMAR_reserve_0x108         (REG_ISP_DMAR_BASE + 0x108)       // 'd066
#define r_ISP_DMAR_reserve_0x10c         (REG_ISP_DMAR_BASE + 0x10c)       // 'd067
#define r_ISP_DMAR_reserve_0x110         (REG_ISP_DMAR_BASE + 0x110)       // 'd068
#define r_ISP_DMAR_reserve_0x114         (REG_ISP_DMAR_BASE + 0x114)       // 'd069
#define r_ISP_DMAR_reserve_0x118         (REG_ISP_DMAR_BASE + 0x118)       // 'd070
#define r_ISP_DMAR_reserve_0x11c         (REG_ISP_DMAR_BASE + 0x11c)       // 'd071

//---------------------------------------------------------------------------
// EOF
