#ifndef _EXT_INTER_H_
#define _EXT_INTER_H_
#include <stdio.h>

extern "C" {
#include "register_top.h"
#include "LisocInit.h"
}

#define reg32(addr)                     (*(volatile uint32_t *)(uint32_t)(addr))
	
int lisr_mode=0;
int isp_cnt;

void ISP_Handler(void)
{
	// AWBレジスタ更新（割り込みの初めに必要）
	if (p_wbg_reg_ctrl != NULL) {
		p_wbg_reg_ctrl->setRegRGain();
		p_wbg_reg_ctrl->setRegBGain();
	}
	
	if (p_AXMPixcessorInt != NULL) {
		if (p_AXMPixcessorInt->creFlg) {
			// AX停止フラグ確認（0x20059500固定）
			if ((reg32(AX_FRM_ISR_STOP_ADDR) & 0x00000001) == 0x00000000) {
				p_AXMPixcessorInt->frameIsrHandler();
			}
		}
	}
	
	// LISr制御用
  #if 1
  uint32_t temp;
  uint32_t lis_mode;
  uint32_t lis_reg;

	if(lisr_mode == 0x80){
		lis_mode = reg32(LISOC_LISR_BASE + 0x18);
		lis_mode &= 0xfdff;
		reg32(LISOC_LISR_BASE + 0x18) = lis_mode;
		lisr_mode &= 0x7f;
	}else if(lisr_mode == 0x81){
		lis_mode = reg32(LISOC_LISR_BASE + 0x18);
		lis_mode |= 0x0200;
		reg32(LISOC_LISR_BASE + 0x18) = lis_mode;
		lisr_mode &= 0x7f;
	}
    lis_reg = reg32(LISOC_ISP_BASE + 0x14);
	if((lis_reg & 0xff00) == 0x8000){
		lis_mode = reg32(LISOC_LISR_BASE + 0x18);
		lis_mode &= 0xfdff;
		reg32(LISOC_LISR_BASE + 0x18) = lis_mode;
		lis_reg &= 0x0FFF;
		reg32(LISOC_ISP_BASE + 0x14) = lis_reg;
	}else if((lis_reg & 0xff00) == 0x8100){
		lis_mode = reg32(LISOC_LISR_BASE + 0x18);
		lis_mode |= 0x0200;
		reg32(LISOC_LISR_BASE + 0x18) = lis_mode;
		lis_reg &= 0x0FFF;
		reg32(LISOC_ISP_BASE + 0x14) = lis_reg;
	}


  if(isp_cnt++ <20){
    
    temp = reg32(LISOC_ISP_BASE + 0x4d18);
    //printf("%d %d,",temp >> 16 , temp & 0xFFFF);
    printf("%08X,,",temp);
    
    temp = reg32(LISOC_ISP_BASE + 0x4d1c);
    //printf("%d %d,",temp >> 16 , temp & 0xFFFF);
    printf("%08X,,",temp);

    temp = reg32(LISOC_ISP_BASE + 0x4d20);
    //printf("%d %d,",temp >> 16 , temp & 0xFFFF);
    printf("%08X,,",temp);

    temp = reg32(LISOC_ISP_BASE + 0x4d24);
    //printf("%d %d,",temp >> 16 , temp & 0xFFFF);
    printf("%08X,,",temp);

    temp =  reg32(LISOC_ISP_BASE + 0x4e58);
    //printf("%d %d,",temp >> 16 , temp & 0xFFFF);
    printf("%08X,,",temp);

    temp = reg32(LISOC_ISP_BASE + 0x4e5c);
    //printf("%d %d,",temp >> 16 , temp & 0xFFFF);
    printf("%08X,,",temp);

    temp = reg32(LISOC_ISP_BASE + 0x4e60);
    //printf("%d %d,",temp >> 16 , temp & 0xFFFF);
    printf("%08X,,",temp);

    temp = reg32(LISOC_ISP_BASE + 0x4e64);
    //printf("%d %d,",temp >> 16 , temp & 0xFFFF);
    printf("%08X\n",temp);
  }

  #else
  uint32_t temp[5][0x2000/4],i,j;
  if(isp_cnt++ < 20){
    if(isp_cnt >= 10 && isp_cnt <15){
      for(i = 0;i <= 0x1B7C/4;i++)
        temp[isp_cnt - 10][i] = reg32(LISOC_ISP_BASE + 0x4000 + i*4);
    }
    if(isp_cnt == 14){
      NVIC_DisableIRQ(ISP_IRQn);
      for(j = 0;j < 1; j++){
        for(i = 0;i <= 0x1B7C/4;i++){
          if(i % 8 == 0)
            printf("%08X: ",LISOC_ISP_BASE + 0x4000  + i*4);
          printf("%08X ",temp[j][i]);
          if(i % 8 == 7)
            printf("\n");
        }
        printf("\n\n");
      }
    }
  }
  #endif
}


#endif /* _EXT_INTER_H_ */