/*
 * @file   AXMScenarioTest.hpp
 * @brief  AXMScenarioTestヘッダ
 *
 * @n      AXフレームワークシナリオテスト
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

#ifndef AXMSCENARIOTEST_HPP_
#define AXMSCENARIOTEST_HPP_

#define AXFLOG_SCENARIO AXFLOG_INFO   ///< シナリオテストログ出力レベル

#ifdef USE_AXFTEST_COMMAND_COMPLOG
#include "AXFLog.hpp"

/*
 * @class AXMScenarioTestクラス
 * @brief シナリオテストに必要な機能を提供する
 */
class AXMScenarioTest{
  int                       mFrameIsrStartMsec;   ///< startIsr開始時間
  int                       mTestCaseNo;          ///< 最終実施テストケース番号

  static const std::string  mCaseEndStr;          ///< ケース終了識別ログ
  static const char         mErrMsg[][50];        ///< エラーメッセージ
  static const char         mTestCaseName[][50];  ///< テストケース名
  static AXMScenarioTest*   m_scnObj;             ///< AXMScenarioTestインスタンス

public:
  static const  int         mFrameIsrTestTime;    ///< startIsrテスト回数
  static const  int         mLoopbackTestTime;    ///< startLoopbackテスト回数

  // エラーコード
  enum TestErrorNo {
    E_FAILED = 0,
    E_SYSERROR,
    E_SENDFAILED,
    E_TIMSTARTFAILED,
    E_TIMSTOPFAILED,
    E_TIMEOUT,
    E_PRIORITYCHECK,
    E_ISRTIMEOVER,
    E_ISRSTOPLATE,
    E_RECVFAILED,
  };

  // テスト番号定義
  enum TestCaseNo {
    TEST_ACTORCOMM = 1, // actorComm
    TEST_PRISCHED,      // priSched
    TEST_STARTISR,      // startIsr
    TEST_STOPISR,       // stopIsr
    TEST_STARTLB,       // startLoopback
    TEST_STOPLB,        // stopLoopback
    TEST_MAX,
  };

  // テスト結果
  enum TestResult {
    RESULT_FAILED  = 0, // NG
    RESULT_SUCCESS = 1, // OK
    RESULT_SKIP    = 2, // SKIP
    RESULT_ERROR   = 3, // ERROR
  };

  /*
   * @brief インスタンス取得
   */
  static AXMScenarioTest* getInstance();

  /*
   * @brief シナリオテスト開始指定
   * @param [in] caseno   テスト番号
   */
  void setTestCase(int caseno);

  /*
   * @brief シナリオテストログ出力
   * @param [in] mlog     AXFLogインスタンス
   * @param [in] result   テスト結果
   * @param [in] errcode  エラーコード
   */
  void writeLog(AXFLog *mlog, int result, int errcode = 0);

  /*
   * @brief 経過時間取得(msec)
   */
  int getLapTime();

private:
  /*
   * @brief シナリオテストログ出力文字生成
   * @param [in] caseno   テスト番号
   * @param [in] casename テスト名
   * @param [in] time     テスト実行時間
   * @param [in] result   テスト結果
   * @param [in] errcode  エラーコード
   */
  std::string getOutputMsg(int caseno, std::string casename, int time, int result, int errcode = 0);

  /*
   * @brief 時間計測開始(msec)
   */
  void calcStartTime();

  /*
   * @brief 時間計測終了(msec)
   */
  int calcEndTime();

  AXMScenarioTest();

  ~AXMScenarioTest();
};
#endif /* USE_AXFTEST_COMMAND_COMPLOG */
#endif /* AXMSCENARIOTEST_HPP_ */


