/*
 * @file   AXMTestState.hpp
 * @brief  AXMTestクラス StateMachineオブジェクトヘッダ
 *
 * @n      サンプル実装
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

// StateMachine用状態定義
enum ModelState {
  STATE_RUNNING = 0,
  STATE_MAX
};

// StateMachine用イベント定義
enum ModelEvent {
  EVENT_AXCOMM_TEST = AXFEVENT_MODEL(1),
  EVENT_LOOPBACK_TEST = AXFEVENT_MODEL(52),
  EVENT_STARTLOOPBACK_TEST = AXFEVENT_MODEL(53),
  EVENT_STOPLOOPBACK_TEST = AXFEVENT_MODEL(54),
  EVENT_STARTLOOPBACK_ALL = AXFEVENT_MODEL(55),
  EVENT_STOPLOOPBACK_ALL = AXFEVENT_MODEL(56),
  EVENT_TIMER_TEST = AXFEVENT_MODEL(80),
  EVENT_WATCHDOG_TIMEOUT_TEST = AXFEVENT_MODEL(5),
  EVENT_SAMPLE_SCRIPT_HANDLER1 = AXFEVENT_MODEL(101),
  EVENT_SAMPLE_SCRIPT_HANDLER2 = AXFEVENT_MODEL(102),
  EVENT_SAMPLE_SCRIPT_HANDLER3 = AXFEVENT_MODEL(103),
  EVENT_SAMPLE_SCRIPT_HANDLER4 = AXFEVENT_MODEL(104),
  EVENT_SAMPLE_SCRIPT_HANDLER5 = AXFEVENT_MODEL(105),
#ifdef USE_AXFTEST_COMMAND_COMPLOG
  EVENT_SCENARIOTEST_ISP_TIMEOUT = AXFEVENT_MODEL(1000),
  EVENT_SCENARIOTEST_AX_TIMEOUT = AXFEVENT_MODEL(1001),
#endif /* USE_AXFTEST_COMMAND_COMPLOG */
};

// StateMachine用状態テーブル宣言
static const AXMTest::StateTable state_running[];

// StateMachine用メンバ関数宣言
ax::actorFuncStatus funcAxcommTest(const void *pParam, int size);
ax::actorFuncStatus funcLoopbackTest(const void *pParam, int size);
ax::actorFuncStatus funcStartLoopbackTest(const void *pParam, int size);
ax::actorFuncStatus funcStopLoopbackTest(const void *pParam, int size);
ax::actorFuncStatus funcStartLoopbackAll(const void *pParam, int size);
ax::actorFuncStatus funcStopLoopbackAll(const void *pParam, int size);
ax::actorFuncStatus funcTimerTest(const void *pParam, int size);
ax::actorFuncStatus funcWatchdogTimeoutTest(const void *pParam, int size);
#ifdef USE_AXFTEST_COMMAND
ax::actorFuncStatus funcSampleScriptHandler1(const void *pParam, int size);
ax::actorFuncStatus funcSampleScriptHandler2(const void *pParam, int size);
ax::actorFuncStatus funcSampleScriptHandler3(const void *pParam, int size);
ax::actorFuncStatus funcSampleScriptHandler4(const void *pParam, int size);
ax::actorFuncStatus funcSampleScriptHandler5(const void *pParam, int size);
#endif /* USE_AXFTEST_COMMAND */
#ifdef USE_AXFTEST_COMMAND_COMPLOG
ax::actorFuncStatus funcScenarioTestIspTimeout(const void *pParam, int size);
ax::actorFuncStatus funcScenarioTestAxTimeout(const void *pParam, int size);
#endif /* USE_AXFTEST_COMMAND_COMPLOG */
