/*!
    \file    rcc.h
    \brief   the header file of rcc

*/

#ifndef RCC_H
#define RCC_H

typedef enum RCC_PERn
{
  WDT_RCC_PERn                    = 0,
  RTC_RCC_PERn                    = 1,
  GPIO_RCC_PERn                   = 2,
  SPIS_RCC_PERn                   = 3,
  SPIM_RCC_PERn                   = 4,
  I2C2_RCC_PERn                   = 5,
  I2C1_RCC_PERn                   = 6,
  I2C0_RCC_PERn                   = 7,
  TIMER2_RCC_PERn                 = 8,
  TIMER1_RCC_PERn                 = 9,
  TIMER0_RCC_PERn                 = 10,
  UART1_RCC_PERn                  = 11,
  UART0_RCC_PERn                  = 12,
} RCC_PERn_Type;

typedef enum RCC_RSTn
{
  CACHE_RCC_RSTn                  = 0,
  UART0_RCC_RSTn                  = 1,
  UART1_RCC_RSTn                  = 2,
  TIMER0_RCC_RSTn                 = 3,
  TIMER1_RCC_RSTn                 = 4,
  TIMER2_RCC_RSTn                 = 5,
  I2C0_RCC_RSTn                   = 6,
  I2C1_RCC_RSTn                   = 7,
  I2C2_RCC_RSTn                   = 8,
  GPIOA_RCC_RSTn                  = 9,
  GPIOB_RCC_RSTn                  = 10,
  RTC_RCC_RSTn                    = 11,
  WDT_RCC_RSTn                    = 12,
  SPIM_RCC_RSTn                   = 13,
  SPIS_RCC_RSTn                   = 14,
} RCC_RSTn_Type;

typedef enum RCC_MCOSELn
{
  CPU_CLK                         = 0,
  AXI_CLK                         = 1,
  MRX_BYTE_CLK                    = 2,
  MRX_PIX_CLK                     = 3,
  VIDEO_CLK1                      = 4,
  VIDEO_CLK2                      = 5,
} RCC_MCOSELn_Type;

#define SYSRST_EN_BITOFS                17u

void rcc_PerEnable(RCC_PERn_Type RCC_PERn);
void rcc_PerDisable(RCC_PERn_Type RCC_PERn);
void rcc_RST(RCC_RSTn_Type RCC_RSTn);
void rcc_MCOSEL(RCC_MCOSELn_Type RCC_MCOSELn);
void rcc_init(void);
void rcc_SYS_RESET(void);
void rcc_switch(void);

#endif  /* RCC_H */
