/*!
    \file    syscfg.h
    \brief   the header file of syscfg

*/

#ifndef SYSCFG_H
#define SYSCFG_H

#define GPIO_AF_0                   0                /*!< alternate function selected 0 */
#define GPIO_AF_1                   1                /*!< alternate function selected 1 */

#define BIT(x)                        ((uint32_t)((uint32_t)0x01U<<(x)))

#define PA0AF                         BIT(0)
#define PA1AF                         BIT(2)
#define PA2AF                         BIT(4)
#define PA3AF                         BIT(6)
#define PA4AF                         BIT(8)
#define PA5AF                         BIT(10)
#define PA6AF                         BIT(12)
#define PA7AF                         BIT(14)
#define PA8AF                         BIT(16)
#define PA9AF                         BIT(18)
#define PA10AF                        BIT(20)
#define PA11AF                        BIT(22)
#define PA12AF                        BIT(24)
#define PA13AF                        BIT(26)
#define PA14AF                        BIT(28)
#define PA15AF                        BIT(30)

#define PB0AF                         BIT(0)
#define PB1AF                         BIT(2)
#define PB2AF                         BIT(4)
#define PB3AF                         BIT(6)
#define PB4AF                         BIT(8)
#define PB5AF                         BIT(10)
#define PB6AF                         BIT(12)
#define PB7AF                         BIT(14)
#define PB8AF                         BIT(16)
#define PB9AF                         BIT(18)
#define PB10AF                        BIT(20)
#define PB11AF                        BIT(22)
#define PB12AF                        BIT(24)
#define PB13AF                        BIT(26)
#define PB14AF                        BIT(28)
#define PB15AF                        BIT(30)

void SYSC_GPIOA_AF_SET(uint8_t alt_func_num,uint32_t pin);
void SYSC_GPIOB_AF_SET(uint8_t alt_func_num,uint32_t pin);


#endif  /* SYSCFG_H */
