/*!
    \file    timer.h
    \brief   the header file of timer

*/

#ifndef _TIMER_H_
#define _TIMER_H_


#define TIMER_FREEMODE 0x0u
#define TIMER_USERMODE 0x1u

#define TIMER_INT_INACTIVE 0x0u
#define TIMER_INT_ACTIVE 0x1u

void timer_ClearIRQ(APB_TIMERS_Register_Table_s *LISOC_TIMER);
uint32_t timer_StatusIRQ(APB_TIMERS_Register_Table_s *LISOC_TIMER);
void timer_StartTimer(APB_TIMERS_Register_Table_s *LISOC_TIMER);
void timer_StopTimer(APB_TIMERS_Register_Table_s *LISOC_TIMER);
void timer_SetMode(APB_TIMERS_Register_Table_s *LISOC_TIMER, uint32_t Mode);
void timer_Setload(APB_TIMERS_Register_Table_s *LISOC_TIMER, uint32_t value);
void CPU_TIM_Init(void);

#endif  /* _TIMER_H_ */
