/*
 * AXMAxStageConfig.cpp
 */

//  C++テスト実行時は、テスト対象外とする
#ifndef PARASOFT_CPPTEST

#include "AXConfig.hpp"
#include "AXFLog.hpp"
#include "AXFStage.hpp"
#include "AXMAxConfig.hpp"
#include "../../classes/AXMTest/AXMTest.hpp"
#include "../../classes/AXMCommon/AXMCommonSetParam.hpp"
#include "../../classes/AXMCommon/AXMCommonStruct.hpp"


#include <vector>

/*
 * axStage AXFLog出力 デフォルト設定
 */
bool AXFLog::isEnable = true;

/*
 * axStage AXFLog出力レベル デフォルト設定
 */
//AXFLOG_LEVEL AXFLog::m_level = AXFLOG_WARN;
AXFLOG_LEVEL AXFLog::m_level = AXFLOG_DEBUG;

/*
 * axStage AXFLog転送 デフォルト設定
 */
bool AXFLog::isTrans = false;

/*
 * AXFLogTask リード・ライト指定
 */
AXFStage::logRW AXFStage::isRW = AXFStage::LOG_READ;

/*
 * axStage アクタ名オブジェクト定義
 */
const std::string stageName("axStage");
const std::string axtestName("axtest");
const std::string axtestName2("axtest2");
const std::string axtestName3("axtest3");
const std::string axtestName4("axtest4");
AXFObjectName nameStage(stageName, stageName);
AXFObjectName nameAXTest(axtestName, stageName);
AXFObjectName nameAXTest2(axtestName2, stageName);
AXFObjectName nameAXTest3(axtestName3, stageName);
AXFObjectName nameAXTest4(axtestName4, stageName);

/* axStage AX Stage名取得メソッド */
static AXFObjectName& getAxStageNameObject() {
  return nameStage;
}

/* axStage AXリソース情報設定メソッド */
static bool setAxStageResourceInfo(
    std::vector<AXFStageResourceInfo>& resourceInfo) {
  // 1. Actorリソース管理情報を作成する
  AXFStageResourceInfo tmpResource;

  //    1.1. AXMTest
  tmpResource.name = nameAXTest;
  tmpResource.mailMaxCount = 15; /* Mailboxデータ最大数(用途に合して編集してください) */
  tmpResource.mailMaxSize = 256; /* Mailboxデータ最大サイズ(用途に合して編集してください) */
  tmpResource.actorPriority = AXFTask::MODEL_PRIORITY_5; /* アクタ優先度(用途に合して編集してください) */
  tmpResource.actorStackSize = (3 * 1024); /* アクタ・スタックサイズ(用途に合して編集してください) */
  tmpResource.actorWatchDogTime = 60000; /* アクタ・ウオッチドックタイム値(ms)(用途に合して編集してください) */
  resourceInfo.push_back(tmpResource);

  //    1.2. AXMTest
  tmpResource.name = nameAXTest2;
  resourceInfo.push_back(tmpResource);

  //    1.3. AXMTest
  tmpResource.name = nameAXTest3;
  resourceInfo.push_back(tmpResource);

  //    1.4. AXMTest
  tmpResource.name = nameAXTest4;
  resourceInfo.push_back(tmpResource);

  return true;
}

/* axStage AX起動情報設定メソッド */
static bool setAxStageStartInfo(std::vector<AXFStageStartInfo>& startInfo) {
  // 1. ActorインスタンスとActor起動情報を作成する
  AXFStageStartInfo tmpStart;

  //    1.1. AXMTest
  tmpStart.name = nameAXTest;
  AXMTest *axtest = new AXMTest(nameAXTest);
  tmpStart.startOrder = 1; /* 1番目に起動要求を行う */
  tmpStart.objRef = axtest;
  startInfo.push_back(tmpStart);

  //    1.2. AXMTest
  tmpStart.name = nameAXTest2;
  AXMTest *axtest2 = new AXMTest(nameAXTest2);
  tmpStart.startOrder = 2; /* 1番目に起動要求を行う */
  tmpStart.objRef = axtest2;
  startInfo.push_back(tmpStart);

  //    1.3. AXMTest
  tmpStart.name = nameAXTest3;
  AXMTest *axtest3 = new AXMTest(nameAXTest3);
  tmpStart.startOrder = 3; /* 1番目に起動要求を行う */
  tmpStart.objRef = axtest3;
  startInfo.push_back(tmpStart);

  //    1.4. AXMTest
  tmpStart.name = nameAXTest4;
  AXMTest *axtest4 = new AXMTest(nameAXTest4);
  tmpStart.startOrder = 4; /* 1番目に起動要求を行う */
  tmpStart.objRef = axtest4;
  startInfo.push_back(tmpStart);

  return true;
}

/*
 * axStage Stage間通信情報
 */
static const struct ax::stageComm_t stageComm[] = {
    {
    { ax::AXCOMMCPUID_ARM_TO_XTENSA, 256, 5}, /* CPU send */
    { ax::AXCOMMCPUID_XTENSA_TO_ARM, 256}, /* CPU receive */
    },
    {
    { ax::AXCOMMCPUID_MAX, 0, 0}, /* デリミタ */
    { ax::AXCOMMCPUID_MAX, 0}, /* デリミタ */
    },
  };

  /*
   * axStage AXShell拡張コマンド情報
   */
  static std::string sendAwbTest("sendAwb");
  static std::string sendAwbHelp("\t\t-- send ispStage.awb test");
  static AXFObjectName awbName("awb", "ispStage");
  static std::string startIsr("startIsr");
  static std::string startIsrHelp("\t-- start fake ISR timer");
  static std::string stopIsr("stopIsr");
  static std::string stopIsrHelp("\t\t-- stop fake ISR timer");
  AXFObjectName namePixessorInt("pixcsrInt", "ispStage");
  static std::string actorComm("actorComm");
  static std::string actorCommHelp("\t-- actor comm test");
  AXFObjectName nameIspAf("af", "ispStage");
  static std::string priSched("priSched");
  static std::string priSchedHelp("\t-- priority scheduling test");
  AXFObjectName nameIsp("isp", "ispStage");

  static std::string startLoopback("startLoopback");
  static std::string startLoopbackHelp("\t-- start loopback test");
  static std::string stopLoopback("stopLoopback");
  static std::string stopLoopbackHelp("\t-- stop loopback test");

  static std::string startLoopback2("startLoopback2");
  static std::string startLoopback2Help("\t-- start loopback test2");
  static std::string stopLoopback2("stopLoopback2");
  static std::string stopLoopback2Help("\t-- stop loopback test2");

  static std::string startLoopback3("startLoopback3");
  static std::string startLoopback3Help("\t-- start loopback test3");
  static std::string stopLoopback3("stopLoopback3");
  static std::string stopLoopback3Help("\t-- stop loopback test3");

  static std::string startLoopback4("startLoopback4");
  static std::string startLoopback4Help("\t-- start loopback test4");
  static std::string stopLoopback4("stopLoopback4");
  static std::string stopLoopback4Help("\t-- stop loopback test4");

  static std::string startLoopbackAll("startLoopbackAll");
  static std::string startLoopbackAllHelp("\t-- start loopback test all");
  static std::string stopLoopbackAll("stopLoopbackAll");
  static std::string stopLoopbackAllHelp("\t-- stop loopback test all");

  static std::string timerTest("timerTest");
  static std::string timerTestHelp("\t-- timer test");

  static std::string dogTimeout("dogTimeout");
    static std::string dogTimeoutHelp("\t-- Watchdog Timeout test");

#ifdef USE_AXFTEST_COMMAND_COMPLOG
  static AXFObjectName nameAXTestIsp("axtest", "ispStage");
  static std::string scnIspTout("scnIspTout");
  static std::string scnIspToutHelp("\t-- ScenarioTest Isp Timeout");
  static AXFObjectName nameAXTestAx("axtest", "axStage");
  static std::string scnAxTout("scnAxTout");
  static std::string scnAxToutHelp("\t-- ScenarioTest Ax Timeout");
#endif /*USE_AXFTEST_COMMAND_COMPLOG*/
  static std::string dummy("dummy");
  static ax::extendCommand_t extendCommandTable[] = {
    {
      sendAwbTest,
      sendAwbHelp,
      awbName,
      AXFEVENT_MODEL(1000),  ///< 拡張コマンドで送信するイベントID (AXMIspAwb::EVENT_AXCOMM_TEST)
      (void *)"ABCDEFGHIJKLMNOPQRSTUVWXYZ",
      sizeof(ST_MSG),
    },
    {
      startIsr,              ///< 拡張コマンド名
      startIsrHelp,          ///< 拡張コマンドHelp情報
      namePixessorInt,       ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(1),     ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_FAKE_ISR_START)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
     },
    {
      stopIsr,               ///< 拡張コマンド名
      stopIsrHelp,           ///< 拡張コマンドHelp情報
      namePixessorInt,       ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(2),     ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_FAKE_ISR_STOP)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
    {
      actorComm,             ///< 拡張コマンド名
      actorCommHelp,         ///< 拡張コマンドHelp情報
      nameIspAf,             ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(1002),  ///< 拡張コマンドで送信するイベントID (EVENT_AXTORCOMM_TEST)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
    {
      priSched,              ///< 拡張コマンド名
      priSchedHelp,          ///< 拡張コマンドHelp情報
      nameIsp,               ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(1000),  ///< 拡張コマンドで送信するイベントID (EVENT_PRISCHED_TEST)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
    {
      startLoopback,         ///< 拡張コマンド名
      startLoopbackHelp,     ///< 拡張コマンドHelp情報
      nameAXTest,            ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(53),    ///< 拡張コマンドで送信するイベントID (EVENT_START_LOOPBACK_TEST)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
    {
      stopLoopback,          ///< 拡張コマンド名
      stopLoopbackHelp,      ///< 拡張コマンドHelp情報
      nameAXTest,            ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(54),    ///< 拡張コマンドで送信するイベントID (EVENT_STOP_LOOPBACK_TEST)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
    {
      startLoopback2,        ///< 拡張コマンド名
      startLoopback2Help,    ///< 拡張コマンドHelp情報
      nameAXTest2,           ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(53),    ///< 拡張コマンドで送信するイベントID (EVENT_START_LOOPBACK_TEST)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
    {
      stopLoopback2,         ///< 拡張コマンド名
      stopLoopback2Help,     ///< 拡張コマンドHelp情報
      nameAXTest2,           ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(54),    ///< 拡張コマンドで送信するイベントID (EVENT_STOP_LOOPBACK_TEST)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
    {
      startLoopback3,        ///< 拡張コマンド名
      startLoopback3Help,    ///< 拡張コマンドHelp情報
      nameAXTest3,           ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(53),    ///< 拡張コマンドで送信するイベントID (EVENT_START_LOOPBACK_TEST)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
    {
      stopLoopback3,         ///< 拡張コマンド名
      stopLoopback3Help,     ///< 拡張コマンドHelp情報
      nameAXTest3,           ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(54),    ///< 拡張コマンドで送信するイベントID (EVENT_STOP_LOOPBACK_TEST)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
    {
      startLoopback4,        ///< 拡張コマンド名
      startLoopback4Help,    ///< 拡張コマンドHelp情報
      nameAXTest4,           ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(53),    ///< 拡張コマンドで送信するイベントID (EVENT_START_LOOPBACK_TEST)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
    {
      stopLoopback4,         ///< 拡張コマンド名
      stopLoopback4Help,     ///< 拡張コマンドHelp情報
      nameAXTest4,           ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(54),    ///< 拡張コマンドで送信するイベントID (EVENT_STOP_LOOPBACK_TEST)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
    {
      startLoopbackAll,      ///< 拡張コマンド名
      startLoopbackAllHelp,  ///< 拡張コマンドHelp情報
      nameAXTest,            ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(55),    ///< 拡張コマンドで送信するイベントID (EVENT_START_LOOPBACK_ALL)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
    {
      stopLoopbackAll,       ///< 拡張コマンド名
      stopLoopbackAllHelp,   ///< 拡張コマンドHelp情報
      nameAXTest,            ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(56),    ///< 拡張コマンドで送信するイベントID (EVENT_STOP_LOOPBACK_ALL)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },

    {
      timerTest,             ///< 拡張コマンド名
      timerTestHelp,         ///< 拡張コマンドHelp情報
      nameAXTest,            ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(80),    ///< 拡張コマンドで送信するイベントID (EVENT_TIMER_TEST)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },

    {
      dogTimeout,            ///< 拡張コマンド名
      dogTimeoutHelp,        ///< 拡張コマンドHelp情報
      nameAXTest,            ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(5),     ///< 拡張コマンドで送信するイベントID (EVENT_WATCHDOG_TIMEOUT_TEST)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
#ifdef USE_AXFTEST_COMMAND_COMPLOG
    {
      scnIspTout,            ///< 拡張コマンド名
      scnIspToutHelp,        ///< 拡張コマンドHelp情報
      nameAXTestIsp,         ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(1000),  ///< 拡張コマンドで送信するイベントID (EVENT_SCENARIOTEST_TIMEOUT)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
    {
      scnAxTout,             ///< 拡張コマンド名
      scnAxToutHelp,         ///< 拡張コマンドHelp情報
      nameAXTestAx,          ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(1001),  ///< 拡張コマンドで送信するイベントID (EVENT_SCENARIOTEST_TIMEOUT)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
#endif /* USE_AXFTEST_COMMAND_COMPLOG */
    { /* デリミタ */dummy, dummy, nameStage, 0, NULL, 0 } };

  static struct axScript_t scriptSuccess[] = {
        // scriptSuccess Step1
        {
            { // メッセージ情報
                1000,                      ///< 時刻 @Todo: AXFChrono形式で指定する
                ".axStage.axtest3",   ///< 対象アクタ名
                AXFEVENT_MODEL(101),  ///< 対象イベントID EVENT_SAMPLE_SCRIPT_HANDLER1
                NULL,                 ///< 対象データ
                0                          ///< 対象データサイズ
            },
            { // 実行結果　期待値
                ax::AXFACTOR_SUCCESS,            ///< ハンドラ戻り値
                AXFActor::AXFACTOR_STATE_ACTIVE, ///< LifeCycle状態値
                0,                               ///< StateMachine状態値
            }
        },
        // scriptSuccess Step2
        {
            { // メッセージ情報
                2000,                      ///< 時刻 @Todo: AXFChrono形式で指定する
                ".axStage.axtest4",   ///< 対象アクタ名
                AXFEVENT_MODEL(102),  ///< 対象イベントID EVENT_SAMPLE_SCRIPT_HANDLER2
                NULL,                 ///< 対象データ
                0                          ///< 対象データサイズ
            },
            { // 実行結果　期待値
                ax::AXFACTOR_SUCCESS,            ///< ハンドラ戻り値
                AXFActor::AXFACTOR_STATE_ACTIVE, ///< LifeCycle状態値
                0,                               ///< StateMachine状態値
            }
        },
        // scriptSuccess Step3
        {
            { // メッセージ情報
                3000,                      ///< 時刻 @Todo: AXFChrono形式で指定する
                ".axStage.axtest3",   ///< 対象アクタ名
                AXFEVENT_MODEL(103),  ///< 対象イベントID EVENT_SAMPLE_SCRIPT_HANDLER3
                NULL,                 ///< 対象データ
                0                          ///< 対象データサイズ
            },
            { // 実行結果　期待値
                ax::AXFACTOR_SUCCESS,            ///< ハンドラ戻り値
                AXFActor::AXFACTOR_STATE_ACTIVE, ///< LifeCycle状態値
                0,                               ///< StateMachine状態値
            }
        },
        // scriptSuccess Step4
        {
            { // メッセージ情報
                4000,                      ///< 時刻 @Todo: AXFChrono形式で指定する
                ".axStage.axtest2",   ///< 対象アクタ名
                AXFEVENT_MODEL(104),  ///< 対象イベントID EVENT_SAMPLE_SCRIPT_HANDLER4
                NULL,                 ///< 対象データ
                0                          ///< 対象データサイズ
            },
            { // 実行結果　期待値
                ax::AXFACTOR_SUCCESS,            ///< ハンドラ戻り値
                AXFActor::AXFACTOR_STATE_ACTIVE, ///< LifeCycle状態値
                0,                               ///< StateMachine状態値
            }
        },
        { /* デリミタ */ {0, NULL, 0, NULL, 0}, {ax::AXFACTOR_SUCCESS, AXFActor::AXFACTOR_STATE_ACTIVE, 0}}
    };

  static struct axScript_t scriptFailHandlerStatus[] = {
      // axScript1 Step1
      {
          { // メッセージ情報
              1000,                      ///< 時刻 @Todo: AXFChrono形式で指定する
              ".axStage.axtest3",   ///< 対象アクタ名
              AXFEVENT_MODEL(101),  ///< 対象イベントID EVENT_SAMPLE_SCRIPT_HANDLER1
              NULL,                 ///< 対象データ
              0                          ///< 対象データサイズ
          },
          { // 実行結果　期待値
              ax::AXFACTOR_SUCCESS,            ///< ハンドラ戻り値
              AXFActor::AXFACTOR_STATE_ACTIVE, ///< LifeCycle状態値
              0,                               ///< StateMachine状態値
          }
      },
      // axScript1 Step2
      {
          { // メッセージ情報
              2000,                      ///< 時刻 @Todo: AXFChrono形式で指定する
              ".axStage.axtest4",   ///< 対象アクタ名
              AXFEVENT_MODEL(105),  ///< 対象イベントID EVENT_SAMPLE_SCRIPT_HANDLER5
              NULL,                 ///< 対象データ
              0                          ///< 対象データサイズ
          },
          { // 実行結果　期待値
              ax::AXFACTOR_SUCCESS,            ///< ハンドラ戻り値
              AXFActor::AXFACTOR_STATE_ACTIVE, ///< LifeCycle状態値
              0,                               ///< StateMachine状態値
          }
      },
      // axScript1 Step3
      {
          { // メッセージ情報
              3000,                      ///< 時刻 @Todo: AXFChrono形式で指定する
              ".axStage.axtest3",   ///< 対象アクタ名
              AXFEVENT_MODEL(103),  ///< 対象イベントID EVENT_SAMPLE_SCRIPT_HANDLER3
              NULL,                 ///< 対象データ
              0                          ///< 対象データサイズ
          },
          { // 実行結果　期待値
              ax::AXFACTOR_SUCCESS,            ///< ハンドラ戻り値
              AXFActor::AXFACTOR_STATE_ACTIVE, ///< LifeCycle状態値
              0,                               ///< StateMachine状態値
          }
      },
      // axScript1 Step4
      {
          { // メッセージ情報
              4000,                      ///< 時刻 @Todo: AXFChrono形式で指定する
              ".axStage.axtest2",   ///< 対象アクタ名
              AXFEVENT_MODEL(104),  ///< 対象イベントID EVENT_SAMPLE_SCRIPT_HANDLER4
              NULL,                 ///< 対象データ
              0                          ///< 対象データサイズ
          },
          { // 実行結果　期待値
              ax::AXFACTOR_SUCCESS,            ///< ハンドラ戻り値
              AXFActor::AXFACTOR_STATE_ACTIVE, ///< LifeCycle状態値
              0,                               ///< StateMachine状態値
          }
      },
      { /* デリミタ */ {0, NULL, 0, NULL, 0}, {ax::AXFACTOR_SUCCESS, AXFActor::AXFACTOR_STATE_ACTIVE, 0}}
  };

  static struct axScript_t scriptFailLifeCycleStatus[] = {
        // scriptSuccess Step1
        {
            { // メッセージ情報
                1000,                      ///< 時刻 @Todo: AXFChrono形式で指定する
                ".axStage.axtest3",   ///< 対象アクタ名
                AXFEVENT_MODEL(101),  ///< 対象イベントID EVENT_SAMPLE_SCRIPT_HANDLER1
                NULL,                 ///< 対象データ
                0                          ///< 対象データサイズ
            },
            { // 実行結果　期待値
                ax::AXFACTOR_SUCCESS,            ///< ハンドラ戻り値
                AXFActor::AXFACTOR_STATE_ACTIVE, ///< LifeCycle状態値
                0,                               ///< StateMachine状態値
            }
        },
        // scriptSuccess Step2
        {
            { // メッセージ情報
                2000,                      ///< 時刻 @Todo: AXFChrono形式で指定する
                ".axStage.axtest4",   ///< 対象アクタ名
                AXFEVENT_MODEL(102),  ///< 対象イベントID EVENT_SAMPLE_SCRIPT_HANDLER2
                NULL,                 ///< 対象データ
                0                          ///< 対象データサイズ
            },
            { // 実行結果　期待値
                ax::AXFACTOR_SUCCESS,            ///< ハンドラ戻り値
                AXFActor::AXFACTOR_STATE_SUSPEND, ///< LifeCycle状態値
                0,                               ///< StateMachine状態値
            }
        },
        // scriptSuccess Step3
        {
            { // メッセージ情報
                3000,                      ///< 時刻 @Todo: AXFChrono形式で指定する
                ".axStage.axtest3",   ///< 対象アクタ名
                AXFEVENT_MODEL(103),  ///< 対象イベントID EVENT_SAMPLE_SCRIPT_HANDLER3
                NULL,                 ///< 対象データ
                0                          ///< 対象データサイズ
            },
            { // 実行結果　期待値
                ax::AXFACTOR_SUCCESS,            ///< ハンドラ戻り値
                AXFActor::AXFACTOR_STATE_ACTIVE, ///< LifeCycle状態値
                0,                               ///< StateMachine状態値
            }
        },
        // scriptSuccess Step4
        {
            { // メッセージ情報
                4000,                      ///< 時刻 @Todo: AXFChrono形式で指定する
                ".axStage.axtest2",   ///< 対象アクタ名
                AXFEVENT_MODEL(104),  ///< 対象イベントID EVENT_SAMPLE_SCRIPT_HANDLER4
                NULL,                 ///< 対象データ
                0                          ///< 対象データサイズ
            },
            { // 実行結果　期待値
                ax::AXFACTOR_SUCCESS,            ///< ハンドラ戻り値
                AXFActor::AXFACTOR_STATE_ACTIVE, ///< LifeCycle状態値
                0,                               ///< StateMachine状態値
            }
        },
        { /* デリミタ */ {0, NULL, 0, NULL, 0}, {ax::AXFACTOR_SUCCESS, AXFActor::AXFACTOR_STATE_ACTIVE, 0}}
    };

  static struct axScript_t scriptFailStateMachineStatus[] = {
        // scriptSuccess Step1
        {
            { // メッセージ情報
                1000,                      ///< 時刻 @Todo: AXFChrono形式で指定する
                ".axStage.axtest3",   ///< 対象アクタ名
                AXFEVENT_MODEL(101),  ///< 対象イベントID EVENT_SAMPLE_SCRIPT_HANDLER1
                NULL,                 ///< 対象データ
                0                          ///< 対象データサイズ
            },
            { // 実行結果　期待値
                ax::AXFACTOR_SUCCESS,            ///< ハンドラ戻り値
                AXFActor::AXFACTOR_STATE_ACTIVE, ///< LifeCycle状態値
                0,                               ///< StateMachine状態値
            }
        },
        // scriptSuccess Step2
        {
            { // メッセージ情報
                2000,                      ///< 時刻 @Todo: AXFChrono形式で指定する
                ".axStage.axtest4",   ///< 対象アクタ名
                AXFEVENT_MODEL(102),  ///< 対象イベントID EVENT_SAMPLE_SCRIPT_HANDLER2
                NULL,                 ///< 対象データ
                0                          ///< 対象データサイズ
            },
            { // 実行結果　期待値
                ax::AXFACTOR_SUCCESS,            ///< ハンドラ戻り値
                AXFActor::AXFACTOR_STATE_ACTIVE, ///< LifeCycle状態値
                1,                               ///< StateMachine状態値
            }
        },
        // scriptSuccess Step3
        {
            { // メッセージ情報
                3000,                      ///< 時刻 @Todo: AXFChrono形式で指定する
                ".axStage.axtest3",   ///< 対象アクタ名
                AXFEVENT_MODEL(103),  ///< 対象イベントID EVENT_SAMPLE_SCRIPT_HANDLER3
                NULL,                 ///< 対象データ
                0                          ///< 対象データサイズ
            },
            { // 実行結果　期待値
                ax::AXFACTOR_SUCCESS,            ///< ハンドラ戻り値
                AXFActor::AXFACTOR_STATE_ACTIVE, ///< LifeCycle状態値
                0,                               ///< StateMachine状態値
            }
        },
        // scriptSuccess Step4
        {
            { // メッセージ情報
                4000,                      ///< 時刻 @Todo: AXFChrono形式で指定する
                ".axStage.axtest2",   ///< 対象アクタ名
                AXFEVENT_MODEL(104),  ///< 対象イベントID EVENT_SAMPLE_SCRIPT_HANDLER4
                NULL,                 ///< 対象データ
                0                          ///< 対象データサイズ
            },
            { // 実行結果　期待値
                ax::AXFACTOR_SUCCESS,            ///< ハンドラ戻り値
                AXFActor::AXFACTOR_STATE_ACTIVE, ///< LifeCycle状態値
                0,                               ///< StateMachine状態値
            }
        },
        { /* デリミタ */ {0, NULL, 0, NULL, 0}, {ax::AXFACTOR_SUCCESS, AXFActor::AXFACTOR_STATE_ACTIVE, 0}}
    };

  /*
   * axStage  AXScript情報
   * @ToDo AXScript テキスト対応までの暫定定義
   */
  static struct axScript_t* scriptTable[] = {
      scriptSuccess,
      scriptFailHandlerStatus,
      scriptFailLifeCycleStatus,
      scriptFailStateMachineStatus
  };

  /*
   * axStage  AXコンフィグレーション情報
   */
  const ax::config_t AXConfig = {
      getAxStageNameObject,       ///< AxStage名取得メソッド
      setAxStageResourceInfo,     ///< AxStageリソース情報設定メソッド
      setAxStageStartInfo,        ///< AxStage起動情報設定メソッド
      stageComm,                  ///< Stage間通信情報
      extendCommandTable,         ///< AXShell拡張コマンド情報
      scriptTable                 ///< AXScript情報
  };

#endif  //  PARASOFT_CPPTEST
