#ifndef RCC_Register_Table__H
#define RCC_Register_Table__H
#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t FRAC_EN:1;
            uint32_t NVC2_S2:5;
            uint32_t NMP:2;
            uint32_t NVC1:2;
            uint32_t NVC2_S1:6;
            uint32_t MCOSEL:3;
            uint32_t APBDIV:1;
            uint32_t RESERVED1:10;
            uint32_t SYSPLLLOCK:1;
            uint32_t DATAPLLLOCK:1;
        } RCC_CR;
        uint32_t RCC_CR_W;
    };

    union {
        struct {
            uint32_t RG_NDIV:6;
            uint32_t RG_NPOST:1;
            uint32_t RESERVED2:1;
            uint32_t RG_DIV_RST:1;
            uint32_t RG_BYPASS_RSVD:1;
            uint32_t DA_OUT_EN:1;
            uint32_t DA_EN:1;
        } RCC_DATPLLCFGR;
        uint32_t RCC_DATPLLCFGR_W;
    };

    union {
        struct {
            uint32_t RG_NDIV:6;
            uint32_t RG_NPOST:1;
            uint32_t RESERVED3:1;
            uint32_t RG_DIV_RST:1;
            uint32_t RG_BYPASS:1;
            uint32_t DA_OUT_EN:1;
            uint32_t DA_EN:1;
        } RCC_SYSPLLCFGR;
        uint32_t RCC_SYSPLLCFGR_W;
    };

    union {
        struct {
            uint32_t SYSSW:1;
            uint32_t AXISW:1;
            uint32_t BYTSW:1;
            uint32_t PIXSW:1;
            uint32_t VI1SW:1;
            uint32_t VI2SW:1;
        } RCC_SYSCFGR;
        uint32_t RCC_SYSCFGR_W;
    };

    union {
        struct {
            uint32_t DDRHENR:1;
            uint32_t CACHEHENR:1;
            uint32_t ROMHENR:1;
            uint32_t SRAM0HENR:1;
            uint32_t SRAM1HENR:1;
            uint32_t SRAM2HENR:1;
            uint32_t RESERVED4:10;
            uint32_t CPURST:1;
            uint32_t SYSRST:1;
        } RCC_SYSENR;
        uint32_t RCC_SYSENR_W;
    };

    union {
        struct {
            uint32_t WDTENR:1;
            uint32_t RTCENR:1;
            uint32_t GPIOENR:1;
            uint32_t SPISLVENR:1;
            uint32_t SPIMSTENR:1;
            uint32_t I2C2ENR:1;
            uint32_t I2C1ENR:1;
            uint32_t I2C0ENR:1;
            uint32_t TIMER2ENR:1;
            uint32_t TIMER1ENR:1;
            uint32_t TIMER0ENR:1;
            uint32_t UART1ENR:1;
            uint32_t UART0ENR:1;
        } RCC_PERENR;
        uint32_t RCC_PERENR_W;
    };

    union {
        struct {
            uint32_t VIDEO2ENR:1;
            uint32_t VIDEO1ENR:1;
            uint32_t PIXENR:1;
            uint32_t BYTENR:1;
            uint32_t AXIENR:1;
            uint32_t DDR0COREENR:1;
            uint32_t DDR1COREENR:1;
            uint32_t PLL0TAXIENR:1;
            uint32_t PLL1TDPENR:1;
        } RCC_DPENR;
        uint32_t RCC_DPENR_W;
    };

    union {
        struct {
            uint32_t CACHERST:1;
            uint32_t UART0RST:1;
            uint32_t UART1RST:1;
            uint32_t TIMER0RST:1;
            uint32_t TIMER1RST:1;
            uint32_t TIMER2RST:1;
            uint32_t I2C0RST:1;
            uint32_t I2C1RST:1;
            uint32_t I2C2RST:1;
            uint32_t GPIOARST:1;
            uint32_t GPIOBRST:1;
            uint32_t RTCRST:1;
            uint32_t WDTRST:1;
            uint32_t SPIMSTRST:1;
            uint32_t SPISLVRST:1;
        } RCC_SYSBLKRSTR;
        uint32_t RCC_SYSBLKRSTR_W;
    };

    union {
        struct {
            uint32_t DDR1RST:1;
            uint32_t DDR0RST:1;
            uint32_t LISRRST:1;
            uint32_t MIPITXRST:1;
            uint32_t ISPRST:1;
            uint32_t CCHGRST:1;
            uint32_t MIPIRXRST:1;
            uint32_t DDR0CORERST:1;
            uint32_t DDR1CORERST:1;
            uint32_t DDR0PHYRST:1;
            uint32_t DDR1PHYRST:1;
            uint32_t AFRST:1;
            uint32_t TPGENRST:1;
        } RCC_DPBLKRSTR;
        uint32_t RCC_DPBLKRSTR_W;
    };

    union {
        struct {
            uint32_t CG_CTRL:7;
            uint32_t RESERVED6:1;
            uint32_t CD_CTRL:7;
            uint32_t RESERVED5:1;
            uint32_t GM_CTRL:4;
            uint32_t IBIAS_CTRL:4;
            uint32_t DCXO_MODE:1;
        } RCC_DCXO_CTRL0;
        uint32_t RCC_DCXO_CTRL0_W;
    };

    union {
        struct {
            uint32_t TC_VCTRL:5;
            uint32_t RESERVED7:3;
            uint32_t SW_VCTRL:5;
            uint32_t RESERVED11:3;
            uint32_t PKDET_EN:1;
            uint32_t OUT_BUF_EN:1;
            uint32_t TEST_DC_EN_RSVD:1;
            uint32_t TEST_DC_SEL_RSVD:2;
            uint32_t TEST_CLK_EN_RSVD:1;
            uint32_t TEST_CLK_SET_RSVD:2;
            uint32_t RSTN_SEL:1;
            uint32_t DREG_RSTN_CLKDIG:1;
            uint32_t DREG_RSTN_PDT:1;
        } RCC_DCXO_CTRL1;
        uint32_t RCC_DCXO_CTRL1_W;
    };

    union {
        struct {
            uint32_t DPLL_VCO_ICTRL:4;
            uint32_t DPLL_VCO_FC:1;
            uint32_t DPLL_LPF_C1:3;
            uint32_t DPLL_LPF_C2:3;
            uint32_t DPLL_LPF_R2:4;
            uint32_t DPLL_CP_CPI:3;
            uint32_t DPLL_LOCK_RST:1;
            uint32_t DPLL_LOCK_DLYTUNE:1;
            uint32_t DPLL_LOCK_CNTTUNE:1;
            uint32_t DPLL_PFD_MODE:2;
            uint32_t DPLL_PFD_RSTDLY:2;
        } RCC_DATPLLCTRL;
        uint32_t RCC_DATPLLCTRL_W;
    };

    union {
        struct {
            uint32_t SPLL_VCO_ICTRL:4;
            uint32_t SPLL_VCO_FC:1;
            uint32_t SPLL_LPF_C1:3;
            uint32_t SPLL_LPF_C2:3;
            uint32_t SPLL_LPF_R2:4;
            uint32_t SPLL_CP_CPI:3;
            uint32_t SPLL_LOCK_RST:1;
            uint32_t SPLL_LOCK_DLYTUNE:1;
            uint32_t SPLL_LOCK_CNTTUNE:1;
            uint32_t SPLL_PFD_MODE:2;
            uint32_t SPLL_PFD_RSTDLY:2;
            uint32_t RG_OUT_TEST_EN:1;
            uint32_t RG_CLK_TEST_EN_RSVD:1;
            uint32_t SPLL_CLK_TEST_SEL:1;
            uint32_t SPLL_CLK_TEST_DIV_SEL_RSVD:1;
            uint32_t RG_DC_TEST_EN_RSVD:1;
            uint32_t SPLL_DC_TEST_SEL:2;
        } RCC_SYSPLLCTRL;
        uint32_t RCC_SYSPLLCTRL_W;
    };

    union {
        struct {
            uint32_t CAL_EN:1;
            uint32_t CAL_ALLOW:1;
            uint32_t CAL_DIV:2;
            uint32_t EXT_CODE_EN:1;
            uint32_t EXT_CODE:7;
            uint32_t CNT_SEL:1;
            uint32_t RESERVED13:6;
            uint32_t ANA_RES:4;
        } RCC_RTC32KCTRL;
        uint32_t RCC_RTC32KCTRL_W;
    };

    union {
        struct {
            uint32_t BIAS_VBG_TRIM:3;
            uint32_t RESERVED10:1;
            uint32_t BIAS_TEMP_TRIM:3;
            uint32_t RESERVED9:1;
            uint32_t LDO11_TRIM:3;
            uint32_t RESERVED8:1;
            uint32_t LDO18_TRIM:3;
        } RCC_TRIMCTRL;
        uint32_t RCC_TRIMCTRL_W;
    };

    union {
        struct {
            uint32_t TEST_DC_EN:1;
            uint32_t TEST_DC_CH:3;
            uint32_t TEST_CLK_EN:1;
            uint32_t TEST_CLK_CH:3;
            uint32_t TEST_PLL_EXT_EN:1;
            uint32_t TEST_PLL_EXT_CH:2;
            uint32_t DCXO_TEST_DC_SEL:2;
            uint32_t DCXO_TEST_CLK_SEL:2;
            uint32_t DPLL_CLK_TEST_SEL:1;
            uint32_t DPLL_DC_TEST_SEL:2;
            uint32_t DPLL_CLK_TEST_DIVSEL:1;
            uint32_t SPLL_CLK_TEST_SEL:1;
            uint32_t SPLL_DC_TEST_SEL:2;
            uint32_t SPLL_CLK_TEST_DIVSEL:1;
            uint32_t RC32K_TEST_CLK_SEL:3;
            uint32_t DIV_TEST_SEL:4;
            uint32_t DIV_TEST_EN:1;
            uint32_t DIV_RSTN:1;
        } RCC_ANATEST;
        uint32_t RCC_ANATEST_W;
    };

    union {
        struct {
            uint32_t RC32K_CODE_FR_CAL:7;
            uint32_t RC32K_CAL_DONE:1;
            uint32_t RC32K_CAL_INPROGRESS:1;
            uint32_t RC32K_RDY:1;
        } RCC_DEBUGRO;
        uint32_t RCC_DEBUGRO_W;
    };

    uint32_t RCC_SDMCFGR_W;
} RCC_Register_Table_s;
#endif
