#ifndef SPI_Register_Table_slv__H
#define SPI_Register_Table_slv__H
#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t DFS:4;
            uint32_t FRF:2;
            uint32_t SCPH:1;
            uint32_t SCPOL:1;
            uint32_t TMOD:2;
            uint32_t SLV_OE:1;
            uint32_t SRL:1;
            uint32_t CFS:4;
            uint32_t DFS_32:5;
            uint32_t SPI_FRF:2;
            uint32_t RSVD_CTRLR0_23:1;
            uint32_t SSTE:1;
            uint32_t RSVD_CTRLR0:7;
        } CTRLR0;
        uint32_t CTRLR0_W;
    };

    union {
        struct {
            uint32_t NDF:16;
            uint32_t RSVD_CTRLR1:16;
        } CTRLR1;
        uint32_t CTRLR1_W;
    };

    union {
        struct {
            uint32_t SSI_EN:1;
            uint32_t RSVD_SSIENR:31;
        } SSIENR;
        uint32_t SSIENR_W;
    };

    union {
        struct {
            uint32_t MWMOD:1;
            uint32_t MDD:1;
            uint32_t rsvd_2:1;
            uint32_t RSVD_MWCR:29;
        } MWCR;
        uint32_t MWCR_W;
    };

    union {
        struct {
            uint32_t SER:1;
            uint32_t RSVD_SER:31;
        } SER;
        uint32_t SER_W;
    };

    uint32_t rsvd_0x14[0x4/4];

    union {
        struct {
            uint32_t TFT:3;
            uint32_t TWFTLR:29;
        } TXFTLR;
        uint32_t TXFTLR_W;
    };

    union {
        struct {
            uint32_t RFT:3;
            uint32_t RSVD_RXFTLR:29;
        } RXFTLR;
        uint32_t RXFTLR_W;
    };

    union {
        struct {
            uint32_t TXTFL:4;
            uint32_t RSVD_TXFLR:28;
        } TXFLR;
        uint32_t TXFLR_W;
    };

    union {
        struct {
            uint32_t RXTFL:4;
            uint32_t RSVD_RXFLR:28;
        } RXFLR;
        uint32_t RXFLR_W;
    };

    union {
        struct {
            uint32_t BUSY:1;
            uint32_t TFNF:1;
            uint32_t TFE:1;
            uint32_t RFNE:1;
            uint32_t RFF:1;
            uint32_t TXE:1;
            uint32_t rsvd_6:1;
            uint32_t RSVD_SR:25;
        } SR;
        uint32_t SR_W;
    };

    union {
        struct {
            uint32_t TXEIM:1;
            uint32_t TXOIM:1;
            uint32_t RXUIM:1;
            uint32_t RXOIM:1;
            uint32_t RXFIM:1;
            uint32_t MSTIM:1;
            uint32_t RSVD_IMR:26;
        } IMR;
        uint32_t IMR_W;
    };

    union {
        struct {
            uint32_t TXEIS:1;
            uint32_t TXOIS:1;
            uint32_t RXUIS:1;
            uint32_t RXOIS:1;
            uint32_t RXFIS:1;
            uint32_t rsvd_5:1;
            uint32_t RSVD_ISR:26;
        } ISR;
        uint32_t ISR_W;
    };

    union {
        struct {
            uint32_t TXEIR:1;
            uint32_t TXOIR:1;
            uint32_t RXUIR:1;
            uint32_t RXOIR:1;
            uint32_t RXFIR:1;
            uint32_t rsvd_5:1;
            uint32_t RSVD_RISR:26;
        } RISR;
        uint32_t RISR_W;
    };

    uint32_t rsvd_0x38[0x4/4];

    union {
        struct {
            uint32_t RXOICR:1;
            uint32_t RSVD_RXOICR:31;
        } RXOICR;
        uint32_t RXOICR_W;
    };

    union {
        struct {
            uint32_t RXUICR:1;
            uint32_t RSVD_RXUICR:31;
        } RXUICR;
        uint32_t RXUICR_W;
    };

    union {
        struct {
            uint32_t MSTICR:1;
            uint32_t RSVD_MSTICR:31;
        } MSTICR;
        uint32_t MSTICR_W;
    };

    union {
        struct {
            uint32_t ICR:1;
            uint32_t RSVD_ICR:31;
        } ICR;
        uint32_t ICR_W;
    };

    union {
        struct {
            uint32_t RDMAE:1;
            uint32_t TDMAE:1;
            uint32_t RSVD_DMACR:30;
        } DMACR;
        uint32_t DMACR_W;
    };

    union {
        struct {
            uint32_t DMATDL:5;
            uint32_t RSVD_DMATDLR:27;
        } DMATDLR;
        uint32_t DMATDLR_W;
    };

    union {
        struct {
            uint32_t DMARDL:3;
            uint32_t RSVD_DMARDLR:29;
        } DMARDLR;
        uint32_t DMARDLR_W;
    };

    union {
        struct {
            uint32_t IDCODE:32;
        } IDR;
        uint32_t IDR_W;
    };

    union {
        struct {
            uint32_t SSI_COMP_VERSION:32;
        } SSI_VERSION_ID;
        uint32_t SSI_VERSION_ID_W;
    };

    union {
        struct {
            uint32_t DR:16;
            uint32_t RSVD_DR:16;
        } DR0;
        uint32_t DR0_W;
    };

    uint32_t rsvd_0x64[0x8c/4];

    union {
        struct {
            uint32_t RSD:8;
            uint32_t RSVD_RX_SAMPLE_DLY:24;
        } RX_SAMPLE_DLY;
        uint32_t RX_SAMPLE_DLY_W;
    };

    union {
        struct {
            uint32_t TRANS_TYPE:2;
            uint32_t ADDR_L:4;
            uint32_t RSVD_SPI_CTRLR0_6_7:2;
            uint32_t INST_L:2;
            uint32_t RSVD_SPI_CTRLR0_10:1;
            uint32_t WAIT_CYCLES:5;
            uint32_t SPI_DDR_EN:1;
            uint32_t INST_DDR_EN:1;
            uint32_t SPI_RXDS_EN:1;
            uint32_t RSVD_SPI_CTRLR0:13;
        } SPI_CTRLR0;
        uint32_t SPI_CTRLR0_W;
    };

    union {
        struct {
            uint32_t TDE:8;
            uint32_t RSVD_TXD_DRIVE_EDGE:24;
        } TXD_DRIVE_EDGE;
        uint32_t TXD_DRIVE_EDGE_W;
    };

    union {
        struct {
            uint32_t RSVD:32;
        } RSVD;
        uint32_t RSVD_W;
    };

} SPI_Register_Table_slv_s;
#endif
