#ifndef SYSCFG_Register_Table__H
#define SYSCFG_Register_Table__H
#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t GAOEN:16;
        } GPIOA_OER;
        uint32_t GPIOA_OER_W;
    };

    union {
        struct {
            uint32_t GAPUEN:16;
        } GPIOA_PUPDR;
        uint32_t GPIOA_PUPDR_W;
    };

    union {
        struct {
            uint32_t PA0AF:2;
            uint32_t PA1AF:2;
            uint32_t PA2AF:2;
            uint32_t PA3AF:2;
            uint32_t PA4AF:2;
            uint32_t PA5AF:2;
            uint32_t PA6AF:2;
            uint32_t PA7AF:2;
            uint32_t PA8AF:2;
            uint32_t PA9AF:2;
            uint32_t PA10AF:2;
            uint32_t PA11AF:2;
            uint32_t PA12AF:2;
            uint32_t PA13AF:2;
            uint32_t PA14AF:2;
            uint32_t PA15AF:2;
        } GPIOA_AFR;
        uint32_t GPIOA_AFR_W;
    };

    union {
        struct {
            uint32_t GBOEN:16;
        } GPIOB_OER;
        uint32_t GPIOB_OER_W;
    };

    union {
        struct {
            uint32_t GBPUEN:16;
        } GPIOB_PUPDR;
        uint32_t GPIOB_PUPDR_W;
    };

    union {
        struct {
            uint32_t PB0AF:2;
            uint32_t PB1AF:2;
            uint32_t PB2AF:2;
            uint32_t PB3AF:2;
            uint32_t PB4AF:2;
            uint32_t PB5AF:2;
            uint32_t PB6AF:2;
            uint32_t PB7AF:2;
            uint32_t PB8AF:2;
            uint32_t PB9AF:2;
            uint32_t PB10AF:2;
            uint32_t PB11AF:2;
            uint32_t PB12AF:2;
            uint32_t PB13AF:2;
            uint32_t PB14AF:2;
            uint32_t PB15AF:2;
        } GPIOB_AFR;
        uint32_t GPIOB_AFR_W;
    };

    union {
        struct {
            uint32_t BOOT_STATUS:2;
        } BOOT_STATR;
        uint32_t BOOT_STATR_W;
    };

    union {
        struct {
            uint32_t XIP_EN:1;
            uint32_t QSPI_SS_IN_N:1;
            uint32_t SPIMST_SS_IN_N:1;
            uint32_t Cache_bridge_en:1;
        } SOC_CCON0;
        uint32_t SOC_CCON0_W;
    };

    union {
        struct {
            uint32_t Soc_ctrl:4;
            uint32_t mipi_rx_tx_thru:1;
            uint32_t Reserved:3;
            uint32_t tpgen_sel:4;
        } SOC_CCON1;
        uint32_t SOC_CCON1_W;
    };

    union {
        struct {
            uint32_t Csi2_state:3;
            uint32_t Reserved:5;
            uint32_t Csi2_data_id:8;
            uint32_t Csi2_ecc:8;
        } MRX_DBG0;
        uint32_t MRX_DBG0_W;
    };

    union {
        struct {
            uint32_t Csi2_wc:16;
            uint32_t Csi_line_length:16;
        } MRX_DBG1;
        uint32_t MRX_DBG1_W;
    };

    union {
        struct {
            uint32_t Csi2_pkt_count:16;
            uint32_t Csi2_err_ecc:16;
        } MRX_DBG2;
        uint32_t MRX_DBG2_W;
    };

    union {
        struct {
            uint32_t Csi2_err_cs:16;
        } MRX_DBG3;
        uint32_t MRX_DBG3_W;
    };

    union {
        struct {
            uint32_t Csi2_tx_fsm_app:4;
            uint32_t csi2_tx_fsm_link:4;
            uint32_t Csi2_tx_fsm_phyd:4;
        } MTX_DBG0;
        uint32_t MTX_DBG0_W;
    };

    union {
        struct {
            uint32_t Csi2_tx_ccp2_vci:2;
            uint32_t csi2_tx_data_id:6;
            uint32_t Csi2_tx_ck_man:1;
            uint32_t Dphy_tx_deskew_man:1;
        } MTX_DBG1;
        uint32_t MTX_DBG1_W;
    };

    union {
        struct {
            uint32_t Csi2_tx_wc:16;
            uint32_t csi2_tx_line_length:16;
        } MTX_DBG2;
        uint32_t MTX_DBG2_W;
    };

    union {
        struct {
            uint32_t Soc_debug0:16;
        } SOC_DBG0;
        uint32_t SOC_DBG0_W;
    };

    union {
        struct {
            uint32_t Soc_debug1:16;
        } SOC_DBG1;
        uint32_t SOC_DBG1_W;
    };

    union {
        struct {
            uint32_t Soc_debug2:16;
        } SOC_DBG2;
        uint32_t SOC_DBG2_W;
    };
    
    union {
        struct {
            uint32_t pre_div:16;
            uint32_t mask0:1;
            uint32_t mask1:1;
            uint32_t mask2:1;
            uint32_t mask3:1;
            uint32_t mask4:1;
            uint32_t EN:1;
        } AF_CCON0;
        uint32_t AF_CCON0_W;
    };
    
    union {
        struct {
            uint32_t mode2:1;
            uint32_t mode1:1;
            uint32_t mode0:1;
            uint32_t enable:1;
            uint32_t CW:1;
        } AF_CCON1;
        uint32_t AF_CCON1_W;
    };

    union {
        struct {
            uint32_t af_count:16;
        } AF_COUNT;
        uint32_t AF_COUNT_W;
    };
} SYSCFG_Register_Table_s;
#endif
