/*!
    \file    gpio_test.c
    \brief   the gpio test file

*/

#include "lisoc_test.h"
#include "gpio.h"
#include "gpio_test.h"

#define PA11_14_TO_PB12_15
//#define PA2_15_TO_PB0_15
#ifdef PA2_15_TO_PB0_15
int gpio_test_result[64] = {0};
int gpio_test_ng_flag = 0;
#endif

void gpio_test(void)
{
  int gpio_num =0;

#ifdef PA11_14_TO_PB12_15
  /*Test premise: Directly connect pins PB12-PB15 and PA11-PA14 */

  for(gpio_num = PA11; gpio_num <= PA14; gpio_num++)
  {
    gpioa_setPinDreict(gpio_num, GPIO_OUT);
  }

  for(gpio_num = PB12; gpio_num <= PB15; gpio_num++)
  {
    gpiob_setPinDreict(gpio_num, GPIO_IN);
  }

  //debug("gpio PB12-PB15 PA11-PA14 test start\n");

  // gpioa output the data to Low
  for(gpio_num = PA11; gpio_num <= PA14; gpio_num++)
  {
    gpioa_out(gpio_num, GPIO_LOW);
  }

  for(gpio_num = PB12; gpio_num <= PB15; gpio_num++)
  {
    if(gpiob_readInput(gpio_num) != GPIO_LOW)
    {
      debug("gpiob %d input not at LOW!\n", gpio_num);
      debug("gpio test\t\t\t\t\tNG.\n");
      return;
    }
  }

  // gpioa output the data to High
  for(gpio_num = PA11; gpio_num <= PA14; gpio_num++)
  {
    gpioa_out(gpio_num, GPIO_HIGH);
  }

  for(gpio_num = PB12; gpio_num <= PB15; gpio_num++)
  {
    if(gpiob_readInput(gpio_num) != GPIO_HIGH)
    {
      debug("gpiob %d input not at HIGH!\n", gpio_num);
      debug("gpio test\t\t\t\t\tNG.\n");
      return;
    }
  }

  for(gpio_num = PA11; gpio_num <= PA14; gpio_num++)
  {
    gpioa_setPinDreict(gpio_num, GPIO_IN);
  }

  for(gpio_num = PB12; gpio_num <= PB15; gpio_num++)
  {
    gpiob_setPinDreict(gpio_num, GPIO_OUT);
  }

  // gpioB output the data to Low
  for(gpio_num = PB12; gpio_num <= PB15; gpio_num++)
  {
    gpiob_out(gpio_num, GPIO_LOW);
  }

  for(gpio_num = PA11; gpio_num <= PA14; gpio_num++)
  {
    if(gpioa_readInput(gpio_num) != GPIO_LOW)
    {
      debug("gpioa %d input not at LOW!\n", gpio_num);
      debug("gpio test\t\t\t\t\tNG.\n");
      return;
    }
  }

  // gpioB output the data to Low
  for(gpio_num = PB12; gpio_num <= PB15; gpio_num++)
  {
    gpiob_out(gpio_num, GPIO_HIGH);
  }

  for(gpio_num = PA11; gpio_num <= PA14; gpio_num++)
  {
    if(gpioa_readInput(gpio_num) != GPIO_HIGH)
    {
      debug("gpioa %d input not at High!\n", gpio_num);
      debug("gpio test\t\t\t\t\tNG.\n");
      return;
    }
  }

  debug("gpio test\t\t\t\t\tOK.\n");
#endif

#ifdef PA2_15_TO_PB0_15
      /*Test premise: Directly connect pins PB0-PB15(Except for PB8-PB9) and PA2-PA15 */
      /*Test OK:LED3 light off */
      /*Test NG:LED3 light on */

      /*Set PA output, PB input*/
      for(gpio_num = PA2; gpio_num <= PA15; gpio_num++)
      {
        gpioa_setPinDreict(gpio_num, GPIO_OUT);
      }
      for(gpio_num = PB0; gpio_num <= PB15; gpio_num++)
      {
        gpiob_setPinDreict(gpio_num, GPIO_IN);
      }

      //debug("gpio PA2-PA15,PB0-PB15 test start\n");

      // gpioa output the data to Low
      for(gpio_num = PA2; gpio_num <= PA15; gpio_num++)
      {
        gpioa_out(gpio_num, GPIO_LOW);
      }

      for(gpio_num = PB0; gpio_num <= PB15; gpio_num++)
      {
        if(gpio_num == PB8 || gpio_num == PB9)
        {
          continue;
        }
        if(gpiob_readInput(gpio_num) != GPIO_LOW)
        {
          gpio_test_result[gpio_num] = 1;
        }
        else
        {
          gpio_test_result[gpio_num] = 0;
        }
      }

      // gpioa output the data to High
      for(gpio_num = PA2; gpio_num <= PA15; gpio_num++)
      {
        gpioa_out(gpio_num, GPIO_HIGH);
      }

      for(gpio_num = PB0; gpio_num <= PB15; gpio_num++)
      {
        if(gpio_num == PB8 || gpio_num == PB9)
        {
          continue;
        }
        if(gpiob_readInput(gpio_num) != GPIO_HIGH)
        {
          gpio_test_result[gpio_num + 16] = 1;
        }
        else
        {
          gpio_test_result[gpio_num + 16] = 0;
        }
      }

      /*Set PA input ,PB output */
      for(gpio_num = PA2; gpio_num <= PA15; gpio_num++)
      {
        gpioa_setPinDreict(gpio_num, GPIO_IN);
      }

      for(gpio_num = PB0; gpio_num <= PB15; gpio_num++)
      {
        gpiob_setPinDreict(gpio_num, GPIO_OUT);
      }

      // gpioB output the data to Low
      for(gpio_num = PB0; gpio_num <= PB15; gpio_num++)
      {
        gpiob_out(gpio_num, GPIO_LOW);
      }

      for(gpio_num = PA2; gpio_num <= PA15; gpio_num++)
      {
        if(gpioa_readInput(gpio_num) != GPIO_LOW)
        {
          gpio_test_result[gpio_num + 32] = 1;
        }
        else
        {
          gpio_test_result[gpio_num + 32] = 0;
        }
      }

      // gpioB output the data to Low
      for(gpio_num = PB0; gpio_num <= PB15; gpio_num++)
      {
        gpiob_out(gpio_num, GPIO_HIGH);
      }

      for(gpio_num = PA2; gpio_num <= PA15; gpio_num++)
      {
        if(gpioa_readInput(gpio_num) != GPIO_HIGH)
        {
          gpio_test_result[gpio_num + 48] = 1;
        }
        else
        {
          gpio_test_result[gpio_num + 48] = 0;
        }
      }

      for(gpio_num = 0; gpio_num < 64; gpio_num++)
      {
        if(gpio_test_result[gpio_num] == 1)
        {
          gpio_test_ng_flag = 1;
          break;
        }
      }

      if(gpio_test_ng_flag == 0)
      {
        /* LED3 light off */
        gpiob_out(PB7, GPIO_HIGH);
      }
      else
      {
        /* LED3 light on */
        gpiob_out(PB7, GPIO_LOW);
      }

#endif

}

