/**
 * @file   AXCChronoFreeRTOS.hpp
 * @brief  AXCChronoFreeRTOSクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXCCHRONOFREERTOS_HPP_
#define AXCCHRONOFREERTOS_HPP_

#include "AXCChrono.hpp"

/**
 * @class AXCChronoFreeRTOS
 * @brief AXFChrono に対し、時刻設定、時刻取得、時刻形式変換機能を提供する（現状は空のコンストラクタ、デストラクタのみ）
 *
 * @n     [注意]AXM層は本クラスは直接使用せず、AXFChrono を使用し、OS依存しないようにする
 */
class AXCChronoFreeRTOS : public AXCChrono {
 public:
  /**
   * @brief AXCChronoFreeRTOSコンストラクタ
   */
  AXCChronoFreeRTOS();

  /**
   * @brief AXCChronoFreeRTOSデストラクタ
   */
  virtual ~AXCChronoFreeRTOS();

};

#endif /* AXCCHRONOFREERTOS_HPP_ */
