/**
 * @file   AXCConditionVariable.hpp
 * @brief  AXCConditionVariableクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXCCONDITIONVARIABLE_HPP_
#define AXCCONDITIONVARIABLE_HPP_

/**
 * @class AXCConditionVariable
 * @brief AXC層の ConditionVariableクラス に対し、抽象クラスを提供する
 *
 */
class AXCConditionVariable {
 public:
  /** @enum  condStatus
   *  @brief 条件変数実行完了状態
   */
  enum condStatus {
    COND_SUCCESS = 0,  ///< 正常終了
    COND_ERROR,        ///< 異常終了
  };

  /**
   * @brief AXCConditionVariableコンストラクタ
   */
  AXCConditionVariable();

  /**
   * @brief AXCConditionVariableデストラクタ
   */
  virtual ~AXCConditionVariable();

  /**
   * @brief 条件変数の初期化
   * @return 条件変数初期化状況
   * - COND_SUCCESS 正常終了
   * - COND_ERROR 異常終了
   */
  virtual condStatus init() = 0;

  /**
   * @brief 条件変数によるシグナル発行
   * @return シグナル発行状況
   * - COND_SUCCESS 正常終了
   * - COND_ERROR 異常終了
   */
  virtual condStatus signal() = 0;

  /**
   * @brief 条件変数によるウエイト
   * @return ウエイト状況
   * - COND_SUCCESS 正常終了
   * - COND_ERROR 異常終了
   */
  virtual condStatus wait() = 0;
};

#endif /* AXCCONDITIONVARIABLE_HPP_ */
