/*
 * AXCMainFreeRTOS.cpp
 */
#include "FreeRTOS.h"
#include "task.h"
#include "AX.hpp"
#include <iostream>
#ifdef AX_MAIN
#include "LisocInit.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef AX_MAIN
int main() {
	BaseType_t xRet;
	
	xRet = lisocInit();
	if (xRet != pdPASS) {
		return -1;
	}
#else
int axmain() {
#endif
  std::cout << "[main] start\n" << std::endl;

  if (false == AX::create()) {
    std::cout << "fail create AX;\n" << std::endl;
    return -1;
  }

  if (false == AX::getInstance()->init()) {
    std::cout << "fail init AX;\n" << std::endl;
    return -2;
  }

	vTaskStartScheduler();
	
  if (false == AX::getInstance()->waitQuit()) {
    std::cout << "fail waitQuit AX;\n" << std::endl;
    return -3;
  }

  if (false == AX::destroy()) {
    std::cout << "fail destroy AX;\n" << std::endl;
    return -4;
  }

  std::cout << "\n[main] exit\n" << std::endl;

  return 0;
}
#ifdef __cplusplus
}
#endif
