/**
 * @file   AXCTimerTaskFreeRTOS.hpp
 * @brief  AXCTimerTaskFreeRTOSクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXCTIMERTASKFREERTOS_HPP_
#define AXCTIMERTASKFREERTOS_HPP_

#include "FreeRTOS.h"
#include "event_groups.h"

#include <list>

#include "AXCTimerTask.hpp"

/**
 * @class AXCTimerTaskFreeRTOS
 * @brief タイマ・イベント通知機能を提供する
 */
class AXCTimerTaskFreeRTOS : public AXCTimerTask {
	EventGroupHandle_t m_flgid;		///< condition variable event group
  std::list<AXCTimerUnit*> m_waitList;

 public:

  AXCTimerTaskFreeRTOS();
  virtual ~AXCTimerTaskFreeRTOS();

  /**
   * @brief init
   * @n     タイマタスクを初期化する
   * @n
   * @return 設定可否
   */
  virtual int init();

  /**
   * @brief initWait
   * @n     タイマタスク待機用の初期化処理
   */
  virtual void initWait();

  /**
   * @brief initWaitTimer
   * @n     タイマタスク待機用の各タイマについての初期化処理
   * @n
   * @param[in]  timer    タイマ
   */
  virtual void initWaitTimer(AXCTimerUnit* timer);

  /**
   * @brief wait
   * @n     タイマの満了を待機する
   * @n
   * @return 起床要因の種別または負の値のエラーコード
   */
  virtual int wait();

  /**
   * @brief isExpired
   * @n     指定タイマの満了判定
   * @n
   * @param[in]  timer    タイマ
   * @n
   * @return 指定タイマが満了したか否か
   */
  virtual bool isExpired(AXCTimerUnit* timer);

  /**
   * @brief wakeUp
   * @n     強制的にタイマタスクを起床させる
   * @n
   * @param[in]  v    起床要因の種別
   * @n
   * @return 設定可否
   */
  virtual int wakeup(TimerTaskWakeup v);

  /**
   * @brief isInWaitList
   * @n     指定タイマが待機リストに登録されてるか判定し返す
   * @n     待機リストは、initWait() でクリアされ
   * @n     initWaitTimer(timer) で timerが登録される
   * @n
   * @param[in]  timer    タイマ
   * @n
   * @return 指定タイマが待機リスト(m_waitList)中にあるか
   */
  // AXCTimerUnitFreeRTOS::expire() からのみ呼び出される
  bool isInWaitList(AXCTimerUnit* timer);
};

#endif /* AXCTIMERTASKFREERTOS_HPP_ */
