/**
 * @file   AXConfig.hpp
 * @brief  AXConfigクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXCONFIG_HPP_
#define AXCONFIG_HPP_

#include "../../project/refkit/AXMIspConfig.hpp"
#include "AXFEvent.hpp"
#include "AXFObjectName.hpp"
#include "AXFStage.hpp"
#include "AXScript.hpp"
#include <vector>

// stageComm_t 配列のインデックスのデフォルト値
// (現在Stage間通信の接続は1つのみ)
#define AXCONFIG_STAGE_DEFAULT		0

// フルアクタ名最大サイズ
// @ToDo: ネットワーク対応時に再検討
#define AXCONFIG_FULLACTORNAME_MAXSIZE 32

namespace ax {
/** @enum  axcommCpuId_e
 *  @brief CPU間通信ID
 */
enum axcommId_e {
  AXCOMMCPUID_ARM_TO_XTENSA = 0,    ///< ARM -> Xtensa		// baba 名前は変わる認識
  AXCOMMCPUID_XTENSA_TO_ARM,        ///< Xtensa -> ARM		// baba 名前は変わる認識
  AXCOMMCPUID_MAX,                  ///< デリミタ
};

/**
 * @struct stageCommSend_t
 * @brief Stage間通信送信情報定義構造体
 */
struct stageCommSend_t {
  axcommId_e id;
  int maxBufSize;
  int maxBufCount;
};

/**
 * @struct stageCommReceive_t
 * @brief Stage間通信受信情報定義構造体
 */
struct stageCommReceive_t {
  axcommId_e id;
  int maxBufSize;
};

/**
 * @struct stageComm_t
 * @brief Stage間通信情報定義構造体
 */
struct stageComm_t {
  stageCommSend_t send;
  stageCommReceive_t receive;
};

/**
 * @struct extendCommand_t
 * @brief AXShell拡張コマンド定義構造体
 */
struct extendCommand_t {
  std::string command;  ///< 拡張コマンド名
  std::string help;     ///< 拡張コマンドHelp情報
  AXFObjectName name;   ///< 拡張コマンドで送信する宛先
  AXFEvent_t eventId;   ///< 拡張コマンドで送信するイベントID
  void* pParam;         ///< 拡張コマンドで送信するデータ
  int size;             ///< 拡張コマンドで送信するデータサイズ
};

/**
 * @struct config_t
 * @brief AXコンフィグレーション定義構造体
 */
struct config_t {
  AXFObjectName& (*getStageNameObject)();  ///< Stage名取得メソッド
  bool (*setResourceInfo)(std::vector<AXFStageResourceInfo>& resourceInfo);  ///< リソース情報設定メソッド
  bool (*setStartInfo)(std::vector<AXFStageStartInfo>& startInfo);  ///< アクタ起動情報設定メソッド
  const struct stageComm_t* stageComm;  ///< Stage間通信情報
  struct extendCommand_t* extendCommandTable;  ///< AXShell拡張コマンド情報（省略時はNULLを指定する）
  struct axScript_t** scriptTable; ///< AXScript情報
};
}

extern const ax::config_t AXConfig;

#endif /* AXCONFIG_HPP_ */
