/*
 * @file   AXFConditionVariableInternal.hpp
 * @brief  AXFConditionVariableInternalクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXFCONDITIONVARIABLEINTERNAL_HPP_
#define AXFCONDITIONVARIABLEINTERNAL_HPP_

#include "AXCConditionVariableFreeRTOS.hpp"

/**
 * @class AXFConditionVariableInternal
 * @brief 条件変数を使用して、スレッド実行の停止と再開を行う機能を提供する
 *
 * @n     使用方法:
 * @n     1. ConditionVariableインスタンスを生成する。
 * @n       int stat;
 * @n       AXFConditionVariableInternal* cond = new (std::nothrow) AXFConditionVariableInternal();
 * @n     2. ConditionVariableインスタンスの初期化を行う。
 * @n        本メソッドは、複数回呼び出してはならない。
 * @n        初期化に失敗した場合、呼び出し元の異常処理を行う。
 * @n       stat = cond.init();
 * @n       if (AXFConditionVariableInternal::COND_SUCCESS != stat) {
 * @n         ...
 * @n     3. 該当するスレッドの実行を停止し、プロセッサを手放す。
 * @n        waitに失敗した場合、呼び出し元の異常処理を行う。
 * @n       stat = cond.wait();
 * @n       if (AXFConditionVariableInternal::COND_SUCCESS != stat) {
 * @n         ...
 * @n     4. 該当するスレッドの実行を再開する。
 * @n        signalに失敗した場合、呼び出し元の異常処理を行う。
 * @n       stat = cond.signal();
 * @n       if (AXFConditionVariableInternal::COND_SUCCESS != stat) {
 * @n         ...
 * @n     5. ConditionVariableインスタンスを破棄する。
 * @n       delelte cond;
 * @n
 * @n     AXFConditionVariableInternalクラスの 詳細は AXCConditionVariableクラス の説明に記述する。
 */
class AXFConditionVariableInternal :
	public AXCConditionVariableFreeRTOS
{
};

#endif /* AXFCONDITIONVARIABLEINTERNAL_HPP_ */
