/**
 * @file   AXFEvent.hpp
 * @brief  AXFEventクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXFEVENT_HPP_
#define AXFEVENT_HPP_
#include "AXCType.hpp"

#ifdef __cplusplus
extern "C" {
#endif

typedef UINT32_t AXFEvent_t;                                                       ///< AXFイベント型
#define AXFEVENT_CATEGORY_SHIFT      (AXFEvent_t)(24)
#define AXFEVENT_CATEGORY_MASK       (AXFEvent_t)(0xffU << AXFEVENT_CATEGORY_SHIFT) ///< AXFイベントカテゴリ判定用マスク

/** @brief AXFイベントカテゴリ一覧
 */
#define AXFEVENT_CATEGORY_LIFECYCLE  (AXFEvent_t)(   1 << AXFEVENT_CATEGORY_SHIFT) ///< ライフサイクル・カテゴリ
#define AXFEVENT_CATEGORY_DEVICE     (AXFEvent_t)(   2 << AXFEVENT_CATEGORY_SHIFT) ///< デバイス・カテゴリ
#define AXFEVENT_CATEGORY_MODEL      (AXFEvent_t)(   3 << AXFEVENT_CATEGORY_SHIFT) ///< Modelカテゴリ
#define AXFEVENT_CATEGORY_SYS        (AXFEvent_t)(   4 << AXFEVENT_CATEGORY_SHIFT) ///< システム・カテゴリ

/** @brief AXFイベント値定義マクロ
 */
#define AXFEVENT_LIFECYCLE(x)        (AXFEvent_t)(AXFEVENT_CATEGORY_LIFECYCLE | (x)) ///< ライフサイクルイベント定義マクロ
#define AXFEVENT_DEVICE(x)           (AXFEvent_t)(AXFEVENT_CATEGORY_DEVICE    | (x)) ///< デバイスイベント定義マクロ
#define AXFEVENT_MODEL(x)            (AXFEvent_t)(AXFEVENT_CATEGORY_MODEL     | (x)) ///< Modelイベント定義マクロ
#define AXFEVENT_SYS(x)              (AXFEvent_t)(AXFEVENT_CATEGORY_SYS       | (x)) ///< システム・イベント定義マクロ

/** @brief AXFイベント値定義
 */
#define AXFEVENT_LIFECYCLE_START     AXFEVENT_LIFECYCLE(1) ///< Startイベント値
#define AXFEVENT_LIFECYCLE_STOP      AXFEVENT_LIFECYCLE(2) ///< Stopイベント値
#define AXFEVENT_LIFECYCLE_PAUSE     AXFEVENT_LIFECYCLE(3) ///< Pauseイベント値
#define AXFEVENT_LIFECYCLE_RESUME    AXFEVENT_LIFECYCLE(4) ///< resumeイベント値
#define AXFEVENT_LIFECYCLE_RESTART   AXFEVENT_LIFECYCLE(5) ///< restartイベント値
#define AXFEVENT_LIFECYCLE_EXIT      AXFEVENT_LIFECYCLE(6) ///< exitイベント値

#define AXFEVENT_DEVICE_FRAME_ISR    AXFEVENT_DEVICE(1)    ///< フレーム完了割り込みイベント値

#define AXFEVENT_SYS_DOG_REQUEST     AXFEVENT_SYS(1)       ///< Watchdog 要求イベント値
#define AXFEVENT_SYS_DOG_ACK         AXFEVENT_SYS(2)       ///< Watchdog 応答ベント値
#define AXFEVENT_SYS_TIMER_SIMU      AXFEVENT_SYS(10)      ///< TIMERシミュレーションイベント値

#ifdef __cplusplus
}
#endif

#endif /* AXFEVENT_HPP_ */
