/*
 * AXFLuaInternal.hpp
 */

#ifndef AXFLuaInternal_HPP_
#define AXFLuaInternal_HPP_
#ifdef USE_LUA

#include "AXFActor.hpp"
#include "AXFLog.hpp"

#include <AXCType.hpp>
#include <lua.hpp>
#include <string>

/**
 * @class AXFLuaInternal
 * @brief Lua 機能を提供する
 * @n
 */
class AXFLuaInternal {
  AXFActor* m_actor;
  AXFLog* m_log;
  lua_State *m_luaState;

 public:
  /** @enum  luaStatus
   *  @brief Lua実行完了状態
   */
  enum luaStatus {
    LUA_STATUS_NOINIT = -100,
    LUA_STATUS_BUSY,
    LUA_STATUS_FAILNEW,
    LUA_STATUS_OK = LUA_OK,
    LUA_STATUS_YIELD = LUA_YIELD,
    LUA_STATUS_ERRRUN = LUA_ERRRUN,
    LUA_STATUS_ERRSYNTAX = LUA_ERRSYNTAX,
    LUA_STATUS_ERRMEM = LUA_ERRMEM,
    LUA_STATUS_ERRGCMM = LUA_ERRGCMM,
    LUA_STATUS_ERRERR = LUA_ERRERR,
  };

  const static UINT32_t luaStrMaxSize;      ///<  Luaスクリプト文字列最大長
  const static UINT32_t luaFileNameMaxSize; ///<  Luaスクリプトファイル名最大長

  /**
   * @brief  AXFLuaInternalコンストラクタ
   */
  AXFLuaInternal(AXFActor* actor, AXFLog* log);

  /**
   * @brief  AXFLuaInternalデストラクタ
   */
  virtual ~AXFLuaInternal();

  /**
   * @brief  Lua の初期化
   */
  luaStatus init();

  /**
   * @brief  Lua 文字列実行
   */
  luaStatus doString(const std::string& str);

  /**
   * @brief  Lua ファイル実行
   */
  luaStatus doFile(const std::string& fileName);
};

#endif /* USE_LUA */
#endif /* AXFLuaInternal_HPP_ */
