/*
 * AXFTimeDomainInternal.hpp
 */

#ifndef AXFTIMEDOMAININTERNAL_HPP_
#define AXFTIMEDOMAININTERNAL_HPP_

#ifndef UNUSE_CHRONO	// baba Chrono非対応のためAXFTimeDomainInternalは現状非対応
#include "AXCStdint.hpp"
#include "AXFChrono.hpp"
#include "AXFActor.hpp"
class AXFLog;

#include <set>

/**
 * @class AXFTimeDomainInternal
 * @brief アプリケーション・レベルでスケジューラ機能を提供する
 *
 * @n     AXシミュレータ動作時のみ機能する。
 * @n
 */
class AXFTimeDomainInternal {
public:
  /**
   * @class BreakDateInfo
   * @brief 時刻 Break情報
   */
  class BreakDateInfo {
   public:
    AXFChrono m_breakTick;
    bool m_isEnable;

    BreakDateInfo(AXFChrono date);
    virtual ~BreakDateInfo();
    bool operator <(const BreakDateInfo& info) const;
    bool operator ==(const BreakDateInfo& info) const;
  };

  /**
   * @class BreakStateInfo
   * @brief LifeCycle・StateMachine Break情報
   */
  class BreakStateInfo {
   public:
    INT32_t m_state;
    INT32_t m_actorId;
    bool m_isEnable;

    BreakStateInfo(INT32_t state, INT32_t actorId);
    virtual ~BreakStateInfo();
    bool operator <(const BreakStateInfo& info) const;
    bool operator ==(const BreakStateInfo& info) const;
  };

private:
  AXFChrono m_currentTick;
  std::set<BreakDateInfo> m_braekDateList;
  bool m_isBreakLifeCycle;
  std::set<BreakStateInfo> m_braekLifeCycleList;
  bool m_isBreakStateMachine;
  std::set<BreakStateInfo> m_breakStateMachineList;
  bool m_isActive;

 public:
  /**
   * @brief  AXFTimeDomainInternalコンストラクタ
   */
  AXFTimeDomainInternal();

  /**
   * @brief  AXFTimeDomainInternalデストラクタ
   */
  virtual ~AXFTimeDomainInternal();

  /**
   * @brief  TimeDomain アクティブチェック処理
   */
  virtual bool isActive();

  /**
   * @brief  TimeDomain 有効処理
   */
  virtual void enable();

  /**
   * @brief  TimeDomain 無効処理
   */
  virtual void disable();

  /**
   * @brief  TimeDomain break予定チック更新処理
   */
  virtual bool addBreakTick(INT64_t count);

  /**
    * @brief  TimeDomain break予定時刻設定処理
    */
  virtual bool setBreakDate(AXFChrono::TimeSpec& date);

  /**
    * @brief  TimeDomain break予定LifeCycle情報設定処理
   */
  virtual void setBreakLifeCycleState(char* actorName, AXFActor::actorState state, AXFLog& log);

  /**
    * @brief  TimeDomain break予定StateMachine情報設定処理
   */
  virtual void setBreakStateMachineState(char* actorName, INT32_t state, AXFLog& log);

  /**
   * @brief  TimeDomain break削除処理
  */
  virtual void delBreak(INT32_t breakId, AXFLog& log);

  /**
    * @brief  TimeDomain LifeCycle・StateMachineメソッド実行後状態登録処理
   */
  virtual void commitState(AXFActor* actorObj);

  /**
   * @brief  TimeDomain トークンリング処理
   */
  virtual bool funcTokenRing(AXFLog& log);

  /**
   * @brief  TimeDomain モデル層アクタ起床処理
   */
  virtual bool funcAllWakeup(AXFLog& log);

  /**
   * @brief  TimeDomain 強制Break指定処理
   */
  virtual bool funcForceBreak(AXFLog& log);

  /**
   * @brief  TimeDomain Date Break情報登録処理
   */
  void registBreakDate(std::set<BreakDateInfo>& list, BreakDateInfo info);

  /**
   * @brief  TimeDomain Date Break情報登録解除処理
   * @return 登録情報あり
   */
  bool unregistBreakDate(std::set<BreakDateInfo>& list, INT32_t delIdx);

  /**
   * @brief  TimeDomain State Break情報登録処理
   */
  void registBreakState(std::set<BreakStateInfo>& list, BreakStateInfo info);

  /**
   * @brief  TimeDomain State Break情報登録解除処理
   * @return 登録情報あり
   */
  bool unregistBreakState(std::set<BreakStateInfo>& list, INT32_t delIdx);

  /**
    * @brief  Break状態のリセット処理
    */
   void resetBreakState();

  /**
   * @brief  TimeDomain Break指定情報出力処理
   */
  void dumpBreakInfo(AXFLog& log);

  /**
   * @brief  TimeDomain BreakDate指定情報出力処理
   */
  void dumpBreakDateInfo(AXFLog& log);

  /**
   * @brief  TimeDomain BreakLifeCycle指定情報出力処理
   */
  void dumpBreakLifeCycleInfo(AXFLog& log);

  /**
   * @brief  TimeDomain BreakStateMachine指定情報出力処理
   */
  void dumpBreakStateMachineInfo(AXFLog& log);
};
#endif	/* UNUSE_CHRONO */
#endif /* AXFTIMEDOMAININTERNAL_HPP_ */

