/**
 * @file   AXHChromaSuppress.hpp
 * @brief  Header file of ChromaSuppress settings.
 * @par    Programming Language
 *         C++
 */

#ifndef A_X_H_CHROMASUPPRESS_H_
#define A_X_H_CHROMASUPPRESS_H_

/**
 * @class AXHChromaSuppress
 * @brief AXHChromaSuppress Class
 */
class AXHChromaSuppress {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 */
	AXHChromaSuppress();
	/**
	 * @brief  オブジェクトを開放する
	 */
	virtual ~AXHChromaSuppress();

private:
	/**
	 * @brief  メンバ変数の初期化を行う
	 */
	void          init();

private:
	const int				SAC_C10_C1G0SL_LUT3A_SHIFT;
	const int				SAC_C20_C2G0SL_LUT3A_SHIFT;
	const int				SAC_VAL10_C1G1_SHIFT;
	const int				SAC_VAL20_C2G1_SHIFT;
	const int				SAC_LUT3A_ON_VALUE;
	const unsigned int	LUT_ACS_EDIT_ON_VALUE;
	const unsigned int	LUT_ACS_EDIT_OFF_VALUE;
	const unsigned int	LUT_3A_CLEAR_MASK;
	const unsigned int	SAC_C10_C1G0SL_CLEAR_MASK;
	const unsigned int	SAC_C20_C2G0SL_CLEAR_MASK;
	const unsigned int	SAC_VAL10_C1G1_CLEAR_MASK;
	const unsigned int	SAC_VAL20_C2G1_CLEAR_MASK;

	/**
	 * @brief  SAC_C10設定アドレス
	 */
	unsigned int*        p_RegSAC_C10;
	/**
	 * @brief  SAC_C20設定アドレス
	 */
	unsigned int*        p_RegSAC_C20;
	/**
	 * @brief  SAC_C30設定アドレス
	 */
	unsigned int*        p_RegSAC_C30;
	/**
	 * @brief  SAC_VAL10設定アドレス
	 */
	unsigned int*        p_RegSAC_VAL10;
	/**
	 * @brief  SAC_VAL20設定アドレス
	 */
	unsigned int*        p_RegSAC_VAL20;
	/**
	 * @brief  LUT_ACS設定アドレス
	 */
	unsigned int*        p_RegLUT_ACS;
	/**
	 * @brief  LUT_H1設定アドレス
	 */
	unsigned int*        p_RegLUT_H1;
	/**
	 * @brief  LUT_3A設定アドレス
	 */
	unsigned int*        p_RegLUT_3A;

public:
	/**
	 * @brief  lutの設定を行う
	 *
	 * @param  [in]  lut                       クロマサプレス計算後変調ゲインLUT
	 * @param  [in]  size                      データ数
	 * @return 設定結果
	 */
	bool          set_chroma_lut(unsigned char* lut, int size);
	/**
	 * @brief  輝度変調処理用信号フローを設定する
	 */
	void          set_chroma_luminanceModulation_signal_flow();
	/**
	 * @brief  低輝度クロマサプレス用ゲイン制御信号フローを設定する
	 *
	 * @param  [in]  gain                      低輝度クロマサプレスゲイン
	 */
	void          set_chroma_lowLuminance_gain_signal_flow(unsigned char gain);
	/**
	 * @brief  エッジクロマサプレス信号フローを設定する
	 */
	void          set_chroma_edge_signal_flow();
	/**
	 * @brief  エッジクロマサプレス用lutの設定を行う
	 *
	 * @param  [in]  lut                       エッジクロマサプレス変調ゲインLUT
	 * @return 設定結果
	 */
	bool          set_chroma_edge_lut(unsigned char* lut);

#ifdef PARASOFT_CPPTEST
	unsigned int	CPPTEST_val1;
	unsigned int	CPPTEST_val2;
#endif

};

#endif /* A_X_H_CHROMASUPPRESS_H_ */
