/*
 * @file   AXHDefect.cpp
 * @brief  Source file of Defect class.
 * @par    Programming Language
 *         C++
 */

#include "AXHDefect.hpp"
#include "AXHRegAddr.hpp"
#include "AXHRegDefine.hpp"
#include "AXHSpecInit.hpp"


#ifndef PARASOFT_CPPTEST
#ifndef BB_TMP_PASS		// baba 使用箇所不明
const unsigned int NULL = 0x00000000ul;
#endif
#endif  //  PARASOFT_CPPTEST

const unsigned short AXH_Detect_LevelModulate_Max = 0xFFFFul;

AXHDefect::AXHDefect() {
	// 現状ハードとは異なるため不要
	/*
  DMAmode = 0;
  AutoEnable = 0;
  for(unsigned int i = 0; i < AXH_Defect_IntAddr_Max; i++) {
    PixcelAddr[i].H = 0;
    PixcelAddr[i].V = 0;
    PixcelAddr[i].CLS = 0;
  }
  AutoCorrect = 0;
  AutoSel = 0;
  WhiteDefectTH = 0;
  BlackDefectTH = 0;
  for(unsigned int i = 0; i < AXH_Defect_ADFOFS_Max; i++) {
    LevelModulate[i] = 0;
  }
  Init();
	*/
}

AXHDefect::~AXHDefect() {
}

void AXHDefect::Init() {
	// 現状ハードとは異なるため不要
	/*
  p_RegSPU_DMAR1_OFS = (unsigned int *)AXH_RegSPU_DMAR1_OFS;
  p_RegSPU_C         = (unsigned int *)AXH_RegSPU_C;
  p_RegDEFCT_C       = (unsigned int *)AXH_RegDEFCT_C;
  p_RegCDEF[ 0]      = (unsigned int *)AXH_RegCDEF0;
  p_RegCDEF[ 1]      = (unsigned int *)AXH_RegCDEF1;
  p_RegCDEF[ 2]      = (unsigned int *)AXH_RegCDEF2;
  p_RegCDEF[ 3]      = (unsigned int *)AXH_RegCDEF3;
  p_RegCDEF[ 4]      = (unsigned int *)AXH_RegCDEF4;
  p_RegCDEF[ 5]      = (unsigned int *)AXH_RegCDEF5;
  p_RegCDEF[ 6]      = (unsigned int *)AXH_RegCDEF6;
  p_RegCDEF[ 7]      = (unsigned int *)AXH_RegCDEF7;
  p_RegCDEF[ 8]      = (unsigned int *)AXH_RegCDEF8;
  p_RegCDEF[ 9]      = (unsigned int *)AXH_RegCDEF9;
  p_RegCDEF[10]      = (unsigned int *)AXH_RegCDEF10;
  p_RegCDEF[11]      = (unsigned int *)AXH_RegCDEF11;
  p_RegCDEF[12]      = (unsigned int *)AXH_RegCDEF12;
  p_RegCDEF[13]      = (unsigned int *)AXH_RegCDEF13;
  p_RegCDEF[14]      = (unsigned int *)AXH_RegCDEF14;
  p_RegCDEF[15]      = (unsigned int *)AXH_RegCDEF15;
  p_RegADFCTTH_H     = (unsigned int *)AXH_RegADFCTTH_H;
  p_RegADFCTTH_L     = (unsigned int *)AXH_RegADFCTTH_L;
  p_RegADFOFS[0]     = (unsigned int *)AXH_RegADFOFS_1A;
  p_RegADFOFS[1]     = (unsigned int *)AXH_RegADFOFS_2A;
  p_RegADFOFS[2]     = (unsigned int *)AXH_RegADFOFS_3A;
  p_RegADFOFS[3]     = (unsigned int *)AXH_RegADFOFS_4A;
  p_RegADFOFS[4]     = (unsigned int *)AXH_RegADFOFS_5A;
  p_RegADFOFS[5]     = (unsigned int *)AXH_RegADFOFS_6A;
  p_RegADFOFS[6]     = (unsigned int *)AXH_RegADFOFS_7A;
  p_RegADFOFS[7]     = (unsigned int *)AXH_RegADFOFS_8A;
  //  画素欠陥補正用データ領域 先頭アドレス定義
  //  実際にはセクションで定義したエリアに配置する
  //  このため、セクションの先頭アドレスとここで設定するアドレスが一致していること
  *p_RegSPU_DMAR1_OFS = AXH_DRAM_OFST_IMG_DEF;
  //  レジスタデフォルト値取得
  getDMAmode();
  getAutoEnable();
  for(unsigned int i = 0; i < AXH_Defect_IntAddr_Max; i++) {
    getPixcelAddr(i);
  }
  getAutoCorrect();
  getAutoSel();
  getWhiteDefectTH();
  getBlackDefectTH();
  for(unsigned int i = 0; i < AXH_Defect_ADFOFS_Max; i++) {
    getLevelModulate(i);
  }
	*/
}

void AXHDefect::setDMAmode(unsigned char mode) {
	// 現状ハードとは異なるため不要
	/*
  DMAmode = (mode & AXH_MASK_1BIT);
  if(DMAmode != 0) {
    *p_RegSPU_C |= AXH_BIT_SPU_C_DEFCSL;
  }
  else {
    *p_RegSPU_C &= ~AXH_BIT_SPU_C_DEFCSL;
  }
	*/
}

unsigned char AXHDefect::getDMAmode() {
	// 現状ハードとは異なるため不要
	/*
  DMAmode = ((*p_RegSPU_C >> AXH_SFT_SPU_C_DEFCSL) & AXH_MASK_1BIT);
	*/
  return DMAmode;
}

void AXHDefect::setAutoEnable(unsigned char mode) {
	// 現状ハードとは異なるため不要
	/*
  AutoEnable = (mode & AXH_MASK_1BIT);
  if(AutoEnable != 0) {
    *p_RegDEFCT_C |= AXH_BIT_DEFCT_C_ADFCTEN;
  }
  else {
    *p_RegDEFCT_C &= ~AXH_BIT_DEFCT_C_ADFCTEN;
  }
	*/
}

unsigned char AXHDefect::getAutoEnable() {
	// 現状ハードとは異なるため不要
	/*
  AutoEnable = ((*p_RegDEFCT_C >> AXH_SFT_DEFCT_C_ADFCTEN) & AXH_MASK_1BIT);
  return AutoEnable;
	*/
	return 0;
}

void AXHDefect::setPixcelAddr(unsigned int index, ST_DEFECT_ADDRESS addr) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_Defect_IntAddr_Max) {
    PixcelAddr[index].H = addr.H;
    PixcelAddr[index].V = addr.V;
    PixcelAddr[index].CLS = addr.CLS;
    unsigned int reg = 0;
    reg |= (((unsigned int)PixcelAddr[index].H   & AXH_MASK_13BIT) << AXH_SFT_CDEF_H  );
    reg |= (((unsigned int)PixcelAddr[index].V   & AXH_MASK_13BIT) << AXH_SFT_CDEF_V  );
    reg |= (((unsigned int)PixcelAddr[index].CLS & AXH_MASK_2BIT ) << AXH_SFT_CDEF_CLS);
    *p_RegCDEF[index] = reg;
  }
	*/
}

ST_DEFECT_ADDRESS AXHDefect::getPixcelAddr(unsigned int index) {
	// 現状ハードとは異なるため不要
	/*
  ST_DEFECT_ADDRESS ret;
  if(index < AXH_Defect_IntAddr_Max) {
    PixcelAddr[index].H   = ((*p_RegCDEF[index] >> AXH_SFT_CDEF_H  ) & AXH_MASK_13BIT);
    PixcelAddr[index].V   = ((*p_RegCDEF[index] >> AXH_SFT_CDEF_V  ) & AXH_MASK_13BIT);
    PixcelAddr[index].CLS = ((*p_RegCDEF[index] >> AXH_SFT_CDEF_CLS) & AXH_MASK_2BIT );
    ret = PixcelAddr[index];
  }
  else {
    ret.H   = AXH_DEFECT_CDEF_H_Init;
    ret.V   = AXH_DEFECT_CDEF_V_Init;
    ret.CLS = AXH_DEFECT_CDEF_CLS_Init;
  }
  return ret;
	*/
	ST_DEFECT_ADDRESS Dmy;
	Dmy.H = 0;
	Dmy.V = 0;
	Dmy.CLS = 0;
	return Dmy;
}

void AXHDefect::setAutoCorrect(unsigned char mode) {
	// 現状ハードとは異なるため不要
	/*
  AutoCorrect = (mode & AXH_MASK_2BIT);
  *p_RegDEFCT_C &= ~AXH_MASK_DEFCT_C_CDEF_CLS_AUTO;
  *p_RegDEFCT_C |= ((AutoCorrect & AXH_MASK_2BIT) << AXH_SFT_DEFCT_C_CDEF_CLS_AUTO);
	*/
}

unsigned char AXHDefect::getAutoCorrect() {
	// 現状ハードとは異なるため不要
	/*
  AutoCorrect = ((*p_RegDEFCT_C >> AXH_SFT_DEFCT_C_CDEF_CLS_AUTO) & AXH_MASK_2BIT);
  return AutoCorrect;
	*/
	return 0;
}

void AXHDefect::setAutoSel(unsigned char sel) {
	// 現状ハードとは異なるため不要
	/*
  AutoSel = (sel & AXH_MASK_2BIT);
  *p_RegDEFCT_C &= ~AXH_MASK_DEFCT_C_C0CDEFAVE;
  *p_RegDEFCT_C |= ((AutoSel & AXH_MASK_2BIT) << AXH_SFT_DEFCT_C_C0CDEFAVE);
	*/
}

unsigned char AXHDefect::getAutoSel() {
	// 現状ハードとは異なるため不要
	/*
  AutoSel = ((*p_RegDEFCT_C >> AXH_SFT_DEFCT_C_C0CDEFAVE) & AXH_MASK_2BIT);
  return AutoSel;
	*/
	return 0;
}

void AXHDefect::setWhiteDefectTH(unsigned short th) {
	// 現状ハードとは異なるため不要
	/*
  WhiteDefectTH = (th & AXH_MASK_14BIT);
  *p_RegADFCTTH_H &= ~AXH_MASK_ADFCTTH_H_ADFCT_WTL;
  *p_RegADFCTTH_H |= ((WhiteDefectTH & AXH_MASK_14BIT) << AXH_SFT_ADFCTTH_H_ADFCT_WTL);
	*/
}

unsigned short AXHDefect::getWhiteDefectTH() {
	// 現状ハードとは異なるため不要
	/*
  WhiteDefectTH = ((*p_RegADFCTTH_H >> AXH_SFT_ADFCTTH_H_ADFCT_WTL) & AXH_MASK_14BIT);
  return WhiteDefectTH;
	*/
	return 0;
}

void AXHDefect::setBlackDefectTH(unsigned short th) {
	// 現状ハードとは異なるため不要
	/*
  BlackDefectTH = (th & AXH_MASK_14BIT);
  *p_RegADFCTTH_L &= ~AXH_MASK_ADFCTTH_L_ADFCT_DKL;
  *p_RegADFCTTH_L |= ((BlackDefectTH & AXH_MASK_14BIT) << AXH_SFT_ADFCTTH_L_ADFCT_DKL);
	*/
}

unsigned short AXHDefect::getBlackDefectTH() {
	// 現状ハードとは異なるため不要
	/*
  BlackDefectTH = ((*p_RegADFCTTH_L >> AXH_SFT_ADFCTTH_L_ADFCT_DKL) & AXH_MASK_14BIT);
  return BlackDefectTH;
	*/
	return 0;
}

void AXHDefect::setLevelModulate(unsigned int index, unsigned short level) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_Defect_ADFOFS_Max) {
    LevelModulate[index] = (level & AXH_MASK_14BIT);
    unsigned int index1 = (index >> 1);
    if((index & AXH_INDEX_ADFOFS_H) != AXH_INDEX_ADFOFS_H) {
      *p_RegADFOFS[index1] &= ~AXH_MASK_ADFOFS_L;
      *p_RegADFOFS[index1] |= ((LevelModulate[index] & AXH_MASK_14BIT) << AXH_SFT_ADFOFS_L);
    }
    else {
      *p_RegADFOFS[index1] &= ~AXH_MASK_ADFOFS_H;
      *p_RegADFOFS[index1] |= ((LevelModulate[index] & AXH_MASK_14BIT) << AXH_SFT_ADFOFS_H);
    }
  }
	*/
}

unsigned short AXHDefect::getLevelModulate(unsigned int index) {
	// 現状ハードとは異なるため不要
	/*
  unsigned short ret = AXH_Detect_LevelModulate_Max;
  if(index < AXH_Defect_ADFOFS_Max) {
    unsigned int index1 = (index >> 1);
    if((index & AXH_INDEX_ADFOFS_H) != AXH_INDEX_ADFOFS_H) {
      LevelModulate[index] = ((*p_RegADFOFS[index1] >> AXH_SFT_ADFOFS_L) & AXH_MASK_14BIT);
    }
    else {
      LevelModulate[index] = ((*p_RegADFOFS[index1] >> AXH_SFT_ADFOFS_H) & AXH_MASK_14BIT);
    }
    ret = LevelModulate[index];
  }
  return ret;
	*/
	return 0;
}
