/**
 * @file   AXHGamma.hpp
 * @brief  Header file of Gamma settings.
 * @par    Programming Language
 *         C++
 */
#ifndef A_X_H_GAMMA_H
#define A_X_H_GAMMA_H

/**
 * @class AXHGamma
 * @brief AXHGamma Class
 */
class AXHGamma {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 */
	AXHGamma();
	/**
	 * @brief  オブジェクトを開放する
	 */
	virtual ~AXHGamma();

private:
	const int		REG_DATA_SIZE;

public:
	/**
	 * @brief  ガンマ補正テーブルの設定を行う
	 *
	 * @param  [in]  gamma                     ガンマ補正テーブル
	 * @param  [in]  size                      ガンマ補正テーブルサイズ
	 */
	void			set_gamma_table(unsigned short* gamma, int size);
};

#endif /* A_X_H_GAMMA_H */
