/*
 * @file   AXHNR.cpp
 * @brief  Source file of NR Class
 * @par    Programming Language
 *         C++
 */

#include "AXHNR.hpp"
#include "AXHRegAddr.hpp"
#include "AXHCommonParam.hpp"


#define SFT_NR_COL0     0
#define SFT_NR_COL1     8
#define SFT_NR_COL2     16
#define SFT_NR_COL3     24
#define MASK_NR_TH      0x0000001Ful
#define MASK_NR_IN      0x0000007Ful
#define MASK_NR_LV      0x000000FFul

AXHNR::AXHNR() {
	// 現状ハードとは異なるため不要
	/*
  p_NRHLen       = (unsigned int *)AXH_NR_HLEN;
  p_NRVLen       = (unsigned int *)AXH_NR_VLEN;
  p_NRBlank      = (unsigned int *)AXH_NR_BLANK;
  p_NREn         = (unsigned int *)AXH_NR_EN;
  p_NRMainYTH[0] = (unsigned int *)AXH_NR_MAIN_YTH0;
  p_NRMainYTH[1] = (unsigned int *)AXH_NR_MAIN_YTH1;
  p_NRMainYTH[2] = (unsigned int *)AXH_NR_MAIN_YTH2;
  p_NRMainYTH[3] = (unsigned int *)AXH_NR_MAIN_YTH3;
  p_NRMainCTH[0] = (unsigned int *)AXH_NR_MAIN_CTH0;
  p_NRMainCTH[1] = (unsigned int *)AXH_NR_MAIN_CTH1;
  p_NRMainCTH[2] = (unsigned int *)AXH_NR_MAIN_CTH2;
  p_NRMainCTH[3] = (unsigned int *)AXH_NR_MAIN_CTH3;
  p_NRMainYIN[0] = (unsigned int *)AXH_NR_MAIN_YIN0;
  p_NRMainYIN[1] = (unsigned int *)AXH_NR_MAIN_YIN1;
  p_NRMainYIN[2] = (unsigned int *)AXH_NR_MAIN_YIN2;
  p_NRMainYIN[3] = (unsigned int *)AXH_NR_MAIN_YIN3;
  p_NRMainCIN[0] = (unsigned int *)AXH_NR_MAIN_CIN0;
  p_NRMainCIN[1] = (unsigned int *)AXH_NR_MAIN_CIN1;
  p_NRMainCIN[2] = (unsigned int *)AXH_NR_MAIN_CIN2;
  p_NRMainCIN[3] = (unsigned int *)AXH_NR_MAIN_CIN3;
  p_NRSubYTH     = (unsigned int *)AXH_NR_SUB_YTH;
  p_NRSubCTH     = (unsigned int *)AXH_NR_SUB_CTH;
  p_NRSubYIN     = (unsigned int *)AXH_NR_SUB_YIN;
  p_NRSubCIN     = (unsigned int *)AXH_NR_SUB_CIN;
  p_NRMainYLV[0] = (unsigned int *)AXH_NR_MAIN_YLV0;
  p_NRMainYLV[1] = (unsigned int *)AXH_NR_MAIN_YLV1;
  p_NRMainYLV[2] = (unsigned int *)AXH_NR_MAIN_YLV2;
  p_NRMainYLV[3] = (unsigned int *)AXH_NR_MAIN_YLV3;
  p_NRMainCLV[0] = (unsigned int *)AXH_NR_MAIN_CLV0;
  p_NRMainCLV[1] = (unsigned int *)AXH_NR_MAIN_CLV1;
  p_NRMainCLV[2] = (unsigned int *)AXH_NR_MAIN_CLV2;
  p_NRMainCLV[3] = (unsigned int *)AXH_NR_MAIN_CLV3;
  p_NRSubYLV   = (unsigned int *)AXH_NR_SUB_YLV;
  p_NRSubCLV   = (unsigned int *)AXH_NR_SUB_CLV;

  Mode = *p_NREn;
  for(int i = 0; i < AXH_NR_MainTH_Max; i++) {
    MainYTH[i * AXH_NR_Col + 0] = (unsigned char)((*p_NRMainYTH[i] >> SFT_NR_COL0) & MASK_NR_TH);
    MainYTH[i * AXH_NR_Col + 1] = (unsigned char)((*p_NRMainYTH[i] >> SFT_NR_COL1) & MASK_NR_TH);
    MainYTH[i * AXH_NR_Col + 2] = (unsigned char)((*p_NRMainYTH[i] >> SFT_NR_COL2) & MASK_NR_TH);
    MainYTH[i * AXH_NR_Col + 3] = (unsigned char)((*p_NRMainYTH[i] >> SFT_NR_COL3) & MASK_NR_TH);
  }
  for(int i = 0; i < AXH_NR_MainTH_Max; i++) {
    MainCTH[i * AXH_NR_Col + 0] = (unsigned char)((*p_NRMainCTH[i] >> SFT_NR_COL0) & MASK_NR_TH);
    MainCTH[i * AXH_NR_Col + 1] = (unsigned char)((*p_NRMainCTH[i] >> SFT_NR_COL1) & MASK_NR_TH);
    MainCTH[i * AXH_NR_Col + 2] = (unsigned char)((*p_NRMainCTH[i] >> SFT_NR_COL2) & MASK_NR_TH);
    MainCTH[i * AXH_NR_Col + 3] = (unsigned char)((*p_NRMainCTH[i] >> SFT_NR_COL3) & MASK_NR_TH);
  }
  for(int i = 0; i < AXH_NR_MainIN_Max; i++) {
    MainYIN[i * AXH_NR_Col + 0] = (unsigned char)((*p_NRMainYIN[i] >> SFT_NR_COL0) & MASK_NR_IN);
    MainYIN[i * AXH_NR_Col + 1] = (unsigned char)((*p_NRMainYIN[i] >> SFT_NR_COL1) & MASK_NR_IN);
    MainYIN[i * AXH_NR_Col + 2] = (unsigned char)((*p_NRMainYIN[i] >> SFT_NR_COL2) & MASK_NR_IN);
    MainYIN[i * AXH_NR_Col + 3] = (unsigned char)((*p_NRMainYIN[i] >> SFT_NR_COL3) & MASK_NR_IN);
  }
  for(int i = 0; i < AXH_NR_MainIN_Max; i++) {
    MainCIN[i * AXH_NR_Col + 0] = (unsigned char)((*p_NRMainCIN[i] >> SFT_NR_COL0) & MASK_NR_IN);
    MainCIN[i * AXH_NR_Col + 1] = (unsigned char)((*p_NRMainCIN[i] >> SFT_NR_COL1) & MASK_NR_IN);
    MainCIN[i * AXH_NR_Col + 2] = (unsigned char)((*p_NRMainCIN[i] >> SFT_NR_COL2) & MASK_NR_IN);
    MainCIN[i * AXH_NR_Col + 3] = (unsigned char)((*p_NRMainCIN[i] >> SFT_NR_COL3) & MASK_NR_IN);
  }
  SubYTH[0] = (unsigned char)((*p_NRSubYTH >> SFT_NR_COL0) & MASK_NR_TH);
  SubYTH[1] = (unsigned char)((*p_NRSubYTH >> SFT_NR_COL1) & MASK_NR_TH);
  SubYTH[2] = (unsigned char)((*p_NRSubYTH >> SFT_NR_COL2) & MASK_NR_TH);
  SubYTH[3] = (unsigned char)((*p_NRSubYTH >> SFT_NR_COL3) & MASK_NR_TH);
  SubCTH[0] = (unsigned char)((*p_NRSubCTH >> SFT_NR_COL0) & MASK_NR_TH);
  SubCTH[1] = (unsigned char)((*p_NRSubCTH >> SFT_NR_COL1) & MASK_NR_TH);
  SubCTH[2] = (unsigned char)((*p_NRSubCTH >> SFT_NR_COL2) & MASK_NR_TH);
  SubCTH[3] = (unsigned char)((*p_NRSubCTH >> SFT_NR_COL3) & MASK_NR_TH);
  SubYIN[0] = (unsigned char)((*p_NRSubYIN >> SFT_NR_COL0) & MASK_NR_IN);
  SubYIN[1] = (unsigned char)((*p_NRSubYIN >> SFT_NR_COL1) & MASK_NR_IN);
  SubYIN[2] = (unsigned char)((*p_NRSubYIN >> SFT_NR_COL2) & MASK_NR_IN);
  SubYIN[3] = (unsigned char)((*p_NRSubYIN >> SFT_NR_COL3) & MASK_NR_IN);
  SubCIN[0] = (unsigned char)((*p_NRSubCIN >> SFT_NR_COL0) & MASK_NR_IN);
  SubCIN[1] = (unsigned char)((*p_NRSubCIN >> SFT_NR_COL1) & MASK_NR_IN);
  SubCIN[2] = (unsigned char)((*p_NRSubCIN >> SFT_NR_COL2) & MASK_NR_IN);
  SubCIN[3] = (unsigned char)((*p_NRSubCIN >> SFT_NR_COL3) & MASK_NR_IN);
  for(int i = 0; i < AXH_NR_MainLV_Max; i++) {
    MainYLV[i * AXH_NR_Col + 0] = (unsigned char)((*p_NRMainYLV[i] >> SFT_NR_COL0) & MASK_NR_LV);
    MainYLV[i * AXH_NR_Col + 1] = (unsigned char)((*p_NRMainYLV[i] >> SFT_NR_COL1) & MASK_NR_LV);
    MainYLV[i * AXH_NR_Col + 2] = (unsigned char)((*p_NRMainYLV[i] >> SFT_NR_COL2) & MASK_NR_LV);
    MainYLV[i * AXH_NR_Col + 3] = (unsigned char)((*p_NRMainYLV[i] >> SFT_NR_COL3) & MASK_NR_LV);
  }
  for(int i = 0; i < AXH_NR_MainTH_Max; i++) {
    MainCLV[i * AXH_NR_Col + 0] = (unsigned char)((*p_NRMainCLV[i] >> SFT_NR_COL0) & MASK_NR_LV);
    MainCLV[i * AXH_NR_Col + 1] = (unsigned char)((*p_NRMainCLV[i] >> SFT_NR_COL1) & MASK_NR_LV);
    MainCLV[i * AXH_NR_Col + 2] = (unsigned char)((*p_NRMainCLV[i] >> SFT_NR_COL2) & MASK_NR_LV);
    MainCLV[i * AXH_NR_Col + 3] = (unsigned char)((*p_NRMainCLV[i] >> SFT_NR_COL3) & MASK_NR_LV);
  }
  SubYLV[0] = (unsigned char)((*p_NRSubYLV >> SFT_NR_COL0) & MASK_NR_LV);
  SubYLV[1] = (unsigned char)((*p_NRSubYLV >> SFT_NR_COL1) & MASK_NR_LV);
  SubYLV[2] = (unsigned char)((*p_NRSubYLV >> SFT_NR_COL2) & MASK_NR_LV);
  SubYLV[3] = (unsigned char)((*p_NRSubYLV >> SFT_NR_COL3) & MASK_NR_LV);
  SubCLV[0] = (unsigned char)((*p_NRSubCLV >> SFT_NR_COL0) & MASK_NR_LV);
  SubCLV[1] = (unsigned char)((*p_NRSubCLV >> SFT_NR_COL1) & MASK_NR_LV);
  SubCLV[2] = (unsigned char)((*p_NRSubCLV >> SFT_NR_COL2) & MASK_NR_LV);
  SubCLV[3] = (unsigned char)((*p_NRSubCLV >> SFT_NR_COL3) & MASK_NR_LV);
	*/
}

AXHNR::~AXHNR() {
}

unsigned char AXHNR::getMode() {
	// 現状ハードとは異なるため不要
	/*
  return (unsigned char)Mode;
	*/
	return 0;
}

void AXHNR::setMode(unsigned char mode) {
	// 現状ハードとは異なるため不要
	/*
  Mode = (unsigned int)mode;
	*/
}

unsigned char AXHNR::getMainYTH(unsigned int index) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Main_Max) {
    return MainYTH[index];
  }
  return AXHNR_Error_Param;
	*/
	return 0;
}

void AXHNR::setMainYTH(unsigned int index, unsigned char yth) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Main_Max)
  {
    MainYTH[index] = (unsigned int)yth;
  }
	*/
}

unsigned char AXHNR::getMainCTH(unsigned int index) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Main_Max)
  {
    return MainCTH[index];
  }
  return AXHNR_Error_Param;
	*/
	return 0;
}

void AXHNR::setMainCTH(unsigned int index, unsigned char cth) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Main_Max) {
    MainCTH[index] = cth;
  }
	*/
}

unsigned char AXHNR::getMainYIN(unsigned int index) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Main_Max)
  {
    return MainYIN[index];
  }
  return AXHNR_Error_Param;
	*/
	return 0;
}

void AXHNR::setMainYIN(unsigned int index, unsigned char yin) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Main_Max) {
    MainYIN[index] = yin;
  }
	*/
}

unsigned char AXHNR::getMainCIN(unsigned int index) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Main_Max)
  {
    return MainCIN[index];
  }
  return AXHNR_Error_Param;
	*/
	return 0;
}

void AXHNR::setMainCIN(unsigned int index, unsigned char cin) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Main_Max) {
    MainCIN[index] = cin;
  }
	*/
}

unsigned char AXHNR::getSubYTH(unsigned int index) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Sub_Max) {
    return SubYTH[index];
  }
  return AXHNR_Error_Param;
	*/
	return 0;
}

void AXHNR::setSubYTH(unsigned int index, unsigned char yth) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Sub_Max)
  {
    SubYTH[index] = (unsigned int)yth;
  }
	*/
}

unsigned char AXHNR::getSubCTH(unsigned int index) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Sub_Max)
  {
    return SubCTH[index];
  }
  return AXHNR_Error_Param;
	*/
	return 0;
}

void AXHNR::setSubCTH(unsigned int index, unsigned char cth) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Sub_Max) {
    SubCTH[index] = cth;
  }
	*/
}

unsigned char AXHNR::getSubYIN(unsigned int index) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Sub_Max)
  {
    return SubYIN[index];
  }
  return AXHNR_Error_Param;
	*/
	return 0;
}

void AXHNR::setSubYIN(unsigned int index, unsigned char yin) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Sub_Max) {
    SubYIN[index] = yin;
  }
	*/
}

unsigned char AXHNR::getSubCIN(unsigned int index) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Sub_Max)
  {
    return SubCIN[index];
  }
  return AXHNR_Error_Param;
	*/
	return 0;
}

void AXHNR::setSubCIN(unsigned int index, unsigned char cin) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Sub_Max) {
    SubCIN[index] = cin;
  }
	*/
}

unsigned char AXHNR::getMainYLV(unsigned int index) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Main_Max) {
    return MainYLV[index];
  }
  return AXHNR_Error_Param;
	*/
	return 0;
}

void AXHNR::setMainYLV(unsigned int index, unsigned char ylv) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Main_Max)
  {
    MainYLV[index] = (unsigned int)ylv;
  }
	*/
}

unsigned char AXHNR::getMainCLV(unsigned int index) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Main_Max)
  {
    return MainCLV[index];
  }
  return AXHNR_Error_Param;
	*/
	return 0;
}

void AXHNR::setMainCLV(unsigned int index, unsigned char clv) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Main_Max) {
    MainCLV[index] = clv;
  }
	*/
}

unsigned char AXHNR::getSubYLV(unsigned int index) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Sub_Max) {
    return SubYLV[index];
  }
  return AXHNR_Error_Param;
	*/
	return 0;
}

void AXHNR::setSubYLV(unsigned int index, unsigned char ylv) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Sub_Max)
  {
    SubYLV[index] = (unsigned int)ylv;
  }
	*/
}

unsigned char AXHNR::getSubCLV(unsigned int index) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Sub_Max)
  {
    return SubCLV[index];
  }
  return AXHNR_Error_Param;
	*/
	return 0;
}

void AXHNR::setSubCLV(unsigned int index, unsigned char clv) {
	// 現状ハードとは異なるため不要
	/*
  if(index < AXH_NR_Sub_Max) {
    SubCLV[index] = clv;
  }
	*/
}

void AXHNR::Execute(unsigned short width, unsigned short height) {
	// 現状ハードとは異なるため不要
	/*
  ExecuteSize(width, height);
  *p_NRBlank = AXHNR_Blank;
  ExecuteMode();
  ExecuteMainY();
  ExecuteMainC();
  ExecuteSubY();
  ExecuteSubC();
	*/
}

void AXHNR::ExecuteSize(unsigned short width, unsigned short height) {
	// 現状ハードとは異なるため不要
	/*
  *p_NRHLen  = AXHNR_HLen | (unsigned int)width;            //  width
  *p_NRVLen  = AXHNR_VLen | (unsigned int)height;           //  height
	*/
}

void AXHNR::ExecuteMode() {
	// 現状ハードとは異なるため不要
	/*
  *p_NREn    = Mode;
	*/
}

void AXHNR::ExecuteMode(unsigned char mode) {
	// 現状ハードとは異なるため不要
	/*
  setMode(mode);
  ExecuteMode();
	*/
}

void AXHNR::ExecuteMainY() {
	// 現状ハードとは異なるため不要
	/*
  unsigned int tmp;

  for(int i = 0; i < AXH_NR_MainTH_Max; i++) {
    tmp  = ((unsigned int)MainYTH[i * AXH_NR_Col + 0] << SFT_NR_COL0);
    tmp |= ((unsigned int)MainYTH[i * AXH_NR_Col + 1] << SFT_NR_COL1);
    tmp |= ((unsigned int)MainYTH[i * AXH_NR_Col + 2] << SFT_NR_COL2);
    tmp |= ((unsigned int)MainYTH[i * AXH_NR_Col + 3] << SFT_NR_COL3);
    *p_NRMainYTH[i] = tmp;
    tmp  = ((unsigned int)MainYIN[i * AXH_NR_Col + 0] << SFT_NR_COL0);
    tmp |= ((unsigned int)MainYIN[i * AXH_NR_Col + 1] << SFT_NR_COL1);
    tmp |= ((unsigned int)MainYIN[i * AXH_NR_Col + 2] << SFT_NR_COL2);
    tmp |= ((unsigned int)MainYIN[i * AXH_NR_Col + 3] << SFT_NR_COL3);
    *p_NRMainYIN[i] = tmp;
    tmp  = ((unsigned int)MainYLV[i * AXH_NR_Col + 0] << SFT_NR_COL0);
    tmp |= ((unsigned int)MainYLV[i * AXH_NR_Col + 1] << SFT_NR_COL1);
    tmp |= ((unsigned int)MainYLV[i * AXH_NR_Col + 2] << SFT_NR_COL2);
    tmp |= ((unsigned int)MainYLV[i * AXH_NR_Col + 3] << SFT_NR_COL3);
    *p_NRMainYLV[i] = tmp;
  }
	*/
}

void AXHNR::ExecuteMainC() {
	// 現状ハードとは異なるため不要
	/*
  unsigned int tmp;

  for(int i = 0; i < AXH_NR_MainTH_Max; i++) {
    tmp  = ((unsigned int)MainCTH[i * AXH_NR_Col + 0] << SFT_NR_COL0);
    tmp |= ((unsigned int)MainCTH[i * AXH_NR_Col + 1] << SFT_NR_COL1);
    tmp |= ((unsigned int)MainCTH[i * AXH_NR_Col + 2] << SFT_NR_COL2);
    tmp |= ((unsigned int)MainCTH[i * AXH_NR_Col + 3] << SFT_NR_COL3);
    *p_NRMainCTH[i] = tmp;
    tmp  = ((unsigned int)MainCIN[i * AXH_NR_Col + 0] << SFT_NR_COL0);
    tmp |= ((unsigned int)MainCIN[i * AXH_NR_Col + 1] << SFT_NR_COL1);
    tmp |= ((unsigned int)MainCIN[i * AXH_NR_Col + 2] << SFT_NR_COL2);
    tmp |= ((unsigned int)MainCIN[i * AXH_NR_Col + 3] << SFT_NR_COL3);
    *p_NRMainCIN[i] = tmp;
    tmp  = ((unsigned int)MainCLV[i * AXH_NR_Col + 0] << SFT_NR_COL0);
    tmp |= ((unsigned int)MainCLV[i * AXH_NR_Col + 1] << SFT_NR_COL1);
    tmp |= ((unsigned int)MainCLV[i * AXH_NR_Col + 2] << SFT_NR_COL2);
    tmp |= ((unsigned int)MainCLV[i * AXH_NR_Col + 3] << SFT_NR_COL3);
    *p_NRMainCLV[i] = tmp;
  }
	*/
}

void AXHNR::ExecuteSubY() {
	// 現状ハードとは異なるため不要
	/*
  unsigned int tmp;

  tmp  = ((unsigned int)SubYTH[0] << SFT_NR_COL0);
  tmp |= ((unsigned int)SubYTH[1] << SFT_NR_COL1);
  tmp |= ((unsigned int)SubYTH[2] << SFT_NR_COL2);
  tmp |= ((unsigned int)SubYTH[3] << SFT_NR_COL3);
  *p_NRSubYTH = tmp;
  tmp  = ((unsigned int)SubYIN[0] << SFT_NR_COL0);
  tmp |= ((unsigned int)SubYIN[1] << SFT_NR_COL1);
  tmp |= ((unsigned int)SubYIN[2] << SFT_NR_COL2);
  tmp |= ((unsigned int)SubYIN[3] << SFT_NR_COL3);
  *p_NRSubYIN = tmp;
  tmp  = ((unsigned int)SubYLV[0] << SFT_NR_COL0);
  tmp |= ((unsigned int)SubYLV[1] << SFT_NR_COL1);
  tmp |= ((unsigned int)SubYLV[2] << SFT_NR_COL2);
  tmp |= ((unsigned int)SubYLV[3] << SFT_NR_COL3);
  *p_NRSubYLV = tmp;
	*/
}

void AXHNR::ExecuteSubC() {
	// 現状ハードとは異なるため不要
	/*
  unsigned int tmp;

  tmp  = ((unsigned int)SubCTH[0] << SFT_NR_COL0);
  tmp |= ((unsigned int)SubCTH[1] << SFT_NR_COL1);
  tmp |= ((unsigned int)SubCTH[2] << SFT_NR_COL2);
  tmp |= ((unsigned int)SubCTH[3] << SFT_NR_COL3);
  *p_NRSubCTH = tmp;
  tmp  = ((unsigned int)SubCIN[0] << SFT_NR_COL0);
  tmp |= ((unsigned int)SubCIN[1] << SFT_NR_COL1);
  tmp |= ((unsigned int)SubCIN[2] << SFT_NR_COL2);
  tmp |= ((unsigned int)SubCIN[3] << SFT_NR_COL3);
  *p_NRSubCIN = tmp;
  tmp  = ((unsigned int)SubCLV[0] << SFT_NR_COL0);
  tmp |= ((unsigned int)SubCLV[1] << SFT_NR_COL1);
  tmp |= ((unsigned int)SubCLV[2] << SFT_NR_COL2);
  tmp |= ((unsigned int)SubCLV[3] << SFT_NR_COL3);
  *p_NRSubCLV = tmp;
	*/
}
