/*
 * @file   AXHPixcessorInt.cpp
 * @brief  Source file of AXHPixcessorInt class.
 * @par    Programming Language
 *         C++
 */
#include "AXHPixcessorInt.hpp"
#include "AXHRegAddr.hpp"
#include "AXHCommonParam.hpp"

// ISP SCL register bit
const unsigned int  SCL_CTL_START        = (1<<8);
const unsigned int  SCL_CTL_CH0          = (1<<16);
const unsigned int  SCL_CTL_CH1          = (1<<17);
const unsigned int  SCL_CTL_CH2          = (1<<18);
const unsigned int  SCL_CTL_CH3          = (1<<19);
const unsigned int  SCL_CTL_CH4          = (1<<20);
const unsigned int  SCL_CTL_CH5          = (1<<21);
const unsigned int  SCL_CTL_SATD8X8_CLR  = (1U<<31);
const unsigned int  RPU_ONE_SHOT_START   = (1<<1);
const unsigned int  RPU_ONE_SHOT_MODE    = (1<<2);

const unsigned int  SET_RPU_C0_CLEAR     = 0xfffffffeul;      // RPU RPU制御OFF(B0)
const unsigned int  SET_RPU_C0           = 0x00000007ul;      // RPU OneShotモード設定(B2), OneShotモードSTART(B1), RPU制御ON(B0)
const unsigned int  SET_RPU_DMA_ACT      = 0x80000001ul;      // RPU DoubleBuffer制御(B31), DMAR0制御(B0)
const unsigned int  SET_NR_ENCORD        = 0x00000001ul;      // NR EncordモードON

AXHPixcessorInt::AXHPixcessorInt() :
	  initSatd         (false)
{
	// 現状ハードとは異なるため不要
	/*
	// TODO 自動生成されたコンストラクター・スタブ
	init();
	*/
}

AXHPixcessorInt::~AXHPixcessorInt() {
	// TODO Auto-generated destructor stub
}

void AXHPixcessorInt::init() {
	// 現状ハードとは異なるため不要
	/*
	p_REG_ISP_SCL_CTL           = (unsigned int*)AXH_REG_ISP_SCL_CTL;
	p_RPU_C0                    = (unsigned int*)AXH_RPU_C0;
	p_RPU_DMA_ACT               = (unsigned int*)AXH_RPU_DMA_ACT;
	p_NR_ISP_MODE               = (unsigned int*)AXH_NR_ISP_MODE;
	p_REG_AUDIO_HOST_RES_ID_REQ = (unsigned int*)AXH_REG_AUDIO_HOST_RES_ID_REQ;
	p_REG_AUDIO_HOST_RES_ARG00  = (unsigned int*)AXH_REG_AUDIO_HOST_RES_ARG00;
	p_REG_AUDIO_HOST_RES_ARG01  = (unsigned int*)AXH_REG_AUDIO_HOST_RES_ARG01;
	p_REG_AUDIO_HOST_RES_ARG02  = (unsigned int*)AXH_REG_AUDIO_HOST_RES_ARG02;
	p_REG_AUDIO_HOST_RES_ARG03  = (unsigned int*)AXH_REG_AUDIO_HOST_RES_ARG03;
	*/
}

void AXHPixcessorInt::set_gdu_start() {
	// 現状ハードとは異なるため不要
	/*
	*p_REG_AUDIO_HOST_RES_ARG00  = AXH_AUDIO_HOST_RES_ARG0_GDU_START;
	*p_REG_AUDIO_HOST_RES_ARG01  = AXH_AUDIO_HOST_RES_ARG1_GDU_START;
	*p_REG_AUDIO_HOST_RES_ARG02  = AXH_AUDIO_HOST_RES_ARG2_GDU_START;
	*p_REG_AUDIO_HOST_RES_ARG03  = AXH_AUDIO_HOST_RES_ARG3_GDU_START;
	*p_REG_AUDIO_HOST_RES_ID_REQ = AXH_AUDIO_HOST_RES_ID_GDU_CMD;
	*/
}

void AXHPixcessorInt::switch_gdu_bank_no(unsigned int bankno, unsigned int satd) {
	// 現状ハードとは異なるため不要
	/*
	*p_REG_AUDIO_HOST_RES_ARG00  = AXH_AUDIO_HOST_RES_ARG0_GDU_BANK_SWITCH;
	*p_REG_AUDIO_HOST_RES_ARG01  = bankno;
	*p_REG_AUDIO_HOST_RES_ARG02  = AXH_AUDIO_HOST_RES_ARG2_GDU_BANK_SWITCH;
	*p_REG_AUDIO_HOST_RES_ARG03  = satd;
	*p_REG_AUDIO_HOST_RES_ID_REQ = AXH_AUDIO_HOST_RES_ID_GDU_CMD;
	*/
}

void AXHPixcessorInt::set_isp_start(unsigned char scl_ch0_enabled, unsigned char scl_ch1_enabled, unsigned char scl_ch2_enabled) {
	// 現状ハードとは異なるため不要
	/*
	unsigned int isp_encen = *p_NR_ISP_MODE;
	if ((isp_encen & 0x00000001ul) == 0) {
		set_scaler_enabled(scl_ch0_enabled, scl_ch1_enabled, scl_ch2_enabled);
		*p_RPU_C0       = (*p_RPU_C0 & SET_RPU_C0_CLEAR) | RPU_ONE_SHOT_MODE | RPU_ONE_SHOT_START;
#ifdef PARASOFT_CPPTEST
		// 途中経過を確認
		CPPTEST_checkValue = *p_RPU_C0;
#endif // PARASOFT_CPPTEST
		*p_RPU_C0      |= SET_RPU_C0;
		*p_RPU_DMA_ACT |= SET_RPU_DMA_ACT;
		*p_NR_ISP_MODE |= SET_NR_ENCORD;
	}
	*/
}

inline void AXHPixcessorInt::set_scaler_enabled(unsigned char ch0_enabled, unsigned char ch1_enabled, unsigned char ch2_enabled) {
	// 現状ハードとは異なるため不要
	/*
	unsigned int val = 0;

	if (initSatd == false) {
		val = SCL_CTL_SATD8X8_CLR;
		initSatd = true;
	}
	if (ch0_enabled == 1) {
		val |= SCL_CTL_CH0;
	}
	if (ch1_enabled == 1) {
		val |= SCL_CTL_CH1;
	}
	if (ch2_enabled == 1) {
		val |= SCL_CTL_CH2;
	}
	val |= SCL_CTL_CH3;
	val |= SCL_CTL_CH4;
	val |= SCL_CTL_CH5;
	val |= SCL_CTL_START;
	*p_REG_ISP_SCL_CTL = val;
	*/
}
