/**
 * @file   AXHPixcessorInt.hpp
 * @brief  Header file of PixcessorIntConfig class.
 * @par    Programming Language
 *         C++
 */
#ifndef A_X_H_PIXCESSOR_INT_H_
#define A_X_H_PIXCESSOR_INT_H_

/**
 * @class AXHPixcessorInt
 * @brief AXHPixcessorInt Class
 */
class AXHPixcessorInt {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 */
	AXHPixcessorInt();
	/**
	 * @brief  オブジェクトを開放する
	 */
	virtual ~AXHPixcessorInt();

private:
	/**
	 * @brief  メンバ変数の初期化を行う
	 */
	void          init();

public:
	/**
	 * @brief  gduの開始通知を行う
	 */
	void          set_gdu_start();
	/**
	 * @brief  gduバンク番号の切り替えを行う
	 *
	 * @param  [in]  bankno                   切り替えバンク番号
	 * @param  [in]  satd                     画像複雑度
	 */
	void          switch_gdu_bank_no(unsigned int bankno, unsigned int satd);
	/**
	 * @brief  isi割り込み時、isp開始設定を行う
	 *
	 * @param  [in]  scl_ch0_enabled          ch0スケーリング機能enabled
	 * @param  [in]  scl_ch1_enabled          ch1スケーリング機能enabled
	 * @param  [in]  scl_ch2_enabled          ch2スケーリング機能enabled
	 */
	void          set_isp_start(unsigned char scl_ch0_enabled, unsigned char scl_ch1_enabled, unsigned char scl_ch2_enabled);

private:
	/**
	 * @brief  スケーリング機能のenabled設定を行う
	 *
	 * @param  [in]  ch0_enabled              ch0スケーリング機能enabled
	 * @param  [in]  ch1_enabled              ch1スケーリング機能enabled
	 * @param  [in]  ch2_enabled              ch2スケーリング機能enabled
	 */
	void          set_scaler_enabled(unsigned char ch0_enabled, unsigned char ch1_enabled, unsigned char ch2_enabled);

private:
	/**
	 * @brief  スケーラー画像複雑度計算領域初期化フラグ
	 */
	bool          initSatd;
	/**
	 * @brief  スケーラー制御開始
	 */
	unsigned int* p_REG_ISP_SCL_CTL;
	/**
	 * @brief  RPU OneShotモード設定、OneShot処理開始、RPU制御ON
	 */
	unsigned int* p_RPU_C0;
	/**
	 * @brief  DoubleBuffer ON、DMAR0制御 ON
	 */
	unsigned int* p_RPU_DMA_ACT;
	/**
	 * @brief  Encordモード設定(NR_DMAR_OFST後にON？NR機能仕様書p8)
	 */
	unsigned int* p_NR_ISP_MODE;
	/**
	 * @brief  GDU REG_AUDIO_HOST_RES_ID_REQスタートアドレス
	 */
	unsigned int* p_REG_AUDIO_HOST_RES_ID_REQ;
	/**
	 * @brief  GDU REG_AUDIO_HOST_RES_ARG00スタートアドレス
	 */
	unsigned int* p_REG_AUDIO_HOST_RES_ARG00;
	/**
	 * @brief  GDU REG_AUDIO_HOST_RES_ARG01スタートアドレス
	 */
	unsigned int* p_REG_AUDIO_HOST_RES_ARG01;
	/**
	 * @brief  GDU REG_AUDIO_HOST_RES_ARG02スタートアドレス
	 */
	unsigned int* p_REG_AUDIO_HOST_RES_ARG02;
	/**
	 * @brief  GDU REG_AUDIO_HOST_RES_ARG03スタートアドレス
	 */
	unsigned int* p_REG_AUDIO_HOST_RES_ARG03;
#ifdef PARASOFT_CPPTEST
	unsigned int CPPTEST_checkValue;
#endif // PARASOFT_CPPTEST
};

#endif /* A_X_H_PIXCESSOR_INT_H_ */
