/**
 * @file   AXHRegAddr.hpp
 * @brief  Header file of Register Address
 * @par    Programming Language
 *         C++
 */

#ifndef A_X_H_REGADDR_H
#define A_X_H_REGADDR_H

#include "AXHCommonConfig.hpp"

typedef unsigned long   UInt32;

#define GetReg32(reg)           (*(volatile UInt32*)(reg))
#define SetReg32(reg,val)       (*(volatile UInt32*)(reg)=(val))


//#define AXH_ADR_SPAD_BASE       0x20000000ul
#define AXH_ADR_REG_BASE        0x40000000ul	//0x30000000ul
#define AXH_ADR_MEM_BASE        0x40000000ul

#define AXH_REG_IMG_ISI_BASE    (AXH_ADR_REG_BASE + 0x01110000ul)
#define AXH_REG_ISP_CORE_BASE   (AXH_ADR_REG_BASE + 0x00070000ul)	//0x01170000ul)
#define AXH_REG_AUDDSP_BASE     (AXH_ADR_REG_BASE + 0x01500000ul)

#define AXH_P_MIX_BASE          (AXH_REG_IMG_ISI_BASE + 0x00004000ul)
#define AXH_P_SPB_BASE          (AXH_REG_IMG_ISI_BASE + 0x00005000ul)
#define AXH_P_SPU_BASE          (AXH_REG_IMG_ISI_BASE + 0x00006000ul)

#define AXH_REG_ISP_RPU_BASE    (AXH_REG_ISP_CORE_BASE + 0x00000000ul)
#define AXH_REG_ISP_SCL_BASE    (AXH_REG_ISP_CORE_BASE + 0x00008000ul)
#define AXH_REG_ISP_WDR_BASE    (AXH_REG_ISP_CORE_BASE + 0x0000c000ul)
#define AXH_REG_ISP_3DNR_BASE   (AXH_REG_ISP_CORE_BASE + 0x0000e000ul)


#define AXH_SPAD_OFST_IMG_AWB_0 (AXH_REG_ISP_CORE_BASE + 0x00004000ul)	//(AXH_ADR_SPAD_BASE + 0x00100000ul)
#define AXH_SPAD_OFST_IMG_AWB_1 (AXH_REG_ISP_CORE_BASE + 0x00004000ul)  //(AXH_ADR_SPAD_BASE + 0x00109600ul)
#define AXH_SPAD_OFST_IMG_AE0_0 (AXH_REG_ISP_CORE_BASE + 0x00004000ul)  //(AXH_ADR_SPAD_BASE + 0x00112C00ul)
#define AXH_SPAD_OFST_IMG_AE0_1 (AXH_REG_ISP_CORE_BASE + 0x00004000ul)  //(AXH_ADR_SPAD_BASE + 0x00113600ul)
#define AXH_SPAD_OFST_IMG_AE1_0 (AXH_REG_ISP_CORE_BASE + 0x00004000ul)  //(AXH_ADR_SPAD_BASE + 0x00114000ul)
#define AXH_SPAD_OFST_IMG_AE1_1 (AXH_REG_ISP_CORE_BASE + 0x00004000ul)  //(AXH_ADR_SPAD_BASE + 0x00114A00ul)


#define AXH_RegMIX_ACT          (AXH_P_MIX_BASE + 0x00000000ul)


#define AXH_RegSPU_ACT          (AXH_P_SPB_BASE + 0x00000000ul)
#define AXH_RegSPU_DMAR1_OFS    (AXH_P_SPB_BASE + 0x00000004ul)
#define AXH_RegSPU_DMAW0_OFS    (AXH_P_SPB_BASE + 0x00000008ul)
#define AXH_RegSPU_DMAW1_OFS    (AXH_P_SPB_BASE + 0x0000000cul)
#define AXH_RegSPU_DMAW0_LEN    (AXH_P_SPB_BASE + 0x00000018ul)
#define AXH_RegSPU_DMAW1_LEN    (AXH_P_SPB_BASE + 0x0000001cul)
#define AXH_RegAVEVER_MODE_SEL  (AXH_P_SPB_BASE + 0x00000038ul)
#define AXH_RegAVEVER_W_NUM     (AXH_P_SPB_BASE + 0x0000003cul)
#define AXH_RegAVEVER_W_SIZE    (AXH_P_SPB_BASE + 0x00000040ul)



#define AXH_RegSPU_C            (AXH_P_SPU_BASE + 0x00000014ul)
#define AXH_RegC0CS_L           (AXH_P_SPU_BASE + 0x00000020ul)
#define AXH_RegC0CS_H           (AXH_P_SPU_BASE + 0x00000024ul)
#define AXH_RegDL0              (AXH_P_SPU_BASE + 0x00000040ul)
#define AXH_RegDL1              (AXH_P_SPU_BASE + 0x00000044ul)
#define AXH_RegDL2              (AXH_P_SPU_BASE + 0x00000048ul)
#define AXH_RegDL3              (AXH_P_SPU_BASE + 0x0000004cul)
#define AXH_RegDL4              (AXH_P_SPU_BASE + 0x00000050ul)
#define AXH_RegDL5              (AXH_P_SPU_BASE + 0x00000054ul)
#define AXH_RegDL6              (AXH_P_SPU_BASE + 0x00000058ul)
#define AXH_RegDL7              (AXH_P_SPU_BASE + 0x0000005cul)

#define AXH_REG_WB0             (AXH_REG_ISP_CORE_BASE + 0x00000010ul)	// 今回１レジスタにRBが存在	(AXH_P_SPU_BASE + 0x00000060ul)
//#define AXH_REG_WB1             (AXH_P_SPU_BASE + 0x00000064ul)				// 使用している箇所が存在しないためコメントアウト
//#define AXH_REG_WB2             (AXH_P_SPU_BASE + 0x00000068ul)				// 今回AXH_REG_WB0側に存在するためコメントアウト
//#define AXH_REG_WB3             (AXH_P_SPU_BASE + 0x0000006cul)				// 使用している箇所が存在しないためコメントアウト
//#define AXH_REG_WB4             (AXH_P_SPU_BASE + 0x00000070ul)				// 使用している箇所が存在しないためコメントアウト
//#define AXH_REG_WB5             (AXH_P_SPU_BASE + 0x00000074ul)				// 使用している箇所が存在しないためコメントアウト
//#define AXH_REG_WB6             (AXH_P_SPU_BASE + 0x00000078ul)				// 使用している箇所が存在しないためコメントアウト
//#define AXH_REG_WB7             (AXH_P_SPU_BASE + 0x0000007cul)				// 使用している箇所が存在しないためコメントアウト
#define AXH_RegCOLOR_TMG        (AXH_P_SPU_BASE + 0x00000080ul)

#define AXH_RegCDEF0            (AXH_P_SPU_BASE + 0x00000198ul)
#define AXH_RegCDEF1            (AXH_P_SPU_BASE + 0x0000019Cul)
#define AXH_RegCDEF2            (AXH_P_SPU_BASE + 0x000001A0ul)
#define AXH_RegCDEF3            (AXH_P_SPU_BASE + 0x000001A4ul)
#define AXH_RegCDEF4            (AXH_P_SPU_BASE + 0x000001A8ul)
#define AXH_RegCDEF5            (AXH_P_SPU_BASE + 0x000001ACul)
#define AXH_RegCDEF6            (AXH_P_SPU_BASE + 0x000001B0ul)
#define AXH_RegCDEF7            (AXH_P_SPU_BASE + 0x000001B4ul)
#define AXH_RegCDEF8            (AXH_P_SPU_BASE + 0x000001B8ul)
#define AXH_RegCDEF9            (AXH_P_SPU_BASE + 0x000001BCul)
#define AXH_RegCDEF10           (AXH_P_SPU_BASE + 0x000001c0ul)
#define AXH_RegCDEF11           (AXH_P_SPU_BASE + 0x000001c4ul)
#define AXH_RegCDEF12           (AXH_P_SPU_BASE + 0x000001c8ul)
#define AXH_RegCDEF13           (AXH_P_SPU_BASE + 0x000001CCul)
#define AXH_RegCDEF14           (AXH_P_SPU_BASE + 0x000001D0ul)
#define AXH_RegCDEF15           (AXH_P_SPU_BASE + 0x000001D4ul)
#define AXH_RegOBEAH            (AXH_P_SPU_BASE + 0x000001e4ul)
#define AXH_RegOBEAV            (AXH_P_SPU_BASE + 0x000001e8ul)
#define AXH_RegOBCRR0           (AXH_P_SPU_BASE + 0x000001ecul)
#define AXH_RegOBCRR1           (AXH_P_SPU_BASE + 0x000001f0ul)
#define AXH_RegOBCRR2           (AXH_P_SPU_BASE + 0x000001f4ul)
#define AXH_RegOBCRR3           (AXH_P_SPU_BASE + 0x000001f8ul)
#define AXH_RegDEFCT_C          (AXH_P_SPU_BASE + 0x00000214ul)
#define AXH_RegADFOFS_1A        (AXH_P_SPU_BASE + 0x00000218ul)
#define AXH_RegADFOFS_2A        (AXH_P_SPU_BASE + 0x0000021Cul)
#define AXH_RegADFOFS_3A        (AXH_P_SPU_BASE + 0x00000220ul)
#define AXH_RegADFOFS_4A        (AXH_P_SPU_BASE + 0x00000224ul)
#define AXH_RegADFOFS_5A        (AXH_P_SPU_BASE + 0x00000228ul)
#define AXH_RegADFOFS_6A        (AXH_P_SPU_BASE + 0x0000022Cul)
#define AXH_RegADFOFS_7A        (AXH_P_SPU_BASE + 0x00000230ul)
#define AXH_RegADFOFS_8A        (AXH_P_SPU_BASE + 0x00000234ul)
#define AXH_RegADFOFSZ          (AXH_P_SPU_BASE + 0x00000238ul)
#define AXH_RegADFCTTH          (AXH_P_SPU_BASE + 0x0000023Cul)
#define AXH_RegADFCTTH_H        (AXH_P_SPU_BASE + 0x00000240ul)
#define AXH_RegADFCTTH_L        (AXH_P_SPU_BASE + 0x00000244ul)
#define AXH_RegADFCTEGTH        (AXH_P_SPU_BASE + 0x00000248ul)
#define AXH_RegADFCT_CT         (AXH_P_SPU_BASE + 0x0000024cul)


#define AXH_RPU_C0              (AXH_REG_ISP_RPU_BASE + 0x00000000ul)
#define AXH_RPU_IDM             (AXH_REG_ISP_RPU_BASE + 0x00000004ul)
#define AXH_RPU_ID0             (AXH_REG_ISP_RPU_BASE + 0x00000008ul)
#define AXH_RPU_ID1             (AXH_REG_ISP_RPU_BASE + 0x0000000Cul)
#define AXH_RPU_ID2             (AXH_REG_ISP_RPU_BASE + 0x00000010ul)
#define AXH_RPU_ID3             (AXH_REG_ISP_RPU_BASE + 0x00000014ul)
#define AXH_RPU_ID4             (AXH_REG_ISP_RPU_BASE + 0x00000018ul)
#define AXH_RPU_ODM             (AXH_REG_ISP_RPU_BASE + 0x0000001Cul)
#define AXH_RPU_OD0             (AXH_REG_ISP_RPU_BASE + 0x00000020ul)
#define AXH_RPU_OD1             (AXH_REG_ISP_RPU_BASE + 0x00000024ul)
#define AXH_RPU_OD2             (AXH_REG_ISP_RPU_BASE + 0x00000028ul)
#define AXH_RPU_OD3             (AXH_REG_ISP_RPU_BASE + 0x0000002Cul)
#define AXH_RG_GMOF0_00         (AXH_REG_ISP_RPU_BASE + 0x00000160ul)
#define AXH_RG_GMOF1_00         (AXH_REG_ISP_RPU_BASE + 0x00000264ul)
#define AXH_RG_GMOF2_00         (AXH_REG_ISP_RPU_BASE + 0x00000368ul)
#define AXH_SPP_C               (AXH_REG_ISP_RPU_BASE + 0x00000058ul)
#define AXH_SPPOB0              (AXH_REG_ISP_RPU_BASE + 0x0000005Cul)
#define AXH_SPPOB1              (AXH_REG_ISP_RPU_BASE + 0x00000060ul)
#define AXH_SPPOB2              (AXH_REG_ISP_RPU_BASE + 0x00000064ul)
#define AXH_SPPOB3              (AXH_REG_ISP_RPU_BASE + 0x00000068ul)
#define AXH_SPPWB0              (AXH_REG_ISP_RPU_BASE + 0x0000006Cul)
#define AXH_SPPWB1              (AXH_REG_ISP_RPU_BASE + 0x00000070ul)
#define AXH_SPPWB2              (AXH_REG_ISP_RPU_BASE + 0x00000074ul)
#define AXH_SPPWB3              (AXH_REG_ISP_RPU_BASE + 0x00000078ul)
#define AXH_LCC01A              (AXH_REG_ISP_RPU_BASE + 0x0000007Cul)
#define AXH_LCC23A              (AXH_REG_ISP_RPU_BASE + 0x00000080ul)
#define AXH_LCC01B              (AXH_REG_ISP_RPU_BASE + 0x00000084ul)
#define AXH_LCC23B              (AXH_REG_ISP_RPU_BASE + 0x00000088ul)
#define AXH_SPPVAL              (AXH_REG_ISP_RPU_BASE + 0x0000008Cul)
#define AXH_SPP_C2              (AXH_REG_ISP_RPU_BASE + 0x00000090ul)
#define AXH_SPP_VAL2            (AXH_REG_ISP_RPU_BASE + 0x00000094ul)
#define AXH_SPP_VAL3            (AXH_REG_ISP_RPU_BASE + 0x00000098ul)
#define AXH_SPP_VAL4            (AXH_REG_ISP_RPU_BASE + 0x0000009Cul)
#define AXH_SPP_VAL5            (AXH_REG_ISP_RPU_BASE + 0x000000A0ul)
#define AXH_SPP_VAL6            (AXH_REG_ISP_RPU_BASE + 0x000000A4ul)
#define AXH_SPP_SHT0            (AXH_REG_ISP_RPU_BASE + 0x000000A8ul)
#define AXH_SPP_SHT1            (AXH_REG_ISP_RPU_BASE + 0x000000ACul)
#define AXH_SPP_SHT2            (AXH_REG_ISP_RPU_BASE + 0x000000B0ul)
#define AXH_LMCF00              (AXH_REG_ISP_RPU_BASE + 0x0000010Cul)
#define AXH_LMCF01              (AXH_REG_ISP_RPU_BASE + 0x00000110ul)
#define AXH_LMCF02              (AXH_REG_ISP_RPU_BASE + 0x00000114ul)
#define AXH_LMCF03              (AXH_REG_ISP_RPU_BASE + 0x00000118ul)
#define AXH_LMCF10              (AXH_REG_ISP_RPU_BASE + 0x0000011Cul)
#define AXH_LMCF11              (AXH_REG_ISP_RPU_BASE + 0x00000120ul)
#define AXH_LMCF12              (AXH_REG_ISP_RPU_BASE + 0x00000124ul)
#define AXH_LMCF13              (AXH_REG_ISP_RPU_BASE + 0x00000128ul)
#define AXH_LMCF20              (AXH_REG_ISP_RPU_BASE + 0x0000012Cul)
#define AXH_LMCF21              (AXH_REG_ISP_RPU_BASE + 0x00000130ul)
#define AXH_LMCF22              (AXH_REG_ISP_RPU_BASE + 0x00000134ul)
#define AXH_LMCF23              (AXH_REG_ISP_RPU_BASE + 0x00000138ul)
#define AXH_LMCF30              (AXH_REG_ISP_RPU_BASE + 0x0000013Cul)
#define AXH_LMCF31              (AXH_REG_ISP_RPU_BASE + 0x00000140ul)
#define AXH_LMCF32              (AXH_REG_ISP_RPU_BASE + 0x00000144ul)
#define AXH_LMCF33              (AXH_REG_ISP_RPU_BASE + 0x00000148ul)
#define AXH_LMOF0               (AXH_REG_ISP_RPU_BASE + 0x0000014Cul)
#define AXH_LMOF1               (AXH_REG_ISP_RPU_BASE + 0x00000150ul)
#define AXH_LMOF2               (AXH_REG_ISP_RPU_BASE + 0x00000154ul)
#define AXH_LMOF3               (AXH_REG_ISP_RPU_BASE + 0x00000158ul)
#define AXH_LMBC                (AXH_REG_ISP_RPU_BASE + 0x0000015Cul)
#define AXH_SAC_C00             (AXH_REG_ISP_RPU_BASE + 0x00000664ul)
#define AXH_SAC_C10             (AXH_REG_ISP_RPU_BASE + 0x0000066Cul)
#define AXH_SAC_C20             (AXH_REG_ISP_RPU_BASE + 0x00000670ul)
#define AXH_SAC_C30             (AXH_REG_ISP_RPU_BASE + 0x00000674ul)

#define AXH_C0COR               (AXH_REG_ISP_RPU_BASE + 0x000006FCul)

#define AXH_HPYOFS_L3A_0        (AXH_REG_ISP_RPU_BASE + 0x00000718ul)
#define AXH_HPYOFS_L3A_1        (AXH_REG_ISP_RPU_BASE + 0x0000071Cul)
#define AXH_HPYOFS_L3A_2        (AXH_REG_ISP_RPU_BASE + 0x00000720ul)

#define AXH_SAC_VAL00           (AXH_REG_ISP_RPU_BASE + 0x0000073Cul)
#define AXH_SAC_VAL01           (AXH_REG_ISP_RPU_BASE + 0x00000740ul)
#define AXH_SAC_VAL02           (AXH_REG_ISP_RPU_BASE + 0x00000744ul)

#define AXH_SAC_VAL10           (AXH_REG_ISP_RPU_BASE + 0x00000750ul)
#define AXH_SAC_VAL20           (AXH_REG_ISP_RPU_BASE + 0x00000758ul)
#define AXH_SAC_VAL30           (AXH_REG_ISP_RPU_BASE + 0x00000760ul)
#define AXH_LUT_ACS             (AXH_REG_ISP_RPU_BASE + 0x00000794ul)
#define AXH_RSZ_C0              (AXH_REG_ISP_RPU_BASE + 0x00000798ul)
#define AXH_RG_RZ_CSCF00        (AXH_REG_ISP_RPU_BASE + 0x000007A4ul)
#define AXH_RG_RZ_CSCF01        (AXH_REG_ISP_RPU_BASE + 0x000007A8ul)
#define AXH_RG_RZ_CSCF02        (AXH_REG_ISP_RPU_BASE + 0x000007ACul)
#define AXH_RG_RZ_CSCF03        (AXH_REG_ISP_RPU_BASE + 0x000007B0ul)
#define AXH_RG_RZ_CSCF10        (AXH_REG_ISP_RPU_BASE + 0x000007B4ul)
#define AXH_RG_RZ_CSCF11        (AXH_REG_ISP_RPU_BASE + 0x000007B8ul)
#define AXH_RG_RZ_CSCF12        (AXH_REG_ISP_RPU_BASE + 0x000007BCul)
#define AXH_RG_RZ_CSCF13        (AXH_REG_ISP_RPU_BASE + 0x000007C0ul)
#define AXH_RG_RZ_CSCF20        (AXH_REG_ISP_RPU_BASE + 0x000007C4ul)
#define AXH_RG_RZ_CSCF21        (AXH_REG_ISP_RPU_BASE + 0x000007C8ul)
#define AXH_RG_RZ_CSCF22        (AXH_REG_ISP_RPU_BASE + 0x000007CCul)
#define AXH_RG_RZ_CSCF23        (AXH_REG_ISP_RPU_BASE + 0x000007D0ul)
#define AXH_RG_RZ_CSCF30        (AXH_REG_ISP_RPU_BASE + 0x000007D4ul)
#define AXH_RG_RZ_CSCF31        (AXH_REG_ISP_RPU_BASE + 0x000007D8ul)
#define AXH_RG_RZ_CSCF32        (AXH_REG_ISP_RPU_BASE + 0x000007DCul)
#define AXH_RG_RZ_CSCF33        (AXH_REG_ISP_RPU_BASE + 0x000007E0ul)
#define AXH_RG_RZ_CSOS0         (AXH_REG_ISP_RPU_BASE + 0x000007E4ul)
#define AXH_RG_RZ_CSOS1         (AXH_REG_ISP_RPU_BASE + 0x000007E8ul)
#define AXH_RG_RZ_CSOS2         (AXH_REG_ISP_RPU_BASE + 0x000007ECul)
#define AXH_RG_RZ_CSOS3         (AXH_REG_ISP_RPU_BASE + 0x000007F0ul)
#define AXH_RG_RZ_CSBC          (AXH_REG_ISP_RPU_BASE + 0x000007F4ul)
#define AXH_RG_RZ_CSCFB00       (AXH_REG_ISP_RPU_BASE + 0x00000B44ul)
#define AXH_RG_RZ_CSCFB01       (AXH_REG_ISP_RPU_BASE + 0x00000B48ul)
#define AXH_RG_RZ_CSCFB02       (AXH_REG_ISP_RPU_BASE + 0x00000B4Cul)
#define AXH_RG_RZ_CSCFB03       (AXH_REG_ISP_RPU_BASE + 0x00000B50ul)
#define AXH_RG_RZ_CSCFB10       (AXH_REG_ISP_RPU_BASE + 0x00000B54ul)
#define AXH_RG_RZ_CSCFB11       (AXH_REG_ISP_RPU_BASE + 0x00000B58ul)
#define AXH_RG_RZ_CSCFB12       (AXH_REG_ISP_RPU_BASE + 0x00000B5Cul)
#define AXH_RG_RZ_CSCFB13       (AXH_REG_ISP_RPU_BASE + 0x00000B60ul)
#define AXH_RG_RZ_CSCFB20       (AXH_REG_ISP_RPU_BASE + 0x00000B64ul)
#define AXH_RG_RZ_CSCFB21       (AXH_REG_ISP_RPU_BASE + 0x00000B68ul)
#define AXH_RG_RZ_CSCFB22       (AXH_REG_ISP_RPU_BASE + 0x00000B6Cul)
#define AXH_RG_RZ_CSCFB23       (AXH_REG_ISP_RPU_BASE + 0x00000B70ul)
#define AXH_RG_RZ_CSCFB30       (AXH_REG_ISP_RPU_BASE + 0x00000B74ul)
#define AXH_RG_RZ_CSCFB31       (AXH_REG_ISP_RPU_BASE + 0x00000B78ul)
#define AXH_RG_RZ_CSCFB32       (AXH_REG_ISP_RPU_BASE + 0x00000B7Cul)
#define AXH_RG_RZ_CSCFB33       (AXH_REG_ISP_RPU_BASE + 0x00000B80ul)
#define AXH_RG_RZ_CSCFC00       (AXH_REG_ISP_RPU_BASE + 0x00000B84ul)
#define AXH_RG_RZ_CSCFC01       (AXH_REG_ISP_RPU_BASE + 0x00000B88ul)
#define AXH_RG_RZ_CSCFC02       (AXH_REG_ISP_RPU_BASE + 0x00000B8Cul)
#define AXH_RG_RZ_CSCFC03       (AXH_REG_ISP_RPU_BASE + 0x00000B90ul)
#define AXH_RG_RZ_CSCFC10       (AXH_REG_ISP_RPU_BASE + 0x00000B94ul)
#define AXH_RG_RZ_CSCFC11       (AXH_REG_ISP_RPU_BASE + 0x00000B98ul)
#define AXH_RG_RZ_CSCFC12       (AXH_REG_ISP_RPU_BASE + 0x00000B9Cul)
#define AXH_RG_RZ_CSCFC13       (AXH_REG_ISP_RPU_BASE + 0x00000BA0ul)
#define AXH_RG_RZ_CSCFC20       (AXH_REG_ISP_RPU_BASE + 0x00000BA4ul)
#define AXH_RG_RZ_CSCFC21       (AXH_REG_ISP_RPU_BASE + 0x00000BA8ul)
#define AXH_RG_RZ_CSCFC22       (AXH_REG_ISP_RPU_BASE + 0x00000BACul)
#define AXH_RG_RZ_CSCFC23       (AXH_REG_ISP_RPU_BASE + 0x00000BB0ul)
#define AXH_RG_RZ_CSCFC30       (AXH_REG_ISP_RPU_BASE + 0x00000BB4ul)
#define AXH_RG_RZ_CSCFC31       (AXH_REG_ISP_RPU_BASE + 0x00000BB8ul)
#define AXH_RG_RZ_CSCFC32       (AXH_REG_ISP_RPU_BASE + 0x00000BBCul)
#define AXH_RG_RZ_CSCFC33       (AXH_REG_ISP_RPU_BASE + 0x00000BC0ul)
#define AXH_RG_RZ_CSCFD00       (AXH_REG_ISP_RPU_BASE + 0x00000BC4ul)
#define AXH_RG_RZ_CSCFD01       (AXH_REG_ISP_RPU_BASE + 0x00000BC8ul)
#define AXH_RG_RZ_CSCFD02       (AXH_REG_ISP_RPU_BASE + 0x00000BCCul)
#define AXH_RG_RZ_CSCFD03       (AXH_REG_ISP_RPU_BASE + 0x00000BD0ul)
#define AXH_RG_RZ_CSCFD10       (AXH_REG_ISP_RPU_BASE + 0x00000BD4ul)
#define AXH_RG_RZ_CSCFD11       (AXH_REG_ISP_RPU_BASE + 0x00000BD8ul)
#define AXH_RG_RZ_CSCFD12       (AXH_REG_ISP_RPU_BASE + 0x00000BDCul)
#define AXH_RG_RZ_CSCFD13       (AXH_REG_ISP_RPU_BASE + 0x00000BE0ul)
#define AXH_RG_RZ_CSCFD20       (AXH_REG_ISP_RPU_BASE + 0x00000BE4ul)
#define AXH_RG_RZ_CSCFD21       (AXH_REG_ISP_RPU_BASE + 0x00000BE8ul)
#define AXH_RG_RZ_CSCFD22       (AXH_REG_ISP_RPU_BASE + 0x00000BECul)
#define AXH_RG_RZ_CSCFD23       (AXH_REG_ISP_RPU_BASE + 0x00000BF0ul)
#define AXH_RG_RZ_CSCFD30       (AXH_REG_ISP_RPU_BASE + 0x00000BF4ul)
#define AXH_RG_RZ_CSCFD31       (AXH_REG_ISP_RPU_BASE + 0x00000BF8ul)
#define AXH_RG_RZ_CSCFD32       (AXH_REG_ISP_RPU_BASE + 0x00000BFCul)
#define AXH_RG_RZ_CSCFD33       (AXH_REG_ISP_RPU_BASE + 0x00000C00ul)
#define AXH_LUT_H1_000          (AXH_REG_ISP_RPU_BASE + 0x00001200ul)
#define AXH_LUT_3A_000          (AXH_REG_ISP_RPU_BASE + 0x00001800ul)
#define AXH_LUT_3B_000          (AXH_REG_ISP_RPU_BASE + 0x00001C00ul)

#define AXH_REG_ISP_SCL_CTL             (AXH_REG_ISP_SCL_BASE + 0x00000000ul)
#define AXH_REG_ISP_SCL_SATD8X8         (AXH_REG_ISP_SCL_BASE + 0x00000020ul)

#define AXH_REG_ISP_SCL_SRC0            (AXH_REG_ISP_SCL_BASE + 0x00000040ul)
#define AXH_REG_ISP_SCL_DST0            (AXH_REG_ISP_SCL_BASE + 0x00000044ul)
#define AXH_REG_ISP_SCL_DMA0            (AXH_REG_ISP_SCL_BASE + 0x00000048ul)
#define AXH_REG_ISP_SCL_NEG_FLIP0       (AXH_REG_ISP_SCL_BASE + 0x0000004cul)
#define AXH_REG_ISP_SCL_CLIP0           (AXH_REG_ISP_SCL_BASE + 0x00000050ul)
// dont use                             (AXH_REG_ISP_SCL_BASE + 0x00000054ul)
// ~                                    (AXH_REG_ISP_SCL_BASE + 0x0000005cul)
#define AXH_REG_ISP_SCL_SRC1            (AXH_REG_ISP_SCL_BASE + 0x00000060ul)
#define AXH_REG_ISP_SCL_DST1            (AXH_REG_ISP_SCL_BASE + 0x00000064ul)
#define AXH_REG_ISP_SCL_DMA1            (AXH_REG_ISP_SCL_BASE + 0x00000068ul)
#define AXH_REG_ISP_SCL_NEG_FLIP1       (AXH_REG_ISP_SCL_BASE + 0x0000006cul)
#define AXH_REG_ISP_SCL_CLIP1           (AXH_REG_ISP_SCL_BASE + 0x00000070ul)
// dont use                             (AXH_REG_ISP_SCL_BASE + 0x00000074ul)
// ~                                    (AXH_REG_ISP_SCL_BASE + 0x0000007cul)
#define AXH_REG_ISP_SCL_SRC2            (AXH_REG_ISP_SCL_BASE + 0x00000080ul)
#define AXH_REG_ISP_SCL_DST2            (AXH_REG_ISP_SCL_BASE + 0x00000084ul)
#define AXH_REG_ISP_SCL_DMA2            (AXH_REG_ISP_SCL_BASE + 0x00000088ul)
#define AXH_REG_ISP_SCL_NEG_FLIP2       (AXH_REG_ISP_SCL_BASE + 0x0000008cul)
#define AXH_REG_ISP_SCL_CLIP2           (AXH_REG_ISP_SCL_BASE + 0x00000090ul)
// dont use                             (AXH_REG_ISP_SCL_BASE + 0x00000094ul)
// ~                                    (AXH_REG_ISP_SCL_BASE + 0x0000009cul)
#define AXH_REG_ISP_SCL_SRC3            (AXH_REG_ISP_SCL_BASE + 0x000000a0ul)
// dont use(AXH_REG_ISP_SCL_DST3)       (AXH_REG_ISP_SCL_BASE + 0x000000a4ul)
#define AXH_REG_ISP_SCL_DMA3            (AXH_REG_ISP_SCL_BASE + 0x000000a8ul)
#define AXH_REG_ISP_SCL_NEG_FLIP3       (AXH_REG_ISP_SCL_BASE + 0x000000acul)
#define AXH_REG_ISP_SCL_CLIP3           (AXH_REG_ISP_SCL_BASE + 0x000000b0ul)
// dont use                             (AXH_REG_ISP_SCL_BASE + 0x000000b4ul)
// ~                                    (AXH_REG_ISP_SCL_BASE + 0x000000bcul)
#define AXH_REG_ISP_SCL_SRC4            (AXH_REG_ISP_SCL_BASE + 0x000000c0ul)
// dont use(AXH_REG_ISP_SCL_DST4)       (AXH_REG_ISP_SCL_BASE + 0x000000c4ul)
#define AXH_REG_ISP_SCL_DMA4            (AXH_REG_ISP_SCL_BASE + 0x000000c8ul)
#define AXH_REG_ISP_SCL_NEG_FLIP4       (AXH_REG_ISP_SCL_BASE + 0x000000ccul)
#define AXH_REG_ISP_SCL_CLIP4           (AXH_REG_ISP_SCL_BASE + 0x000000d0ul)
// dont use                             (AXH_REG_ISP_SCL_BASE + 0x000000d4ul)
// ~                                    (AXH_REG_ISP_SCL_BASE + 0x000000dcul)
#define AXH_REG_ISP_SCL_SRC5            (AXH_REG_ISP_SCL_BASE + 0x000000e0ul)
#define AXH_REG_ISP_SCL_DST5            (AXH_REG_ISP_SCL_BASE + 0x000000e4ul)
#define AXH_REG_ISP_SCL_IMGRAM          (AXH_REG_ISP_SCL_BASE + 0x000000e8ul)
// dont use(AXH_REG_ISP_SCL_NEG_FLIP5)  (AXH_REG_ISP_SCL_BASE + 0x000000ecul)
// dont use(AXH_REG_ISP_SCL_CLIP5)      (AXH_REG_ISP_SCL_BASE + 0x000000f0ul)
#define AXH_REG_ISP_SCL_IMG_ID          (AXH_REG_ISP_SCL_BASE + 0x000000f4ul)

#define AXH_IR_LEN                      (AXH_REG_ISP_WDR_BASE + 0x00000000ul)
#define AXH_IR_DITHER                   (AXH_REG_ISP_WDR_BASE + 0x00000004ul)
#define AXH_IR_SLOPE                    (AXH_REG_ISP_WDR_BASE + 0x00000008ul)
#define AXH_IR_LEVEL                    (AXH_REG_ISP_WDR_BASE + 0x0000000cul)
#define AXH_IR_CONTROL                  (AXH_REG_ISP_WDR_BASE + 0x00000010ul)
#define AXH_IR_STRENGTH                 (AXH_REG_ISP_WDR_BASE + 0x00000014ul)
#define AXH_IR_LUT_FI_ADR               (AXH_REG_ISP_WDR_BASE + 0x00000018ul)
#define AXH_IR_LUT_FI_DATA              (AXH_REG_ISP_WDR_BASE + 0x0000001cul)
#define AXH_IR_FWD_PERCEPT_LUT_ADR      (AXH_REG_ISP_WDR_BASE + 0x00000020ul)
#define AXH_IR_FWD_PERCEPT_LUT_DATA     (AXH_REG_ISP_WDR_BASE + 0x00000024ul)
#define AXH_IR_FWD_PERCEPT_LUT_EN       (AXH_REG_ISP_WDR_BASE + 0x00000028ul)
#define AXH_IR_REV_PERCEPT_LUT_ADR      (AXH_REG_ISP_WDR_BASE + 0x0000002cul)
#define AXH_IR_REV_PERCEPT_LUT_DATA     (AXH_REG_ISP_WDR_BASE + 0x00000030ul)
#define AXH_IR_REV_PERCEPT_LUT_EN       (AXH_REG_ISP_WDR_BASE + 0x00000034ul)
#define AXH_IR_RGGB_START               (AXH_REG_ISP_WDR_BASE + 0x00000038ul)
#define AXH_IR_WBGAIN0                  (AXH_REG_ISP_WDR_BASE + 0x0000003cul)
#define AXH_IR_WBGAIN1                  (AXH_REG_ISP_WDR_BASE + 0x00000040ul)
#define AXH_IR_IFCONTROL                (AXH_REG_ISP_WDR_BASE + 0x00000044ul)

//  3DNR Register
#define AXH_NR_HLEN                     (AXH_REG_ISP_3DNR_BASE + 0x00000000ul)
#define AXH_NR_VLEN                     (AXH_REG_ISP_3DNR_BASE + 0x00000004ul)
#define AXH_NR_BLANK                    (AXH_REG_ISP_3DNR_BASE + 0x00000008ul)
#define AXH_NR_EN                       (AXH_REG_ISP_3DNR_BASE + 0x0000000cul)
#define AXH_NR_MAIN_YTH0                (AXH_REG_ISP_3DNR_BASE + 0x00000010ul)
#define AXH_NR_MAIN_YTH1                (AXH_REG_ISP_3DNR_BASE + 0x00000014ul)
#define AXH_NR_MAIN_YTH2                (AXH_REG_ISP_3DNR_BASE + 0x00000018ul)
#define AXH_NR_MAIN_YTH3                (AXH_REG_ISP_3DNR_BASE + 0x0000001cul)
#define AXH_NR_MAIN_CTH0                (AXH_REG_ISP_3DNR_BASE + 0x00000020ul)
#define AXH_NR_MAIN_CTH1                (AXH_REG_ISP_3DNR_BASE + 0x00000024ul)
#define AXH_NR_MAIN_CTH2                (AXH_REG_ISP_3DNR_BASE + 0x00000028ul)
#define AXH_NR_MAIN_CTH3                (AXH_REG_ISP_3DNR_BASE + 0x0000002cul)
#define AXH_NR_MAIN_YIN0                (AXH_REG_ISP_3DNR_BASE + 0x00000030ul)
#define AXH_NR_MAIN_YIN1                (AXH_REG_ISP_3DNR_BASE + 0x00000034ul)
#define AXH_NR_MAIN_YIN2                (AXH_REG_ISP_3DNR_BASE + 0x00000038ul)
#define AXH_NR_MAIN_YIN3                (AXH_REG_ISP_3DNR_BASE + 0x0000003cul)
#define AXH_NR_MAIN_CIN0                (AXH_REG_ISP_3DNR_BASE + 0x00000040ul)
#define AXH_NR_MAIN_CIN1                (AXH_REG_ISP_3DNR_BASE + 0x00000044ul)
#define AXH_NR_MAIN_CIN2                (AXH_REG_ISP_3DNR_BASE + 0x00000048ul)
#define AXH_NR_MAIN_CIN3                (AXH_REG_ISP_3DNR_BASE + 0x0000004cul)
#define AXH_NR_SUB_YTH                  (AXH_REG_ISP_3DNR_BASE + 0x00000050ul)
#define AXH_NR_SUB_CTH                  (AXH_REG_ISP_3DNR_BASE + 0x00000054ul)
#define AXH_NR_SUB_YIN                  (AXH_REG_ISP_3DNR_BASE + 0x00000058ul)
#define AXH_NR_SUB_CIN                  (AXH_REG_ISP_3DNR_BASE + 0x0000005cul)
#define AXH_NR_MAIN_YLV0                (AXH_REG_ISP_3DNR_BASE + 0x00000060ul)
#define AXH_NR_MAIN_YLV1                (AXH_REG_ISP_3DNR_BASE + 0x00000064ul)
#define AXH_NR_MAIN_YLV2                (AXH_REG_ISP_3DNR_BASE + 0x00000068ul)
#define AXH_NR_MAIN_YLV3                (AXH_REG_ISP_3DNR_BASE + 0x0000006cul)
#define AXH_NR_MAIN_CLV0                (AXH_REG_ISP_3DNR_BASE + 0x00000070ul)
#define AXH_NR_MAIN_CLV1                (AXH_REG_ISP_3DNR_BASE + 0x00000074ul)
#define AXH_NR_MAIN_CLV2                (AXH_REG_ISP_3DNR_BASE + 0x00000078ul)
#define AXH_NR_MAIN_CLV3                (AXH_REG_ISP_3DNR_BASE + 0x0000007cul)
#define AXH_NR_SUB_YLV                  (AXH_REG_ISP_3DNR_BASE + 0x00000080ul)
#define AXH_NR_SUB_CLV                  (AXH_REG_ISP_3DNR_BASE + 0x00000084ul)
#define AXH_RPU_DMA_ACT                 (AXH_REG_ISP_3DNR_BASE + 0x00000088ul)
#define AXH_RPU_DMAR0_OFS               (AXH_REG_ISP_3DNR_BASE + 0x0000008cul)
#define AXH_RPU_DMAR0_FMT               (AXH_REG_ISP_3DNR_BASE + 0x00000090ul)
#define AXH_RPU_DMAR1_OFS               (AXH_REG_ISP_3DNR_BASE + 0x00000094ul)
#define AXH_RPU_DMAR1_FMT               (AXH_REG_ISP_3DNR_BASE + 0x00000098ul)
#define AXH_RPU_DMAW1_OFS               (AXH_REG_ISP_3DNR_BASE + 0x0000009cul)
#define AXH_RPU_DMAW1_LEN               (AXH_REG_ISP_3DNR_BASE + 0x000000a0ul)
#define AXH_NR_DMAR_OFS                 (AXH_REG_ISP_3DNR_BASE + 0x000000a4ul)
#define AXH_NR_ISP_MODE                 (AXH_REG_ISP_3DNR_BASE + 0x000000a8ul)


#define AXH_DRAM_OFST_IMG_SPU_0         (AXH_ADR_MEM_BASE + 0x32000000ul)
#define AXH_DRAM_OFST_IMG_SPU_1         (AXH_ADR_MEM_BASE + 0x323F6000ul)
#define AXH_DRAM_OFST_IMG_MIX_0         (AXH_ADR_MEM_BASE + 0x327EC000ul)
#define AXH_DRAM_OFST_IMG_MIX_1         (AXH_ADR_MEM_BASE + 0x32BE2000ul)
#define AXH_DRAM_OFST_IMG_DEF           (AXH_ADR_MEM_BASE + 0x32FD8000ul)
#ifdef USE_NON_ROM_ENV
#define AXH_DRAM_OFST_ISP_3A_0          (AXH_ADR_MEM_BASE + 0x05040000ul)
#define AXH_DRAM_OFST_ISP_3A_1          (AXH_ADR_MEM_BASE + 0x05050000ul)
#define AXH_DRAM_OFST_ISP_NR_0          (AXH_ADR_MEM_BASE + 0x05500000ul)
#define AXH_DRAM_OFST_ISP_NR_1          (AXH_ADR_MEM_BASE + 0x05900000ul)
// ch0
#define AXH_DRAM_OFST_ISP_SCL0_0        (AXH_ADR_MEM_BASE + 0x05D00000ul)
#define AXH_DRAM_OFST_ISP_SCL0_1        (AXH_ADR_MEM_BASE + 0x06100000ul)
// ENABLE_PIXCESSOR_MEM_BANK_6
// hdwのメモリが6bank割り当てられた時に変更が必要(2015/03/17時点で2bankの割り当てしかないので、bank2〜5にはbank0,bank1と同じアドレスを割り当てている)
#define AXH_DRAM_OFST_ISP_SCL0_2        (AXH_ADR_MEM_BASE + 0x05D00000ul)
#define AXH_DRAM_OFST_ISP_SCL0_3        (AXH_ADR_MEM_BASE + 0x06100000ul)
#define AXH_DRAM_OFST_ISP_SCL0_4        (AXH_ADR_MEM_BASE + 0x05D00000ul)
#define AXH_DRAM_OFST_ISP_SCL0_5        (AXH_ADR_MEM_BASE + 0x06100000ul)
// ch1
#define AXH_DRAM_OFST_ISP_SCL1_0        (AXH_ADR_MEM_BASE + 0x06500000ul)
#define AXH_DRAM_OFST_ISP_SCL1_1        (AXH_ADR_MEM_BASE + 0x06900000ul)
// ENABLE_PIXCESSOR_MEM_BANK_6
// hdwのメモリが6bank割り当てられた時に変更が必要(2015/03/17時点で2bankの割り当てしかないので、bank2〜5にはbank0,bank1と同じアドレスを割り当てている)
#define AXH_DRAM_OFST_ISP_SCL1_2        (AXH_ADR_MEM_BASE + 0x06500000ul)
#define AXH_DRAM_OFST_ISP_SCL1_3        (AXH_ADR_MEM_BASE + 0x06900000ul)
#define AXH_DRAM_OFST_ISP_SCL1_4        (AXH_ADR_MEM_BASE + 0x06500000ul)
#define AXH_DRAM_OFST_ISP_SCL1_5        (AXH_ADR_MEM_BASE + 0x06900000ul)
// ch2
#define AXH_DRAM_OFST_ISP_SCL2_0        (AXH_ADR_MEM_BASE + 0x06D00000ul)
#define AXH_DRAM_OFST_ISP_SCL2_1        (AXH_ADR_MEM_BASE + 0x07100000ul)
// ENABLE_PIXCESSOR_MEM_BANK_6
// hdwのメモリが6bank割り当てられた時に変更が必要(2015/03/17時点で2bankの割り当てしかないので、bank2〜5にはbank0,bank1と同じアドレスを割り当てている)
#define AXH_DRAM_OFST_ISP_SCL2_2        (AXH_ADR_MEM_BASE + 0x06D00000ul)
#define AXH_DRAM_OFST_ISP_SCL2_3        (AXH_ADR_MEM_BASE + 0x07100000ul)
#define AXH_DRAM_OFST_ISP_SCL2_4        (AXH_ADR_MEM_BASE + 0x06D00000ul)
#define AXH_DRAM_OFST_ISP_SCL2_5        (AXH_ADR_MEM_BASE + 0x07100000ul)
// ch3
#define AXH_DRAM_OFST_ISP_SCL3_0        (AXH_ADR_MEM_BASE + 0x07500000ul)
#define AXH_DRAM_OFST_ISP_SCL3_1        (AXH_ADR_MEM_BASE + 0x07900000ul)
// ENABLE_PIXCESSOR_MEM_BANK_6
// hdwのメモリが6bank割り当てられた時に変更が必要(2015/03/17時点で2bankの割り当てしかないので、bank2〜5にはbank0,bank1と同じアドレスを割り当てている)
#define AXH_DRAM_OFST_ISP_SCL3_2        (AXH_ADR_MEM_BASE + 0x07500000ul)
#define AXH_DRAM_OFST_ISP_SCL3_3        (AXH_ADR_MEM_BASE + 0x07900000ul)
#define AXH_DRAM_OFST_ISP_SCL3_4        (AXH_ADR_MEM_BASE + 0x07500000ul)
#define AXH_DRAM_OFST_ISP_SCL3_5        (AXH_ADR_MEM_BASE + 0x07900000ul)
#else   //  USE_NON_ROM_ENV
//#define AXH_DRAM_OFST_ISP_3A_0          (AXH_ADR_MEM_BASE + 0x05025c00ul)
//#define AXH_DRAM_OFST_ISP_3A_1          (AXH_ADR_MEM_BASE + 0x0502f200ul)
#define AXH_DRAM_OFST_ISP_NR_0          (AXH_ADR_MEM_BASE + 0x32FDC000ul)
#define AXH_DRAM_OFST_ISP_NR_1          (AXH_ADR_MEM_BASE + 0x333D2000ul)
#define AXH_DRAM_OFST_ISP_SCL0_0        (AXH_ADR_MEM_BASE + 0x337C8000ul)
#define AXH_DRAM_OFST_ISP_SCL0_1        (AXH_ADR_MEM_BASE + 0x33BBE000ul)
#define AXH_DRAM_OFST_ISP_SCL0_2        (AXH_ADR_MEM_BASE + 0x33FB4000ul)
#define AXH_DRAM_OFST_ISP_SCL0_3        (AXH_ADR_MEM_BASE + 0x343AA000ul)
#define AXH_DRAM_OFST_ISP_SCL0_4        (AXH_ADR_MEM_BASE + 0x347A0000ul)
#define AXH_DRAM_OFST_ISP_SCL0_5        (AXH_ADR_MEM_BASE + 0x34B96000ul)
#define AXH_DRAM_OFST_ISP_SCL1_0        (AXH_ADR_MEM_BASE + 0x34F8C000ul)
#define AXH_DRAM_OFST_ISP_SCL1_1        (AXH_ADR_MEM_BASE + 0x35022000ul)
#define AXH_DRAM_OFST_ISP_SCL1_2        (AXH_ADR_MEM_BASE + 0x350B8000ul)
#define AXH_DRAM_OFST_ISP_SCL1_3        (AXH_ADR_MEM_BASE + 0x3514E000ul)
#define AXH_DRAM_OFST_ISP_SCL1_4        (AXH_ADR_MEM_BASE + 0x351E4000ul)
#define AXH_DRAM_OFST_ISP_SCL1_5        (AXH_ADR_MEM_BASE + 0x3527A000ul)
#define AXH_DRAM_OFST_ISP_SCL2_0        (AXH_ADR_MEM_BASE + 0x35310000ul)
#define AXH_DRAM_OFST_ISP_SCL2_1        (AXH_ADR_MEM_BASE + 0x35342000ul)
#define AXH_DRAM_OFST_ISP_SCL2_2        (AXH_ADR_MEM_BASE + 0x35374000ul)
#define AXH_DRAM_OFST_ISP_SCL2_3        (AXH_ADR_MEM_BASE + 0x353A6000ul)
#define AXH_DRAM_OFST_ISP_SCL2_4        (AXH_ADR_MEM_BASE + 0x353D8000ul)
#define AXH_DRAM_OFST_ISP_SCL2_5        (AXH_ADR_MEM_BASE + 0x3540A000ul)
#define AXH_DRAM_OFST_ISP_SCL3_0        (AXH_ADR_MEM_BASE + 0x3543C000ul)
#define AXH_DRAM_OFST_ISP_SCL3_1        (AXH_ADR_MEM_BASE + 0x35832000ul)
#define AXH_DRAM_OFST_ISP_SCL3_2        (AXH_ADR_MEM_BASE + 0x35C28000ul)
#define AXH_DRAM_OFST_ISP_SCL3_3        (AXH_ADR_MEM_BASE + 0x3601E000ul)
#define AXH_DRAM_OFST_ISP_SCL3_4        (AXH_ADR_MEM_BASE + 0x36414000ul)
#define AXH_DRAM_OFST_ISP_SCL3_5        (AXH_ADR_MEM_BASE + 0x3680A000ul)
#endif
#define AXH_REG_AUDIO_HOST_RES_ID_REQ   (AXH_REG_AUDDSP_BASE + 0x00000028ul)
#define AXH_REG_AUDIO_HOST_RES_ARG00    (AXH_REG_AUDDSP_BASE + 0x0000002cul)
#define AXH_REG_AUDIO_HOST_RES_ARG01    (AXH_REG_AUDDSP_BASE + 0x00000030ul)
#define AXH_REG_AUDIO_HOST_RES_ARG02    (AXH_REG_AUDDSP_BASE + 0x00000034ul)
#define AXH_REG_AUDIO_HOST_RES_ARG03    (AXH_REG_AUDDSP_BASE + 0x00000038ul)

#endif  //  A_X_H_REGADDR_H
