/**
 * @file   AXHSpec.hpp
 * @brief  Header file of Spec class.
 * @par    Programming Language
 *         C++
 */
#ifndef AXH_SPEC_H
#define AXH_SPEC_H

/**
 * @enum	AXH_IRIDIX_MODE
 * @brief	IRIDIX設定モード定義
 */
typedef enum
{
  AXH_Spec_Mode_Default = 0,                                ///< SPECデフォルト値設定モード
  AXH_Spec_Mode_Normal                                      ///< SPEC通常モード
} AXH_SPEC_MODE;

/**
 * @class AXHSpec
 * @brief Spec class
 * 
 */
class AXHSpec {
 public:
  /**
   * @brief  オブジェクトを初期化する
   */
  AXHSpec();

  /**
   * @brief  オブジェクトを初期化する
   *
   * @param [in] mode 初期化モード
   */
  AXHSpec(AXH_SPEC_MODE mode);

  /**
   * @brief  オブジェクトを開放する
   */
  ~AXHSpec();

  /**
   * @brief デフォルト値設定
   */
  void setDefault();

  /**
   * @brief AWBデフォルト値設定
   */
  void setDefault_AWB();

  /**
   * @brief スケーラー機能デフォルト値設定
   */
  void setDefault_Scaler();

  /**
   * @brief OB調整デフォルト値設定
   */
  void setDefault_OB();

  /**
   * @brief ガンマ補正デフォルト値設定
   */
  void setDefault_Gamma();

  /**
   * @brief アパーチャ補正デフォルト値設定
   */
  void setDefault_Aperture();

  /**
   * @brief クロマサプレスデフォルト値設定
   */
  void setDefault_Chroma();

  /**
   * @brief AEデフォルト値設定
   */
  void setDefault_AE();

  /**
   * @brief AFデフォルト値設定
   */
  void setDefault_AF();

  /**
   * @brief ImageSensorデフォルト値設定
   */
  void setDefault_ImageSensor();

  /**
   * @brief DayNightデフォルト値設定
   */
  void setDefault_DayNight();

  /**
   * @brief 設定値格納先アドレス取得
   */
  void *getSpecAddr();

};
#endif
