/**
 * AdjSpec.h
 */
#ifndef _ADJSPEC_H_
#define _ADJSPEC_H_

#include "FreeRTOS.h"

#ifdef __cplusplus
extern "C" {
#endif	/* __cplusplus */
/***************************************************************
* Constants
***************************************************************/

#define ADJSP_CHANG_STATUS							0x20058000			// changeStatus
#define ADJSP_MODE											0x20058008			// Mode
#define ADJSP_AWB_MODE									0x2005800A			// AWB.AWBMode
#define ADJSP_AWB_ATW_SMODE							0x2005800B			// AWB.ATWSceaneMode
#define ADJSP_AWB_MANU_MODE_COLOR				0x2005800C			// AWB.ManuModeColorTemp
#define ADJSP_AWB_MANU_MODE_LIGHT_SEL		0x2005800E			// AWB.ManuModeLightSelect
#define ADJSP_AWB_OP_START							0x20058010			// AWB.OnePush.Start
#define ADJSP_AWB_OP_AREA								0x20058012			// AWB.OnePush.Area
#define ADJSP_AWB_OP_RANGE							0x2005801A			// AWB.OnePush.Range
#define ADJSP_AWB_OP_SPEED							0x2005801B			// AWB.OnePush.Speed
#define ADJSP_AWB_LIGHTRANGE_LTMPADJ		0x2005801E			// AWB.LightRange.LTempAdjust
#define ADJSP_AWB_LIGHTRANGE_HTMPADJ		0x2005801C			// AWB.LightRange.HTempAdjust
#define ADJSP_AWB_LIGHTRANGE_CPNT				0x20058020			// AWB.LightRange.CPnt
#define ADJSP_AWB_LIGHTRANGE_MGDIRADJ		0x20058028			// AWB.LightRange.MgDirAdjust
#define ADJSP_AWB_LIGHTRANGE_GDIRADJ		0x2005802A			// AWB.LightRange.GDirAdjust
#define ADJSP_AWB_OFF_PNT								0x2005802C			// AWB.Offset.Pnt
#define ADJSP_AWB_ADJMATRIX_MATRIX			0x2005805C			// AWB.AdjustMatrix
#define ADJSP_AWB_WBGAIN_RGAIN					0x200580BE			// AWB.WBGain.rGain
#define ADJSP_AWB_WBGAIN_BGAIN					0x200580BC			// AWB.WBGain.bGain
#define ADJSP_AWB_CONV_SPEED						0x200580C0			// AWB.Convergence.Speed
#define ADJSP_AWB_CONV_LIGHTTH					0x200580C2			// AWB.Convergence.LightTH
#define ADJSP_AWB_CONV_STABLETH					0x200580C4			// AWB.Convergence.StableTH
#define ADJSP_AWB_CONV_STABLETERM				0x200580C6			// AWB.Convergence.StableTern
#define ADJSP_AWB_LIGHTW_WAIGHT					0x200580C8			// AWB.LightWeight.Weight
#define ADJSP_AWB_STOPLOWBRIGHTTH				0x20058110			// AWB.stopLowBrightTH
#define ADJSP_AWB_OPDSET_HDIV						0x20058112			// AWB.OPDSet.Hdiv
#define ADJSP_AWB_OPDSET_VDIV						0x20058113			// AWB.OPDSet.Vdiv
#define ADJSP_AWB_OPDSET_HLIMIT					0x20058114			// AWB.OPDSet.Hlimit
#define ADJSP_AWB_OPDSET_LLIMIT					0x20058116			// AWB.OPDSet.Lllimit
#define ADJSP_AWB_OPDWEIGHT_V1					0x20058118			// AWB.OPDWeight.V1
#define ADJSP_AWB_OPDWEIGHT_H2					0x20058119			// AWB.OPDWeight.H2
#define ADJSP_AWB_OPDWAIGHT_H3					0x2005811A			// AWB.OPDWeight.H3
#define ADJSP_AWB_OPDWAIGHT_V4					0x2005811B			// AWB.OPDWeight.V4
#define ADJSP_AWB_OPDWAIGHT_MODE				0x2005811C			// AWB.OPDWeight.WeightMode
#define ADJSP_AWB_OPDMASK_PNT						0x20058121			// AWB.OPDMask.Pnt
#define ADJSP_AWB_SPECADJ_LOWSTART			0x200581EA			// AWB.SpectrumAdjust.regLowTempStart
#define ADJSP_AWB_SPECADJ_HIGHSTART			0x200581EB			// AWB.SpectrumAdjust.regHighTempStart
#define ADJSP_AWB_SPECADJ_PNTLOW_BG			0x200581EC			// AWB.SpectrumAdjust.pntLowTemp.Bg
#define ADJSP_AWB_SPECADJ_PNTLOW_RG			0x200581EE			// AWB.SpectrumAdjust.pntLowTemp.Rg
#define ADJSP_AWB_SPECADJ_PNTHIGH_BG		0x200581F0			// AWB.SpectrumAdjust.pntHighTemp.Bg
#define ADJSP_AWB_SPECADJ_PNTHIGH_RG		0x200581F2			// AWB.SpectrumAdjust.pntHighTemp.Rg
#define ADJSP_AWB_LIGHTSRC							0x200581F4			// AWB.LightSource
#define ADJSP_AWB_LIGHTDEF							0x200582E4			// AWB.LightDefault
#define ADJSP_AWB_OPDTRUST_TH						0x20058324			// AWB.OPDTrust.TH
#define ADJSP_AWB_OPDTRUST_SEL					0x20058326			// AWB.OPDTrust.Sel
#define ADJSP_AWB_OPDTRUST_ZERO					0x20058327			// AWB.OPDTrust.Zero
#define ADJSP_AWB_COLORMTX_MODE					0x20058328			// AWB.ColorMatrix.Mode
#define ADJSP_AWB_COLORMTX_MATRIX				0x2005832A			// AWB.ColorMatrix.Matrix
#define ADJSP_AWB_COLORMTX_CC11					0x2005834A			// AWB.ColorMatrix.CC11
#define ADJSP_AWB_COLORMTX_COF1					0x2005834C			// AWB.ColorMatrix.COF1
#define ADJSP_AE_MODE										0x20058350			// AE.AEMode
#define ADJSP_AE_FLICKER_ENABLE					0x20058351			// AE.flickerEnable
#define ADJSP_AE_CHARA_SHTTSPEED_U			0x20058354			// AE.aeChara.st_shutterSpeed.upper
#define ADJSP_AE_CHARA_SHTTSPEED_L			0x20058356			// AE.aeChara.st_shutterSpeed.lower
#define ADJSP_AE_CHARA_GAINUP						0x20058358			// AE.aeChara.gainUpper
#define ADJSP_AE_CHARA_SSHTTENABLE			0x2005835A			// AE.aeChara.slowShutterEnable
#define ADJSP_AE_CHARA_GAINSSHTTPRIO		0x2005835B			// AE.aeChara.gainSlowShutterPrio
#define ADJSP_AE_CHARA_SSHTTMAX					0x2005835C			// AE.aeChara.slowShutterMax
#define ADJSP_AE_CHARA_PHOTOPATNO				0x20058360			// AE.aeChara.photometryPatNo
#define ADJSP_AE_CHARA_SELBLCFLCENABLE	0x20058361			// AE.aeChara.selectBL_CorFLCEnable
#define ADJSP_AE_CHARA_SELBLCFLC				0x20058362			// AE.aeChara.selectBL_CorFLC
#define ADJSP_AE_CHARA_SELHISTMAIN			0x20058363			// AE.aeChara.selectHISTorMAIN
#define ADJSP_AE_STMAINSAREA_START_H		0x20058364			// AE.aeChara.st_mainSubjArea.start.h
#define ADJSP_AE_STMAINSAREA_START_V		0x20058365			// AE.aeChara.st_mainSubjArea.start.v
#define ADJSP_AE_STMAINSAREA_END_H			0x20058366			// AE.aeChara.st_mainSubjArea.end.h
#define ADJSP_AE_STMAINSAREA_END_V			0x20058367			// AE.aeChara.st_mainSubjArea.end.v
#define ADJSP_AE_PHOTPATT_PATTERN				0x20058368			// AE.photPatt.pattern
#define ADJSP_AE_AETARGET								0x200583CC			// AE.AETarget
#define ADJSP_AE_AEMANU_SHTTSPEED				0x200583CE			// AE.aeManual.shutter_speed
#define ADJSP_AE_AEMANU_GAIN						0x200583D0			// AE.aeManual.gain
#define ADJSP_AE_AECONVADJ_AESPEED			0x200583D2			// AE.aeConvAdj.aeSpeed
#define ADJSP_AE_AECONVADJ_DEADZONEOUT	0x200583D4			// AE.aeConvAdj.deadZoneOut
#define ADJSP_AE_AECONVADJ_DEADZONEIN		0x200583D6			// AE.aeConvAdj.deadZoneIn
#ifdef MECHA_IRIS
#define ADJSP_AE_MIRISADJ_FLGREGION			0x200583D8			// AE.mechaIrisAdjust.flagIrisRegion
#define ADJSP_AE_MIRISADJ_RIRISVAL			0x200583D9			// AE.mechaIrisAdjust.roughIrisValue
#define ADJSP_AE_MIRISADJ_IRISSTOPU			0x200583DA			// AE.mechaIrisAdjust.irisStopUpper
#define ADJSP_AE_MIRISADJ_IRISSTOPL			0x200583DB			// AE.mechaIrisAdjust.irisStopLower
#define ADJSP_AE_MIRISADJ_IRISCLSS			0x200583DC			// AE.mechaIrisAdjust.irisCloseSlow
#define ADJSP_AE_MIRISADJ_IRISCLSF			0x200583DD			// AE.mechaIrisAdjust.irisCloseFast
#define ADJSP_AE_MIRISADJ_IRISOPNS			0x200583DE			// AE.mechaIrisAdjust.irisOpenSlow
#define ADJSP_AE_MIRISADJ_IRISOPNF			0x200583DF			// AE.mechaIrisAdjust.irisOpenFast
#endif
#define ADJSP_AE_WDRCHR_EXPRATIO				0x200583E0			// AE.wdrCharacteristic.exposureRatio
#define ADJSP_AE_WDRCHR_MIXEXPRATIO			0x200583E2			// AE.wdrCharacteristic.mixExpRatio
#define ADJSP_AE_WDRCHR_MIXTHRLNG				0x200583E4			// AE.wdrCharacteristic.mixThrLong
#define ADJSP_AE_WDRCHR_MIXTHRSHT				0x200583E6			// AE.wdrCharacteristic.mixThrShort
#define ADJSP_AE_WDRCHR_MIXTHRERR				0x200583E8			// AE.wdrCharacteristic.mixThrErr
#define ADJSP_AE_WDRCHR_SHTEXPCTRL			0x200583EC			// AE.wdrCharacteristic.shortExpoControl
#define ADJSP_AE_WDRCHR_AUTOWDRSEXPTGT	0x200583EE			// AE.wdrCharacteristic.autoWdrShortExpTarget
#define ADJSP_AE_WDRCHR_AUTOWDRLEXPTGT	0x200583F0			// AE.wdrCharacteristic.autoWdrLongExpTarget
#define ADJSP_AE_WDRCMPCHARA1						0x200583F4			// AE.wdrCompoChara1
#define ADJSP_AE_WDRCMPCHARA2						0x200583F6			// AE.wdrCompoChara2
#define ADJSP_AE_WDRCMPCHARA3						0x200583F8			// AE.wdrCompoChara3


/**
 * @brief AX用設定値を更新する
 *
 * @param [in]	addr	設定値アドレス
 * @param [in]	dat		更新設定値
 */
void setSpec(uint32_t addr, uint32_t dat);

/**
 * @brief AX用設定値を取得する
 *
 * @param [in]	addr	設定アドレス
 * @retval dat	設定値
 */
uint32_t getSpec(uint32_t addr);

#ifdef __cplusplus
}
#endif	/* __cplusplus */

#endif	/* _ADKSPEC_H_ */