/**
 * @file   AXModelStage.hpp
 * @brief  AXModelStageクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXMODELSTAGE_HPP_
#define AXMODELSTAGE_HPP_

#include "AXFStage.hpp"

/**
 * @class AXModelStage
 * @brief AXM層のAXModelActorコンテナクラス
 *
 * @n     AXM層へAXModelActorを格納するコンテナを提供する
 */
class AXModelStage : public AXFStage {
 public:

  /**
   * @brief AXModelStageコンストラクタ
   * @n     AXModelActorを格納するコンテナを作成する
   *
   * @param [in] name アクタ名
   */
  AXModelStage(AXFObjectName& name);

  /**
   * @brief AXModelStageデストラクタ
   *
   * @n
   */
  virtual ~AXModelStage();
};

#endif /* AXMODELSTAGE_HPP_ */
