#ifndef AXMCOMMONBRIDGEPARAM_HPP_
#define AXMCOMMONBRIDGEPARAM_HPP_

/*
 * AXBridge用イベント定義
 *   AXイベント値は、以下のAXイベント生成マクロを使用する
 *
 *     AXFEVENT_MODEL() : AX_SDK/AX/libraries/AXF/inc/AXFEvent.hpp
 *
 */

#include <AXFEvent.hpp>

/* ISP -> NVR イベント定義 : AXFEVENT_MODEL() に設定する値 */
enum {
  EVENT_ISPTONVR_GDU_START = 0,
  EVENT_ISPTONVR_GDU_BANK_SWITCH,
  EVENT_ISPTONVR_GDU_STOP,
  EVENT_ISPTONVR_MAX,
};

/* フレーム生成完了パラメータ定義 (NVR -> ISP) */
struct IspToNvrParam_FrameGen_Control_t {
  int cmd;
  int bankno;
  int complex;
};

#endif /* AXMCOMMONBRIDGEPARAM_HPP_ */

