/**
 * @file   AXMImageSensor.hpp
 * @brief  AXMImageSensorクラスヘッダ
 *
 * @n      ImageSensor IFクラス
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

#ifndef AXMImageSensor_HPP_
#define AXMImageSensor_HPP_

#include "AXMCommon/AXMCommonConfig.hpp"
#include "AXM/AXModelActor.hpp"
#include "AXHSpecStruct.hpp"
#include "AXHSpec.hpp"

  enum eIrisKind {
  	E_IRISCONT_NONE = 0,
  	E_IRISCONT_DC ,
  	E_IRISCONT_P 
  };
typedef unsigned char IrisKind;

typedef struct st_ismsg {
	unsigned int time;                  //  露光時間
	unsigned int gain;                  //  ゲイン
	unsigned int iris;                  //  アイリス
	unsigned int frame;                 //  フレーム情報
} ST_ISMSG;

#define DC_IRIS_TX_I2C_PORT         (1)
#define DC_IRIS_TX_SLAVE_ADDR (0x0D) // デバイスのI2Cスレーブアドレス
extern "C" {
    void    init_iris_control(void);
	void	init_i2c_master(unsigned int	id_I);
	void    init_pwm(void);
	void    init_focus_pwm(void);
}
/**
 * @class AXMImageSensor
 * @brief ImageSensor IFクラス
 *
 */
class AXMImageSensor : public AXModelActor {
  AXFLog m_log;
  AXFObjectName& m_name;
  AXFActor::TimerId_t m_timerID;  // タイマーID
  ST_SPEC                             *p_spec;              //  設定値参照用
  
 public:
  AXMImageSensor(AXFObjectName& name);
  virtual ~AXMImageSensor();
  ax::actorFuncStatus onCreate();
  ax::actorFuncStatus onStart();
  ax::actorFuncStatus onStop();
  ax::actorFuncStatus onDestroy();
  void controlExposure(unsigned int time, unsigned int gain);
  void setSpecParameter(void);				// spec 初期化
  void checkComm(void);
  void    set_iris_control(IrisKind iris);

#if 0
  ax::actorFuncStatus onPause();
  ax::actorFuncStatus onResume();
  ax::actorFuncStatus onRestart();
#endif

  void Init();

// StateMachineオブジェクト用ヘッダファイル挿入
#include "./AXMImageSensorState.hpp"
};
#endif /* AXMImageSensor_HPP_ */
