/**
 * @file   AXMIsp.hpp
 * @brief  AXMIspクラスヘッダ
 *
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

#ifndef AXMISP_HPP_
#define AXMISP_HPP_


#include "../AXM/AXModelActor.hpp"
#include "../AXMCommon/AXMCommonSetParam.hpp"
#include "../AXMCommon/AXMCommonStruct.hpp"
#include "AXMIspAe/AXMISPtype.hpp"

#ifdef  ENABLE_OPD_CONFIG_ISP_TO_AXH
#include "AXHOpdConfigAWB.hpp"
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
//#if defined(ENABLE_OPD_CONFIG_ISP_TO_AXH) || defined(ENABLE_IMAGE_ADDR_ISP_TO_AXH)
#include "AXHOpdConfigAE.hpp"
#include "AXHOpdCommon.hpp"
//#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH || ENABLE_IMAGE_ADDR_ISP_TO_AXH

#ifdef  ENABLE_OPD_DATA_ISP_TO_AXH
#include "AXHOpdDataAWB.hpp"
#include "AXHOpdDataAE.hpp"
#include "AXHOpdCommon.hpp"
#include "AXHPixcessorMemConfig.hpp"
#endif  //  ENABLE_OPD_DATA_ISP_TO_AXH

#ifdef USE_AXFTEST_COMMAND
extern const int AXM_SAMPLE_SEND_MAX_COUNT;
extern const bool isUsedTimer;
extern const bool isUsedPriorityCheck;
#endif /* USE_AXFTEST_COMMAND */

const int Status_Waiting  = 0x00000000l;
const int Status_FrameIsr = 0x00000001l;
const int Status_AeEnd    = 0x00000002l;
const int Status_AwbEnd   = 0x00000004l;
const int Status_ObEnd    = 0x00000008l;

/*
 * @class AXMIsp
 * @brief ISP サンプル実装
 *
 * @n     ISP Stage から起動要求を受信すると、AF, AE, AWB に対し起動要求を行う。
 * @n     ISP Stage から停止要求を受信すると、AF, AE, AWB に対し停止要求し、停止完了を待つ。
 * @n     Pixcessor からフレーム完了通知を受信する。
 * @n     Pixcessor からフレーム完了通知を100回受信すると、状態遷移を行う。
 * @n
 */
class AXMIsp : public AXModelActor {
  AXFLog m_log;
  AXFObjectName& m_name;
  int m_count;

 public:
  AXMIsp(AXFObjectName& name);
  virtual ~AXMIsp();
  ax::actorFuncStatus onCreate();
  ax::actorFuncStatus onStart();
  ax::actorFuncStatus onStop();
#if 0
  ax::actorFuncStatus onPause();
  ax::actorFuncStatus onResume();
  ax::actorFuncStatus onRestart();
#endif

  /**
   * @enum CorrectMode
   * @brief 補正モード定義
   */
  typedef enum
  {
	CorrectMode_OFF = 0,
	CorrectMode_ON,
  } CorrectMode;

// StateMachineオブジェクト用ヘッダファイル挿入
#include "./AXMIspState.hpp"

  //  ISP用AWBモード
//  typedef enum
//  {
//    ISP_AWBMode_ATWMode = 0,
//    ISP_AWBMode_ManuMode,
//    ISP_AWBMode_OnePush,
//  } ISP_AWBMode;

  //  ISP用動作モード
  typedef enum
  {
    ISP_Mode_Run = 0,                   //  通常動作モード
    ISP_Mode_Adjust_WB,                 //  調整モード : WB調整
    ISP_Mode_Adjust_IRIS,               //  調整モード : IRIS調整
    ISP_Mode_Adjust_SHADE,              //  調整モード : シェーディング補正
    ISP_Mode_Adjust_KIZU,               //  調整モード :
  } ISP_Mode;

  //  AWBモード格納用
  unsigned char ispAWBMode;
  //  ATWシーンモード格納用
  unsigned char ispATWSceaneMode;
  //  モード格納用
  unsigned char ispMode;

  //  補正モード用変数定義
  typedef struct {
    //  バックアップ用変数定義
    CorrectMode Mode;                   //  シェーディング補正状態
    unsigned char AEMode;               //  AE制御モード
    unsigned char AESlowShutterMode;    //  スローシャッター ON/OFF
    struct {
      unsigned char Mode;               //  IRIS調整 モード
      unsigned char adjVal;             //  IRIS調整 制御値
    } IRIS;
    //  OPDデータ切替用変数定義
    unsigned char frameCnt;             //  フレームカウンタ：0と1を交互に切替えて使用する
  } ST_CORRECT;
  ST_CORRECT ispCorrect;

  ST_SPEC *p_spec;                      //  設定値格納先ポインタ
  bool    f_init;                       //  初期化確認用フラグ

private:
  int     status;

#ifdef  ENABLE_OPD_CONFIG_ISP_TO_AXH
  AXHOpdConfigAWB opdConfigAWB;
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
//#if defined(ENABLE_OPD_CONFIG_ISP_TO_AXH) || defined(ENABLE_IMAGE_ADDR_ISP_TO_AXH)
  AXHOpdConfigAE  opdConfigAE;
//#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH || ENABLE_IMAGE_ADDR_ISP_TO_AXH

  AXHPixcessorMemConfig m_pixMemConfig;

#ifdef  ENABLE_OPD_DATA_ISP_TO_AXH
  AXHOpdDataAWB opdDataAWB;
  AXHOpdDataAE  opdDataAE;
#endif  //  ENABLE_OPD_DATA_ISP_TO_AXH

#ifdef  PARASOFT_CPPTEST
  int     event;                        //  c++testパスケース確認用変数
  ST_MSG  msg;                          //  c++test送信内容確認用
#endif  //  PARASOFT__CPPTEST

  unsigned char ispLensKind;
#ifdef PARASOFT_CPPTEST
  int send(AXFObjectName& name, AXFEvent_t eventId, void* data, int size);
  int return_stub_send;
  int setStateInfo(AXFActor* obj, int initState, int maxState);
  int return_stub_setStateInfo;
  void setStateTable(int registState, const StateTable* stateTable);

#endif	// PARASOFT_CPPTEST

};

extern void pthread_pri_dbgprint();

#endif /* AXMISP_HPP_ */
