/**
 * @file   AXMIspAdjust.hpp
 * @brief  AXMIspAdjustクラスヘッダ
 *
 * @n
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

#ifndef AXMISPADJUST_HPP_
#define AXMISPADJUST_HPP_

#include "../AXM/AXModelActor.hpp"
#include "AXMIspGamma.hpp"
#include "AXMIspGammaSettings.hpp"
#include "AXMIspAperture.hpp"
#include "AXMIspApertureSettings.hpp"
#include "AXMIspChromaSuppress.hpp"
#include "AXMIspChromaSuppressSettings.hpp"
#include "AXMIspAdjustType.hpp"
#include "../AXMCommon/AXMCommonStruct.hpp"

#ifdef PARASOFT_CPPTEST
	enum CPPTEST_ModifyGammaProc {
		GMTest_noProc = 0,
		GMTest_modeChange = 0x01,
		GMTest_curvChange = 0x01 << 1,
		GMTest_kneeChange = 0x01 << 2,
		GMTest_userChange = 0x01 << 3,
		GMTest_dataSend   = 0x01 << 4,
	};
	typedef struct {
		BYTE			size;
		BYTE			data[300];
		int				param[15];
	} ST_APERTURE_MSG;
#endif

const USHORT PTN_NR_ALL   = 0x0000u;                        ///<  NR 一括設定要求
const USHORT PTN_NR_MODE  = 0x0001u;                        ///<  NR モード設定要求
const USHORT PTN_NR_MainY = 0x0002u;                        ///<  NR 3DNR MainY信号設定要求
const USHORT PTN_NR_MainC = 0x0004u;                        ///<  NR 3DNR MainC信号設定要求
const USHORT PTN_NR_SubY  = 0x0008u;                        ///<  NR 2DNR SubY信号設定要求
const USHORT PTN_NR_SubC  = 0x0010u;                        ///<  NR 2DNR SubC信号設定要求

const USHORT PTN_DEFECT_ALL          = 0x0000u;             ///<  画素欠陥補正 一括設定要求
const USHORT PTN_DEFECT_Mode         = 0x0001u;             ///<  画素欠陥補正 モード設定要求
const USHORT PTN_DEFECT_Address      = 0x0002u;             ///<  画素欠陥補正 アドレス指定
const USHORT PTN_DEFECT_AutoSettings = 0x0004u;             ///<  画素欠陥補正 自動補正設定
const USHORT PTN_DEFECT_AutoLevel    = 0x0008u;             ///<  画素欠陥補正 輝度信号レベル設定
const USHORT PTN_DEFECT_StaticDetect = 0x0010u;             ///<  画素欠陥補正 静的検出方法設定

const USHORT PTN_AP_UPD_TOTALGAIN    = 0x0001u;             ///<  トータルゲイン設定要求
const USHORT PTN_AP_UPD_LIMIT        = 0x0002u;             ///<  リミット設定要求
const USHORT PTN_AP_UPD_CORING       = 0x0004u;             ///<  コアリング設定要求
const USHORT PTN_AP_UPD_MID_RATIO    = 0x0008u;             ///<  高域・中域ゲイン比率設定要求

const USHORT PTN_GM_UPD_CURVE        = 0x0001u;             ///<  ガンマ補正カーブ選択設定要求
const USHORT PTN_GM_UPD_KNEE         = 0x0002u;             ///<  Knee設定要求

const USHORT PTN_SCL_UPD_ZOOM        = 0x0001u;             ///<  スケーラ機能拡大縮小設定要求
const USHORT PTN_SCL_UPD_REVERSE     = 0x0002u;             ///<  スケーラ機能上下反転・ネガポジ反転設定要求
/**
 * @class     AXMIspAdjust
 * @brief     画質調整タスククラス
 *
 * @n         画質調整要求を監視する。要求が発生した場合、その処理を実行する。
 */
class AXMIspAdjust : public AXModelActor {
	AXFLog	m_log;
public:
	AXMIspAdjust(AXFObjectName& name);
	virtual ~AXMIspAdjust();
public:
	ax::actorFuncStatus onCreate();
	ax::actorFuncStatus onStart();
	ax::actorFuncStatus onStop();

	/**
	 * @brief	画素欠陥補正関連設定値保持用変数初期化
	 */
    void RGBMatrixInit();
	/**
	 * @brief	画素欠陥補正関連設定値保持用変数初期化
	 */
    void DefectInit();
	/**
	 * @brief	ガンマテーブル初期化
	 */
	void GammaTableInit();
	/**
	 * @brief	アパーチャ補正初期化
	 */
	void ApertureInit();
	/**
	 * @brief	クロマサプレス初期化
	 */
	void ChromaInit();
	/**
	 * @brief	レンズシェーディング補正設定
	 *
	 * @param [in] cmd   コマンド
	 */
	void SetLensShade(USHORT cmd);
	/**
	 * @brief	IRIDIX設定
	 *
	 * @param [in] cmd   コマンド
	 */
	void SetIridix(USHORT cmd);
	/**
	 * @brief	NR設定
	 *
	 * @param [in] mode  設定モード
	 */
	void SetNR(USHORT mode);

	/**
	 * @brief	Defect設定
	 *
	 * @param [in] mode  設定モード
	 */
	void SetDefect(USHORT mode);

	/**
	 * @brief	RGBマトリックス設定
	 */
	void SetRGBMatrix();

#include "AXMIspAdjustState.hpp"
public:
	AXMIspGammaSettings     m_gammaSettings;                //!< ガンマ補正設定
	AXMIspGammaCalc         m_gammaCalc;                    //!< ガンマ補正計算
	AXMIspApertureSettings  m_apertureSettings;             //!< アパーチャ補正設定
	AXMIspApertureCalc      m_apertureCalc;                 //!< アパーチャ補正計算
	AXMIspChromaSettings    m_chromaLutSettings;            //!< クロマサプレス設定
	AXMIspChromaCalc        m_chromaLutCalc;					//!< クロマサプレス輝度変調LUT計算
	ST_SCALER               m_scalerSettings;               //!< スケーラー機能設定
	ST_SPEC*                p_adjustspec;                   //!< パラメータ調整設定格納先ポインタ

	::ST_RGB_MATRIX         RGBMatrixSettings;              //!<  RGBマトリックス設定値
	::ST_LENS_SHADE         LensShadeSettings;              //!<  レンズシェーディング補正設定値
	::ST_IRIDIX             IridixSettings;                 //!<  Iridix設定値
	::ST_NR                 NRSettings;                     //!<  NR設定値
	::ST_DEFECT             DefectSettings;                 //!<  画素欠陥補正 設定値
#ifdef PARASOFT_CPPTEST
	ST_APERTURE_MSG			checkDataCPPTEST;
#endif
};

#endif /* AXMISPADJUST_HPP_ */
