/*
 * AXMIspApertureAlgorithm.cpp
 */

#include "AXMIspApertureAlgorithm.hpp"
#include "AXMIspApertureSettings.hpp"
#include <iostream>
AXMIspApertureAlgorithm::AXMIspApertureAlgorithm() :
	  HIGH_MID_RANGE_GAIN_MAX(AP_HIGH_MID_RANGE_GAIN_MAX)
	, MODULATION_GAIN_BASE(AP_MODULATION_GAIN_BASE)
	, LUT_SIZE(AP_LUT_DATA_CNT) {
	// TODO 自動生成されたコンストラクター・スタブ
}

AXMIspApertureAlgorithm::~AXMIspApertureAlgorithm() {
	// TODO Auto-generated destructor stub
}

/*
 * 高域・中域ゲイン比率計算
 */
void AXMIspApertureAlgorithm::CalcOverMidRangeGainRatio(BYTE midRatio, BYTE* highRangeRatio, BYTE* midRangeRatio) {
	*highRangeRatio = HIGH_MID_RANGE_GAIN_MAX - midRatio;
	*midRangeRatio  = midRatio;
}

/*
 * 輝度変調LUT計算
 */
void AXMIspApertureAlgorithm::CalcLuminanceModulationLUT(BYTE startSupresLuminance, BYTE startStrongLuminance, BYTE correctSupressInc, BYTE correctStrongInc, BYTE correctStrongLimit, BYTE* lut) {
	if (startStrongLuminance < startSupresLuminance) {
		BYTE valTmp = startStrongLuminance;
		startStrongLuminance = startSupresLuminance;
		startSupresLuminance = valTmp;
	}
	// 暗部アパーチャ抑制開始輝度＆高輝度側アパーチャ補正強化開始輝度をLUT_3Bの分解能(256→128分解能)にする
	BYTE startSupresLuminanceIdx = (startSupresLuminance >> 1);
	BYTE startStrongLuminanceIdx = (startStrongLuminance >> 1);

	SHORT modulationGainTmp = 0;
	for (int i = 0; i < LUT_SIZE; i++) {
		BYTE luminance = i * 2;
		// 暗部アパーチャ抑制開始輝度未満
		if (i < startSupresLuminanceIdx) {
			modulationGainTmp = (MODULATION_GAIN_BASE - (((startSupresLuminance - luminance) * correctSupressInc) >> 4));
		}

		// 暗部アパーチャ抑制リミットチェック
		if (modulationGainTmp < 0) {
			modulationGainTmp = 0;
		}

		// 暗部アパーチャ抑制開始輝度以上、かつ、高輝度側アパーチャ補正強化開始輝度以下
		if (startSupresLuminanceIdx <= i && i <= startStrongLuminanceIdx) {
			modulationGainTmp = MODULATION_GAIN_BASE;
		}

		// 高輝度側アパーチャ補正強化開始輝度超え
		if (startStrongLuminanceIdx < i) {
			modulationGainTmp = (MODULATION_GAIN_BASE + (((luminance - startStrongLuminance) * correctStrongInc) >> 4));
		}

		// 高輝度側アパーチャ補正強化リミットチェック
		if (correctStrongLimit < modulationGainTmp) {
			modulationGainTmp = correctStrongLimit;
		}
		lut[i] = static_cast<BYTE>(modulationGainTmp);
	}
}
