/**
 * @file			AXMIspApertureAlgorithm.hpp
 * @brief			AXMIspApertureAlgorithmクラスヘッダ
 *
 * @par			言語
 * 					C++
 */
#ifndef AXMISPAPERTUREALGORITHM_HPP_
#define AXMISPAPERTUREALGORITHM_HPP_
#include "AXMIspAdjustType.hpp"

/**
 * @class		AXMIspApertureAlgorithm
 * @brief		アパーチャ補正アルゴリズムクラス
 *
 * @n			アパーチャ補正計算時に計算アルゴリズムを提供する
 */
typedef class AXMIspApertureAlgorithm {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 *
	 * @n
	 */
	AXMIspApertureAlgorithm();
	/**
	 * @brief  オブジェクトを開放する
	 *
	 * @n
	 */
	virtual ~AXMIspApertureAlgorithm();

private:
	/**
	 * 高域・中域ゲイン最大値
	 */
	const BYTE			HIGH_MID_RANGE_GAIN_MAX;

	/**
	 * 変調ゲイン基準値
	 */
	const BYTE			MODULATION_GAIN_BASE;

	/**
	 * 輝度変調後LUTデータ格納用サイズ
	 */
	const BYTE			LUT_SIZE;

public:
	/**
	 * @brief	高域・中域ゲイン比率計算
	 *
	 * @param	[in]  midRatio                 高域に対する中域比率
	 * @param	[out] highRangeRatio           高域ゲイン比率
	 * @param	[out] midRangeRatio            中域ゲイン比率
	 */
	void 				CalcOverMidRangeGainRatio(BYTE midRatio, BYTE* highRangeRatio, BYTE* midRangeRatio);

	/**
	 * @brief	輝度変調LUT計算
	 *
	 * @param	[in]  startSupresLuminance     暗部アパーチャ抑制開始輝度
	 * @param	[in]  startStrongLuminance     高輝度側アパーチャ補正強化開始輝度
	 * @param	[in]  correctSupressInc        暗部アパーチャ補正抑圧傾き
	 * @param	[in]  correctStrongInc         高輝度側アパーチャ補正強化傾き
	 * @param	[in]  correctStrongLimit       高輝度側アパーチャ補正強化リミット
	 * @param	[out] lut                      出力ゲインLUTテーブル
	 */
	void				CalcLuminanceModulationLUT(BYTE startSupresLuminance, BYTE startStrongLuminance, BYTE correctSupressInc, BYTE correctStrongInc, BYTE correctStrongLimit, BYTE* lut);

} AXMIspApAlgorithm;

#endif /* AXMISPAPERTUREALGORITHM_HPP_ */
