/*
 * AXMIspApertureSettings.cpp
 */

#include "AXMIspApertureSettings.hpp"

ApertureCorrectStrong::ApertureCorrectStrong() :
	  darkSupressStartLuminance(0)
	, highCorrectStartStrongLuminance(0xFF)
	, darkCorrectSupressInc(0)
	, highCorrectStrongInc(0)
	, highCorrectStrongLimit(0xFF)
{
	// TODO 自動生成されたコンストラクター・スタブ
}

ApertureCorrectStrong::~ApertureCorrectStrong() {
	// TODO Auto-generated destructor stub
}

/*
 * アパーチャ補正強度パラメータ設定
 */
bool ApertureCorrectStrong::Set(BYTE startSupresLuminance, BYTE startStrongLuminance, BYTE correctSupressInc, BYTE correctStrongInc, BYTE correctStrongLimit) {
	bool isChange = false;
	if (this->darkSupressStartLuminance != startSupresLuminance) {
		this->darkSupressStartLuminance = startSupresLuminance;
		isChange = true;
	}
	if (this->highCorrectStartStrongLuminance != startStrongLuminance) {
		this->highCorrectStartStrongLuminance = startStrongLuminance;
		isChange = true;
	}
	if (this->darkCorrectSupressInc != correctSupressInc) {
		this->darkCorrectSupressInc = correctSupressInc;
		isChange = true;
	}
	if (this->highCorrectStrongInc != correctStrongInc) {
		this->highCorrectStrongInc = correctStrongInc;
		isChange = true;
	}
	if (this->highCorrectStrongLimit != correctStrongLimit) {
		this->highCorrectStrongLimit = correctStrongLimit;
		isChange = true;
	}
	return isChange;
}

AXMIspApertureSettings::AXMIspApertureSettings() :
	  totalGain     (AP_TOTAL_GAIN)
	, limitPositive (AP_LIMIT_POSITIVE)
	, limitNegative (AP_LIMIT_NEGATIVE)
	, correctStrong (APCorrectStrong())
	, coringTh      (AP_CORING_TH)
	, midRangeRatio (AP_MID_RANGE_RATIO)
{
	// TODO 自動生成されたコンストラクター・スタブ
}

AXMIspApertureSettings::~AXMIspApertureSettings() {
	// TODO Auto-generated destructor stub
}
