/**
 * @file			AXMIspChromaSuppressSettings.hpp
 * @brief			AXMIspChromaSuppressSettingsクラスヘッダ
 *
 * @par			言語
 * 					C++
 */

#ifndef AXMISPCHROMASUPPRESSSETTINGS_HPP_
#define AXMISPCHROMASUPPRESSSETTINGS_HPP_
#include "AXMIspAdjustType.hpp"

/**
 * クロマサプレス色ゲイン変調LUTサイズ
 */
const SHORT			CH_MAX_LUT_SIZE = 256;
/**
 * エッジクロマサプレス色ゲイン変調LUTサイズ
 */
const SHORT			CH_MAX_EDGE_LUT_SIZE = 128;
/**
 * 輝度変調ゲイン基準値
 */
const BYTE				CH_MODULATION_GAIN_BASE = 0x80;
/**
 * ハイライトクロマサプレス開始輝度デフォルト値
 */
const BYTE				CH_DEF_HIGH_LIGHT_START_LUMINANCE = 220;
/**
 * ハイライトクロマサプレス傾き
 */
const BYTE				CH_DEF_HIGH_LIGHT_INC = 0x50;
/**
 * @class     ChromaModulationSettings
 * @brief     クロマサプレス変調設定パラメータクラス
 *
 * @n         色ゲイン変調LUTの計算パラメータを格納する
 */
typedef class ChromaModulationSettings {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 *
	 * @n
	 */
	ChromaModulationSettings();
	/**
	 * @brief  オブジェクトを開放する
	 *
	 * @n
	 */
	virtual ~ChromaModulationSettings();
public:
	/**
	 * @brief	クロマ信号変調パラメータ設定
	 *
	 * @param	[in]  darkStartLuminance       暗部クロマプレス開始輝度
	 * @param	[in]  darkInc                  暗部クロマサプレス傾き
	 * @param	[in]  highColorStartLuminance  高輝度側色強化開始輝度
	 * @param	[in]  highColorInc             高輝度側色強化傾き
	 * @param	[in]  highColorLimit           高輝度側色強化リミット
	 * @param	[in]  highLightStartLuminance  ハイライトクロマサプレス開始輝度
	 * @param	[in]  highLightInc             ハイライトクロマサプレス傾き
	 * @return	      パラメータ変更の有無
	 */
	bool				Set(BYTE darkStartLuminance, BYTE darkInc, BYTE highColorStartLuminance, BYTE highColorInc, BYTE highColorLimit, BYTE highLightStartLuminance, BYTE highLightInc);
public:
	BYTE				darkStartLuminance;                //!< 暗部クロマプレス開始輝度
	BYTE				darkInc;                           //!< 暗部クロマサプレス傾き
	BYTE				highColorStartLuminance;           //!< 高輝度側色強化開始輝度
	BYTE				highColorInc;                      //!< 高輝度側色強化傾き
	BYTE				highColorLimit;                    //!< 高輝度側色強化リミット
	BYTE				highLightStartLuminance;           //!< ハイライトクロマサプレス開始輝度
	BYTE				highLightInc;                      //!< ハイライトクロマサプレス傾き
} ChromaModSettings;

/**
 * @class		AXMIspChromaSuppressSettings
 * @brief		クロマサプレス設定パラメータクラス
 *
 * @n         クロマサプレスの計算パラメータと、計算結果を格納する
 */
typedef class AXMIspChromaSuppressSettings {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 *
	 * @n
	 */
	AXMIspChromaSuppressSettings();
	/**
	 * @brief  オブジェクトを開放する
	 *
	 * @n
	 */
	virtual ~AXMIspChromaSuppressSettings();

	ChromaModSettings	modSettings;                       //!< クロマ信号変調設定
	BYTE				lowStartGain;                      //!< 低輝度クロマサプレス開始ゲイン
	BYTE				lowInc;                            //!< 低輝度クロマサプレス傾き
	BYTE				edgeTh;                            //!< エッジしきい値
	BYTE				edgeSuppressStrong;                //!< サプレス強度
	BYTE				lut[CH_MAX_LUT_SIZE];              //!< クロマサプレス色ゲイン変調LUT
	BYTE				edgeLut[CH_MAX_EDGE_LUT_SIZE];     //!< エッジクロマサプレス色ゲイン変調LUT
} AXMIspChromaSettings;

#endif /* AXMISPCHROMASUPPRESSSETTINGS_HPP_ */
