/**
 * @file			AXMIspGamma.hpp
 * @brief			AXMIspGamma計算クラス群ヘッダ
 *
 * @par			言語
 * 					C++
 */

#ifndef AXMISPGAMMA_HPP_
#define AXMISPGAMMA_HPP_
#include "AXMIspGammaAlgorithm.hpp"
#include "AXMIspGammaSettings.hpp"

/**
 * @class     AXMIspGammaCalc
 * @brief     ガンマ補正計算クラス
 *
 * @n         ガンマ補正アルゴリズムを使用し、ガンマ補正計算を行う
 */
class AXMIspGammaCalc {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 *
	 * @n
	 */
	AXMIspGammaCalc();
	/**
	 * @brief  オブジェクトを開放する
	 *
	 * @n
	 */
	virtual ~AXMIspGammaCalc();
public:
	/**
	 * @brief	ガンマ補正設定
	 *
	 * @param	[in]  gammaSettings            ガンマ補正設定
	 */
	void					NotifySettings(AXMIspGammaSettings* gammaSettings);
	/**
	 * @brief	デフォルトガンマ補正カーブ計算
	 *
	 * @return	      処理結果
	 */
	bool					CreateDefGammaCurve();
	/**
	 * @brief	ガンマ補正カーブ変換
	 *
	 * @return	      処理結果
	 */
	bool					ConvertGammaCurve();
	/**
	 * @brief		ユーザー設定のガンマ補正カーブを格納
	 *
	 * @param	[in]  usrGammaCurve        ユーザー設定のガンマ補正カーブ
	 * @return	      処理結果
	 */
	bool					SetUserGammaCurve(USHORT* usrGammaCurve);

private:
	AXMIspGammaSettings*	m_gammaSettings;
	AXMIspGammaAlgorithm	m_gammaAlgorithm;
};

#endif /* AXMISPGAMMA_HPP_ */
