/**
 * @file   AXMIspAe.hpp
 * @brief  AXMIspAeクラスヘッダ
 *
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

#ifndef AXMISPAE_HPP_
#define AXMISPAE_HPP_

//#define DISABLE_AE2PACK_PROC

#include "AXM/AXModelActor.hpp"
#include "AXMCommon/AXMCommonConfig.hpp"
#include "AXMCommon/AXMCommonStruct.hpp"

//#ifndef DISABLE_AE2PACK_PROC
#include "AXMISPtype.hpp"
#include "AXMIspAe2.hpp"
#include "AXMIspAeSetting.hpp"
//#endif  //  DISABLE_AE2PACK_PROC
#include "AXHSpec.hpp"

extern const std::string aeSampleData;

/**
 * @class AXMIspAe
 * @brief AE 実処理クラス
 *
 */
class AXMIspAe : public AXModelActor {
  AXFLog m_log;
  AXFObjectName& m_name;
  int m_count;
  const UCHAR *opdData;
#ifndef DISABLE_AE2PACK_PROC
  AXMIspAeExecCalcBase *aeCalc;
  AXMIspAeSetting *aeSetting;
  AXMIspAeSetting aeSettingObj;
  AXMIspAeModes AeModeSave;

  AXMIspAeSequencer *sequencer;
#endif  //  DISALBE_AE2PACK_PROC
  ST_FROM_AE_TO_ISP fromAeToIsp;		// 明るさ情報等送信用
  ST_SPEC                             *p_spec;              //  設定値参照用
#ifdef PARASOFT_CPPTEST
  bool flag_newStub;
#endif

 public:
  AXMIspAe(AXFObjectName& name);
  virtual ~AXMIspAe();
  ax::actorFuncStatus onCreate();
  ax::actorFuncStatus onStart();
  ax::actorFuncStatus onStop();
  void AeExec(ST_MSG *p_msg);
  void AeExecAdjust(ST_MSG *p_msg);

	void convertAeMode(void);

	void notifyAeSettings(AXMIspAeSetting *obj);

	void checkAeModeChange(void);

	void AeExecDoCalc(ST_MSG *p_msg) ;

	void checkComm(void);

// StateMachineオブジェクト用ヘッダファイル挿入
#include "./AXMIspAeState.hpp"

private:
  // インスタンスのコピーは想定しない(Klockwork指摘対応:CL.FFM.ASSIGN)
  AXMIspAe& operator=(const AXMIspAe&) {
    return *this;
  }

  // インスタンスのコピーは想定しない(Klockwork指摘対応:CL.FFM.COPY)
  AXMIspAe(const AXMIspAe& obj)
      : AXModelActor(obj.m_name)
       ,m_log(obj.m_log)
       ,m_name(obj.m_name)
       ,m_count(obj.m_count)
       ,opdData(obj.opdData)
#ifndef DISABLE_AE2PACK_PROC
       ,aeCalc(obj.aeCalc)
       ,aeSetting(obj.aeSetting)
       ,AeModeSave(obj.AeModeSave)
       ,sequencer(obj.sequencer)
#endif  //  DISALBE_AE2PACK_PROC
       ,fromAeToIsp(obj.fromAeToIsp)
  {
  }
};
#endif /* AXMISPAE_HPP_ */
