/*
 * AXMIspAe.cpp
 * AEシーケンサ
 *
 */

#include "AXMIspAe2.hpp"
#include "AXMCommon/AXMCommonConfig.hpp"
#ifdef AXM_ISP_CT_AE
#include "AXMIspCT/AXMIspCTAe.hpp"
#endif

#ifndef PARASOFT_CPPTEST
using namespace std;
#endif

AXMIspAeExecCalcBase::AXMIspAeExecCalcBase() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
	cout << "AXMIspAeExecCalcBase::constructor" << endl;
  #endif
#endif

  opdData = NULL;  // フレームNo.を見て切り替える
  controlExposure.doControlExposure = E_ISC_None;
  controlExposure.contShutter = 0;
  controlExposure.contGain = 0;
  controlExposure.contIris = 0;	//klocwork指摘に対応
  controlExposure.frame = 0;	//coverity指摘に対応
  controlExposure.contFocus = 0;
  controlExposure.chromaOff = 0;

  objAeSettingRef = NULL;
  base = NULL;
  weight = NULL;
  hist = NULL;
  histBase = NULL;
  mainObj = NULL;
#ifdef WDR
  exprat = NULL;
  autoWdr = NULL;
#endif
  AeModeSave2 = static_cast<AXMIspAeModes>(0);		// ※コンパイラ都合によりenumから数値に変更（_ZERO -> 0）

#ifdef AE_DEBUG2
  aeNum = 0;
  aePracIdx = 0;
#endif
  execFromAeToIsp.luminance = 0;
  execFromAeToIsp.is_wdr_mode = 0;
#ifdef PARASOFT_CPPTEST
  flag_newWeightStub = false;
  flag_newMainObjStub = false;
  flag_newHistStub = false;
  flag_newExpRatStub = false;
  flag_newAutoWdrStub = false;

#endif

}

AXMIspAeExecCalcBase::AXMIspAeExecCalcBase(AXMIspAeExecCalcBase &obj) {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "AXMIspAeExecCalcBase::copy constructor" << endl;
  #endif
#endif
    opdData = obj.opdData;  // フレームNo.を見て切り替える
    controlExposure.doControlExposure = E_ISC_None;
    controlExposure.contShutter = 0;
    controlExposure.contGain = 0;
    controlExposure.contIris = 0;	//coverity指摘に対応
    controlExposure.frame = 0;	//coverity指摘に対応
    controlExposure.contFocus = 0;
    controlExposure.chromaOff = 0;

    objAeSettingRef = obj.objAeSettingRef;
    base = obj.base;
    weight = obj.weight;
    mainObj = obj.mainObj;
    hist = obj.hist;
    histBase = obj.histBase;
#ifdef WDR
    exprat = obj.exprat;
    autoWdr = obj.autoWdr;
#endif

    AeModeSave2 = obj.AeModeSave2;
  // for test v v v
#ifdef AE_DEBUG2
    aeNum = obj.aeNum;
    aePracIdx = obj.aePracIdx;
#endif
  // for test ^ ^ ^
    execFromAeToIsp.luminance = 0;
    execFromAeToIsp.is_wdr_mode = false;
}

// =演算子オーバーロード
AXMIspAeExecCalcBase& AXMIspAeExecCalcBase::operator=(const AXMIspAeExecCalcBase& obj) {
//  *this = obj;
  return *this;
}

AXMIspAeExecCalcBase::~AXMIspAeExecCalcBase() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "AXMIspAeExecCalcBase::destructor" << endl;
  #endif
  if (weight != NULL) {
    delete weight;
  }
  if (mainObj) {
    delete mainObj;
  }
  if (hist) {
    delete hist;
  }
#ifdef WDR
  if (exprat) {
    delete exprat;
  }
  if (autoWdr) {
    delete autoWdr;
  }
#endif
#endif
}

void AXMIspAeExecCalcBase::notifyAeSequencer(AXMIspAeSetting *obj) {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "AXMIspAeExecCalcBase::notifyAeSequencer" << endl;
  #endif
#endif
  objAeSettingRef = obj;
}

void AXMIspAeExecCalcBase::exec(const ControlValue contrl[]) {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "AXMIspAeExecCalcBase::exec" << endl;
  #endif
#endif
	// AeModeが変更された場合にインスタンスの再生成を行う
	checkModeChange();

#ifdef AXM_ISP_CT_AE
	AXMIspCTAe::SetAeBase(this);
#endif

	// AEシーケンスを実行する
	execSequence(contrl);
}

void AXMIspAeExecCalcBase::checkModeChange(void) {
	  bool changeFlag = false;
	  AXMispAeWeightOPD *p_weight = NULL;
	  AXMIspAeAutoBLFLCHistogram *p_hist = NULL;
	  AXMIspAEAutoBLFLCMainObject *p_mainObj = NULL;
#ifdef WDR
	  AXMIspAeExposureRatioWDRMode *p_exprat = NULL;
	  AXMIspAeAutoWDR *p_autoWdr = NULL;
#endif
	
  if (objAeSettingRef != NULL) {
    if (objAeSettingRef->AeMode != AeModeSave2) {
      // if文の中でインスタンス削除を行うとklocworkで指摘されるためポインタのコピーのみ行う
  	  changeFlag = true;
  	  p_weight = weight;
  	  p_hist = hist;
  	  p_mainObj = mainObj;
#ifdef WDR
      p_exprat = exprat;
      p_autoWdr = autoWdr;
#endif

    }  // end of if(objAeSettingRef->AeMode != AeModeSave2)
  }  // end of if(objAeSettingRef != NULL)
#ifndef PARASOFT_CPPTEST
#ifdef WDR
	if (p_autoWdr != NULL) {
		delete p_autoWdr;
		autoWdr = NULL;
		histBase = NULL;
		base = NULL;
	}
	if (p_exprat != NULL) {
		delete p_exprat;
		exprat = NULL;
		weight = NULL;
		p_weight = NULL;
		base = NULL;
	}
#endif
	if (p_weight != NULL) {	//NULLチェックはklocworkでもOK
		delete p_weight;
		weight = NULL;
		base = NULL;
	}
	if (p_mainObj != NULL) {
		delete p_mainObj;
		mainObj = NULL;
		base = NULL;
	}
	if (p_hist != NULL) {
		delete p_hist;
		hist = NULL;
		histBase = NULL;
		base = NULL;
	}
#endif
  if(changeFlag) {
      	generateInstance(objAeSettingRef , objAeSettingRef->AeMode);
  }
  if (objAeSettingRef != NULL) {
	if (weight != NULL) {
		weight->notifyAeAlgorithm(objAeSettingRef);
	}
  	if (mainObj != NULL) {
		mainObj->notifyAeAlgorithm(objAeSettingRef);
	}
	if (hist != NULL) {
		hist->notifyAeAlgorithm(objAeSettingRef);
	}
#ifdef WDR
	if (exprat != NULL) {
		exprat->notifyAeAlgorithm(objAeSettingRef);
		weight = exprat;
	}
	if (autoWdr != NULL) {
		autoWdr->notifyAeAlgorithm(objAeSettingRef);
		histBase = autoWdr;
	}
#endif
  }

}

void AXMIspAeExecCalcBase::generateInstance(AXMIspAeSetting * objAeSettingRef , AXMIspAeModes AeMode ) {
	switch (AeMode) {
	case E_AeManualMode:
		generateInstanceWeight(objAeSettingRef);   // 
		break;
	case E_AeUsualProgMode:
	case E_AeShutterControlMode:
	case E_AeShutterAndGainControlMode:
		generateInstanceWeight(objAeSettingRef);   // 
		break;
		
	case E_AeUsualProg_MainObjMode:              // 主要被写体補正
	case E_AeShutterControl_MainObjMode:         // 主要被写体補正
	case E_AeShutterAndGainControl_MainObjMode:  // 主要被写体補正
		generateInstanceMainObj(objAeSettingRef);
		break;

	case E_AeUsualProg_HistogramMode:              // ヒストグラム
	case E_AeShutterControl_HistogramMode:         // ヒストグラム
	case E_AeShutterAndGainControl_HistogramMode:  // ヒストグラム
		generateInstanceHist(objAeSettingRef);
		break;
#ifdef WDR
	case E_AeExposureRatioWDRMode:
		generateInstanceExposureRatio(objAeSettingRef);   // 
		break;
	case E_AeAutoWDRMode:
		generateInstanceAutoWdr(objAeSettingRef);
		break;
#endif
	default:
		base = NULL;
		break;
	}  // end of switch
	if (base != NULL) {
		AeModeSave2 = AeMode;
	}
}

void AXMIspAeExecCalcBase::generateInstanceWeight(AXMIspAeSetting *objAeSettingRef) {
#ifndef PARASOFT_CPPTEST
	weight = new AXMispAeWeightOPD();
#else
	weight = newWeightStub();
#endif
	if (weight != NULL) {
		base = weight;
	}
}

void AXMIspAeExecCalcBase::generateInstanceMainObj(AXMIspAeSetting *objAeSettingRef) {
#ifndef PARASOFT_CPPTEST
	mainObj = new AXMIspAEAutoBLFLCMainObject();	//主要被写体
#else
	mainObj = newMainObjStub();						//主要被写体
#endif
	if (mainObj != NULL) {
		base = mainObj;
	}
}

void AXMIspAeExecCalcBase::generateInstanceHist(AXMIspAeSetting *objAeSettingRef) {
#ifndef PARASOFT_CPPTEST
	hist = new AXMIspAeAutoBLFLCHistogram();
#else
	hist = newHistStub();	// ヒストグラム
#endif
	if (hist != NULL) {
		histBase = hist;
		base = hist;
	}
}
#ifdef WDR
void AXMIspAeExecCalcBase::generateInstanceExposureRatio(AXMIspAeSetting *objAeSettingRef) {
#ifndef PARASOFT_CPPTEST
	exprat = new AXMIspAeExposureRatioWDRMode();	// 露光比率指定WDR
#else
	exprat = newExpRatStub();
#endif
	if (exprat != NULL) {
		weight = exprat;
		base = exprat;
	}
}
#endif
#ifdef WDR
void AXMIspAeExecCalcBase::generateInstanceAutoWdr(AXMIspAeSetting *objAeSettingRef) {
#ifndef PARASOFT_CPPTEST
	autoWdr = new AXMIspAeAutoWDR();	// AutoWDR
#else
	autoWdr = newAutoWdrStub();
#endif
	if (autoWdr != NULL) {
		histBase = autoWdr;
		base = autoWdr;
	}
}
#endif
void AXMIspAeExecCalcBase::execSequence(const ControlValue contrl[]) {
	for (int i = 0; contrl[i] != E_TERMINATE; ++i) {
		switch (contrl[i] & EGROUPMASK) {
			case E_CONGRP_COMMON:		// 共通部
				execSequenceCommonGroup(contrl[i]);
				break;
			case E_CONGRP_WEIGHT:		// OPD重み付け
				execSequenceWeightGroup(contrl[i]);
				break;
			case E_CONGRP_MANUAL:		// Manual mode
				execSequenceManualGroup(contrl[i]);
				break;
			case E_CONGRP_MAINOBJ:		// 主要被写体
				execSequenceMainObjGroup(contrl[i]);
				break;
			case E_CONGRP_HIST:			// ヒストグラム
				execSequenceHistGroup(contrl[i]);
				break;
#ifdef WDR
			case E_CONGRP_WDR_EXRAT:		// 露光比率指定WDR
				execSequenceExpRatGroup(contrl[i]);
				break;
			case E_CONGRP_WDR_AUTO:			// AutoWDR
				execSequenceAutoWDRGroup(contrl[i]);
				break;
#endif
			default:
				break;
		}
	}
}

void AXMIspAeExecCalcBase::execSequenceWeightGroup(const ControlValue contVal) {
    switch (contVal) {
      case E_WeightOPD:						// 1) OPD重み付け
    	callWeightOPD();
        break;
      case E_CalcAverageOPD:				// 2) OPD平均計算
    	callCalcAverageOPD();
        break;
      default:		// 無いはず
    	callNop();
        break;
    }
}

void AXMIspAeExecCalcBase::execSequenceCommonGroup(const ControlValue contVal) {
	switch (contVal) {
      case E_CalcAeDiff:					// 3) 偏差計算
    	callCalcAeDiff();
        break;
      case E_CalcAeDiffExtend:				// 4) 偏差計算(拡張)
    	callCalcAeDiffExtend();
        break;
      case E_CalcAeControlValue:			// 5) AE制御量計算
    	callCalcAeControlValue();
        break;
      case E_SelectControlObject:			// 6) 制御対象選択
    	callSelectControlObject();
        break;
      case E_DecideControlValue:			// 7) 制御量決定
    	callDecideControlValue();
        break;
      case E_CalcLuminanceValue:			// 8) 明るさ計算
		callCalcLuminanceValue();
    	break;
      case E_CalcISPGain:             		// 9) ISPゲイン計算
    	callCalcISPGain();
        break;
      default:		// 無いはず
    	callNop();
        break;
    }
}

void AXMIspAeExecCalcBase::execSequenceManualGroup(const ControlValue contVal) {
    switch (contVal) {
      case E_ManageRoughIrisValue:			// 10) 概略アイリス値管理
    	callManageRoughIrisValue();
        break;
      default:		// 無いはず
    	callNop();
        break;
    }
}

void AXMIspAeExecCalcBase::execSequenceHistGroup(const ControlValue contVal) {
    switch (contVal) {
      case E_CalcHistogram:					// 11)
    	callCalcHistogram();
        break;
      case E_DivHistogram:					// 12)
		callDivHistogram();
        break;
      case E_CalcAverageLowLumiAreaOPD:		// 13)
    	callCalcAverageLowLumiAreaOPD();
        break;
      case E_CalcAverageHighLumiAreaOPD:	// 14)
    	callCalcAverageHighLumiAreaOPD();
        break;
      case E_CalcAverageALLHist:			// 15)
    	callCalcAverageALLHist();
        break;
      default:		// 無いはず
    	callNop();
        break;
    }
}

void AXMIspAeExecCalcBase::execSequenceMainObjGroup(const ControlValue contVal) {
    switch (contVal) {
      case E_CalcAverageMainObjectOPD:		// 16)
    	callCalcAverageMainObjectOPD();
        break;
      case E_CalcAverageNonMainObjectOPD:	// 17)
    	callCalcAverageNonMainObjectOPD();
        break;
      case E_WeightNonMainObjectArea:		// 18)
		callWeightNonMainObjectArea();
        break;
      case E_CalcAverageALL:				// 19)
    	callCalcAverageALL();
        break;
      default:		// 無いはず
		callNop();
        break;
    }
}

#ifdef WDR
void AXMIspAeExecCalcBase::execSequenceExpRatGroup(const ControlValue contVal) {
    switch (contVal) {
     case E_CalcWDRShortExposureTime:		// 20):
    	callCalcWDRShortExposureTime();
        break;
      case E_DecideWDRShortControlValue:	// 21)
    	callDecideWDRShortControlValue();
        break;
      case E_DecideWDRLongControlValue:		// 22)
		callDecideWDRLongControlValue();
        break;
      default:		// 無いはず
		callNop();
        break;
    }
}
#endif

#ifdef WDR
void AXMIspAeExecCalcBase::execSequenceAutoWDRGroup(const ControlValue contVal) {
    switch (contVal) {
     case E_SetAutoWDRShortTarget:				// 23):
    	callSetAutoWDRShortTarget();
        break;
     case E_SetAutoWDRLongTarget:				// 24):
    	callSetAutoWDRLongTarget();
        break;
     case E_CalcAutoWDRShortAverage:			// 25):
    	callCalcAutoWDRShortAverage();
        break;
      case E_CalcAutoWDRLongAverage:			// 26):
    	callCalcAutoWDRLongAverage();
        break;
      case E_DecideAutoWDRShortControlValue:	// 27)
    	callDecideAutoWDRShortControlValue();
        break;
      case E_DecideAutoWDRLongControlValue:		// 28)
		callDecideAutoWDRLongControlValue();
        break;
      default:		// 無いはず
		callNop();
        break;
    }
}
#endif
void AXMIspAeExecCalcBase::callWeightOPD(void) {
	if (weight != NULL) {
		weight->WeightOPD(opdData);
// for test v v v
#ifdef AE_DEBUG2
		aeNum++;
		if ((21 <= aeNum) && (aeNum < 32)) {
		aePracIdx++;
		}
		opdData = ptrPracArray[aePracIdx];	// フレームNo.を見て切り替える
#endif
// for test ^ ^ ^
	}
}

void AXMIspAeExecCalcBase::callCalcAverageOPD(void) {
	if (weight != NULL) {
		weight->CalcAverageOPD();
	}
}

void AXMIspAeExecCalcBase::callCalcAeDiff(void) {
	if (base != NULL) {
		base->CalcAeDiff(AE_USUAL_BANK);
	}
}

void AXMIspAeExecCalcBase::callCalcAeDiffExtend(void) {
	if (base != NULL) {
		base->CalcAeDiff(AE_EXTEND_BANK);
	}
}

void AXMIspAeExecCalcBase::callCalcAeControlValue(void) {
	if (base != NULL) {
		base->CalcAeControlValue();
	}
}

void AXMIspAeExecCalcBase::callSelectControlObject(void) {
	if (base != NULL) {
		base->SelectControlObject();
	}
}

void AXMIspAeExecCalcBase::callDecideControlValue(void) {
	if (base != NULL) {
		base->DecideControlValue(&controlExposure);
	}
}

void AXMIspAeExecCalcBase::callCalcLuminanceValue(void) {
	if (base != NULL) {
		base->CalcLuminanceValue(&controlExposure , &execFromAeToIsp);
	}
}

void AXMIspAeExecCalcBase::callCalcISPGain(void) {
	if (base != NULL) {
		base->CalcISPGain();
	}
}

void AXMIspAeExecCalcBase::callManageRoughIrisValue(void) {
	if (base != NULL) {
		base->ManageRoughIrisValue(&controlExposure);
	}
}

void AXMIspAeExecCalcBase::callCalcHistogram(void) {
	if (histBase != NULL) {
		histBase->CalcHistogram(opdData);
	}
}

void AXMIspAeExecCalcBase::callDivHistogram(void) {
	if (histBase != NULL) {
		histBase->DivHistogram();
	}
}

void AXMIspAeExecCalcBase::callCalcAverageLowLumiAreaOPD(void) {
	if (histBase != NULL) {
		histBase->CalcAverageLowLumiAreaOPD(opdData);
	}
}

void AXMIspAeExecCalcBase::callCalcAverageHighLumiAreaOPD(void) {
	if (histBase != NULL) {
		histBase->CalcAverageHighLumiAreaOPD(opdData);
	}
}

void AXMIspAeExecCalcBase::callCalcAverageALLHist(void) {
	if (hist != NULL) {
		hist->CalcAverageALLHist();
	}
}

void AXMIspAeExecCalcBase::callCalcAverageMainObjectOPD(void) {
	if (mainObj != NULL) {
		mainObj->CalcAverageMainObjectOPD(opdData);
	}
}

void AXMIspAeExecCalcBase::callCalcAverageNonMainObjectOPD(void) {
	if (mainObj != NULL) {
		mainObj->CalcAverageNonMainObjectOPD(opdData);
	}
}

void AXMIspAeExecCalcBase::callWeightNonMainObjectArea(void) {
	if (mainObj != NULL) {
		mainObj->WeightNonMainObjectArea();
	}
}

void AXMIspAeExecCalcBase::callCalcAverageALL(void) {
	if (mainObj != NULL) {
		mainObj->CalcAverageALL();
	}
}
#ifdef WDR
void AXMIspAeExecCalcBase::callCalcWDRShortExposureTime(void) {
	if (exprat != NULL) {
		exprat->CalcWDRShortExposureTime(&controlExposure);
	}
}

void AXMIspAeExecCalcBase::callDecideWDRShortControlValue(void) {
	if (exprat != NULL) {
		exprat->DecideWDRShortControlValue(&controlExposure);
	}
}

void AXMIspAeExecCalcBase::callDecideWDRLongControlValue(void) {
	if (exprat != NULL) {
		exprat->DecideWDRLongControlValue(&controlExposure);
	}
}

void AXMIspAeExecCalcBase::callSetAutoWDRShortTarget(void) {
	if (autoWdr != NULL) {
		autoWdr->SetAutoWDRShortTarget();
	}
}

void AXMIspAeExecCalcBase::callSetAutoWDRLongTarget(void) {
	if (autoWdr != NULL) {
		autoWdr->SetAutoWDRLongTarget();
	}
}

void AXMIspAeExecCalcBase::callCalcAutoWDRShortAverage(void) {
	if (autoWdr != NULL) {
		autoWdr->CalcAutoWDRShortAverage(&controlExposure);
	}
}

void AXMIspAeExecCalcBase::callCalcAutoWDRLongAverage(void) {
	if (autoWdr != NULL) {
		autoWdr->CalcAutoWDRLongAverage(&controlExposure);
	}
}

void AXMIspAeExecCalcBase::callDecideAutoWDRShortControlValue(void) {
	if (autoWdr != NULL) {
		autoWdr->DecideAutoWDRShortControlValue(&controlExposure);
	}
}

void AXMIspAeExecCalcBase::callDecideAutoWDRLongControlValue(void) {
	if (autoWdr != NULL) {
		autoWdr->DecideAutoWDRLongControlValue(&controlExposure);
	}
}
#endif
void AXMIspAeExecCalcBase::callNop(void) {
}

AXMIspAeSequencer::AXMIspAeSequencer() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "AXMIspAeSequencer::constructor" << endl;
  #endif
#endif
}

AXMIspAeSequencer::~AXMIspAeSequencer() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "AXMIspAeSequencer::destructor" << endl;
  #endif
#endif
}

// bbtest
#if 0
#include "AdjSpec.h"
#endif
void AXMIspAeSequencer::doCalc(ST_MSG *p_msg) {
	// bbtest
#if 0
	uint32_t addr = 0x20058000;
	uint32_t dat = 0;
	bool dmySFlg = false;
	if (dmySFlg) {
		dat = getSpec(addr);
		setSpec(addr, dat);
		if (addr >= 0x20058350) {
			addr = 0x20058000;
			dat = getSpec(addr);
			dat |= SPEC_CHG_AE001;		// モード選択
			//dat |= SPEC_CHG_AE005;	// マニュアルモード設定
			setSpec(addr, dat);
		}
	}
#endif
	
	
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "AXMIspAeSequencer::doCalc" << endl;
  #endif
#endif
	if(objAeSettingRef != NULL) {
#ifdef WDR
		if(objAeSettingRef->AeMode == E_AeExposureRatioWDRMode ||        			// 露光比指定WDRモード
		   objAeSettingRef->AeMode == E_AeAutoWDRMode) {                 			// オートWDRモード
				execFromAeToIsp.is_wdr_mode = true;
		} else {
				execFromAeToIsp.is_wdr_mode = false;
#endif
				//10フレームに1回2フレーム前のOPDを参照する不具合に対応
				if((p_msg->cmd & ~Cmd_Get_OPD_Mask) == Cmd_Frame_2nd) {
					opdData = NULL;
				}
#ifdef WDR
		}
#endif
		switch(objAeSettingRef->AeMode) {
			case E_AeManualMode:
				AXMIspAeExecCalcBase::exec(AXMIspAeManualModeControl);
				break;
			case E_AeUsualProgMode:
				AXMIspAeExecCalcBase::exec(AXMIspAeUsualProgModeControl);
				break;
			case E_AeShutterControlMode:
				AXMIspAeExecCalcBase::exec(AXMIspAeShutterControlModeControl);
				break;
			case E_AeShutterAndGainControlMode:
				AXMIspAeExecCalcBase::exec(AXMIspAeShutterAndGainControlModeControl);
				break;

			case E_AeUsualProg_MainObjMode:              // 主要被写体補正
				AXMIspAeExecCalcBase::exec(AXMIspAEAutoBLFLCMainObjectModeControl);
				break;
			case E_AeShutterControl_MainObjMode:         // 主要被写体補正
				AXMIspAeExecCalcBase::exec(AXMIspAEAutoBLFLCMainObjectModeControl);
				break;
			case E_AeShutterAndGainControl_MainObjMode:  // 主要被写体補正
				AXMIspAeExecCalcBase::exec(AXMIspAEAutoBLFLCMainObjectModeControl);
				break;

			case E_AeUsualProg_HistogramMode:              // ヒストグラム
				AXMIspAeExecCalcBase::exec(AXMIspAeAutoBLFLCHistogramModeControl);
				break;
			case E_AeShutterControl_HistogramMode:         // ヒストグラム
				AXMIspAeExecCalcBase::exec(AXMIspAeAutoBLFLCHistogramModeControl);
				break;
			case E_AeShutterAndGainControl_HistogramMode:  // ヒストグラム
				AXMIspAeExecCalcBase::exec(AXMIspAeAutoBLFLCHistogramModeControl);
				break;
#ifdef WDR
			case E_AeExposureRatioWDRMode:					// 露光比率指定WDRモード
			{
				int Cmd = (p_msg->cmd & Cmd_Get_OPD_Mask);
				if(Cmd == Cmd_Get_OPD_AE_0 || Cmd == Cmd_Get_OPD_AE_1){
					AXMIspAeExecCalcBase::exec(AXMIspAeExposureRatioWDRModeControl_Short);	// 短時間露光
				} else {
					AXMIspAeExecCalcBase::exec(AXMIspAeExposureRatioWDRModeControl_Long);	// 長時間露光
				}
			}
				break;
			case E_AeAutoWDRMode:
			{
				int Cmd = (p_msg->cmd & Cmd_Get_OPD_Mask);
				if(Cmd == Cmd_Get_OPD_AE_0 || Cmd == Cmd_Get_OPD_AE_1){
					AXMIspAeExecCalcBase::exec(AXMIspAeAutoWDRControl_Short);	// 短時間露光
				} else {
					AXMIspAeExecCalcBase::exec(AXMIspAeAutoWDRControl_Long);	// 長時間露光
				}
			}
				break;
#endif
			default:
				doCalcDummy();
				break;
		}

	}
}

void AXMIspAeSequencer::doCalcDummy() {
}

#ifdef PARASOFT_CPPTEST
AXMispAeWeightOPD *AXMIspAeExecCalcBase::newWeightStub(void) {
	AXMispAeWeightOPD *l_weight;
	if(flag_newWeightStub) {
		l_weight = NULL;
	}else{
		l_weight = new AXMispAeWeightOPD();
	}
	return l_weight;
}

AXMIspAEAutoBLFLCMainObject *AXMIspAeExecCalcBase::newMainObjStub(void) {
	AXMIspAEAutoBLFLCMainObject *l_MainObj;
	if(flag_newMainObjStub) {
		l_MainObj = NULL;
	}else{
		l_MainObj = new AXMIspAEAutoBLFLCMainObject();
	}
	return l_MainObj;
}

AXMIspAeAutoBLFLCHistogram *AXMIspAeExecCalcBase::newHistStub(void) {
	AXMIspAeAutoBLFLCHistogram *l_hist;
	if(flag_newHistStub) {
		l_hist = NULL;
	}else{
		l_hist = new AXMIspAeAutoBLFLCHistogram();
	}
	return l_hist;
}

AXMIspAeExposureRatioWDRMode *AXMIspAeExecCalcBase::newExpRatStub(void) {
	AXMIspAeExposureRatioWDRMode *l_ExpRat;
	if(flag_newExpRatStub) {
		l_ExpRat = NULL;
	}else{
		l_ExpRat = new AXMIspAeExposureRatioWDRMode();
	}
	return l_ExpRat;
}

AXMIspAeAutoWDR *AXMIspAeExecCalcBase::newAutoWdrStub(void) {
	AXMIspAeAutoWDR *l_AutoWdr;
	if(flag_newAutoWdrStub) {
		l_AutoWdr = NULL;
	}else{
		l_AutoWdr = new AXMIspAeAutoWDR();
	}
	return l_AutoWdr;
}
#endif
