/**
 * @file       	AXMIspAfAlgorithm.hpp
 * @brief      	AFアルゴリズム演算クラス群ヘッダ
 *
 * @par			言語
 *              C++
 */

#ifndef AXMISPAFALGORITHM_HPP_
#define AXMISPAFALGORITHM_HPP_
#include "../AXM/AXModelActor.hpp"
#include "../AXMCommon/AXMCommonConfig.hpp"
#include <string>
#include <iostream>
#include <iomanip>
#include "AXHSpec.hpp"
#include "AXMCommon/AXMCommonStruct.hpp"
#include "AXMCommon/AXMCommonTypedefine.hpp"

	enum AF_STATUS {
		AF_STS_DIRJUDG = 1,
		AF_STS_HIGHSPEED ,
		AF_STS_LOWSPEED ,
		AF_STS_PEAKDETECT ,
		AF_STS_RETANDSTOP ,
		AF_STS_REBOOT	,
		AF_STS_DIRJUDG_RETURN	,
		AF_STS_DEBUG_TOINF_FAST = 0x100 ,
		AF_STS_DEBUG_TOMACRO_FAST ,
		AF_STS_DEBUG_TOINF_SLOW ,
		AF_STS_DEBUG_TOMACRO_SLOW ,
		AF_STS_DEBUG_MOVE_AND_STOP ,
		AF_STS_DEBUG_TOINF_FAST_FOREVER = 0x200 ,
		AF_STS_DEBUG_TOMACRO_FAST_FOREVER ,
		AF_STS_DEBUG_TOINF_SLOW_FOREVER  ,
		AF_STS_DEBUG_TOMACRO_SLOW_FOREVER ,
		AF_STS_DEBUG_STOP_FOREVER ,
		AF_STS_DEBUG_FAST_START = 0x300 ,
		AF_STS_DEBUG_TOINF_SLOW_START ,
		AF_STS_DEBUG_TOMACRO_SLOW_START ,
		

	} ;

	enum START_DIRECTION {
		AF_STADIR_TOMACRO = 1,
		AF_STADIR_TOINF
	};
	
	enum AF_CONTVALUE {
		AF_CONT_TOMACRO_FAST    = 1,		// (1)レンズ高速駆動(マクロ方向)
		AF_CONT_TOMACRO_SLOW    ,			// (2)レンズ低速駆動(マクロ方向)
		AF_CONT_TOINF_SLOW      ,			// (3)レンズ低速駆動(無限遠方向)
		AF_CONT_TOINF_FAST      ,			// (4)レンズ高速駆動(無限遠方向)
		AF_CONT_STOP            ,			// (5)レンズ駆動停止
		ZOOM_CONT_ZOOMOUT_FAST  = 0x10,	// (1)レンズ高速駆動(マクロ方向)
		ZOOM_CONT_ZOOMOUT_SLOW  = 0x20,	// (2)レンズ低速駆動(マクロ方向)
		ZOOM_CONT_ZOOMIN_SLOW   = 0x30,	// (3)レンズ低速駆動(無限遠方向)
		ZOOM_CONT_ZOOMIN_FAST   = 0x40,	// (4)レンズ高速駆動(無限遠方向)
		ZOOM_CONT_STOP          = 0x50,	// (5)レンズ駆動停止
    };

/**
 * @class  AXMIspAfBase
 * @brief  AEアルゴリズム基本クラス
 *
 * @n		 AE全モードで共通に実行される演算処理
 */
class AXMIspAfBase {
 public:
  /**
   * @brief  オブジェクトを初期化する
   *
   * @n
   */
  AXMIspAfBase();
  /**
   * @brief  オブジェクトを開放する
   *
   * @n
   */
  virtual ~AXMIspAfBase();
 /**
  * @brief AF実行
  *
  */
  void AfExec(void);

 /**
  * @brief AF評価値情報通知
  * 
  * @param [in]   obj	AF設定情報クラスへのポインタ
  * @n [出力]  long afLfEval[9];    // LF評価値
  *		   -    long afHfEval[9];    // HF評価値
  */
  void notifyAfEval(long *obj);
  /**
   * @brief (1)開始時方向判定
   *
   */
  void StartDirectionJudge(void);
  /**
   * @brief (2)高速駆動
   *
   */
  void HighSpeedDrive(void);
  /**
   * @brief (3)低速駆動（変曲点でブレーキング／省略する場合もあり）
   *
   */
  void LowSpeedDrive(void);
  /**
   * @brief (4)頂点検知
   *
    */
  void PeakDetection(void);
  /**
   * @brief (5)戻って停止
   *
    */
  void ReturnAndStop(void);
  /**
   * @brief (6)再起動
   *
   */
  void Reboot(void);
  /**
   * @brief (7)開始時方向判定の戻し
   *
   */
  void StartDirectionJudgeReturn(void);
  /**
   * @brief デバッグ用実行関数
   *
   */
  void Debug(void);
	void debugSupport(void);
	void debugDetect(void);

  /**
   * @brief AF機能初期化関数
   *
   * @param [in] ptrSpec パラメータ格納領域アドレス
   */
  void initAfSpec(ST_SPEC *ptrSpec);
  /**
   * @brief AF機能パラメータ設定
   *
   */
  void setAfSpec(void);

 public:
	ST_CONTROL_AF	controlAF;
 public:
	USHORT	status;						// AF状態遷移フラグ
	USHORT	afStartDirJudMax;			// 開始時方向切替判定所定回数
	UCHAR	afStartDir;					// 初動方向
	UCHAR	afArea;						// オートフォーカス領域指定0縲鰀8
	UCHAR	afOneShotEnable;			// AFワンショットモードOn/Off
	UCHAR	afOneShotStart;				// AFワンショット起動
	USHORT	afStartDirectJudgCount;		// 開始時方向切替判定カウンタ
	LONG	afStartDirChangeThreshHf;		// 開始時方向切替判定閾値
	LONG	afStartDirChangeThreshLf;		// 開始時方向切替判定閾値
	LONG	afStartDirChangeThreshRatio;	// 開始時方向切替判定閾値比率 2015/05/22追加
	LONG	afLfEval[9];				// LF評価値
	LONG	afHfEval[9];				// HF評価値

	LONG	afHfEval1;					// 前々回AF評価値
	LONG	afHfEval2;					// 前回AF評価値
	LONG	afHfEval3;					// 今回AF評価値
	LONG	afLfEval1;					// 前々回AF評価値
	LONG	afLfEval2;					// 前回AF評価値
	LONG	afLfEval3;					// 今回AF評価値

	LONG	afHfDiffSav;				// 以前の0でない差分
	USHORT	mtValCnt;					// 山谷検出数カウンタ
	LONG	afLfDiffSav;				// 以前の0でない差分
	USHORT	mtLfValCnt;					// 山谷検出数カウンタ
	USHORT	mtValJudg;					// レンズ端判定値
	USHORT	overPeakCount;				// ピーク検出後に進んだフレーム数
	LONG	afHfEvalPeak;				// ピーク時のAF評価値
	LONG	afHfDiffPeak;				// 微分の最大値
	LONG	afHfDiffValley;				// 微分の最小値
	UCHAR	afEvalPeakRatio;			// ピークに戻る時のAF評価値比率
	USHORT	returnPeakCount;			// ピークに戻る時のカウンタ
	LONG	afEvalPeakJudge;			// ピークに戻る時のAF評価値
	USHORT	lensAtEndJudg;				// レンズが端にあるか判定用
	LONG	afHfEvalChgStatus;
	UCHAR   detectEndFlag;
	UCHAR   detectChgSpedFlag;
	UCHAR   detectChgDirFlag;
	USHORT   evalZeroCount;

	USHORT	HighSpeedCount;
	USHORT	LowSpeedCount;
	
	LONG	afHfEvalReboot;				// 再起動時のHF評価値
	LONG	afLfEvalReboot;				// 再起動時のLF評価値
	LONG	afChngSpedThresh;			// 
	LONG	afChngSpedThreshRatio;			// 
	LONG	afOverPeakThresh;
	LONG	afOverPeakThreshRatio;		// 2012/05/22追加
	LONG	afEvalStop;
	LONG	afEvalRebootThresh;
	LONG	afEvalRebootThreshRatio;
//	LONG	HighSpeedChangeDirThresh;	//
	USHORT	afRebootCount;

    ST_SPEC                             *p_spec;              //  設定値参照用
	unsigned int	zoomControl;

};

#endif /* AXMISPAFALGORITHM_HPP_ */
